/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache30.CacheListenerTestCase;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import com.gemstone.gemfire.internal.cache.LoaderHelperImpl;
import dunit.DistributedTestCase;
import junit.framework.TestCase;

public class LocalRegionTest
extends CacheListenerTestCase {
    public LocalRegionTest(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        return factory.create();
    }

    public void testIncompatibleSubregions() throws CacheException {
        RegionAttributes attrs;
        AttributesFactory factory2;
        Region region = this.createRegion(this.getUniqueName());
        LocalRegionTest.assertEquals((Object)Scope.LOCAL, (Object)region.getAttributes().getScope());
        try {
            factory2 = new AttributesFactory(region.getAttributes());
            factory2.setScope(Scope.DISTRIBUTED_NO_ACK);
            attrs = factory2.create();
            region.createSubregion(this.getUniqueName(), attrs);
            LocalRegionTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException factory2) {
            // empty catch block
        }
        try {
            factory2 = new AttributesFactory(region.getAttributes());
            factory2.setScope(Scope.DISTRIBUTED_ACK);
            attrs = factory2.create();
            region.createSubregion(this.getUniqueName(), attrs);
            LocalRegionTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException factory3) {
            // empty catch block
        }
        try {
            factory2 = new AttributesFactory(region.getAttributes());
            factory2.setScope(Scope.GLOBAL);
            attrs = factory2.create();
            region.createSubregion(this.getUniqueName(), attrs);
            LocalRegionTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLocalLoaderNetSearch() throws CacheException {
        LocalRegionTest.assertEquals((Object)Scope.LOCAL, (Object)this.getRegionAttributes().getScope());
        String name = this.getUniqueName();
        String key = this.getUniqueName();
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                try {
                    helper.netSearch(true);
                }
                catch (TimeoutException ex) {
                    DistributedTestCase.fail("Why did I timeout?", ex);
                }
                return null;
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        Region region = this.createRegion(name, factory.create());
        LocalRegionTest.assertEquals((Object)Scope.LOCAL, (Object)region.getAttributes().getScope());
        try {
            region.get((Object)key);
            LocalRegionTest.fail((String)"Should have thrown a CacheLoaderException");
        }
        catch (CacheLoaderException ex) {
            String expected = LoaderHelperImpl.NET_SEARCH_LOCAL.toLocalizedString();
            String message = ex.getMessage();
            LocalRegionTest.assertTrue((String)("Unexpected message \"" + message + "\""), (message.indexOf(expected) != -1 ? 1 : 0) != 0);
        }
    }

    public void testLocalCreateModifiedCallbackArgument() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        final String value = "VALUE";
        final String one = "ONE";
        final String two = "TWO";
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                Object[] array = (Object[])helper.getArgument();
                TestCase.assertEquals((Object)one, (Object)array[0]);
                array[0] = two;
                return value;
            }
        };
        TestCacheWriter writer = new TestCacheWriter(){

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                Object[] array = (Object[])event.getCallbackArgument();
                TestCase.assertEquals((Object)two, (Object)array[0]);
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        factory.setCacheWriter((CacheWriter)writer);
        Region region = this.createRegion(name, factory.create());
        Object[] array = new Object[]{one};
        LocalRegionTest.assertEquals((Object)value, (Object)region.get((Object)key, (Object)array));
        LocalRegionTest.assertTrue((boolean)loader.wasInvoked());
        LocalRegionTest.assertTrue((boolean)writer.wasInvoked());
    }

    public void testLocalUpdateModifiedCallbackArgument() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        final String value = "VALUE";
        final String one = "ONE";
        final String two = "TWO";
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                Object[] array = (Object[])helper.getArgument();
                TestCase.assertEquals((Object)one, (Object)array[0]);
                array[0] = two;
                return value;
            }
        };
        TestCacheWriter writer = new TestCacheWriter(){

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
            }

            @Override
            public void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                Object[] array = (Object[])event.getCallbackArgument();
                TestCase.assertEquals((Object)two, (Object)array[0]);
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        factory.setCacheWriter((CacheWriter)writer);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, null);
        LocalRegionTest.assertFalse((boolean)loader.wasInvoked());
        LocalRegionTest.assertTrue((boolean)writer.wasInvoked());
        Object[] array = new Object[]{one};
        LocalRegionTest.assertEquals((Object)value, (Object)region.get((Object)key, (Object)array));
        LocalRegionTest.assertTrue((boolean)loader.wasInvoked());
        LocalRegionTest.assertTrue((boolean)writer.wasInvoked());
    }
}

