/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.SharedLibrary;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.lru.MemLRUCapacityController;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.gemstone.gemfire.internal.size.WellKnownClassSizer;
import java.util.Properties;
import java.util.Random;

public class MemLRUEvictionControllerTest
extends CacheTestCase {
    private static boolean usingMain = false;

    public MemLRUEvictionControllerTest(String name) {
        super(name);
    }

    private LRUStatistics getLRUStats(Region region) {
        LocalRegion l = (LocalRegion)region;
        return l.getEvictionController().getLRUHelper().getStats();
    }

    private int getEntryOverhead(Region region) {
        LocalRegion lRegion = (LocalRegion)region;
        return ((MemLRUCapacityController)lRegion.getEvictionController()).getPerEntryOverhead();
    }

    public void testRegionOperations() throws CacheException {
        String key;
        int i;
        Region region;
        int threshold = 4;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)threshold));
        if (usingMain) {
            DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
            Cache cache = CacheFactory.create((DistributedSystem)system);
            region = cache.createRegion("Test", factory.create());
        } else {
            region = this.createRegion(name, factory.create());
        }
        LRUStatistics lruStats = this.getLRUStats(region);
        MemLRUEvictionControllerTest.assertNotNull((Object)lruStats);
        String sampleKey = new String("10000");
        int stringSize = SharedLibrary.getObjectHeaderSize() + 4 + 4 + 4 + SharedLibrary.getReferenceSize();
        stringSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)stringSize);
        int charArraySize = sampleKey.length() * 2 + SharedLibrary.getObjectHeaderSize() + 4;
        charArraySize = (int)ReflectionSingleObjectSizer.roundUpSize((long)charArraySize);
        MemLRUEvictionControllerTest.assertEquals((long)stringSize, (long)ReflectionSingleObjectSizer.sizeof(String.class));
        MemLRUEvictionControllerTest.assertEquals((long)ReflectionSingleObjectSizer.roundUpSize((long)(SharedLibrary.getObjectHeaderSize() + 4)), (long)new ReflectionSingleObjectSizer().sizeof((Object)new char[0]));
        MemLRUEvictionControllerTest.assertEquals((long)charArraySize, (long)new ReflectionSingleObjectSizer().sizeof((Object)new char[5]));
        int keySize = stringSize + charArraySize;
        MemLRUEvictionControllerTest.assertEquals((int)keySize, (int)WellKnownClassSizer.sizeof((Object)sampleKey));
        MemLRUEvictionControllerTest.assertEquals((int)keySize, (int)ObjectSizer.DEFAULT.sizeof((Object)sampleKey));
        byte[] sampleValue = new byte[1000];
        int valueSize = sampleValue.length + 8 + 4;
        if (SharedLibrary.is64Bit()) {
            valueSize += 8;
        }
        valueSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)valueSize);
        int entrySize = keySize + valueSize + this.getEntryOverhead(region);
        MemLRUEvictionControllerTest.assertEquals((int)valueSize, (int)ObjectSizer.DEFAULT.sizeof((Object)sampleValue));
        for (i = 1; i <= 100; ++i) {
            key = String.valueOf(10000 + i);
            byte[] value = new byte[1000];
            region.put((Object)key, (Object)value);
            MemLRUEvictionControllerTest.assertEquals((long)(i * entrySize), (long)lruStats.getCounter());
            MemLRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
        for (i = 100; i >= 1; --i) {
            key = String.valueOf(10000 + i);
            region.destroy((Object)key);
            MemLRUEvictionControllerTest.assertEquals((long)((i - 1) * entrySize), (long)lruStats.getCounter());
            MemLRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
    }

    public void testSizeClassesOnce() throws CacheException {
        String key;
        int i;
        int threshold = 4;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)threshold));
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        MemLRUEvictionControllerTest.assertNotNull((Object)lruStats);
        TestObject object = new TestObject(50);
        int keySize = ObjectSizer.DEFAULT.sizeof((Object)new String("10000"));
        int valueSize = ObjectSizer.DEFAULT.sizeof((Object)object);
        int entrySize = keySize + valueSize + this.getEntryOverhead(region);
        Random ran = new Random();
        for (i = 1; i <= 100; ++i) {
            key = String.valueOf(10000 + i);
            TestObject value = new TestObject(ran.nextInt(100));
            region.put((Object)key, (Object)value);
            MemLRUEvictionControllerTest.assertEquals((long)(i * entrySize), (long)lruStats.getCounter());
            MemLRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
        for (i = 100; i >= 1; --i) {
            key = String.valueOf(10000 + i);
            region.destroy((Object)key);
            MemLRUEvictionControllerTest.assertEquals((long)((i - 1) * entrySize), (long)lruStats.getCounter());
            MemLRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
    }

    public void testEntryOverHead() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)50));
        Region region = this.createRegion(name, factory.create());
        String s = "Each entry occupies " + this.getEntryOverhead(region) + " bytes";
        region.getCache().getDistributedSystem().getLogWriter().info(s);
    }

    public void testCustomObjectSizer() throws Exception {
        String name = this.getUniqueName();
        int entrySize = 0x100000;
        int numEntries = 3;
        AttributesFactory factory = new AttributesFactory();
        CustomObjectSizer cs = new CustomObjectSizer(0x100000);
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)1, (ObjectSizer)cs));
        Region r = this.createRegion(name, factory.create());
        for (int size = 0; size < 3; ++size) {
            r.put((Object)new Integer(size), (Object)new byte[0x100000]);
        }
        MemLRUEvictionControllerTest.assertTrue((String)"ObjectSizer was not triggered", (boolean)cs.wasCalled());
        long actualSize = this.getLRUStats(r).getCounter();
        int bytesPut = 0x300000;
        MemLRUEvictionControllerTest.assertTrue((String)("Expected bytes put: " + bytesPut + " is not < " + actualSize), (actualSize < (long)bytesPut ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws Exception {
        usingMain = true;
        new MemLRUEvictionControllerTest("test").testRegionOperations();
    }

    private static class TestObject {
        private final byte[] field;

        public TestObject(int size) {
            this.field = new byte[size];
        }
    }

    class CustomObjectSizer
    implements ObjectSizer {
        private int dataSize;
        private boolean wasCalled = false;

        public CustomObjectSizer(int dataSize) {
            this.dataSize = dataSize;
        }

        public int sizeof(Object o) {
            this.wasCalled = true;
            return this.dataSize;
        }

        public boolean wasCalled() {
            return this.wasCalled;
        }
    }
}

