/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;
import junit.framework.TestCase;

public class PutAllMultiVmDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static Region mirroredRegion;
    static CacheTransactionManager cacheTxnMgr;

    public PutAllMultiVmDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllMultiVmDUnitTest.class, "createCache");
        vm1.invoke(PutAllMultiVmDUnitTest.class, "createCache");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllMultiVmDUnitTest.class, "closeCache");
        vm1.invoke(PutAllMultiVmDUnitTest.class, "closeCache");
        cache = null;
        PutAllMultiVmDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void createCache() {
        try {
            ds = new PutAllMultiVmDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createMirroredRegion() {
        try {
            AttributesFactory factory = new AttributesFactory();
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr = factory.create();
            mirroredRegion = cache.createRegion("mirrored", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testSimplePutAll() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable clear = new CacheSerializableRunnable("clear"){

            @Override
            public void run2() throws CacheException {
                try {
                    region.clear();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        vm0.invoke(new CacheSerializableRunnable("testSimplePutAll1"){

            @Override
            public void run2() throws CacheException {
                int cntr = 0;
                int cntr1 = 0;
                for (int i = 1; i < 6; ++i) {
                    region.put((Object)new Integer(i), (Object)new String("testSimplePutAll" + i));
                    ++cntr;
                }
                int size1 = region.size();
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                for (int i = 6; i < 27; ++i) {
                    m.put(new Integer(i), new String("map" + i));
                    ++cntr;
                    ++cntr1;
                }
                region.putAll(m);
                int size2 = region.size();
                TestCase.assertEquals((int)cntr, (int)region.size());
                TestCase.assertEquals((int)cntr1, (int)(size2 - size1));
                TestCase.assertEquals((boolean)true, (boolean)region.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)true, (boolean)region.containsValue((Object)new String("map12")));
            }
        });
        vm0.invoke(clear);
        vm1.invoke(new CacheSerializableRunnable("create mirrored region"){

            @Override
            public void run2() throws CacheException {
                PutAllMultiVmDUnitTest.createMirroredRegion();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("testSimplePutAll2"){

            @Override
            public void run2() throws CacheException {
                PutAllMultiVmDUnitTest.createMirroredRegion();
                cacheTxnMgr = cache.getCacheTransactionManager();
                int cntr = 0;
                for (int i = 1; i < 6; ++i) {
                    mirroredRegion.put((Object)new Integer(i), (Object)new String("testSimplePutAll" + i));
                    ++cntr;
                }
                int size1 = mirroredRegion.size();
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                for (int i = 6; i < 27; ++i) {
                    m.put(new Integer(i), new String("map" + i));
                    ++cntr;
                }
                TestCase.assertEquals((int)size1, (int)mirroredRegion.size());
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsValue((Object)new String("map12")));
                mirroredRegion.putAll(m);
                TestCase.assertEquals((int)cntr, (int)mirroredRegion.size());
                TestCase.assertEquals((boolean)true, (boolean)mirroredRegion.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)true, (boolean)mirroredRegion.containsValue((Object)new String("map12")));
                mirroredRegion.put((Object)"size", (Object)new Integer(mirroredRegion.size()));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("testSimplePutAll3"){

            @Override
            public void run2() throws CacheException {
                Integer i = (Integer)mirroredRegion.get((Object)"size");
                int cntr = i;
                TestCase.assertEquals((int)cntr, (int)(mirroredRegion.size() - 1));
                TestCase.assertEquals((boolean)true, (boolean)mirroredRegion.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)true, (boolean)mirroredRegion.containsValue((Object)new String("map12")));
            }
        });
    }

    public void testPutAllExceptions() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("testPutAllExceptions1"){

            @Override
            public void run2() throws CacheException {
                int cntr = 0;
                for (int i = 1; i < 6; ++i) {
                    region.put((Object)new Integer(i), (Object)new String("testSimplePutAll" + i));
                    ++cntr;
                }
                TreeMap<Integer, String> m = new TreeMap<Integer, String>();
                for (int i = 6; i < 27; ++i) {
                    if (i == 16) {
                        m.put(new Integer(i), null);
                        continue;
                    }
                    m.put(new Integer(i), new String("map" + i));
                }
                try {
                    region.putAll(m);
                    TestCase.fail((String)"Expect NullPointerException");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                TestCase.assertEquals((int)5, (int)region.size());
                TestCase.assertEquals((boolean)false, (boolean)region.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)false, (boolean)region.containsValue((Object)new String("map12")));
                TestCase.assertEquals((boolean)false, (boolean)region.containsKey((Object)new Integer(20)));
                TestCase.assertEquals((boolean)false, (boolean)region.containsValue((Object)new String("map21")));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("create mirrored region"){

            @Override
            public void run2() throws CacheException {
                PutAllMultiVmDUnitTest.createMirroredRegion();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("testPutAllExceptions2"){

            @Override
            public void run2() throws CacheException {
                PutAllMultiVmDUnitTest.createMirroredRegion();
                for (int i = 1; i < 6; ++i) {
                    mirroredRegion.put((Object)new Integer(i), (Object)new String("testSimplePutAll" + i));
                }
                TreeMap<Integer, String> m = new TreeMap<Integer, String>();
                for (int i = 6; i < 27; ++i) {
                    if (i == 16) {
                        m.put(new Integer(i), null);
                        continue;
                    }
                    m.put(new Integer(i), new String("map" + i));
                }
                try {
                    mirroredRegion.putAll(m);
                    TestCase.fail((String)"Expect NullPointerException");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                TestCase.assertEquals((int)5, (int)mirroredRegion.size());
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsValue((Object)new String("map12")));
                TestCase.assertEquals((boolean)false, (boolean)region.containsKey((Object)new Integer(20)));
                TestCase.assertEquals((boolean)false, (boolean)region.containsValue((Object)new String("map21")));
                mirroredRegion.put((Object)"size", (Object)new Integer(mirroredRegion.size()));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("testPutAllExceptions3"){

            @Override
            public void run2() throws CacheException {
                Integer i = (Integer)mirroredRegion.get((Object)"size");
                int cntr = i;
                TestCase.assertEquals((int)cntr, (int)(mirroredRegion.size() - 1));
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsKey((Object)new Integer(10)));
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsValue((Object)new String("map12")));
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsKey((Object)new Integer(20)));
                TestCase.assertEquals((boolean)false, (boolean)mirroredRegion.containsValue((Object)new String("map21")));
            }
        });
    }

    public void testPutAllExceptionHandling() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("testPutAllExceptionHandling1"){

            @Override
            public void run2() throws CacheException {
                HashMap m = new HashMap();
                m = null;
                try {
                    region.putAll(m);
                    TestCase.fail((String)"Should have thrown NullPointerException");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                region.localDestroyRegion();
                try {
                    HashMap<Integer, String> m1 = new HashMap<Integer, String>();
                    for (int i = 1; i < 21; ++i) {
                        m1.put(new Integer(i), Integer.toString(i));
                    }
                    region.putAll(m1);
                    TestCase.fail((String)"Should have thrown RegionDestroyedException");
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
    }
}

