/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.ReliabilityTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import junit.framework.TestCase;

public class QueueMsgDUnitTest
extends ReliabilityTestCase {
    public QueueMsgDUnitTest(String name) {
        super(name);
    }

    public void disabled_testQueueWhenRoleMissing() throws Exception {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        DistributedRegion r = (DistributedRegion)this.createRootRegion(factory.create());
        final CachePerfStats stats = r.getCachePerfStats();
        int queuedOps = stats.getReliableQueuedOps();
        r.create((Object)"createKey", (Object)"createValue", (Object)"createCBArg");
        r.invalidate((Object)"createKey", (Object)"invalidateCBArg");
        r.put((Object)"createKey", (Object)"putValue", (Object)"putCBArg");
        r.destroy((Object)"createKey", (Object)"destroyCBArg");
        QueueMsgDUnitTest.assertEquals((int)(queuedOps + 4), (int)stats.getReliableQueuedOps());
        queuedOps = stats.getReliableQueuedOps();
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("aKey", "aValue");
        m.put("bKey", "bValue");
        r.putAll(m);
        QueueMsgDUnitTest.assertEquals((int)(queuedOps + 2), (int)stats.getReliableQueuedOps());
        queuedOps = stats.getReliableQueuedOps();
        r.invalidateRegion((Object)"invalidateRegionCBArg");
        QueueMsgDUnitTest.assertEquals((int)(queuedOps + 1), (int)stats.getReliableQueuedOps());
        queuedOps = stats.getReliableQueuedOps();
        r.clear();
        QueueMsgDUnitTest.assertEquals((int)(queuedOps + 1), (int)stats.getReliableQueuedOps());
        queuedOps = stats.getReliableQueuedOps();
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties config = new Properties();
                config.setProperty("roles", "missing");
                QueueMsgDUnitTest.this.getSystem(config);
            }
        });
        QueueMsgDUnitTest.assertEquals((int)queuedOps, (int)stats.getReliableQueuedOps());
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                TestCacheListener cl = new TestCacheListener(){

                    @Override
                    public void afterCreate2(EntryEvent event) {
                    }

                    @Override
                    public void afterUpdate2(EntryEvent event) {
                    }

                    @Override
                    public void afterInvalidate2(EntryEvent event) {
                    }

                    @Override
                    public void afterDestroy2(EntryEvent event) {
                    }
                };
                cl.enableEventHistory();
                factory.addCacheListener((CacheListener)cl);
                QueueMsgDUnitTest.this.createRootRegion(factory.create());
            }
        });
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return stats.getReliableQueuedOps() == 0;
            }

            @Override
            public String description() {
                return "waiting for reliableQueuedOps to become 0";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
        vm.invoke(new CacheSerializableRunnable("check"){

            @Override
            public void run2() throws CacheException {
                Region r = QueueMsgDUnitTest.this.getRootRegion();
                TestCase.assertEquals(null, (Object)r.getEntry((Object)"createKey"));
                int evIdx = 0;
                TestCacheListener cl = (TestCacheListener)r.getAttributes().getCacheListener();
                List events = cl.getEventHistory();
                CacheEvent ce = (CacheEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.REGION_CREATE, (Object)ce.getOperation());
                EntryEvent ee = (EntryEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.CREATE, (Object)ee.getOperation());
                TestCase.assertEquals((Object)"createKey", (Object)ee.getKey());
                TestCase.assertEquals((Object)"createValue", (Object)ee.getNewValue());
                TestCase.assertEquals(null, (Object)ee.getOldValue());
                TestCase.assertEquals((Object)"createCBArg", (Object)ee.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                ee = (EntryEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.INVALIDATE, (Object)ee.getOperation());
                TestCase.assertEquals((Object)"createKey", (Object)ee.getKey());
                TestCase.assertEquals(null, (Object)ee.getNewValue());
                TestCase.assertEquals((Object)"createValue", (Object)ee.getOldValue());
                TestCase.assertEquals((Object)"invalidateCBArg", (Object)ee.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                ee = (EntryEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.UPDATE, (Object)ee.getOperation());
                TestCase.assertEquals((Object)"createKey", (Object)ee.getKey());
                TestCase.assertEquals((Object)"putValue", (Object)ee.getNewValue());
                TestCase.assertEquals(null, (Object)ee.getOldValue());
                TestCase.assertEquals((Object)"putCBArg", (Object)ee.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                ee = (EntryEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.DESTROY, (Object)ee.getOperation());
                TestCase.assertEquals((Object)"createKey", (Object)ee.getKey());
                TestCase.assertEquals(null, (Object)ee.getNewValue());
                TestCase.assertEquals((Object)"putValue", (Object)ee.getOldValue());
                TestCase.assertEquals((Object)"destroyCBArg", (Object)ee.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                ee = (EntryEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.PUTALL_CREATE, (Object)ee.getOperation());
                TestCase.assertEquals((Object)"aKey", (Object)ee.getKey());
                TestCase.assertEquals((Object)"aValue", (Object)ee.getNewValue());
                TestCase.assertEquals(null, (Object)ee.getOldValue());
                TestCase.assertEquals(null, (Object)ee.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                ee = (EntryEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.PUTALL_CREATE, (Object)ee.getOperation());
                TestCase.assertEquals((Object)"bKey", (Object)ee.getKey());
                TestCase.assertEquals((Object)"bValue", (Object)ee.getNewValue());
                TestCase.assertEquals(null, (Object)ee.getOldValue());
                TestCase.assertEquals(null, (Object)ee.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ee.isOriginRemote());
                RegionEvent re = (RegionEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.REGION_INVALIDATE, (Object)re.getOperation());
                TestCase.assertEquals((Object)"invalidateRegionCBArg", (Object)re.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)re.isOriginRemote());
                re = (RegionEvent)events.get(evIdx++);
                TestCase.assertEquals((Object)Operation.REGION_CLEAR, (Object)re.getOperation());
                TestCase.assertEquals(null, (Object)re.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)re.isOriginRemote());
                TestCase.assertEquals((int)evIdx, (int)events.size());
            }
        });
    }

    public void disabled_testIllegalConfigQueueExists() throws Exception {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        this.createRootRegion(factory.create());
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties config = new Properties();
                config.setProperty("roles", "pubFirst");
                QueueMsgDUnitTest.this.getSystem(config);
            }
        });
        vm.invoke(new CacheSerializableRunnable("create root"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                String expectedExceptions = "does not allow queued messages";
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                QueueMsgDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>does not allow queued messages</ExpectedException>");
                try {
                    QueueMsgDUnitTest.this.createRootRegion(factory.create());
                    TestCase.fail((String)"expected IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    QueueMsgDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>does not allow queued messages</ExpectedException>");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable_testIllegalConfigSubscriberExists() throws Exception {
        String expectedExceptions = "does not allow queued messages";
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties config = new Properties();
                config.setProperty("roles", "subFirst");
                QueueMsgDUnitTest.this.getSystem(config);
            }
        });
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                QueueMsgDUnitTest.this.createRootRegion(factory.create());
            }
        });
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        this.getCache().getLogger().info("<ExpectedException action=add>does not allow queued messages</ExpectedException>");
        try {
            this.createRootRegion(factory.create());
            QueueMsgDUnitTest.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            this.getCache().getLogger().info("<ExpectedException action=remove>does not allow queued messages</ExpectedException>");
        }
    }

    public void testEmpty() {
    }
}

