/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.stack.Protocol;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class ReconnectDUnitTest
extends CacheTestCase {
    int locatorPort;
    Locator locator;
    static DistributedSystem savedSystem;
    static int locatorVMNumber;
    Properties dsProperties;
    public static volatile int reconnectTries;
    public static volatile boolean initialized;
    public static volatile boolean initialRolePlayerStarted;

    public ReconnectDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        final int locPort = this.locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        Host.getHost(0).getVM(locatorVMNumber).invoke(new SerializableRunnable("start locator"){

            @Override
            public void run() {
                try {
                    ReconnectDUnitTest.this.locatorPort = locPort;
                    Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                    props.put("log-file", "autoReconnectLocatorVM" + VM.getCurrentVMNum() + "_" + ReconnectDUnitTest.getPID() + ".log");
                    ReconnectDUnitTest.this.locator = Locator.startLocatorAndDS((int)ReconnectDUnitTest.this.locatorPort, null, (Properties)props);
                    DistributedTestCase.addExpectedException("com.gemstone.gemfire.ForcedDisconnectException||Possible loss of quorum");
                }
                catch (IOException e) {
                    DistributedTestCase.fail("unable to start locator", e);
                }
            }
        });
    }

    @Override
    public Properties getDistributedSystemProperties() {
        if (this.dsProperties == null) {
            this.dsProperties = super.getDistributedSystemProperties();
            this.dsProperties.put("max-wait-time-reconnect", "20000");
            this.dsProperties.put("enable-network-partition-detection", "true");
            this.dsProperties.put("disable-auto-reconnect", "false");
            this.dsProperties.put("locators", "localHost[" + this.locatorPort + "]");
            this.dsProperties.put("mcast-port", "0");
            this.dsProperties.put("member-timeout", "1000");
        }
        return this.dsProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
            Host.getHost(0).getVM(3).invoke(new SerializableRunnable("stop locator"){

                @Override
                public void run() {
                    if (ReconnectDUnitTest.this.locator != null) {
                        ReconnectDUnitTest.this.locator.stop();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            ReconnectDUnitTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    savedSystem = null;
                }
            });
            ReconnectDUnitTest.disconnectAllFromDS();
            throw throwable;
        }
        ReconnectDUnitTest.invokeInEveryVM(new /* invalid duplicate definition of identical inner class */);
        ReconnectDUnitTest.disconnectAllFromDS();
    }

    private RegionAttributes createAtts() {
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        return factory.create();
    }

    public void testReconnect() throws TimeoutException, CacheException, IOException {
        final int locPort = this.locatorPort;
        ReconnectDUnitTest.beginCacheXml();
        this.createRegion("myRegion", this.createAtts());
        this.finishCacheXml("MyDisconnect");
        ReconnectDUnitTest.closeCache();
        this.getSystem().disconnect();
        ReconnectDUnitTest.getLogWriter().fine("Cache Closed ");
        final String xmlFileLoc = new File(".").getAbsolutePath();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create1 = new CacheSerializableRunnable("Create Cache and Regions from cache.xml"){

            @Override
            public void run2() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "200");
                props.put("max-num-reconnect-tries", "1");
                DistributedTestCase.getLogWriter().info("test is creating distributed system");
                ReconnectDUnitTest.this.getSystem(props);
                DistributedTestCase.getLogWriter().info("test is creating cache");
                Cache cache = ReconnectDUnitTest.this.getCache();
                Region myRegion = cache.getRegion("root/myRegion");
                myRegion.put((Object)"MyKey1", (Object)"MyValue1");
            }
        };
        CacheSerializableRunnable create2 = new CacheSerializableRunnable("Create Cache and Regions from cache.xml"){

            @Override
            public void run2() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "200");
                props.put("max-num-reconnect-tries", "1");
                ReconnectDUnitTest.this.getSystem(props);
                Cache cache = ReconnectDUnitTest.this.getCache();
                Region myRegion = cache.getRegion("root/myRegion");
                myRegion.put((Object)"Mykey2", (Object)"MyValue2");
                TestCase.assertNotNull((Object)myRegion.get((Object)"MyKey1"));
            }
        };
        vm0.invoke(create1);
        vm1.invoke(create2);
        CacheSerializableRunnable reconnect = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "200");
                props.put("max-num-reconnect-tries", "1");
                ReconnectDUnitTest.this.getSystem(props);
                Cache cache = ReconnectDUnitTest.this.getCache();
                Region reg = cache.getRegion("root/myRegion");
                TestCase.assertNotNull((Object)reg.get((Object)"MyKey1"));
                DistributedTestCase.getLogWriter().fine("MyKey1 Value after disconnect : " + reg.get((Object)"MyKey1"));
            }
        };
        vm1.invoke(reconnect);
    }

    public void testReconnectWithQuorum() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final int locPort = this.locatorPort;
        int secondLocPort = AvailablePortHelper.getRandomAvailableTCPPort();
        final String xmlFileLoc = new File(".").getAbsolutePath();
        host.getVM(locatorVMNumber).invoke(new SerializableRunnable("disable force-disconnect"){

            @Override
            public void run() {
                GMS gms = (GMS)MembershipManagerHelper.getJChannel((DistributedSystem)InternalDistributedSystem.getConnectedInstance()).getProtocolStack().findProtocol("GMS");
                gms.disableDisconnectOnQuorumLossForTesting();
            }
        });
        SerializableCallable create = new SerializableCallable("Create Cache and Regions from cache.xml"){

            public Object call() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "1000");
                props.put("max-num-reconnect-tries", "2");
                props.put("log-file", "autoReconnectVM" + VM.getCurrentVMNum() + "_" + ReconnectDUnitTest.getPID() + ".log");
                Cache cache = new CacheFactory(props).create();
                DistributedTestCase.addExpectedException("com.gemstone.gemfire.ForcedDisconnectException||Possible loss of quorum");
                Region myRegion = cache.getRegion("root/myRegion");
                savedSystem = cache.getDistributedSystem();
                myRegion.put((Object)"MyKey1", (Object)"MyValue1");
                return savedSystem.getDistributedMember();
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm2.invoke(create);
        System.out.println("disconnecting vm0");
        this.forceDisconnect(vm0);
        ReconnectDUnitTest.pause(10000);
        System.out.println("disconnecting vm1");
        this.forceDisconnect(vm1);
        this.waitForReconnect(vm0);
        this.waitForReconnect(vm1);
    }

    private void deleteStateFile(int port) {
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
    }

    public void testReconnectOnForcedDisconnect() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int locPort = this.locatorPort;
        final int secondLocPort = AvailablePortHelper.getRandomAvailableTCPPort();
        final String xmlFileLoc = new File(".").getAbsolutePath();
        SerializableCallable create1 = new SerializableCallable("Create Cache and Regions from cache.xml"){

            public Object call() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "1000");
                props.put("max-num-reconnect-tries", "2");
                props.put("log-file", "autoReconnectVM" + VM.getCurrentVMNum() + "_" + ReconnectDUnitTest.getPID() + ".log");
                Cache cache = new CacheFactory(props).create();
                Region myRegion = cache.getRegion("root/myRegion");
                savedSystem = cache.getDistributedSystem();
                myRegion.put((Object)"MyKey1", (Object)"MyValue1");
                return savedSystem.getDistributedMember();
            }
        };
        SerializableCallable create2 = new SerializableCallable("Create Cache and Regions from cache.xml"){

            public Object call() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "1000");
                props.put("max-num-reconnect-tries", "2");
                props.put("start-locator", "localhost[" + secondLocPort + "]");
                props.put("locators", props.get("locators") + ",localhost[" + secondLocPort + "]");
                props.put("log-file", "autoReconnectVM" + VM.getCurrentVMNum() + "_" + ReconnectDUnitTest.getPID() + ".log");
                ReconnectDUnitTest.this.getSystem(props);
                Cache cache = ReconnectDUnitTest.this.getCache();
                savedSystem = cache.getDistributedSystem();
                Region myRegion = cache.getRegion("root/myRegion");
                myRegion.put((Object)"Mykey2", (Object)"MyValue2");
                TestCase.assertNotNull((Object)myRegion.get((Object)"MyKey1"));
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        vm0.invoke(create1);
        DistributedMember dm = (DistributedMember)vm1.invoke(create2);
        this.forceDisconnect(vm1);
        DistributedMember newdm = (DistributedMember)vm1.invoke(new SerializableCallable("wait for reconnect(1)"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() {
                final DistributedSystem ds = savedSystem;
                savedSystem = null;
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ds.isReconnecting();
                    }

                    @Override
                    public String description() {
                        return "waiting for ds to begin reconnecting";
                    }
                }, 30000L, 1000L, true);
                DistributedTestCase.getLogWriter().info("entering reconnect wait for " + ds);
                DistributedTestCase.getLogWriter().info("ds.isReconnecting() = " + ds.isReconnecting());
                boolean failure = true;
                try {
                    ds.waitUntilReconnected(60L, TimeUnit.SECONDS);
                    savedSystem = ds.getReconnectedSystem();
                    InternalLocator locator = (InternalLocator)Locator.getLocator();
                    TestCase.assertTrue((String)"Expected system to be restarted", (ds.getReconnectedSystem() != null ? 1 : 0) != 0);
                    TestCase.assertTrue((String)"Expected system to be running", (boolean)ds.getReconnectedSystem().isConnected());
                    TestCase.assertTrue((String)"Expected there to be a locator", (locator != null ? 1 : 0) != 0);
                    TestCase.assertTrue((String)"Expected locator to be restarted", (!locator.isStopped() ? 1 : 0) != 0);
                    failure = false;
                    DistributedMember distributedMember = ds.getReconnectedSystem().getDistributedMember();
                    return distributedMember;
                }
                catch (InterruptedException e) {
                    DistributedTestCase.getLogWriter().warning("interrupted while waiting for reconnect");
                    Object var4_6 = null;
                    return var4_6;
                }
                finally {
                    if (failure) {
                        ds.disconnect();
                    }
                }
            }
        });
        ReconnectDUnitTest.assertNotSame((Object)dm, (Object)newdm);
        this.forceDisconnect(vm1);
        boolean stopped = (Boolean)vm1.invoke(new SerializableCallable("wait for reconnect and stop"){

            public Object call() {
                final DistributedSystem ds = savedSystem;
                savedSystem = null;
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ds.isReconnecting() || ds.getReconnectedSystem() != null;
                    }

                    @Override
                    public String description() {
                        return "waiting for reconnect to commence in " + ds;
                    }
                }, 10000L, 1000L, true);
                ds.stopReconnecting();
                TestCase.assertFalse((boolean)ds.isReconnecting());
                InternalDistributedSystem newDs = InternalDistributedSystem.getAnyInstance();
                if (newDs != null) {
                    DistributedTestCase.getLogWriter().warning("expected distributed system to be disconnected: " + newDs);
                    return false;
                }
                return true;
            }
        });
        ReconnectDUnitTest.assertTrue((String)"expected DistributedSystem to disconnect", (boolean)stopped);
        dm = (DistributedMember)vm1.invoke(create1);
        this.forceDisconnect(vm1);
        newdm = this.waitForReconnect(vm1);
        ReconnectDUnitTest.assertNotSame((String)"expected a reconnect to occur in member", (Object)dm, (Object)newdm);
        this.deleteStateFile(locPort);
        this.deleteStateFile(secondLocPort);
    }

    private DistributedMember getDMID(VM vm) {
        return (DistributedMember)vm.invoke(new SerializableCallable("get ID"){

            public Object call() {
                savedSystem = InternalDistributedSystem.getAnyInstance();
                return savedSystem.getDistributedMember();
            }
        });
    }

    private DistributedMember waitForReconnect(VM vm) {
        return (DistributedMember)vm.invoke(new SerializableCallable("wait for Reconnect and return ID"){

            public Object call() {
                System.out.println("waitForReconnect invoked");
                final DistributedSystem ds = savedSystem;
                savedSystem = null;
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ds.isReconnecting();
                    }

                    @Override
                    public String description() {
                        return "waiting for ds to begin reconnecting";
                    }
                }, 60000L, 1000L, true);
                long waitTime = 180L;
                DistributedTestCase.getLogWriter().info("VM" + VM.getCurrentVMNum() + " waiting up to " + waitTime + " seconds for reconnect to complete");
                try {
                    ds.waitUntilReconnected(120L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)"interrupted while waiting for reconnect");
                }
                TestCase.assertTrue((String)"expected system to be reconnected", (ds.getReconnectedSystem() != null ? 1 : 0) != 0);
                return ds.getReconnectedSystem().getDistributedMember();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReconnectALocator() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int locPort = this.locatorPort;
        final int secondLocPort = AvailablePortHelper.getRandomAvailableTCPPort();
        final String xmlFileLoc = new File(".").getAbsolutePath();
        File locatorViewLog = new File("locator" + this.locatorPort + "views.log");
        ReconnectDUnitTest.assertTrue((String)("Expected to find " + locatorViewLog.getPath() + " file"), (boolean)locatorViewLog.exists());
        long logSize = locatorViewLog.length();
        vm0.invoke(new SerializableRunnable("Create a second locator"){

            @Override
            public void run() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("max-wait-time-reconnect", "1000");
                props.put("max-num-reconnect-tries", "2");
                props.put("locators", props.get("locators") + ",localhost[" + locPort + "]");
                try {
                    Locator.startLocatorAndDS((int)secondLocPort, null, (Properties)props);
                }
                catch (IOException e) {
                    DistributedTestCase.fail("exception starting locator", e);
                }
            }
        });
        File locator2ViewLog = new File("locator" + secondLocPort + "views.log");
        ReconnectDUnitTest.assertTrue((String)("Expected to find " + locator2ViewLog.getPath() + " file"), (boolean)locator2ViewLog.exists());
        long log2Size = locator2ViewLog.length();
        SerializableCallable create1 = new SerializableCallable("Create Cache and Regions from cache.xml"){

            public Object call() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/MyDisconnect-cache.xml");
                props.put("max-wait-time-reconnect", "1000");
                props.put("max-num-reconnect-tries", "2");
                savedSystem = ReconnectDUnitTest.this.getSystem(props);
                Cache cache = ReconnectDUnitTest.this.getCache();
                Region myRegion = cache.getRegion("root/myRegion");
                myRegion.put((Object)"MyKey1", (Object)"MyValue1");
                return savedSystem.getDistributedMember();
            }
        };
        vm1.invoke(create1);
        try {
            DistributedMember dm = this.getDMID(vm0);
            this.forceDisconnect(vm0);
            DistributedMember newdm = this.waitForReconnect(vm0);
            boolean running = (Boolean)vm0.invoke(new SerializableCallable("check for running locator"){

                public Object call() {
                    if (Locator.getLocator() == null) {
                        DistributedTestCase.getLogWriter().error("expected to find a running locator but getLocator() returns null");
                        return false;
                    }
                    if (((InternalLocator)Locator.getLocator()).isStopped()) {
                        DistributedTestCase.getLogWriter().error("found a stopped locator");
                        return false;
                    }
                    return true;
                }
            });
            if (!running) {
                ReconnectDUnitTest.fail((String)"expected the restarted member to be hosting a running locator");
            }
            ReconnectDUnitTest.assertNotSame((String)"expected a reconnect to occur in the locator", (Object)dm, (Object)newdm);
            ReconnectDUnitTest.assertTrue((String)("expected " + locator2ViewLog.getPath() + " to grow in size"), (locator2ViewLog.length() > log2Size ? 1 : 0) != 0);
            ReconnectDUnitTest.assertTrue((String)("expected " + locatorViewLog.getPath() + " to grow in size"), (locatorViewLog.length() > logSize ? 1 : 0) != 0);
            vm0.invoke(new SerializableRunnable("stop locator"){

                @Override
                public void run() {
                    Locator loc = Locator.getLocator();
                    if (loc != null) {
                        loc.stop();
                    }
                }
            });
            this.deleteStateFile(locPort);
            this.deleteStateFile(secondLocPort);
        }
        catch (Throwable throwable) {
            vm0.invoke(new /* invalid duplicate definition of identical inner class */);
            this.deleteStateFile(locPort);
            this.deleteStateFile(secondLocPort);
            throw throwable;
        }
    }

    public void testReconnectWithRoleLoss() throws TimeoutException, RegionExistsException {
        String rr1 = "RoleA";
        String rr2 = "RoleB";
        String[] requiredRoles = new String[]{"RoleA", "RoleB"};
        final int locPort = this.locatorPort;
        final String xmlFileLoc = new File(".").getAbsolutePath();
        ReconnectDUnitTest.beginCacheXml();
        this.locatorPort = locPort;
        Properties config = this.getDistributedSystemProperties();
        config.put("roles", "");
        config.put("log-level", ReconnectDUnitTest.getDUnitLogLevel());
        config.put("log-file", "roleLossController.log");
        this.getSystem(config);
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attr = fac.create();
        this.createRootRegion("MyRegion", attr);
        File file = new File("RoleReconnect-cache.xml");
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)this.getCache(), (PrintWriter)pw);
            pw.close();
        }
        catch (IOException ex) {
            ReconnectDUnitTest.fail("IOException during cache.xml generation to " + file, ex);
        }
        ReconnectDUnitTest.closeCache();
        this.getSystem().disconnect();
        ReconnectDUnitTest.getLogWriter().info("disconnected from the system...");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        CacheSerializableRunnable roleLoss = new CacheSerializableRunnable("ROLERECONNECTTESTS"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException, RuntimeException {
                DistributedTestCase.getLogWriter().fine("####### STARTING THE REAL TEST ##########");
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("cache-xml-file", xmlFileLoc + "/RoleReconnect-cache.xml");
                props.put("max-wait-time-reconnect", "200");
                int timeReconnect = 3;
                props.put("max-num-reconnect-tries", "3");
                props.put("log-level", DistributedTestCase.getDUnitLogLevel());
                props.put("log-file", "roleLossVM0.log");
                ReconnectDUnitTest.this.getSystem(props);
                ReconnectDUnitTest.this.addReconnectListener();
                DistributedTestCase.system.getLogWriter().info("<ExpectedException action=add>CacheClosedException</ExpectedException");
                try {
                    try {
                        ReconnectDUnitTest.this.getCache();
                        throw new RuntimeException("The test should throw a CancelException ");
                    }
                    catch (CancelException ignor) {
                        Log.getLogWriter().info("Got Expected CancelException ");
                        DistributedTestCase.system.getLogWriter().info("<ExpectedException action=remove>CacheClosedException</ExpectedException");
                    }
                }
                catch (Throwable throwable) {
                    DistributedTestCase.system.getLogWriter().info("<ExpectedException action=remove>CacheClosedException</ExpectedException");
                    throw throwable;
                }
                DistributedTestCase.getLogWriter().fine("roleLoss Sleeping SO call dumprun.sh");
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return reconnectTries >= 3;
                    }

                    @Override
                    public String description() {
                        return "Waiting for reconnect count 3 currently " + reconnectTries;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                DistributedTestCase.getLogWriter().fine("roleLoss done Sleeping");
                TestCase.assertEquals((int)3, (int)reconnectTries);
            }
        };
        vm0.invoke(roleLoss);
    }

    public static Integer reconnectTries() {
        return new Integer(reconnectTries);
    }

    public static Boolean isInitialized() {
        return new Boolean(initialized);
    }

    public static Boolean isInitialRolePlayerStarted() {
        return new Boolean(initialRolePlayerStarted);
    }

    public void DISABLED_testReconnectWithRequiredRoleRegained() throws Throwable {
        String rr1 = "RoleA";
        String[] requiredRoles = new String[]{"RoleA"};
        Integer[] numReconnect = new Integer[]{new Integer(-1)};
        String myKey = "MyKey";
        String myValue = "MyValue";
        String regionName = "MyRegion";
        final int locPort = this.locatorPort;
        ReconnectDUnitTest.beginCacheXml();
        this.locatorPort = locPort;
        Properties config = this.getDistributedSystemProperties();
        config.put("roles", "");
        config.put("log-level", ReconnectDUnitTest.getDUnitLogLevel());
        this.getSystem(config);
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.RECONNECT, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.create();
        this.createRootRegion("MyRegion", attr);
        File file = new File("RoleRegained.xml");
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)this.getCache(), (PrintWriter)pw);
            pw.close();
        }
        catch (IOException ex) {
            ReconnectDUnitTest.fail("IOException during cache.xml generation to " + file, ex);
        }
        ReconnectDUnitTest.closeCache();
        this.getSystem().disconnect();
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        final VM vm1 = host.getVM(1);
        CacheSerializableRunnable roleLoss = new CacheSerializableRunnable("roleloss runnable"){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run2() {
                block9: {
                    Thread t = null;
                    try {
                        DistributedTestCase.getLogWriter().info("####### STARTING THE REAL TEST ##########");
                        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                return (Boolean)vm1.invoke(ReconnectDUnitTest.class, "isInitialRolePlayerStarted");
                            }

                            @Override
                            public String description() {
                                return null;
                            }
                        };
                        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                        DistributedTestCase.getLogWriter().info("Starting the test and creating the cache and regions etc ...");
                        ReconnectDUnitTest.this.locatorPort = locPort;
                        Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                        props.put("cache-xml-file", "RoleRegained.xml");
                        props.put("max-wait-time-reconnect", "3000");
                        props.put("max-num-reconnect-tries", "8");
                        props.put("log-level", DistributedTestCase.getDUnitLogLevel());
                        ReconnectDUnitTest.this.getSystem(props);
                        DistributedTestCase.system.getLogWriter().info("<ExpectedException action=add>CacheClosedException</ExpectedException");
                        CacheTestCase.disconnectFromDS();
                        ReconnectDUnitTest.this.addReconnectListener();
                        t = new Thread(){

                            @Override
                            public void run() {
                                DistributedTestCase.WaitCriterion ev2 = new DistributedTestCase.WaitCriterion(){

                                    @Override
                                    public boolean done() {
                                        return reconnectTries != 0;
                                    }

                                    @Override
                                    public String description() {
                                        return null;
                                    }
                                };
                                DistributedTestCase.waitForCriterion(ev2, 30000L, 200L, true);
                            }
                        };
                        t.start();
                        try {
                            ReconnectDUnitTest.this.getCache();
                        }
                        catch (CancelException ignor) {
                            DistributedTestCase.getLogWriter().info("Get CacheCloseException while creating the cache");
                        }
                        initialized = true;
                        ev = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                return reconnectTries != 0;
                            }

                            @Override
                            public String description() {
                                return null;
                            }
                        };
                        DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
                        DistributedTestCase.getLogWriter().info("ReconnectTries=" + reconnectTries);
                        ev = new DistributedTestCase.WaitCriterion(){
                            String excuse;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public boolean done() {
                                if (InternalDistributedSystem.getReconnectCount() != 0) {
                                    this.excuse = "reconnectCount is " + reconnectTries + " waiting for it to be zero";
                                    return false;
                                }
                                Object key = null;
                                Object value = null;
                                Region.Entry keyValue2 = null;
                                try {
                                    Cache cache = CacheFactory.getAnyInstance();
                                    if (cache == null) {
                                        this.excuse = "no cache";
                                        boolean bl = false;
                                        return bl;
                                    }
                                    Region myRegion = cache.getRegion("MyRegion");
                                    if (myRegion == null) {
                                        this.excuse = "no region";
                                        boolean bl = false;
                                        return bl;
                                    }
                                    Set keyValuePair = myRegion.entrySet();
                                    for (Region.Entry keyValue2 : keyValuePair) {
                                        key = keyValue2.getKey();
                                        value = keyValue2.getValue();
                                    }
                                    if (key == null) {
                                        this.excuse = "key is null";
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (!"MyKey".equals(key)) {
                                        this.excuse = "key is wrong";
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (value == null) {
                                        this.excuse = "value is null";
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (!"MyValue".equals(value)) {
                                        this.excuse = "value is wrong";
                                        boolean bl = false;
                                        return bl;
                                    }
                                    DistributedTestCase.getLogWriter().info("All assertions passed");
                                    DistributedTestCase.getLogWriter().info("MyKey : " + key + " and myvalue : " + value);
                                    boolean bl = true;
                                    return bl;
                                }
                                catch (CancelException cancelException) {
                                }
                                catch (RegionDestroyedException regionDestroyedException) {
                                }
                                finally {
                                    DistributedTestCase.getLogWriter().info("waiting for reconnect.  Current status is '" + this.excuse + "'");
                                }
                                return false;
                            }

                            @Override
                            public String description() {
                                return this.excuse;
                            }
                        };
                        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                        Cache cache = CacheFactory.getAnyInstance();
                        if (cache != null) {
                            cache.getDistributedSystem().disconnect();
                        }
                        if (t == null) break block9;
                    }
                    catch (VirtualMachineError e) {
                        try {
                            SystemFailure.initiateFailure((Error)e);
                            throw e;
                            catch (Error th) {
                                DistributedTestCase.getLogWriter().severe("DEBUG", (Throwable)th);
                                throw th;
                            }
                        }
                        catch (Throwable throwable) {
                            if (t != null) {
                                DistributedTestCase.join(t, 120000L, DistributedTestCase.getLogWriter());
                            }
                            DistributedTestCase.system.getLogWriter().info("<ExpectedException action=remove>CacheClosedException</ExpectedException");
                            throw throwable;
                        }
                    }
                    DistributedTestCase.join(t, 120000L, DistributedTestCase.getLogWriter());
                }
                DistributedTestCase.system.getLogWriter().info("<ExpectedException action=remove>CacheClosedException</ExpectedException");
            }
        };
        CacheSerializableRunnable roleAPlayer = new CacheSerializableRunnable("ROLEAPLAYER"){

            @Override
            public void run2() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("log-level", DistributedTestCase.getDUnitLogLevel());
                props.put("roles", "RoleA");
                ReconnectDUnitTest.this.getSystem(props);
                ReconnectDUnitTest.this.getCache();
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(Scope.DISTRIBUTED_ACK);
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                Region region = ReconnectDUnitTest.this.createRootRegion("MyRegion", attr);
                DistributedTestCase.getLogWriter().info("STARTED THE REQUIREDROLES CACHE");
                try {
                    Thread.sleep(120L);
                }
                catch (Exception ee) {
                    TestCase.fail((String)"interrupted");
                }
                region.put((Object)"MyKey", (Object)"MyValue");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ee) {
                    TestCase.fail((String)"interrupted");
                }
                DistributedTestCase.getLogWriter().info("RolePlayer is done...");
            }
        };
        CacheSerializableRunnable roleAPlayerForCacheInitialization = new CacheSerializableRunnable("ROLEAPLAYERInitializer"){

            @Override
            public void run2() throws CacheException {
                ReconnectDUnitTest.this.locatorPort = locPort;
                Properties props = ReconnectDUnitTest.this.getDistributedSystemProperties();
                props.put("log-level", DistributedTestCase.getDUnitLogLevel());
                props.put("roles", "RoleA");
                ReconnectDUnitTest.this.getSystem(props);
                ReconnectDUnitTest.this.getCache();
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(Scope.DISTRIBUTED_ACK);
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                ReconnectDUnitTest.this.createRootRegion("MyRegion", attr);
                DistributedTestCase.getLogWriter().info("STARTED THE REQUIREDROLES CACHE");
                initialRolePlayerStarted = true;
                while (!((Boolean)vm0.invoke(ReconnectDUnitTest.class, "isInitialized")).booleanValue()) {
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException ignor) {
                        TestCase.fail((String)"interrupted");
                    }
                }
                DistributedTestCase.getLogWriter().info("RoleAPlayerInitializer is done...");
                CacheTestCase.closeCache();
            }
        };
        ReconnectDUnitTest.getLogWriter().info("starting roleAplayer, which will initialize, wait for vm0 to initialize, and then close its cache to cause role loss");
        AsyncInvocation avkVm1 = vm1.invokeAsync(roleAPlayerForCacheInitialization);
        ReconnectDUnitTest.getLogWriter().info("starting role loss vm.  When the role is lost it wills start trying to reconnect");
        final AsyncInvocation avkVm0 = vm0.invokeAsync(roleLoss);
        ReconnectDUnitTest.getLogWriter().info("waiting for role loss vm to start reconnect attempts");
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                if (!avkVm0.isAlive()) {
                    return true;
                }
                Object res = vm0.invoke(ReconnectDUnitTest.class, "reconnectTries");
                return (Integer)res != 0;
            }

            @Override
            public String description() {
                return "waiting for event";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
        VM vm2 = host.getVM(2);
        if (avkVm0.isAlive()) {
            ReconnectDUnitTest.getLogWriter().info("starting roleAPlayer in a different vm.  After this reconnect should succeed in vm0");
            vm2.invoke(roleAPlayer);
            ReconnectDUnitTest.getLogWriter().info("waiting for vm0 to finish reconnecting");
            DistributedTestCase.join(avkVm0, 120000L, ReconnectDUnitTest.getLogWriter());
        }
        if (avkVm0.getException() != null) {
            ReconnectDUnitTest.fail("Exception in Vm0", avkVm0.getException());
        }
        DistributedTestCase.join(avkVm1, 30000L, ReconnectDUnitTest.getLogWriter());
        if (avkVm1.getException() != null) {
            ReconnectDUnitTest.fail("Exception in Vm1", avkVm1.getException());
        }
    }

    void addReconnectListener() {
        reconnectTries = 0;
        ReconnectDUnitTest.getLogWriter().info("adding reconnect listener");
        InternalDistributedSystem.ReconnectListener reconlis = new InternalDistributedSystem.ReconnectListener(){

            public void reconnecting(InternalDistributedSystem oldSys) {
                DistributedTestCase.getLogWriter().info("reconnect listener invoked");
                ++reconnectTries;
            }

            public void onReconnect(InternalDistributedSystem system1, InternalDistributedSystem system2) {
            }
        };
        InternalDistributedSystem.addReconnectListener((InternalDistributedSystem.ReconnectListener)reconlis);
    }

    private void waitTimeout() throws InterruptedException {
        Thread.sleep(500L);
    }

    public boolean forceDisconnect(VM vm) {
        return (Boolean)vm.invoke(new SerializableCallable("crash distributed system"){

            public Object call() throws Exception {
                InternalDistributedSystem msys = InternalDistributedSystem.getAnyInstance();
                final Locator oldLocator = Locator.getLocator();
                MembershipManagerHelper.playDead((DistributedSystem)msys);
                JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
                Protocol udp = c.getProtocolStack().findProtocol("UDP");
                udp.passUp(new Event(46, (Object)new ForcedDisconnectException("killing member's ds")));
                if (oldLocator != null) {
                    DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return ((InternalLocator)oldLocator).isStopped();
                        }

                        @Override
                        public String description() {
                            return "waiting for locator to stop: " + oldLocator;
                        }
                    };
                    DistributedTestCase.waitForCriterion(wc, 10000L, 50L, true);
                }
                return true;
            }
        });
    }

    private static int getPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int idx = name.indexOf(64);
        try {
            return Integer.parseInt(name.substring(0, idx));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    static {
        locatorVMNumber = 3;
        initialized = false;
        initialRolePlayerStarted = false;
    }
}

