/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.RegionTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class RegionAttributesTestCase
extends RegionTestCase {
    public RegionAttributesTestCase(String name) {
        super(name);
    }

    public void testAttributesMutator() throws CacheException {
        String name = this.getUniqueName();
        AttributesFactory fac = new AttributesFactory(this.getRegionAttributes());
        fac.setStatisticsEnabled(true);
        Region region = this.createRegion(name, fac.create());
        TestCacheListener listener = new TestCacheListener(){};
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) {
                TestCase.fail((String)"Why was I invoked?");
                return null;
            }
        };
        TestCacheWriter writer = new TestCacheWriter(){};
        TestExpiry customEntryIdle = new TestExpiry();
        TestExpiry customTtl = new TestExpiry();
        ExpirationAttributes entryIdle = new ExpirationAttributes(5, ExpirationAction.DESTROY);
        ExpirationAttributes entryTTL = new ExpirationAttributes(6, ExpirationAction.INVALIDATE);
        ExpirationAttributes regionIdle = new ExpirationAttributes(7, ExpirationAction.DESTROY);
        ExpirationAttributes regionTTL = new ExpirationAttributes(8, ExpirationAction.INVALIDATE);
        AttributesMutator mutator = region.getAttributesMutator();
        RegionAttributesTestCase.assertEquals((Object)region, (Object)mutator.getRegion());
        RegionAttributesTestCase.assertSame((Object)region, (Object)mutator);
        mutator.setCacheListener((CacheListener)listener);
        mutator.setCacheLoader((CacheLoader)loader);
        mutator.setCacheWriter((CacheWriter)writer);
        mutator.setEntryIdleTimeout(entryIdle);
        mutator.setCustomEntryIdleTimeout((CustomExpiry)customEntryIdle);
        mutator.setEntryTimeToLive(entryTTL);
        mutator.setCustomEntryTimeToLive((CustomExpiry)customTtl);
        mutator.setRegionIdleTimeout(regionIdle);
        mutator.setRegionTimeToLive(regionTTL);
        RegionAttributes attrs = region.getAttributes();
        RegionAttributesTestCase.assertSame((Object)region, (Object)attrs);
        RegionAttributesTestCase.assertEquals((Object)listener, (Object)attrs.getCacheListener());
        RegionAttributesTestCase.assertEquals((Object)loader, (Object)attrs.getCacheLoader());
        RegionAttributesTestCase.assertEquals((Object)writer, (Object)attrs.getCacheWriter());
        RegionAttributesTestCase.assertEquals((Object)entryIdle, (Object)attrs.getEntryIdleTimeout());
        RegionAttributesTestCase.assertEquals((Object)entryTTL, (Object)attrs.getEntryTimeToLive());
        RegionAttributesTestCase.assertEquals((Object)customEntryIdle, (Object)attrs.getCustomEntryIdleTimeout());
        RegionAttributesTestCase.assertEquals((Object)customTtl, (Object)attrs.getCustomEntryTimeToLive());
        TestCacheListener listener2 = new TestCacheListener(){};
        TestCacheLoader loader2 = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) {
                TestCase.fail((String)"Why was I invoked?");
                return null;
            }
        };
        TestCacheWriter writer2 = new TestCacheWriter(){};
        TestExpiry customEntryIdle2 = new TestExpiry();
        TestExpiry customTtl2 = new TestExpiry();
        ExpirationAttributes entryIdle2 = new ExpirationAttributes(5, ExpirationAction.DESTROY);
        ExpirationAttributes entryTTL2 = new ExpirationAttributes(6, ExpirationAction.INVALIDATE);
        ExpirationAttributes regionIdle2 = new ExpirationAttributes(7, ExpirationAction.DESTROY);
        ExpirationAttributes regionTTL2 = new ExpirationAttributes(8, ExpirationAction.INVALIDATE);
        RegionAttributesTestCase.assertEquals((Object)listener, (Object)mutator.setCacheListener((CacheListener)listener2));
        RegionAttributesTestCase.assertEquals((Object)loader, (Object)mutator.setCacheLoader((CacheLoader)loader2));
        RegionAttributesTestCase.assertEquals((Object)writer, (Object)mutator.setCacheWriter((CacheWriter)writer2));
        RegionAttributesTestCase.assertEquals((Object)entryIdle, (Object)mutator.setEntryIdleTimeout(entryIdle2));
        RegionAttributesTestCase.assertEquals((Object)customEntryIdle, (Object)mutator.setCustomEntryIdleTimeout((CustomExpiry)customEntryIdle2));
        RegionAttributesTestCase.assertEquals((Object)entryTTL, (Object)mutator.setEntryTimeToLive(entryTTL2));
        RegionAttributesTestCase.assertEquals((Object)customTtl, (Object)mutator.setCustomEntryTimeToLive((CustomExpiry)customTtl2));
        RegionAttributesTestCase.assertEquals((Object)regionIdle, (Object)mutator.setRegionIdleTimeout(regionIdle2));
        RegionAttributesTestCase.assertEquals((Object)regionTTL, (Object)mutator.setRegionTimeToLive(regionTTL2));
    }

    public void testAttributesMutatorBogus() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        AttributesMutator mutator = region.getAttributesMutator();
        try {
            mutator.setEntryIdleTimeout(null);
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            mutator.setEntryTimeToLive(null);
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            mutator.setRegionIdleTimeout(null);
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            mutator.setRegionTimeToLive(null);
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            mutator.setEntryIdleTimeout(new ExpirationAttributes(1, ExpirationAction.DESTROY));
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            mutator.setEntryTimeToLive(new ExpirationAttributes(1, ExpirationAction.DESTROY));
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            mutator.setRegionIdleTimeout(new ExpirationAttributes(1, ExpirationAction.DESTROY));
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            mutator.setRegionTimeToLive(new ExpirationAttributes(1, ExpirationAction.DESTROY));
            RegionAttributesTestCase.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRegionAttributes() throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setConcurrencyLevel(60);
        factory.setConcurrencyChecksEnabled(true);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attrs = factory.create();
        String name = this.getUniqueName();
        Region region = this.createRegion(name, attrs);
        RegionAttributesTestCase.assertEquals((int)60, (int)region.getAttributes().getConcurrencyLevel());
        RegionAttributesTestCase.assertTrue((String)"expected concurrencyChecksEnabled to be true", (boolean)region.getAttributes().getConcurrencyChecksEnabled());
    }

    protected static class TestExpiry
    implements CustomExpiry,
    Declarable {
        final Exception created = new Exception();

        protected TestExpiry() {
        }

        public String toString() {
            final StringBuffer sb = new StringBuffer();
            sb.append("CustomExpiry from: <");
            OutputStream os = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    sb.append((char)b);
                }
            };
            PrintStream ps = new PrintStream(os);
            this.created.printStackTrace(ps);
            sb.append(">");
            return sb.toString();
        }

        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }
}

