/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.util.RegionMembershipListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.stack.Protocol;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class RegionMembershipListenerDUnitTest
extends CacheTestCase {
    private transient MyRML myListener;
    private transient MyRML mySRListener;
    private transient Region r;
    private transient Region sr;
    protected transient DistributedMember otherId;

    public RegionMembershipListenerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributedRegion.TEST_HOOK_ADD_PROFILE = true;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DistributedRegion.TEST_HOOK_ADD_PROFILE = false;
    }

    protected VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                RegionMembershipListenerDUnitTest.this.getCache();
            }
        });
        this.otherId = (DistributedMember)vm.invoke(RegionMembershipListenerDUnitTest.class, "getVMDistributedMember");
    }

    protected void createRootOtherVm(final String rName) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                Region r = RegionMembershipListenerDUnitTest.this.createRootRegion(rName, RegionMembershipListenerDUnitTest.this.createRootRegionAttributes(null));
                r.createSubregion("mysub", RegionMembershipListenerDUnitTest.this.createSubRegionAttributes(null));
            }
        });
    }

    protected RegionAttributes createRootRegionAttributes(CacheListener[] cacheListeners) {
        AttributesFactory af = new AttributesFactory();
        if (cacheListeners != null) {
            af.initCacheListeners(cacheListeners);
        }
        return af.create();
    }

    protected RegionAttributes createSubRegionAttributes(CacheListener[] cacheListeners) {
        return this.createRootRegionAttributes(cacheListeners);
    }

    protected void destroyRootOtherVm(final String rName) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("local destroy root"){

            @Override
            public void run2() throws CacheException {
                RegionMembershipListenerDUnitTest.this.getRootRegion(rName).localDestroyRegion();
            }
        });
    }

    protected void closeRootOtherVm(final String rName) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("close root"){

            @Override
            public void run2() throws CacheException {
                RegionMembershipListenerDUnitTest.this.getRootRegion(rName).close();
            }
        });
    }

    private void closeCacheOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("close cache"){

            @Override
            public void run2() throws CacheException {
                RegionMembershipListenerDUnitTest.this.getCache().close();
            }
        });
    }

    private void crashCacheOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("crash cache"){

            @Override
            public void run2() throws CacheException {
                GemFireCacheImpl cache = (GemFireCacheImpl)RegionMembershipListenerDUnitTest.this.getCache();
                InternalDistributedSystem sys = cache.getDistributedSystem();
                MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
                MembershipManagerHelper.playDead((DistributedSystem)sys);
                JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)sys);
                Protocol udp = c.getProtocolStack().findProtocol("UDP");
                udp.stop();
                udp.passUp(new Event(46, (Object)new Exception("killing locators ds")));
                try {
                    MembershipManagerHelper.getJChannel((DistributedSystem)sys).waitForClose();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
            }
        });
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    protected void createRootRegionWithListener(String rName) throws CacheException {
        int to = this.getOpTimeout();
        this.myListener = new MyRML(to);
        this.r = this.createRootRegion(rName, this.createRootRegionAttributes(new CacheListener[]{this.myListener}));
        this.mySRListener = new MyRML(to);
        this.sr = this.r.createSubregion("mysub", this.createSubRegionAttributes(new CacheListener[]{this.mySRListener}));
    }

    public int getOpTimeout() {
        return this.getSystem().getDistributionManager().getConfig().getMemberTimeout() * 3;
    }

    public void testInitialMembers() throws CacheException {
        String rName = this.getUniqueName();
        this.initOtherId();
        this.createRootRegionWithListener(rName);
        this.assertInitialMembers(null);
        this.createRootOtherVm(rName);
        this.closeRoots();
        this.createRootRegionWithListener(rName);
        this.assertInitialMembers(this.otherId);
    }

    protected void closeRoots() {
        this.r.close();
    }

    protected List<DistributedMember> assertInitialMembers(DistributedMember expectedId) {
        List<DistributedMember> l = expectedId == null ? Arrays.asList(new DistributedMember[0]) : Arrays.asList(expectedId);
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.myListener.lastOpWasInitialMembers());
        RegionMembershipListenerDUnitTest.assertEquals(l, (Object)this.myListener.getInitialMembers());
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.mySRListener.lastOpWasInitialMembers());
        RegionMembershipListenerDUnitTest.assertEquals(l, (Object)this.mySRListener.getInitialMembers());
        if (expectedId != null) {
            Cache cache = (Cache)this.r.getRegionService();
            RegionMembershipListenerDUnitTest.assertEquals(l, new ArrayList(cache.getMembers(this.r)));
            RegionMembershipListenerDUnitTest.assertEquals(l, new ArrayList(cache.getMembers(this.sr)));
        }
        return l;
    }

    public void testCreate() throws CacheException {
        String rName = this.getUniqueName();
        this.initOtherId();
        this.createRootRegionWithListener(rName);
        this.createRootOtherVm(rName);
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.myListener.lastOpWasCreate());
        RegionEvent e = this.myListener.getLastEvent();
        RegionMembershipListenerDUnitTest.assertEquals((Object)this.otherId, (Object)e.getDistributedMember());
        RegionMembershipListenerDUnitTest.assertEquals((Object)Operation.REGION_CREATE, (Object)e.getOperation());
        RegionMembershipListenerDUnitTest.assertEquals((boolean)true, (boolean)e.isOriginRemote());
        RegionMembershipListenerDUnitTest.assertEquals((boolean)false, (boolean)e.isDistributed());
        RegionMembershipListenerDUnitTest.assertEquals((Object)this.r, (Object)e.getRegion());
        RegionMembershipListenerDUnitTest.assertTrue((boolean)(e.getCallbackArgument() instanceof DistributionAdvisor.Profile));
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.mySRListener.lastOpWasCreate());
        e = this.mySRListener.getLastEvent();
        RegionMembershipListenerDUnitTest.assertEquals((Object)this.otherId, (Object)e.getDistributedMember());
        RegionMembershipListenerDUnitTest.assertEquals((Object)Operation.REGION_CREATE, (Object)e.getOperation());
        RegionMembershipListenerDUnitTest.assertEquals((boolean)true, (boolean)e.isOriginRemote());
        RegionMembershipListenerDUnitTest.assertEquals((boolean)false, (boolean)e.isDistributed());
        RegionMembershipListenerDUnitTest.assertEquals((Object)this.sr, (Object)e.getRegion());
        RegionMembershipListenerDUnitTest.assertTrue((boolean)(e.getCallbackArgument() instanceof DistributionAdvisor.Profile));
    }

    public void testDeparture() throws CacheException {
        String rName = this.getUniqueName();
        this.initOtherId();
        this.createRootRegionWithListener(rName);
        this.createRootOtherVm(rName);
        this.assertOpWasCreate();
        this.destroyRootOtherVm(rName);
        this.assertOpWasDeparture();
        this.createRootOtherVm(rName);
        this.assertOpWasCreate();
        this.closeRootOtherVm(rName);
        this.assertOpWasDeparture();
        this.createRootOtherVm(rName);
        this.assertOpWasCreate();
        this.closeCacheOtherVm();
        this.assertOpWasDeparture();
    }

    protected void assertOpWasDeparture() {
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.myListener.lastOpWasDeparture());
        RegionMembershipListenerDUnitTest.assertEventStuff(this.myListener.getLastEvent(), this.otherId, this.r);
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.mySRListener.lastOpWasDeparture());
        RegionMembershipListenerDUnitTest.assertEventStuff(this.mySRListener.getLastEvent(), this.otherId, this.sr);
    }

    public static void assertEventStuff(RegionEvent e, DistributedMember em, Region er) {
        RegionMembershipListenerDUnitTest.assertEquals((Object)em, (Object)e.getDistributedMember());
        RegionMembershipListenerDUnitTest.assertEquals((Object)Operation.REGION_CLOSE, (Object)e.getOperation());
        RegionMembershipListenerDUnitTest.assertEquals((boolean)true, (boolean)e.isOriginRemote());
        RegionMembershipListenerDUnitTest.assertEquals((boolean)false, (boolean)e.isDistributed());
        RegionMembershipListenerDUnitTest.assertEquals((Object)er, (Object)e.getRegion());
        RegionMembershipListenerDUnitTest.assertEquals(null, (Object)e.getCallbackArgument());
    }

    protected void assertOpWasCreate() {
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.myListener.lastOpWasCreate());
        RegionMembershipListenerDUnitTest.assertTrue((boolean)this.mySRListener.lastOpWasCreate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCrash() throws CacheException {
        String rName = this.getUniqueName();
        this.initOtherId();
        this.createRootRegionWithListener(rName);
        this.createRootOtherVm(rName);
        try {
            RegionMembershipListenerDUnitTest.assertTrue((boolean)this.myListener.lastOpWasCreate());
            RegionMembershipListenerDUnitTest.assertTrue((boolean)this.mySRListener.lastOpWasCreate());
            MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
            this.crashCacheOtherVm();
            int to = this.getOpTimeout();
            MembershipManagerHelper.waitForMemberDeparture((DistributedSystem)system, (DistributedMember)this.otherId, (long)to);
            this.myListener.waitForCrashOp();
            RegionEvent e = this.myListener.getLastEvent();
            RegionMembershipListenerDUnitTest.assertEquals((Object)this.otherId, (Object)e.getDistributedMember());
            RegionMembershipListenerDUnitTest.assertEquals((Object)Operation.REGION_CLOSE, (Object)e.getOperation());
            RegionMembershipListenerDUnitTest.assertEquals((boolean)true, (boolean)e.isOriginRemote());
            RegionMembershipListenerDUnitTest.assertEquals((boolean)false, (boolean)e.getOperation().isDistributed());
            RegionMembershipListenerDUnitTest.assertEquals((Object)this.r, (Object)e.getRegion());
            RegionMembershipListenerDUnitTest.assertEquals(null, (Object)e.getCallbackArgument());
            this.mySRListener.waitForCrashOp();
            e = this.mySRListener.getLastEvent();
            RegionMembershipListenerDUnitTest.assertEquals((Object)this.otherId, (Object)e.getDistributedMember());
            RegionMembershipListenerDUnitTest.assertEquals((Object)Operation.REGION_CLOSE, (Object)e.getOperation());
            RegionMembershipListenerDUnitTest.assertEquals((boolean)true, (boolean)e.isOriginRemote());
            RegionMembershipListenerDUnitTest.assertEquals((boolean)false, (boolean)e.getOperation().isDistributed());
            RegionMembershipListenerDUnitTest.assertEquals((Object)this.sr, (Object)e.getRegion());
            RegionMembershipListenerDUnitTest.assertEquals(null, (Object)e.getCallbackArgument());
        }
        finally {
            MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
            RegionMembershipListenerDUnitTest.disconnectAllFromDS();
        }
    }

    public class MyRML
    extends RegionMembershipListenerAdapter {
        private final int timeOut;
        volatile Op lastOp;
        private volatile RegionEvent lastEvent;
        private volatile DistributedMember[] initialMembers;
        private volatile boolean memberInitialized;

        public MyRML(int to) {
            this.timeOut = to;
        }

        public boolean lastOpWasInitialMembers() {
            return this.waitForOp(Op.Initial);
        }

        public boolean lastOpWasCreate() {
            boolean result = this.waitForOp(Op.Create);
            if (result) {
                TestCase.assertTrue((String)"bug #44684 - expected remote member to be initialized when afterRemoteRegionCreate was invoked", (boolean)this.memberInitialized);
            }
            return result;
        }

        public boolean lastOpWasDeparture() {
            return this.waitForOp(Op.Departure);
        }

        public String getOpName(Op op) {
            if (op == null) {
                return "null";
            }
            switch (op) {
                case Initial: {
                    return "Initial";
                }
                case Create: {
                    return "Create";
                }
                case Departure: {
                    return "Departure";
                }
                case Crash: {
                    return "Crash";
                }
            }
            return "Unknown";
        }

        private boolean waitForOp(final Op op) {
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return MyRML.this.lastOp == op;
                }

                @Override
                public String description() {
                    return ((Object)((Object)MyRML.this)).toString() + " waiting for Op " + (Object)((Object)op) + " when lastOp was " + MyRML.this.getOpName(MyRML.this.lastOp);
                }
            };
            DistributedTestCase.getLogWriter().info(((Object)((Object)this)).toString() + " waiting for Op " + this.getOpName(op) + " when lastOp was " + this.getOpName(this.lastOp));
            DistributedTestCase.waitForCriterion(ev, this.timeOut, 200L, true);
            TestCase.assertEquals((Object)((Object)op), (Object)((Object)this.lastOp));
            return true;
        }

        public void waitForCrashOp() {
            this.waitForOp(Op.Crash);
        }

        public RegionEvent getLastEvent() {
            return this.lastEvent;
        }

        public List getInitialMembers() {
            return Arrays.asList(this.initialMembers);
        }

        public void initialMembers(Region r, DistributedMember[] initialMembers) {
            this.lastOp = Op.Initial;
            this.lastEvent = null;
            this.initialMembers = initialMembers;
            DistributedTestCase.getLogWriter().info(((Object)((Object)this)).toString() + " received initialMembers notification for region " + r + " with members " + Arrays.deepToString(initialMembers));
        }

        public void afterRemoteRegionCreate(RegionEvent event) {
            this.lastOp = Op.Create;
            this.lastEvent = event;
            CacheDistributionAdvisor.CacheProfile cacheProfile = (CacheDistributionAdvisor.CacheProfile)event.getCallbackArgument();
            if (cacheProfile != null) {
                this.memberInitialized = cacheProfile.regionInitialized;
                if (!this.memberInitialized) {
                    DistributedTestCase.getLogWriter().warning("afterRemoteRegionCreate invoked when member is not done initializing!", (Throwable)new Exception("stack trace"));
                }
                DistributedTestCase.getLogWriter().info(((Object)((Object)this)).toString() + " received afterRemoteRegionCreate notification for event " + event);
            } else {
                DistributedTestCase.getLogWriter().warning("afterRemoteRegionCreate was expecting a profile in the event callback but there was none.  This indicates a problem with the test hook DistributedRegion.TEST_HOOK_ADD_PROFILE");
            }
        }

        public void afterRemoteRegionDeparture(RegionEvent event) {
            this.lastOp = Op.Departure;
            this.lastEvent = event;
            DistributedTestCase.getLogWriter().info(((Object)((Object)this)).toString() + " received afterRemoteRegionDeparture notification for event " + event);
        }

        public void afterRemoteRegionCrash(RegionEvent event) {
            this.lastOp = Op.Crash;
            this.lastEvent = event;
            DistributedTestCase.getLogWriter().info(((Object)((Object)this)).toString() + " received afterRemoteRegionCrash notification for event " + event);
        }
    }

    static enum Op {
        Initial,
        Create,
        Departure,
        Crash;

    }
}

