/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.RoleEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.RegionRoleListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.ReliabilityTestCase;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.Properties;
import java.util.Set;

public class RegionReliabilityListenerTest
extends ReliabilityTestCase {
    protected static transient Set rolesGain = null;
    protected static transient Set rolesLoss = null;

    public RegionReliabilityListenerTest(String name) {
        super(name);
    }

    public void testRoleGainAndLoss() throws Exception {
        InternalRole role;
        int i;
        InternalRole role2;
        int i2;
        final String name = this.getUniqueName();
        boolean vm0 = false;
        boolean vm1 = true;
        int vm2 = 2;
        int vm3 = 3;
        String roleA = name + "-A";
        String roleC = name + "-C";
        String roleD = name + "-D";
        String[] requiredRoles = new String[]{roleA, roleC, roleD};
        final String[] rolesProp = new String[]{"", roleA, roleA, roleC + "," + roleD};
        String[][] vmRoles = new String[][]{new String[0], {roleA}, {roleA}, {roleC, roleD}};
        int i3 = 0;
        while (i3 < vmRoles.length) {
            final int vm = i3++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Properties config = new Properties();
                    config.setProperty("roles", rolesProp[vm]);
                    RegionReliabilityListenerTest.this.getSystem(config);
                }
            });
        }
        RegionRoleListenerAdapter listener = new RegionRoleListenerAdapter(){

            public void afterRoleGain(RoleEvent event) {
                rolesGain = event.getRequiredRoles();
            }

            public void afterRoleLoss(RoleEvent event) {
                rolesLoss = event.getRequiredRoles();
            }
        };
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.addCacheListener((CacheListener)listener);
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attr = fac.create();
        this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        this.assertMissingRoles(name, requiredRoles);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(Scope.DISTRIBUTED_ACK);
                RegionAttributes attr = fac.create();
                RegionReliabilityListenerTest.this.createRootRegion(name, attr);
            }
        };
        Host.getHost(0).getVM(0).invoke(create);
        RegionReliabilityListenerTest.assertNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertNull((Object)rolesLoss);
        this.assertMissingRoles(name, requiredRoles);
        Host.getHost(0).getVM(1).invoke(create);
        RegionReliabilityListenerTest.assertNotNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertEquals((int)vmRoles[1].length, (int)rolesGain.size());
        for (i2 = 0; i2 < vmRoles[1].length; ++i2) {
            role2 = InternalRole.getRole((String)vmRoles[1][i2]);
            RegionReliabilityListenerTest.assertEquals((boolean)true, (boolean)rolesGain.contains(role2));
        }
        RegionReliabilityListenerTest.assertNull((Object)rolesLoss);
        rolesGain = null;
        this.assertMissingRoles(name, vmRoles[3]);
        Host.getHost(0).getVM(2).invoke(create);
        RegionReliabilityListenerTest.assertNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertNull((Object)rolesLoss);
        this.assertMissingRoles(name, vmRoles[3]);
        Host.getHost(0).getVM(3).invoke(create);
        RegionReliabilityListenerTest.assertNotNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertEquals((int)vmRoles[3].length, (int)rolesGain.size());
        for (i2 = 0; i2 < vmRoles[3].length; ++i2) {
            role2 = InternalRole.getRole((String)vmRoles[3][i2]);
            RegionReliabilityListenerTest.assertEquals((boolean)true, (boolean)rolesGain.contains(role2));
        }
        RegionReliabilityListenerTest.assertNull((Object)rolesLoss);
        rolesGain = null;
        this.assertMissingRoles(name, new String[0]);
        CacheSerializableRunnable destroy = new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = RegionReliabilityListenerTest.this.getRootRegion(name);
                region.localDestroyRegion();
            }
        };
        Host.getHost(0).getVM(0).invoke(destroy);
        RegionReliabilityListenerTest.assertNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertNull((Object)rolesLoss);
        this.assertMissingRoles(name, new String[0]);
        Host.getHost(0).getVM(1).invoke(destroy);
        RegionReliabilityListenerTest.assertNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertNull((Object)rolesLoss);
        this.assertMissingRoles(name, new String[0]);
        Host.getHost(0).getVM(2).invoke(destroy);
        RegionReliabilityListenerTest.assertNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertNotNull((Object)rolesLoss);
        RegionReliabilityListenerTest.assertEquals((int)vmRoles[2].length, (int)rolesLoss.size());
        for (i = 0; i < vmRoles[2].length; ++i) {
            role = InternalRole.getRole((String)vmRoles[2][i]);
            RegionReliabilityListenerTest.assertEquals((boolean)true, (boolean)rolesLoss.contains(role));
        }
        rolesLoss = null;
        this.assertMissingRoles(name, vmRoles[2]);
        Host.getHost(0).getVM(3).invoke(destroy);
        RegionReliabilityListenerTest.assertNull((Object)rolesGain);
        RegionReliabilityListenerTest.assertNotNull((Object)rolesLoss);
        RegionReliabilityListenerTest.assertEquals((int)vmRoles[3].length, (int)rolesLoss.size());
        for (i = 0; i < vmRoles[3].length; ++i) {
            role = InternalRole.getRole((String)vmRoles[3][i]);
            RegionReliabilityListenerTest.assertEquals((boolean)true, (boolean)rolesLoss.contains(role));
        }
        rolesLoss = null;
        this.assertMissingRoles(name, requiredRoles);
    }
}

