/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CommitDistributionException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAccessException;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDistributionException;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionReinitializedException;
import com.gemstone.gemfire.cache.RequiredRoles;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.util.RegionMembershipListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.ReliabilityTestCase;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import junit.framework.TestCase;

public abstract class RegionReliabilityTestCase
extends ReliabilityTestCase {
    protected static Boolean[] detectedDeparture_testCommitDistributionException = new Boolean[]{Boolean.FALSE};
    protected static Boolean[] detectedDeparture_testRegionDistributionException = new Boolean[]{Boolean.FALSE};

    public RegionReliabilityTestCase(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        DistributedCacheOperation.setBeforePutOutgoing(null);
        super.tearDown2();
    }

    protected abstract Scope getRegionScope();

    protected InternalDistributedSystem createConnection(String[] roles) {
        StringBuffer rolesValue = new StringBuffer();
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                if (i > 0) {
                    rolesValue.append(",");
                }
                rolesValue.append(roles[i]);
            }
        }
        Properties config = new Properties();
        config.setProperty("roles", rolesValue.toString());
        return this.getSystem(config);
    }

    protected void assertLimitedAccessThrows(Region region) throws Exception {
        try {
            region.clear();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.create((Object)"KEY", (Object)"VAL");
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.destroy(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.destroyRegion();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        if (region.getAttributes().getScope().isGlobal()) {
            try {
                region.becomeLockGrantor();
                RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
            }
            catch (RegionAccessException regionAccessException) {
                // empty catch block
            }
            try {
                region.getDistributedLock(new Object());
                RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
            }
            catch (RegionAccessException regionAccessException) {
                // empty catch block
            }
            try {
                region.getRegionDistributedLock();
                RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
            }
            catch (RegionAccessException regionAccessException) {
                // empty catch block
            }
        }
        try {
            region.invalidate(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.invalidateRegion();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.loadSnapshot((InputStream)new ByteArrayInputStream(new byte[0]));
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.get((Object)"netload");
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.get((Object)"netsearch");
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.put(new Object(), new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(new Object(), new Object());
            region.putAll(map);
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException map) {
            // empty catch block
        }
        try {
            region.remove(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException map) {
            // empty catch block
        }
        if (!region.getAttributes().getScope().isGlobal()) {
            CacheTransactionManager tx = region.getCache().getCacheTransactionManager();
            tx.begin();
            try {
                region.put((Object)"KEY-tx", (Object)"VAL-tx");
                RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
            }
            catch (RegionAccessException regionAccessException) {
                // empty catch block
            }
            tx.rollback();
        }
    }

    protected void assertNoAccessThrows(Region region) throws Exception {
        this.assertLimitedAccessThrows(region);
        try {
            region.containsKey(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.containsValue(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.containsValueForKey(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.entries(false);
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.entrySet();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.get(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.getEntry(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.isEmpty();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.keys();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.keySet();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.localDestroy(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.localInvalidate(new Object());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.localInvalidateRegion();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.saveSnapshot((OutputStream)new ByteArrayOutputStream());
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.size();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            region.values();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
        try {
            QueryService qs = region.getCache().getQueryService();
            Query query = qs.newQuery("(select distinct * from " + region.getFullPath() + ").size");
            query.execute();
            RegionReliabilityTestCase.fail((String)"Should have thrown an RegionAccessException");
        }
        catch (RegionAccessException regionAccessException) {
            // empty catch block
        }
    }

    protected void assertLimitedAccessDoesNotThrow(Region region) throws Exception {
        Object[] keys = new Object[]{"hip", "hop"};
        Object[] values = new Object[]{"clip", "clop"};
        for (int i = 0; i < keys.length; ++i) {
            region.put(keys[i], values[i]);
        }
        region.create((Object)"jack", (Object)"jill");
        region.destroy((Object)"jack");
        if (region.getAttributes().getScope().isGlobal()) {
            region.becomeLockGrantor();
            Lock dlock = region.getDistributedLock(keys[0]);
            dlock.lock();
            dlock.unlock();
            Lock rlock = region.getRegionDistributedLock();
            rlock.lock();
            rlock.unlock();
        }
        RegionReliabilityTestCase.assertEquals((Object)"netload", (Object)region.get((Object)"netload"));
        RegionReliabilityTestCase.assertEquals((Object)"netsearch", (Object)region.get((Object)"netsearch"));
        region.invalidate(keys[0]);
        region.invalidateRegion();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        region.saveSnapshot((OutputStream)baos);
        region.loadSnapshot((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        region = this.getRootRegion(region.getFullPath());
        region.put(keys[0], values[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mom", "pop");
        region.putAll(map);
        QueryService qs = region.getCache().getQueryService();
        Query query = qs.newQuery("(select distinct * from " + region.getFullPath() + ").size");
        query.execute();
        region.remove(keys[0]);
        if (!region.getAttributes().getScope().isGlobal()) {
            CacheTransactionManager tx = region.getCache().getCacheTransactionManager();
            tx.begin();
            region.put((Object)"KEY-tx", (Object)"VAL-tx");
            tx.commit();
        }
        region.clear();
        region.destroyRegion();
    }

    protected void assertNoAccessDoesNotThrow(Region region) throws Exception {
        Object[] keys = new Object[]{"bip", "bam"};
        Object[] values = new Object[]{"foo", "bar"};
        for (int i = 0; i < keys.length; ++i) {
            region.put(keys[i], values[i]);
        }
        region.containsKey(new Object());
        region.containsValue(new Object());
        region.containsValueForKey(new Object());
        region.entries(false);
        region.entrySet();
        region.get(keys[0]);
        region.getEntry(keys[0]);
        region.isEmpty();
        region.keys();
        region.keySet();
        region.localDestroy(keys[0]);
        region.localInvalidate(keys[1]);
        region.localInvalidateRegion();
        region.saveSnapshot((OutputStream)new ByteArrayOutputStream());
        region.size();
        region.values();
        QueryService qs = region.getCache().getQueryService();
        Query query = qs.newQuery("(select distinct * from " + region.getFullPath() + ").size");
        query.execute();
        this.assertLimitedAccessDoesNotThrow(region);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            RegionReliabilityTestCase.fail((String)"interrupted");
        }
    }

    public void testNoAccess() throws Exception {
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(null);
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                fac.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        if ("netload".equals(helper.getKey())) {
                            return "netload";
                        }
                        return null;
                    }

                    public void close() {
                    }
                });
                RegionAttributes attr = fac.create();
                Region region = RegionReliabilityTestCase.this.createRootRegion(name, attr);
                String netsearch = "netsearch";
                region.put((Object)netsearch, (Object)netsearch);
            }
        });
        this.assertNoAccessThrows(region);
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        Role role = (Role)requiredRolesSet.iterator().next();
        RegionReliabilityTestCase.assertTrue((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role));
        this.assertNoAccessDoesNotThrow(region);
    }

    private static LogWriter findLogWriter() {
        DM dm = InternalDistributedSystem.getAnyInstance().getDistributionManager();
        return dm.getLoggerI18n().convertToLogWriter();
    }

    private static InternalDistributedMember findDistributedMember() {
        DM dm = InternalDistributedSystem.getAnyInstance().getDistributionManager();
        return dm.getDistributionManagerId();
    }

    public void testNoAccessWithLocalEntryExpiration() throws Exception {
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        region.put((Object)"expireMe", (Object)"expireMe");
        RegionReliabilityTestCase.assertTrue((region.size() == 1 ? 1 : 0) != 0);
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Close Region"){

            @Override
            public void run2() throws CacheException {
                Region region = RegionReliabilityTestCase.this.getRootRegion(name);
                region.close();
            }
        });
        AttributesMutator mutator = region.getAttributesMutator();
        mutator.setEntryTimeToLive(new ExpirationAttributes(1, ExpirationAction.LOCAL_DESTROY));
        this.sleep(2000L);
        Set entries = ((LocalRegion)region).basicEntries(false);
        RegionReliabilityTestCase.assertTrue((entries.size() == 1 ? 1 : 0) != 0);
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        this.sleep(2000L);
        RegionReliabilityTestCase.assertEquals(null, (Object)region.get((Object)"expireMe"));
        RegionReliabilityTestCase.assertTrue((region.size() == 0 ? 1 : 0) != 0);
    }

    public void testNoAccessWithLocalRegionExpiration() throws Exception {
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        AttributesMutator mutator = region.getAttributesMutator();
        mutator.setRegionTimeToLive(new ExpirationAttributes(1, ExpirationAction.LOCAL_DESTROY));
        this.sleep(2000L);
        RegionReliabilityTestCase.assertFalse((boolean)region.isDestroyed());
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        this.sleep(2000L);
        RegionReliabilityTestCase.assertTrue((boolean)region.isDestroyed());
    }

    public void testLimitedAccess() throws Exception {
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.LIMITED_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(null);
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                fac.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        if ("netload".equals(helper.getKey())) {
                            return "netload";
                        }
                        return null;
                    }

                    public void close() {
                    }
                });
                RegionAttributes attr = fac.create();
                Region region = RegionReliabilityTestCase.this.createRootRegion(name, attr);
                String netsearch = "netsearch";
                region.put((Object)netsearch, (Object)netsearch);
            }
        });
        this.assertLimitedAccessThrows(region);
        QueryService qs = region.getCache().getQueryService();
        Query query = qs.newQuery("(select distinct * from " + region.getFullPath() + ").size");
        query.execute();
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        this.assertLimitedAccessDoesNotThrow(region);
    }

    public void testLimitedAccessWithLocalEntryExpiration() throws Exception {
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.LIMITED_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        region.put((Object)"expireMe", (Object)"expireMe");
        RegionReliabilityTestCase.assertTrue((region.size() == 1 ? 1 : 0) != 0);
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Close Region"){

            @Override
            public void run2() throws CacheException {
                Region region = RegionReliabilityTestCase.this.getRootRegion(name);
                region.close();
            }
        });
        AttributesMutator mutator = region.getAttributesMutator();
        mutator.setEntryTimeToLive(new ExpirationAttributes(1, ExpirationAction.LOCAL_DESTROY));
        this.sleep(2000L);
        Set entries = ((LocalRegion)region).basicEntries(false);
        RegionReliabilityTestCase.assertTrue((entries.size() == 0 ? 1 : 0) != 0);
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        region.put((Object)"expireMe", (Object)"expireMe");
        RegionReliabilityTestCase.assertTrue((region.size() == 1 ? 1 : 0) != 0);
        this.sleep(2000L);
        RegionReliabilityTestCase.assertEquals(null, (Object)region.get((Object)"expireMe"));
        RegionReliabilityTestCase.assertTrue((region.size() == 0 ? 1 : 0) != 0);
    }

    public void testLimitedAccessWithLocalRegionExpiration() throws Exception {
        String name = this.getUniqueName();
        String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.LIMITED_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        AttributesMutator mutator = region.getAttributesMutator();
        mutator.setRegionTimeToLive(new ExpirationAttributes(1, ExpirationAction.LOCAL_DESTROY));
        this.sleep(2000L);
        RegionReliabilityTestCase.assertTrue((boolean)region.isDestroyed());
    }

    public void testFullAccess() throws Exception {
        final String name = this.getUniqueName();
        String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(null);
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                fac.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        if ("netload".equals(helper.getKey())) {
                            return "netload";
                        }
                        return null;
                    }

                    public void close() {
                    }
                });
                RegionAttributes attr = fac.create();
                Region region = RegionReliabilityTestCase.this.createRootRegion(name, attr);
                String netsearch = "netsearch";
                region.put((Object)netsearch, (Object)netsearch);
            }
        });
        this.assertNoAccessDoesNotThrow(region);
    }

    public void testFullAccessWithLocalEntryExpiration() throws Exception {
        String name = this.getUniqueName();
        String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        region.put((Object)"expireMe", (Object)"expireMe");
        RegionReliabilityTestCase.assertTrue((region.size() == 1 ? 1 : 0) != 0);
        AttributesMutator mutator = region.getAttributesMutator();
        mutator.setEntryTimeToLive(new ExpirationAttributes(1, ExpirationAction.LOCAL_DESTROY));
        this.sleep(2000L);
        RegionReliabilityTestCase.assertNull((Object)region.get((Object)"expireMe"));
        RegionReliabilityTestCase.assertTrue((region.size() == 0 ? 1 : 0) != 0);
    }

    public void testFullAccessWithLocalRegionExpiration() throws Exception {
        String name = this.getUniqueName();
        String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setStatisticsEnabled(true);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        AttributesMutator mutator = region.getAttributesMutator();
        mutator.setRegionTimeToLive(new ExpirationAttributes(1, ExpirationAction.LOCAL_DESTROY));
        this.sleep(2000L);
        RegionReliabilityTestCase.assertTrue((boolean)region.isDestroyed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testCommitDistributionException() throws Exception {
        if (this.getRegionScope().isGlobal()) {
            return;
        }
        if (this.getRegionScope().isDistributedNoAck()) {
            return;
        }
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        RegionMembershipListenerAdapter listener = new RegionMembershipListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRemoteRegionDeparture(RegionEvent event) {
                Boolean[] booleanArray = detectedDeparture_testCommitDistributionException;
                synchronized (detectedDeparture_testCommitDistributionException) {
                    RegionReliabilityTestCase.detectedDeparture_testCommitDistributionException[0] = Boolean.TRUE;
                    detectedDeparture_testCommitDistributionException.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.addCacheListener((CacheListener)listener);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        SerializableRunnable removeRequiredRole = new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Host.getHost(0).getVM(1).invoke(new SerializableRunnable("Close Region"){

                    @Override
                    public void run() {
                        RegionReliabilityTestCase.this.getRootRegion(name).close();
                    }
                });
                try {
                    Boolean[] booleanArray = detectedDeparture_testCommitDistributionException;
                    synchronized (detectedDeparture_testCommitDistributionException) {
                        while (detectedDeparture_testCommitDistributionException[0] == Boolean.FALSE) {
                            detectedDeparture_testCommitDistributionException.wait();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)"interrupted");
                }
                {
                    return;
                }
            }
        };
        String expectedExceptions = "com.gemstone.gemfire.internal.cache.CommitReplyException";
        CacheSerializableRunnable addExpectedExceptions = new CacheSerializableRunnable("addExpectedExceptions"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.getCache().getLogger().info("<ExpectedException action=add>com.gemstone.gemfire.internal.cache.CommitReplyException</ExpectedException>");
            }
        };
        CacheSerializableRunnable removeExpectedExceptions = new CacheSerializableRunnable("removeExpectedExceptions"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.getCache().getLogger().info("<ExpectedException action=remove>com.gemstone.gemfire.internal.cache.CommitReplyException</ExpectedException>");
            }
        };
        TXManagerImpl ctm = cache.getCacheTransactionManager();
        ctm.begin();
        region.put((Object)"KEY", (Object)"VAL");
        addExpectedExceptions.run();
        Host.getHost(0).getVM(1).invoke(addExpectedExceptions);
        try {
            ctm.commit();
            RegionReliabilityTestCase.fail((String)"Should have thrown CommitDistributionException");
        }
        catch (CommitDistributionException commitDistributionException) {
        }
        finally {
            removeExpectedExceptions.run();
            Host.getHost(0).getVM(1).invoke(removeExpectedExceptions);
        }
    }

    public void testRegionDistributionException() throws Exception {
        if (this.getRegionScope().isDistributedNoAck()) {
            return;
        }
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        RegionMembershipListenerAdapter listener = new RegionMembershipListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRemoteRegionDeparture(RegionEvent event) {
                Boolean[] booleanArray = detectedDeparture_testRegionDistributionException;
                synchronized (detectedDeparture_testRegionDistributionException) {
                    RegionReliabilityTestCase.detectedDeparture_testRegionDistributionException[0] = Boolean.TRUE;
                    detectedDeparture_testRegionDistributionException.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        RegionReliabilityTestCase.assertTrue((boolean)((AbstractRegion)region).requiresReliabilityCheck());
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        };
        Host.getHost(0).getVM(1).invoke(createRegion);
        region.put((Object)"DESTROY_ME", (Object)"VAL");
        region.put((Object)"INVALIDATE_ME", (Object)"VAL");
        SerializableRunnable removeRequiredRole = new SerializableRunnable(){

            @Override
            public void run() {
                Host.getHost(0).getVM(1).invoke(new SerializableRunnable("Close Region"){

                    @Override
                    public void run() {
                        RegionReliabilityTestCase.this.getRootRegion(name).close();
                    }
                });
            }
        };
        DistributedCacheOperation.setBeforePutOutgoing((Runnable)removeRequiredRole);
        Runnable reset = new Runnable(){

            @Override
            public void run() {
            }
        };
        try {
            region.put((Object)"KEY", (Object)"VAL");
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
        reset.run();
        Host.getHost(0).getVM(1).invoke(createRegion);
        try {
            region.invalidate((Object)"INVALIDATE_ME");
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
        reset.run();
        Host.getHost(0).getVM(1).invoke(createRegion);
        try {
            region.destroy((Object)"DESTROY_ME");
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
        reset.run();
        Host.getHost(0).getVM(1).invoke(createRegion);
        try {
            region.clear();
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
        reset.run();
        Host.getHost(0).getVM(1).invoke(createRegion);
        try {
            HashMap<String, String> putAll = new HashMap<String, String>();
            putAll.put("PUTALL_ME", "VAL");
            region.putAll(putAll);
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
        reset.run();
        Host.getHost(0).getVM(1).invoke(createRegion);
        try {
            region.invalidateRegion();
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
        reset.run();
        Host.getHost(0).getVM(1).invoke(createRegion);
        try {
            region.destroyRegion();
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionDistributionException");
        }
        catch (RegionDistributionException regionDistributionException) {
            // empty catch block
        }
    }

    public void testReinitialization() throws Exception {
        final String name = this.getUniqueName();
        final String roleA = name + "-A";
        String[] requiredRoles = new String[]{roleA};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RegionReliabilityTestCase.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        this.getCache();
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.REINITIALIZE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(this.getRegionScope());
        fac.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        RegionReliabilityTestCase.assertTrue((boolean)((AbstractRegion)region).requiresReliabilityCheck());
        RegionReliabilityTestCase.assertFalse((boolean)RequiredRoles.checkForRequiredRoles((Region)region).isEmpty());
        String key = "KEY-testReinitialization";
        String val = "VALUE-testReinitialization";
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("Create Data"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[0]);
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                fac.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr = fac.create();
                Region region = RegionReliabilityTestCase.this.createRootRegion(name, attr);
                region.put((Object)"KEY-testReinitialization", (Object)"VALUE-testReinitialization");
            }
        });
        final Region finalRegion = region;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RequiredRoles.waitForRequiredRoles((Region)finalRegion, (long)-1L);
                }
                catch (InterruptedException e) {
                    TestCase.fail((String)"interrupted");
                }
                catch (RegionReinitializedException regionReinitializedException) {
                    // empty catch block
                }
            }
        });
        thread.start();
        Host.getHost(0).getVM(1).invokeAsync(new CacheSerializableRunnable("Create Role"){

            @Override
            public void run2() throws CacheException {
                RegionReliabilityTestCase.this.createConnection(new String[]{roleA});
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(RegionReliabilityTestCase.this.getRegionScope());
                RegionAttributes attr = fac.create();
                RegionReliabilityTestCase.this.createRootRegion(name, attr);
            }
        });
        DistributedTestCase.join(thread, 30000L, RegionReliabilityTestCase.getLogWriter());
        RegionReliabilityTestCase.assertTrue((boolean)region.isDestroyed());
        try {
            region.put((Object)"fee", (Object)"fi");
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionReinitializedException");
        }
        catch (RegionReinitializedException regionReinitializedException) {
            // empty catch block
        }
        try {
            RequiredRoles.checkForRequiredRoles((Region)region);
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionReinitializedException");
        }
        catch (RegionReinitializedException regionReinitializedException) {
            // empty catch block
        }
        try {
            Role role = (Role)requiredRolesSet.iterator().next();
            RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role);
            RegionReliabilityTestCase.fail((String)"Should have thrown RegionReinitializedException");
        }
        catch (RegionReinitializedException regionReinitializedException) {
            // empty catch block
        }
        region = this.getRootRegion(name);
        RegionReliabilityTestCase.assertNotNull((Object)region);
        RegionReliabilityTestCase.assertTrue((boolean)((AbstractRegion)region).requiresReliabilityCheck());
        RegionReliabilityTestCase.assertTrue((boolean)RequiredRoles.checkForRequiredRoles((Region)region).isEmpty());
        RegionReliabilityTestCase.assertNotNull((Object)region.getEntry((Object)"KEY-testReinitialization"));
        RegionReliabilityTestCase.assertEquals((Object)"VALUE-testReinitialization", (Object)region.getEntry((Object)"KEY-testReinitialization").getValue());
    }
}

