/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionReinitializedException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.ExpiryTask;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

public abstract class RegionTestCase
extends CacheTestCase {
    static TestCacheListener listener;
    static TestCacheListener subrgnListener;
    static TestCacheLoader loader;
    static TestCacheLoader subrgnLoader;
    static TestCacheWriter writer;
    static TestCacheWriter subrgnWriter;
    private static final String WAIT_PROPERTY = "UpdatePropagationDUnitTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 60000;
    private static final int SLOP = 1000;
    protected volatile int eventCount;
    public static Region preSnapshotRegion;
    private static final int MAX_KEYS = 10;

    private static void cleanup() {
        listener = null;
        loader = null;
        writer = null;
        subrgnListener = null;
        subrgnLoader = null;
        subrgnWriter = null;
    }

    public RegionTestCase(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        RegionTestCase.cleanup();
        RegionTestCase.invokeInEveryVM(this.getClass(), "cleanup");
        super.tearDown2();
    }

    protected final Region createRegion(String name) throws CacheException {
        return this.createRegion(name, this.getRegionAttributes());
    }

    protected final Region createRootRegion() throws CacheException {
        return this.createRootRegion(this.getRegionAttributes());
    }

    protected abstract RegionAttributes getRegionAttributes();

    protected void pauseIfNecessary() {
    }

    protected void pauseIfNecessary(int ms) {
    }

    public void testContainsKey() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        String key = name;
        Integer value = new Integer(42);
        RegionTestCase.assertFalse((boolean)region.containsKey((Object)key));
        region.create((Object)key, null);
        RegionTestCase.assertFalse((boolean)region.containsValueForKey((Object)key));
        Region.Entry entry = region.getEntry((Object)key);
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertEquals((Object)entry.getKey(), (Object)key);
        RegionTestCase.assertNull((Object)entry.getValue());
        region.put((Object)key, (Object)value);
        RegionTestCase.assertTrue((boolean)region.containsValueForKey((Object)key));
        RegionTestCase.assertEquals((Object)entry, (Object)region.getEntry((Object)key));
        if (entry.isLocal()) {
            RegionTestCase.assertEquals((Object)value, (Object)entry.getValue());
        } else {
            RegionTestCase.assertEquals((Object)value, (Object)region.getEntry((Object)key).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadRegionAccess() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        String key = name;
        RegionTestCase.assertNull((Object)region.get((Object)key));
        RegionTestCase.assertNull((Object)region.getEntry((Object)key));
        Integer value = new Integer(42);
        region.create((Object)key, (Object)value);
        try {
            region.getCache().getLogger().info("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            region.create((Object)key, (Object)value);
            RegionTestCase.fail((String)"Should have thrown an EntryExistsException");
        }
        catch (EntryExistsException entryExistsException) {
        }
        finally {
            region.getCache().getLogger().info("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
        }
    }

    public void testPutNonExistentEntry() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        String key = name;
        RegionTestCase.assertNull((Object)region.getEntry((Object)key));
        Integer value = new Integer(42);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertEquals((Object)key, (Object)entry.getKey());
        RegionTestCase.assertEquals((Object)value, (Object)entry.getValue());
        RegionTestCase.assertEquals((Object)value, (Object)region.get((Object)key));
        try {
            Collection values = region.values();
            RegionTestCase.assertEquals((int)1, (int)values.size());
            RegionTestCase.assertEquals((Object)value, values.iterator().next());
        }
        catch (UnsupportedOperationException uoe) {
            RegionTestCase.getLogWriter().info("Region.values() reported UnsupportedOperation");
        }
    }

    protected boolean supportsSubregions() {
        return true;
    }

    protected boolean supportsLocalDestroyAndLocalInvalidate() {
        return true;
    }

    public void testNulls() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        String key = name;
        try {
            region.getSubregion(null);
            RegionTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.createSubregion(null, region.getAttributes());
            RegionTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.createSubregion("TEST", null);
            RegionTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        RegionTestCase.assertEquals((String)"/", (String)"/");
        RegionTestCase.assertEquals((char)'/', (char)'/');
        try {
            region.createSubregion("BAD/TEST", region.getAttributes());
            RegionTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.createSubregion("", region.getAttributes());
            RegionTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            region.getEntry(null);
            RegionTestCase.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.get(null);
            RegionTestCase.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.get(null, null);
            RegionTestCase.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.put(null, (Object)new Integer(42));
            RegionTestCase.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.put((Object)key, null);
            RegionTestCase.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            region.destroy(null);
            RegionTestCase.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCreateSubregions() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        RegionAttributes attrs = this.getRegionAttributes();
        AttributesFactory factory = new AttributesFactory(attrs);
        factory.setStatisticsEnabled(true);
        attrs = factory.create();
        Region region = this.createRegion(name, attrs);
        attrs = region.getAttributes();
        CacheStatistics stats = region.getStatistics();
        long lastAccessed = stats.getLastAccessedTime();
        long lastModified = stats.getLastModifiedTime();
        try {
            region.createSubregion(name + "/BAD", attrs);
            RegionTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            CacheStatistics stats2 = region.getStatistics();
            RegionTestCase.assertEquals((long)lastAccessed, (long)stats2.getLastAccessedTime());
            RegionTestCase.assertEquals((long)lastModified, (long)stats2.getLastModifiedTime());
        }
        Region subregion = region.createSubregion(name, attrs);
        RegionTestCase.assertTrue((attrs != subregion.getAttributes() ? 1 : 0) != 0);
        Set subregions = region.subregions(false);
        RegionTestCase.assertEquals((int)1, (int)subregions.size());
        RegionTestCase.assertEquals((Object)subregion, subregions.iterator().next());
    }

    public static boolean entryIsLocal(Region.Entry re) {
        if (re instanceof EntrySnapshot) {
            return ((EntrySnapshot)re).wasInitiallyLocal();
        }
        return re.isLocal();
    }

    public void testDestroyEntry() throws CacheException {
        String name;
        String key = name = this.getUniqueName();
        Integer value = new Integer(42);
        Region region = this.createRegion(name);
        try {
            region.destroy((Object)key);
            RegionTestCase.fail((String)"Should have thrown an EntryNotFoundException");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        RegionTestCase.assertNotNull((Object)entry);
        region.destroy((Object)key);
        Region.Entry entry2 = region.getEntry((Object)key);
        RegionTestCase.getLogWriter().info("Found entry for destroyed key: " + entry2);
        RegionTestCase.assertNull((Object)entry2);
        if (entry.isLocal()) {
            RegionTestCase.assertTrue((boolean)entry.isDestroyed());
        } else {
            RegionTestCase.assertFalse((boolean)entry.isDestroyed());
        }
        RegionTestCase.assertEquals((int)0, (int)region.keySet().size());
        if (entry.isLocal()) {
            try {
                entry.getKey();
                RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getRegion();
                RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getStatistics();
                RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getUserAttribute();
                RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.setUserAttribute((Object)"blah");
                RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            try {
                entry.getValue();
                RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
        }
    }

    public void testDestroyRegion() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        RegionTestCase.assertNotNull((Object)entry);
        region.createSubregion("SUB", region.getAttributes());
        region.destroyRegion();
        RegionTestCase.assertTrue((boolean)entry.isDestroyed());
        RegionTestCase.assertTrue((boolean)region.isDestroyed());
        try {
            region.containsKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsValueForKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value, (Object)"BLAH");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.createSubregion("SUB", this.getRegionAttributes());
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key, (Object)"BLAH");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion((Object)"ARG");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.entries(false);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key, (Object)"ARG");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getAttributes();
        try {
            region.getAttributesMutator();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getCache();
        }
        catch (RegionDestroyedException ex) {
            RegionTestCase.fail((String)"getCache() shouldn't have thrown a RegionDestroyedException");
        }
        try {
            region.getEntry((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getDistributedLock((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        RegionTestCase.assertEquals((String)name, (String)region.getName());
        region.getParentRegion();
        RegionTestCase.assertEquals((String)("/root/" + name), (String)region.getFullPath());
        RegionTestCase.assertEquals((String)name, (String)region.getName());
        try {
            region.getRegionDistributedLock();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getStatistics();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getSubregion("SUB");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getUserAttribute();
        try {
            region.invalidate((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.invalidateRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.keys();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroy((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroyRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidate((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidateRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value, (Object)"ARG");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.setUserAttribute((Object)"ATTR");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.subregions(true);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.values();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    public void testEntries() throws CacheException {
        int i;
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionTestCase.assertEquals((int)0, (int)region.entries(true).size());
        RegionTestCase.assertEquals((int)0, (int)region.entries(false).size());
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        Set entries = region.entries(false);
        RegionTestCase.assertEquals((int)3, (int)entries.size());
        HashSet<String> keys = new HashSet<String>(Arrays.asList("A", "B", "C"));
        Iterator iter = entries.iterator();
        for (i = 0; i < 3; ++i) {
            RegionTestCase.assertTrue((boolean)iter.hasNext());
            RegionTestCase.assertTrue((boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        RegionTestCase.assertFalse((boolean)iter.hasNext());
        entries = region.entries(true);
        RegionTestCase.assertEquals((int)3, (int)entries.size());
        keys = new HashSet<String>(Arrays.asList("A", "B", "C"));
        iter = entries.iterator();
        for (i = 0; i < 3; ++i) {
            RegionTestCase.assertTrue((boolean)iter.hasNext());
            RegionTestCase.assertTrue((boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        RegionTestCase.assertFalse((boolean)iter.hasNext());
        Iterator iter2 = region.entries(false).iterator();
        Region.Entry entry = (Region.Entry)iter2.next();
        region.destroy(entry.getKey());
        if (entry.isLocal()) {
            RegionTestCase.assertTrue((boolean)entry.isDestroyed());
        } else {
            RegionTestCase.assertFalse((boolean)entry.isDestroyed());
        }
    }

    public void testEntriesRecursive() throws CacheException {
        int i;
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        Region sub = region.createSubregion("SUB", region.getAttributes());
        sub.put((Object)"D", (Object)"d");
        sub.put((Object)"E", (Object)"e");
        sub.put((Object)"F", (Object)"f");
        Set entries = region.entries(true);
        RegionTestCase.assertEquals((int)6, (int)entries.size());
        HashSet<String> keys = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        Iterator iter = entries.iterator();
        for (i = 0; i < 6; ++i) {
            RegionTestCase.assertTrue((String)("!hasNext, i=" + i), (boolean)iter.hasNext());
            RegionTestCase.assertTrue((String)("remove returned false, i=" + i), (boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        RegionTestCase.assertFalse((boolean)iter.hasNext());
        entries = this.getRootRegion().entries(true);
        RegionTestCase.assertEquals((int)6, (int)entries.size());
        keys = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        iter = entries.iterator();
        for (i = 0; i < 6; ++i) {
            RegionTestCase.assertTrue((String)("!hasNext, i=" + i), (boolean)iter.hasNext());
            RegionTestCase.assertTrue((String)("remove returned false, i=" + i), (boolean)keys.remove(((Region.Entry)iter.next()).getKey()));
        }
        RegionTestCase.assertFalse((boolean)iter.hasNext());
        Iterator iter2 = region.entries(true).iterator();
        Region.Entry entry = (Region.Entry)iter2.next();
        Object ekey = entry.getKey();
        region.destroy(ekey);
        RegionTestCase.assertEquals((boolean)false, (boolean)region.containsKey(ekey));
        RegionTestCase.assertTrue((boolean)entry.isDestroyed());
    }

    public void testGetCache() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionTestCase.assertSame((Object)this.getCache(), (Object)region.getCache());
    }

    public void testGetName() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionTestCase.assertEquals((String)name, (String)region.getName());
        RegionTestCase.assertEquals((String)"root", (String)region.getParentRegion().getName());
    }

    public void testGetPathFromRoot() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        String fullPath = "/root/" + name;
        RegionTestCase.assertEquals((String)fullPath, (String)region.getFullPath());
        RegionTestCase.assertEquals((String)"/root", (String)region.getParentRegion().getFullPath());
        Region sub = region.createSubregion("SUB", region.getAttributes());
        RegionTestCase.assertEquals((String)(fullPath + "/SUB"), (String)sub.getFullPath());
    }

    public void testGetParentRegion() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionTestCase.assertEquals((Object)this.getRootRegion(), (Object)region.getParentRegion());
        Region sub = region.createSubregion("SUB", region.getAttributes());
        RegionTestCase.assertEquals((Object)region, (Object)sub.getParentRegion());
        RegionTestCase.assertSame((Object)sub, (Object)region.getSubregion("SUB"));
        RegionTestCase.assertNotNull((Object)sub.getAttributes());
    }

    public void testRegionUserAttribute() throws CacheException {
        String name = this.getUniqueName();
        String value = "USER_ATTRIBUTE";
        Region region = this.createRegion(name);
        RegionTestCase.assertNull((Object)region.getUserAttribute());
        region.setUserAttribute((Object)value);
        RegionTestCase.assertEquals((Object)value, (Object)region.getUserAttribute());
    }

    public void testEntryUserAttribute() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String attr = "USER_ATTRIBUTE";
        Region region = this.createRegion(name);
        region.create((Object)key, null);
        Region.Entry entry = region.getEntry((Object)key);
        entry.setUserAttribute((Object)attr);
        RegionTestCase.assertEquals((Object)attr, (Object)entry.getUserAttribute());
        entry = region.getEntry((Object)key);
        RegionTestCase.assertEquals((Object)attr, (Object)entry.getUserAttribute());
    }

    public void testInvalidateEntry() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        int beforeInvalidates = ((GemFireCacheImpl)this.getCache()).getCachePerfStats().getInvalidates();
        Region.Entry entry = region.getEntry((Object)key);
        region.invalidate((Object)key);
        if (entry.isLocal()) {
            RegionTestCase.assertNull((Object)entry.getValue());
        }
        RegionTestCase.assertNull((Object)region.get((Object)key));
        int afterInvalidates = ((GemFireCacheImpl)this.getCache()).getCachePerfStats().getInvalidates();
        RegionTestCase.assertEquals((String)"Invalidate CachePerfStats incorrect", (int)(beforeInvalidates + 1), (int)afterInvalidates);
    }

    public void testInvalidateRegion() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        for (int i = 0; i < 50; ++i) {
            region.put((Object)("Key=" + i), (Object)("Value-" + i));
        }
        region.invalidateRegion();
        Region.Entry entry = region.getEntry((Object)"A");
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"B");
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"C");
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertNull((Object)entry.getValue());
        for (int i = 0; i < 50; ++i) {
            String key = "Key=" + i;
            RegionTestCase.assertFalse((String)("containsValueForKey returned true for key " + key), (boolean)region.containsValueForKey((Object)key));
            RegionTestCase.assertTrue((String)("containsKey returned false for key " + key), (boolean)region.containsKey((Object)key));
        }
    }

    public void testKeys() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionTestCase.assertEquals((int)0, (int)region.keys().size());
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        Set keys = region.keys();
        RegionTestCase.assertEquals((int)3, (int)keys.size());
        RegionTestCase.assertTrue((boolean)keys.contains("A"));
        RegionTestCase.assertTrue((boolean)keys.contains("B"));
        RegionTestCase.assertTrue((boolean)keys.contains("C"));
    }

    public void testLocalDestroyEntry() throws CacheException {
        String name;
        if (!this.supportsLocalDestroyAndLocalInvalidate()) {
            return;
        }
        String key = name = this.getUniqueName();
        Integer value = new Integer(42);
        Region region = this.createRegion(name);
        boolean isMirrored = this.getRegionAttributes().getMirrorType().isMirrored();
        try {
            region.localDestroy((Object)key);
            if (isMirrored) {
                RegionTestCase.fail((String)"Should have thrown an IllegalStateException");
            }
            RegionTestCase.fail((String)"Should have thrown an EntryNotFoundException");
        }
        catch (EntryNotFoundException entryNotFoundException) {
        }
        catch (IllegalStateException ex) {
            if (!isMirrored) {
                throw ex;
            }
            return;
        }
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        RegionTestCase.assertNotNull((Object)entry);
        region.localDestroy((Object)key);
        RegionTestCase.assertNull((Object)region.getEntry((Object)key));
        RegionTestCase.assertTrue((boolean)entry.isDestroyed());
        RegionTestCase.assertEquals((int)0, (int)region.keys().size());
        try {
            entry.getKey();
            RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getRegion();
            RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getStatistics();
            RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getUserAttribute();
            RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.setUserAttribute((Object)"blah");
            RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
        try {
            entry.getValue();
            RegionTestCase.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
    }

    public void testLocalDestroyRegion() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        RegionTestCase.assertNotNull((Object)entry);
        region.createSubregion("SUB", region.getAttributes());
        region.localDestroyRegion();
        RegionTestCase.assertTrue((boolean)entry.isDestroyed());
        RegionTestCase.assertTrue((boolean)region.isDestroyed());
        try {
            region.containsKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsValueForKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.create((Object)key, (Object)value, (Object)"BLAH");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.createSubregion("SUB", this.getRegionAttributes());
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroy((Object)key, (Object)"BLAH");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.destroyRegion((Object)"ARG");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.entries(false);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.get((Object)key, (Object)"ARG");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getAttributes();
        try {
            region.getAttributesMutator();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.containsKey((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getCache();
        }
        catch (RegionDestroyedException ex) {
            RegionTestCase.fail((String)"getCache() shouldn't have thrown a RegionDestroyedException");
        }
        try {
            region.getEntry((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getDistributedLock((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        RegionTestCase.assertEquals((String)name, (String)region.getName());
        region.getParentRegion();
        RegionTestCase.assertEquals((String)("/root/" + name), (String)region.getFullPath());
        try {
            region.getRegionDistributedLock();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getStatistics();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.getSubregion("SUB");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        region.getUserAttribute();
        try {
            region.invalidate((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.invalidateRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.keys();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroy((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localDestroyRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidate((Object)key);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.localInvalidateRegion();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.put((Object)key, (Object)value, (Object)"ARG");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.setUserAttribute((Object)"ATTR");
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.subregions(true);
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        try {
            region.values();
            RegionTestCase.fail((String)"Should have thrown a RegionDestroyedException");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    public void testCloseRegion() throws CacheException {
        String name = this.getUniqueName();
        AttributesFactory fac = new AttributesFactory(this.getRegionAttributes());
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
            }

            @Override
            public void afterRegionDestroy2(RegionEvent re) {
                TestCase.assertEquals((Object)Operation.REGION_CLOSE, (Object)re.getOperation());
            }

            @Override
            public void close2() {
            }
        };
        fac.setCacheListener((CacheListener)list);
        RegionAttributes attrs = fac.create();
        Region region = this.createRegion(name, attrs);
        File diskDir = null;
        if (attrs.getDataPolicy().withPersistence()) {
            diskDir = this.getCache().findDiskStore(attrs.getDiskStoreName()).getDiskDirs()[0];
            this.getCache().getLogger().info("list=" + Arrays.toString(diskDir.list()));
        }
        for (int i = 0; i < 1000; ++i) {
            region.put((Object)new Integer(i), (Object)String.valueOf(i));
        }
        RegionTestCase.assertTrue((boolean)list.wasInvoked());
        if (attrs.getDataPolicy().withPersistence()) {
            RegionTestCase.assertTrue((diskDir.list().length > 0 ? 1 : 0) != 0);
        }
        boolean persistent = region.getAttributes().getDataPolicy().withPersistence();
        region.close();
        if (attrs.getDataPolicy().withPersistence()) {
            RegionTestCase.assertTrue((diskDir.list().length > 0 ? 1 : 0) != 0);
        }
        RegionTestCase.assertTrue((boolean)list.waitForInvocation(333));
        RegionTestCase.assertTrue((boolean)list.isClosed());
        RegionTestCase.assertTrue((boolean)region.isDestroyed());
        region = this.createRegion(name, attrs);
        if (attrs.getDataPolicy().withPersistence()) {
            for (int i = 0; i < 1000; ++i) {
                Region.Entry entry = region.getEntry((Object)new Integer(i));
                RegionTestCase.assertNotNull((String)("entry " + i + " not found"), (Object)entry);
                RegionTestCase.assertEquals((Object)String.valueOf(i), (Object)entry.getValue());
            }
            RegionTestCase.assertEquals((int)1000, (int)region.keys().size());
        } else {
            RegionTestCase.assertEquals((int)0, (int)region.keys().size());
        }
        region.localDestroyRegion();
    }

    public void testLocalInvalidateEntry() throws CacheException {
        if (!this.supportsLocalDestroyAndLocalInvalidate()) {
            return;
        }
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        Region region = this.createRegion(name);
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        boolean isMirrorKeysValues = this.getRegionAttributes().getMirrorType().isKeysValues();
        try {
            region.localInvalidate((Object)key);
            if (isMirrorKeysValues) {
                RegionTestCase.fail((String)"Should have thrown an IllegalStateException");
            }
        }
        catch (IllegalStateException e) {
            if (!isMirrorKeysValues) {
                throw e;
            }
            return;
        }
        RegionTestCase.assertNull((Object)entry.getValue());
        RegionTestCase.assertNull((Object)region.get((Object)key));
    }

    public void testLocalInvalidateRegion() throws CacheException {
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        boolean isKV = this.getRegionAttributes().getMirrorType().isKeysValues();
        try {
            region.localInvalidateRegion();
            if (isKV) {
                RegionTestCase.fail((String)"Should have thrown an IllegalStateException");
            }
        }
        catch (IllegalStateException e) {
            if (!isKV) {
                throw e;
            }
            return;
        }
        Region.Entry entry = region.getEntry((Object)"A");
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"B");
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertNull((Object)entry.getValue());
        entry = region.getEntry((Object)"C");
        RegionTestCase.assertNotNull((Object)entry);
        RegionTestCase.assertNull((Object)entry.getValue());
    }

    public void testSubregions() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        RegionTestCase.assertEquals((int)0, (int)region.subregions(false).size());
        region.createSubregion("A", region.getAttributes());
        region.createSubregion("B", region.getAttributes());
        region.createSubregion("C", region.getAttributes());
        Set subregions = region.subregions(false);
        RegionTestCase.assertEquals((int)3, (int)subregions.size());
        HashSet<String> names = new HashSet<String>(Arrays.asList("A", "B", "C"));
        Iterator iter = subregions.iterator();
        for (int i = 0; i < 3; ++i) {
            RegionTestCase.assertTrue((boolean)iter.hasNext());
            RegionTestCase.assertTrue((boolean)names.remove(((Region)iter.next()).getName()));
        }
        RegionTestCase.assertFalse((boolean)iter.hasNext());
    }

    public void testSubregionsRecursive() throws CacheException {
        if (!this.supportsSubregions()) {
            return;
        }
        String name = this.getUniqueName();
        Region region = this.createRegion(name);
        Region A = region.createSubregion("A", region.getAttributes());
        Region B = region.createSubregion("B", region.getAttributes());
        Region C = region.createSubregion("C", region.getAttributes());
        A.createSubregion("D", region.getAttributes());
        B.createSubregion("E", region.getAttributes());
        C.createSubregion("F", region.getAttributes());
        Set subregions = region.subregions(true);
        RegionTestCase.assertEquals((int)6, (int)subregions.size());
        HashSet<String> names = new HashSet<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        Iterator iter = subregions.iterator();
        for (int i = 0; i < 6; ++i) {
            RegionTestCase.assertTrue((boolean)iter.hasNext());
            RegionTestCase.assertTrue((boolean)names.remove(((Region)iter.next()).getName()));
        }
        RegionTestCase.assertFalse((boolean)iter.hasNext());
    }

    public void testValues() throws CacheException {
        String name = this.getUniqueName();
        System.err.println("testValues region name is " + name);
        Region region = this.createRegion(name);
        RegionTestCase.assertEquals((int)0, (int)region.values().size());
        region.create((Object)"A", null);
        TreeSet values = new TreeSet(region.values());
        RegionTestCase.assertTrue((boolean)values.isEmpty());
        Iterator itr = values.iterator();
        RegionTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        try {
            itr.next();
            RegionTestCase.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        region.put((Object)"A", (Object)"a");
        region.put((Object)"B", (Object)"b");
        region.put((Object)"C", (Object)"c");
        values = new TreeSet(region.values());
        RegionTestCase.assertEquals((int)3, (int)values.size());
        Iterator iter = values.iterator();
        RegionTestCase.assertTrue((boolean)iter.hasNext());
        RegionTestCase.assertEquals((Object)"a", iter.next());
        RegionTestCase.assertTrue((boolean)iter.hasNext());
        RegionTestCase.assertEquals((Object)"b", iter.next());
        RegionTestCase.assertTrue((boolean)iter.hasNext());
        RegionTestCase.assertEquals((Object)"c", iter.next());
        RegionTestCase.assertFalse((boolean)iter.hasNext());
        region.invalidate((Object)"B");
        values = new TreeSet(region.values());
        RegionTestCase.assertEquals((int)2, (int)values.size());
        iter = values.iterator();
        RegionTestCase.assertTrue((boolean)iter.hasNext());
        RegionTestCase.assertEquals((Object)"a", iter.next());
        RegionTestCase.assertTrue((boolean)iter.hasNext());
        RegionTestCase.assertEquals((Object)"c", iter.next());
        RegionTestCase.assertFalse((boolean)iter.hasNext());
    }

    private Object fetchEntryValue(Region.Entry re) {
        Object key;
        if (re.isLocal()) {
            return re.getValue();
        }
        Region r = re.getRegion();
        Region.Entry freshRE = r.getEntry(key = re.getKey());
        if (freshRE == null) {
            return null;
        }
        return freshRE.getValue();
    }

    protected void waitForInvalidate(Region.Entry entry, long p_tilt) {
        long tilt = p_tilt;
        if (entry == null) {
            return;
        }
        while (true) {
            boolean wasInvalidated = this.fetchEntryValue(entry) == null;
            long now = System.currentTimeMillis();
            if (now >= tilt) break;
            if (!wasInvalidated) {
                RegionTestCase.pause(100);
                continue;
            }
            if (now >= tilt - 1000L) {
                RegionTestCase.getLogWriter().warning("Entry invalidated sloppily now=" + now + " tilt=" + tilt + " delta = " + (tilt - now));
                break;
            }
            RegionTestCase.fail((String)("Entry invalidated prematurely now=" + now + " tilt=" + tilt + " delta = " + (tilt - now)));
        }
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        tilt += (long)maxWaitTime;
        while (this.fetchEntryValue(entry) != null) {
            if (System.currentTimeMillis() > tilt) {
                if (this.fetchEntryValue(entry) == null) break;
                RegionTestCase.fail((String)"Entry failed to invalidate");
            }
            RegionTestCase.pause(1000);
        }
    }

    private boolean isEntryDestroyed(Region.Entry re) {
        Object key;
        if (re.isLocal()) {
            return re.isDestroyed();
        }
        Region r = re.getRegion();
        Region.Entry freshRE = r.getEntry(key = re.getKey());
        if (freshRE == null) {
            return true;
        }
        return freshRE.isDestroyed();
    }

    protected void waitForDestroy(Region.Entry entry, long p_tilt) {
        long now;
        long tilt = p_tilt;
        while ((now = System.currentTimeMillis()) < tilt) {
            if (!this.isEntryDestroyed(entry)) {
                RegionTestCase.pause(100);
                continue;
            }
            if (now >= tilt - 1000L) {
                RegionTestCase.getLogWriter().warning("Entry destroyed sloppily now=" + now + " tilt=" + tilt + " delta = " + (tilt - now));
                break;
            }
            RegionTestCase.fail((String)("Entry destroyed prematurelynow=" + now + " tilt=" + tilt + " delta = " + (tilt - now)));
        }
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        tilt += (long)maxWaitTime;
        while (!this.isEntryDestroyed(entry)) {
            Assert.assertTrue((System.currentTimeMillis() <= tilt ? 1 : 0) != 0, (Object)"Entry failed to destroy");
            RegionTestCase.pause(1000);
        }
    }

    protected void waitForRegionDestroy(Region region, long p_tilt) {
        long now;
        long tilt = p_tilt;
        while ((now = System.currentTimeMillis()) < tilt) {
            if (!region.isDestroyed()) {
                RegionTestCase.pause(100);
                continue;
            }
            if (now >= tilt - 1000L) {
                RegionTestCase.getLogWriter().warning("Region destroyed sloppily now=" + now + " tilt=" + tilt + " delta = " + (tilt - now));
                break;
            }
            RegionTestCase.fail((String)("Region destroyed prematurelynow=" + now + " tilt=" + tilt + " delta = " + (tilt - now)));
        }
        int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 60000);
        tilt += (long)maxWaitTime;
        while (!region.isDestroyed()) {
            Assert.assertTrue((System.currentTimeMillis() <= tilt ? 1 : 0) != 0, (Object)"Region failed to destroy");
            RegionTestCase.pause(1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryTtlInvalidate() throws CacheException {
        long tilt;
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.put((Object)"KEY", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryTtl1() {
        long tilt;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setCustomEntryTimeToLive((CustomExpiry)new TestExpiry("KEY2", expire));
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.put((Object)"KEY1", (Object)"VALUE");
        RegionTestCase.pause(40);
        assert (region.get((Object)"KEY1").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.put((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        assert (region.get((Object)"KEY1").equals("VALUE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryTtl2() {
        long tilt;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire2 = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setCustomEntryTimeToLive((CustomExpiry)new TestExpiry("KEY2", expire2));
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
            }
        };
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE");
        RegionTestCase.pause(40);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY1").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.create((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY1").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY1").equals("VALUE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryTtl3() {
        String name = this.getUniqueName();
        int timeout1 = 200;
        int timeout2 = 2000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        String value2 = "VALUE2";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(200, ExpirationAction.INVALIDATE);
        factory.setCustomEntryTimeToLive((CustomExpiry)new TestExpiry("KEY1", expire1));
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
                ++RegionTestCase.this.eventCount;
            }
        };
        this.eventCount = 0;
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            DistributedTestCase.WaitCriterion wc;
            DistributedTestCase.WaitCriterion wc2;
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            this.eventCount = 0;
            try {
                region.create((Object)"KEY1", (Object)"VALUE1");
                tilt = System.currentTimeMillis() + 200L;
                entry = region.getEntry((Object)"KEY1");
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(1000));
                Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                wc2 = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc2, 10000L, 100L, true);
            }
            this.eventCount = 0;
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE1");
                tilt = System.currentTimeMillis() + 200L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(10000));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                wc2 = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc2, 10000L, 100L, true);
            }
            this.eventCount = 0;
            AttributesMutator mutt = region.getAttributesMutator();
            ExpirationAttributes expire2 = new ExpirationAttributes(2000, ExpirationAction.INVALIDATE);
            mutt.setCustomEntryTimeToLive((CustomExpiry)new TestExpiry("KEY1", expire2));
            RegionTestCase.pause(2200);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE2");
                tilt = System.currentTimeMillis() + 2000L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(1000));
            }
            finally {
                ExpiryTask.permitExpiration();
                if (region.getAttributes().getPartitionAttributes() != null) {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
            this.waitForInvalidate(entry, tilt);
            if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
            }
            this.eventCount = 0;
            mutt = region.getAttributesMutator();
            expire2 = new ExpirationAttributes(2000, ExpirationAction.INVALIDATE);
            mutt.setCustomEntryTimeToLive((CustomExpiry)new TestExpiry("KEY1", expire2));
            RegionTestCase.pause(2200);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE2");
                tilt = System.currentTimeMillis() + 2000L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
            }
            this.eventCount = 0;
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryTtl3() {
        String name = this.getUniqueName();
        int timeout1 = 200;
        int timeout2 = 2000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        String value2 = "VALUE2";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(200, ExpirationAction.INVALIDATE);
        factory.setEntryTimeToLive(expire1);
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
                ++RegionTestCase.this.eventCount;
            }
        };
        this.eventCount = 0;
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            DistributedTestCase.WaitCriterion wc;
            DistributedTestCase.WaitCriterion wc2;
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            this.eventCount = 0;
            try {
                region.create((Object)"KEY1", (Object)"VALUE1");
                tilt = System.currentTimeMillis() + 200L;
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(1000));
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                wc2 = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc2, 10000L, 100L, true);
            }
            this.eventCount = 0;
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE1");
                tilt = System.currentTimeMillis() + 200L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(1000));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                wc2 = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc2, 10000L, 100L, true);
            }
            this.eventCount = 0;
            AttributesMutator mutt = region.getAttributesMutator();
            ExpirationAttributes expire2 = new ExpirationAttributes(2000, ExpirationAction.INVALIDATE);
            mutt.setEntryTimeToLive(expire2);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE2");
                tilt = System.currentTimeMillis() + 2000L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(1000));
            }
            finally {
                ExpiryTask.permitExpiration();
                if (region.getAttributes().getPartitionAttributes() != null) {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
            this.waitForInvalidate(entry, tilt);
            if (!region.getAttributes().getDataPolicy().withPartitioning()) {
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
            }
            this.eventCount = 0;
            mutt = region.getAttributesMutator();
            expire2 = new ExpirationAttributes(2000, ExpirationAction.INVALIDATE);
            mutt.setEntryTimeToLive(expire2);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE2");
                tilt = System.currentTimeMillis() + 2000L;
                entry = region.getEntry((Object)"KEY1");
                Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            if (!region.getAttributes().getDataPolicy().withPartitioning()) {
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return RegionTestCase.this.eventCount == 1;
                    }

                    @Override
                    public String description() {
                        return "eventCount never became 1";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
            }
            this.eventCount = 0;
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryFromLoadTtlInvalidate() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        factory.setCacheLoader((CacheLoader)new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) {
                return "VALUE";
            }
        });
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.get((Object)"KEY");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryTtlDestroy() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.DESTROY);
        factory.setEntryTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis();
                entry = region.getEntry((Object)"KEY");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForDestroy(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    public void testRegionTtlInvalidate() throws CacheException, InterruptedException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String name = this.getUniqueName();
        vm0.invoke(new CacheSerializableRunnable("testRegionTtlInvalidate"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                long tilt;
                int timeout = 50;
                String key = "KEY";
                String value = "VALUE";
                AttributesFactory factory = new AttributesFactory(RegionTestCase.this.getRegionAttributes());
                ExpirationAttributes expire = new ExpirationAttributes(50, ExpirationAction.INVALIDATE);
                factory.setRegionTimeToLive(expire);
                factory.setStatisticsEnabled(true);
                RegionAttributes attrs = factory.create();
                Region region = null;
                Region.Entry entry = null;
                ExpiryTask.suspendExpiration();
                try {
                    System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                    try {
                        region = RegionTestCase.this.createRegion(name, attrs);
                        region.put((Object)key, (Object)value);
                        region.put((Object)"k2", (Object)"v2");
                        tilt = System.currentTimeMillis() + 50L;
                        entry = region.getEntry((Object)key);
                        TestCase.assertNotNull((Object)entry.getValue());
                    }
                    finally {
                        System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                    }
                }
                finally {
                    ExpiryTask.permitExpiration();
                }
                RegionTestCase.this.waitForInvalidate(entry, tilt);
                RegionTestCase.this.waitForInvalidate(region.getEntry((Object)"k2"), tilt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionTtlDestroy() throws CacheException, InterruptedException {
        long tilt;
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        String name = this.getUniqueName();
        int timeout = 700;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(700, ExpirationAction.DESTROY);
        factory.setRegionTimeToLive(expire);
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        ExpiryTask.suspendExpiration();
        try {
            try {
                region = this.createRegion(name, attrs);
                RegionTestCase.assertFalse((boolean)region.isDestroyed());
                tilt = System.currentTimeMillis() + 700L;
                region.put((Object)key, (Object)value);
                Region.Entry entry = region.getEntry((Object)key);
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            }
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForRegionDestroy(region, tilt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryIdleInvalidate() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
            }
        };
        factory.setCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.create((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(333));
                entry = region.getEntry((Object)"KEY");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForInvalidate(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryIdleTimeout1() {
        long tilt;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout((CustomExpiry)new TestExpiry("KEY2", expire));
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
            }
        };
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY1", (Object)"VALUE");
        RegionTestCase.pause(40);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY1").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.create((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            entry = region.getEntry((Object)"KEY2");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY1").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY2", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY2");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY1").equals("VALUE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryIdleTimeout2() {
        long tilt;
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setEntryIdleTimeout(expire);
        ExpirationAttributes expire2 = new ExpirationAttributes(0, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout((CustomExpiry)new TestExpiry("KEY2", expire2));
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
            }
        };
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY2", (Object)"VALUE");
        RegionTestCase.pause(40);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY2").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.create((Object)"KEY1", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            entry = region.getEntry((Object)"KEY1");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY2").equals("VALUE"));
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY1", (Object)"VALUE");
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)"KEY1");
            RegionTestCase.assertNotNull((Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        RegionTestCase.assertTrue((boolean)region.get((Object)"KEY2").equals("VALUE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryIdleTimeout3() {
        DistributedTestCase.WaitCriterion wc;
        long tilt;
        String name = this.getUniqueName();
        int timeout1 = 200;
        int timeout2 = 2000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        String value2 = "VALUE2";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(200, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout((CustomExpiry)new TestExpiry("KEY1", expire1));
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
                ++RegionTestCase.this.eventCount;
            }
        };
        this.eventCount = 0;
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            if (region.getAttributes().getPartitionAttributes() == null) {
                System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            }
        }
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.create((Object)"KEY1", (Object)"VALUE1");
            tilt = System.currentTimeMillis() + 200L;
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            entry = region.getEntry((Object)"KEY1");
            Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return RegionTestCase.this.eventCount == 1;
                }

                @Override
                public String description() {
                    return "eventCount never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
        }
        this.eventCount = 0;
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY1", (Object)"VALUE1");
            tilt = System.currentTimeMillis() + 200L;
            entry = region.getEntry((Object)"KEY1");
            Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return RegionTestCase.this.eventCount == 1;
                }

                @Override
                public String description() {
                    return "eventCount never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
        }
        this.eventCount = 0;
        AttributesMutator mutt = region.getAttributesMutator();
        ExpirationAttributes expire2 = new ExpirationAttributes(2000, ExpirationAction.INVALIDATE);
        mutt.setCustomEntryIdleTimeout((CustomExpiry)new TestExpiry("KEY1", expire2));
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY1", (Object)"VALUE2");
            tilt = System.currentTimeMillis() + 2000L;
            entry = region.getEntry((Object)"KEY1");
            Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
        }
        finally {
            if (region.getAttributes().getPartitionAttributes() != null) {
                System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            }
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
            DistributedTestCase.WaitCriterion wc2 = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return RegionTestCase.this.eventCount == 1;
                }

                @Override
                public String description() {
                    return "eventCount never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc2, 10000L, 100L, true);
        }
        this.eventCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryIdleTimeout3() {
        DistributedTestCase.WaitCriterion wc;
        long tilt;
        String name = this.getUniqueName();
        int timeout1 = 200;
        int timeout2 = 2000;
        String key1 = "KEY1";
        String value1 = "VALUE1";
        String value2 = "VALUE2";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire1 = new ExpirationAttributes(200, ExpirationAction.INVALIDATE);
        factory.setEntryIdleTimeout(expire1);
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
                ++RegionTestCase.this.eventCount;
            }
        };
        this.eventCount = 0;
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            if (region.getAttributes().getPartitionAttributes() == null) {
                System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            }
        }
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.create((Object)"KEY1", (Object)"VALUE1");
            tilt = System.currentTimeMillis() + 200L;
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
            entry = region.getEntry((Object)"KEY1");
            Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return RegionTestCase.this.eventCount == 1;
                }

                @Override
                public String description() {
                    return "eventCount never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
        }
        this.eventCount = 0;
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY1", (Object)"VALUE1");
            tilt = System.currentTimeMillis() + 200L;
            entry = region.getEntry((Object)"KEY1");
            Assert.assertTrue((boolean)"VALUE1".equals(entry.getValue()));
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        if (!this.getRegionAttributes().getDataPolicy().withPartitioning()) {
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return RegionTestCase.this.eventCount == 1;
                }

                @Override
                public String description() {
                    return "eventCount never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
        }
        this.eventCount = 0;
        AttributesMutator mutt = region.getAttributesMutator();
        ExpirationAttributes expire2 = new ExpirationAttributes(2000, ExpirationAction.INVALIDATE);
        mutt.setEntryIdleTimeout(expire2);
        ExpiryTask.suspendExpiration();
        try {
            region.put((Object)"KEY1", (Object)"VALUE2");
            tilt = System.currentTimeMillis() + 2000L;
            entry = region.getEntry((Object)"KEY1");
            Assert.assertTrue((boolean)"VALUE2".equals(entry.getValue()));
            RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
        }
        finally {
            ExpiryTask.permitExpiration();
            if (region.getAttributes().getPartitionAttributes() != null) {
                System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            }
        }
        this.waitForInvalidate(entry, tilt);
        if (!region.getAttributes().getDataPolicy().withPartitioning()) {
            DistributedTestCase.WaitCriterion wc2 = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return RegionTestCase.this.eventCount == 1;
                }

                @Override
                public String description() {
                    return "eventCount never became 1";
                }
            };
            DistributedTestCase.waitForCriterion(wc2, 10000L, 100L, true);
        }
        this.eventCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomIdleOnce() {
        String name = this.getUniqueName();
        int timeout = 20;
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        factory.setCustomEntryTimeToLive((CustomExpiry)new CountExpiry("KEY2", expire));
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Class<CountExpiry> clazz = CountExpiry.class;
        synchronized (CountExpiry.class) {
            long tilt;
            CountExpiry.invokeCounts.clear();
            // ** MonitorExit[var9_9] (shouldn't be in output)
            Region region = null;
            System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
            try {
                region = this.createRegion(name, attrs);
            }
            finally {
                if (region.getAttributes().getPartitionAttributes() == null) {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
            region.put((Object)"KEY1", (Object)"VALUE");
            RegionTestCase.pause(40);
            assert (region.get((Object)"KEY1").equals("VALUE"));
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.put((Object)"KEY2", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY2");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
                if (region.getAttributes().getPartitionAttributes() != null) {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
            this.waitForInvalidate(entry, tilt);
            assert (region.get((Object)"KEY1").equals("VALUE"));
            Class<CountExpiry> clazz2 = CountExpiry.class;
            synchronized (CountExpiry.class) {
                if (CountExpiry.invokeCounts.size() != 2) {
                    RegionTestCase.fail((String)("CountExpiry not invoked correctly, size = " + CountExpiry.invokeCounts.size()));
                }
                Integer i = (Integer)CountExpiry.invokeCounts.get("KEY1");
                RegionTestCase.assertNotNull((Object)i);
                RegionTestCase.assertEquals((int)1, (int)i);
                i = (Integer)CountExpiry.invokeCounts.get("KEY2");
                RegionTestCase.assertNotNull((Object)i);
                RegionTestCase.assertEquals((int)1, (int)i);
                // ** MonitorExit[var13_15] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomEntryIdleReset() {
        String name = this.getUniqueName();
        int timeout = 200;
        String key1 = "KEY1";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(200, ExpirationAction.INVALIDATE);
        factory.setCustomEntryIdleTimeout((CustomExpiry)new TestExpiry("KEY1", expire));
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterUpdate2(EntryEvent e) {
            }

            @Override
            public void afterInvalidate2(EntryEvent e) {
            }
        };
        factory.addCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.create((Object)"KEY1", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 200L;
                RegionTestCase.assertTrue((boolean)list.waitForInvocation(5000));
                entry = region.getEntry((Object)"KEY1");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            RegionTestCase.pause(100);
            long now = System.currentTimeMillis();
            if (entry.getValue() == null && now < tilt) {
                RegionTestCase.fail((String)("Entry invalidated " + (tilt - now) + " ms prematurely"));
            }
            region.get((Object)"KEY1");
            this.waitForInvalidate(entry, tilt);
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY1", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 200L;
                entry = region.getEntry((Object)"KEY1");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            RegionTestCase.pause(100);
            now = System.currentTimeMillis();
            if (entry.getValue() == null && now < tilt) {
                RegionTestCase.fail((String)("entry invalidated " + (tilt - now) + " ms prematurely"));
            }
            region.put((Object)"KEY1", (Object)"VALUE");
            this.waitForInvalidate(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryIdleDestroy() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        int timeout = 20;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.DESTROY);
        factory.setEntryIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterDestroy2(EntryEvent e) {
            }
        };
        factory.setCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.create((Object)"KEY", null);
                tilt = System.currentTimeMillis() + 20L;
                RegionTestCase.assertTrue((boolean)list.wasInvoked());
                entry = region.getEntry((Object)"KEY");
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForDestroy(entry, tilt);
            RegionTestCase.assertNull((Object)region.getEntry((Object)"KEY"));
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 20L;
                entry = region.getEntry((Object)"KEY");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForDestroy(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryIdleReset() throws Exception {
        String name = this.getUniqueName();
        int timeout = 2000;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(2000, ExpirationAction.DESTROY);
        factory.setEntryIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterDestroy2(EntryEvent e) {
            }
        };
        factory.setCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            long tilt;
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            Region.Entry entry = null;
            try {
                region.create((Object)"KEY", null);
                tilt = System.currentTimeMillis() + 2000L;
                RegionTestCase.assertTrue((boolean)list.wasInvoked());
                entry = region.getEntry((Object)"KEY");
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            RegionTestCase.pause(1000);
            long now = System.currentTimeMillis();
            if (region.getEntry((Object)"KEY") == null && now < tilt) {
                RegionTestCase.fail((String)("Entry for key KEY destroyed " + (tilt - now) + " ms prematurely"));
            }
            region.get((Object)"KEY");
            this.waitForDestroy(entry, tilt);
            RegionTestCase.assertNull((Object)region.getEntry((Object)"KEY"));
            ExpiryTask.suspendExpiration();
            try {
                region.put((Object)"KEY", (Object)"VALUE");
                tilt = System.currentTimeMillis() + 2000L;
                entry = region.getEntry((Object)"KEY");
                RegionTestCase.assertNotNull((Object)entry.getValue());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            RegionTestCase.pause(1000);
            now = System.currentTimeMillis();
            if (region.getEntry((Object)"KEY") == null && now < tilt) {
                RegionTestCase.fail((String)("Entry for key KEY destroyed " + (tilt - now) + " ms prematurely"));
            }
            region.put((Object)"KEY", (Object)"VALUE");
            this.waitForDestroy(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryExpirationAfterMutate() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        int timeout = 20;
        int hugeTimeout = Integer.MAX_VALUE;
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        ExpirationAttributes hugeExpire = new ExpirationAttributes(Integer.MAX_VALUE, ExpirationAction.INVALIDATE);
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        region.create((Object)"KEY", (Object)"VALUE");
        long tilt = System.currentTimeMillis() + 20L;
        ExpiryTask.suspendExpiration();
        Region.Entry entry = null;
        try {
            region.getAttributesMutator().setEntryIdleTimeout(expire);
            entry = region.getEntry((Object)"KEY");
            RegionTestCase.assertEquals((Object)"VALUE", (Object)entry.getValue());
        }
        finally {
            ExpiryTask.permitExpiration();
        }
        this.waitForInvalidate(entry, tilt);
        region.getAttributesMutator().setEntryIdleTimeout(hugeExpire);
        region.put((Object)"KEY", (Object)"VALUE");
        tilt = System.currentTimeMillis() + 20L;
        entry = region.getEntry((Object)"KEY");
        RegionTestCase.pause(40);
        RegionTestCase.assertEquals((Object)"VALUE", (Object)entry.getValue());
        region.getAttributesMutator().setEntryIdleTimeout(expire);
        this.waitForInvalidate(entry, tilt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryIdleTtl() {
        long tilt;
        String name = this.getUniqueName();
        int timeout = 2000;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expireIdle = new ExpirationAttributes(1000, ExpirationAction.DESTROY);
        factory.setEntryIdleTimeout(expireIdle);
        ExpirationAttributes expireTtl = new ExpirationAttributes(2000, ExpirationAction.DESTROY);
        factory.setEntryTimeToLive(expireTtl);
        factory.setStatisticsEnabled(true);
        TestCacheListener list = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent e) {
            }

            @Override
            public void afterDestroy2(EntryEvent e) {
            }
        };
        factory.setCacheListener((CacheListener)list);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
            ExpiryTask.suspendExpiration();
            try {
                tilt = System.currentTimeMillis() + 2000L;
                region.create((Object)"KEY", (Object)"VALUE");
                RegionTestCase.assertTrue((boolean)list.wasInvoked());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
        while (true) {
            Object val;
            if (System.currentTimeMillis() > tilt + 30000L) {
                RegionTestCase.fail((String)"Region did not honor ttl");
            }
            if ((val = region.get((Object)"KEY")) == null) {
                if (System.currentTimeMillis() >= tilt) break;
                RegionTestCase.fail((String)"Region expired value prematurely?");
                break;
            }
            RegionTestCase.pause(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionExpirationAfterMutate() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        int timeout = 20;
        int hugeTimeout = Integer.MAX_VALUE;
        ExpirationAttributes expire = new ExpirationAttributes(20, ExpirationAction.INVALIDATE);
        ExpirationAttributes hugeExpire = new ExpirationAttributes(Integer.MAX_VALUE, ExpirationAction.INVALIDATE);
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            region = this.createRegion(name, attrs);
            region.create((Object)key, (Object)value);
            long tilt = System.currentTimeMillis() + 20L;
            Region.Entry entry = region.getEntry((Object)key);
            RegionTestCase.assertEquals((Object)value, (Object)entry.getValue());
            region.getAttributesMutator().setRegionIdleTimeout(expire);
            this.waitForInvalidate(entry, tilt);
            region.getAttributesMutator().setRegionIdleTimeout(hugeExpire);
            region.put((Object)key, (Object)value);
            tilt = System.currentTimeMillis() + 20L;
            entry = region.getEntry((Object)key);
            RegionTestCase.pause(40);
            RegionTestCase.assertEquals((Object)value, (Object)entry.getValue());
            region.getAttributesMutator().setRegionIdleTimeout(expire);
            this.waitForInvalidate(entry, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    public void testRegionIdleInvalidate() throws InterruptedException, CacheException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final String name = this.getUniqueName();
        final String subname = this.getUniqueName() + "-SUB";
        int timeout = 222;
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("testRegionIdleInvalidate"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                long tilt;
                TestCacheListener list = new TestCacheListener(){
                    private int createCount = 0;

                    @Override
                    public void afterInvalidate2(EntryEvent e) {
                        e.getRegion().getCache().getLogger().info("invalidate2 key=" + e.getKey());
                    }

                    @Override
                    public void afterRegionInvalidate2(RegionEvent e) {
                    }

                    @Override
                    public void afterUpdate2(EntryEvent e) {
                        this.wasInvoked();
                    }

                    @Override
                    public void afterCreate2(EntryEvent e) {
                        ++this.createCount;
                        TestCase.assertEquals((int)1, (int)this.createCount);
                        this.wasInvoked();
                    }
                };
                AttributesFactory factory = new AttributesFactory(RegionTestCase.this.getRegionAttributes());
                ExpirationAttributes expire = new ExpirationAttributes(222, ExpirationAction.INVALIDATE);
                factory.setRegionIdleTimeout(expire);
                factory.setStatisticsEnabled(true);
                RegionAttributes subRegAttrs = factory.create();
                factory.setCacheListener((CacheListener)list);
                RegionAttributes attrs = factory.create();
                Region region = null;
                Region sub = null;
                Region.Entry entry = null;
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                ExpiryTask.suspendExpiration();
                try {
                    region = RegionTestCase.this.createRegion(name, attrs);
                    region.put(key, value);
                    tilt = System.currentTimeMillis() + 222L;
                    entry = region.getEntry(key);
                    TestCase.assertEquals((Object)value, (Object)entry.getValue());
                    if (!region.getAttributes().getDataPolicy().withPartitioning()) {
                        sub = region.createSubregion(subname, subRegAttrs);
                    }
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                    ExpiryTask.permitExpiration();
                }
                RegionTestCase.this.waitForInvalidate(entry, tilt);
                TestCase.assertTrue((boolean)list.waitForInvocation(333));
                DistributedTestCase.pause(222);
                TestCase.assertFalse((boolean)list.wasInvoked());
                long endTime = System.currentTimeMillis() + 444L;
                region.put(key, value);
                do {
                    tilt = System.currentTimeMillis() + 222L;
                    region.get(key);
                    boolean wasInvoked = list.wasInvoked();
                    if (value.equals(entry.getValue()) && !wasInvoked) continue;
                    long now = System.currentTimeMillis();
                    TestCase.assertTrue((String)("Entry invalidated " + (tilt - now) + " ms prematurely (" + entry.getValue() + ")" + " value=" + value + " entryValue=" + entry.getValue() + " wasInvoked=" + wasInvoked), (now >= tilt ? 1 : 0) != 0);
                    break;
                } while (System.currentTimeMillis() < endTime);
                RegionTestCase.this.waitForInvalidate(entry, tilt);
                TestCase.assertTrue((boolean)list.waitForInvocation(333));
                region.put(key, value);
                TestCase.assertEquals((Object)value, (Object)entry.getValue());
                if (!region.getAttributes().getDataPolicy().withPartitioning()) {
                    endTime = System.currentTimeMillis() + 444L;
                    sub.put(key, value);
                    do {
                        tilt = System.currentTimeMillis() + 222L;
                        sub.get(key, value);
                        if (value.equals(entry.getValue()) && !list.wasInvoked()) continue;
                        long now = System.currentTimeMillis();
                        TestCase.assertTrue((String)("Entry invalidated " + (tilt - now) + " ms prematurely (" + entry.getValue() + ")"), (now >= tilt ? 1 : 0) != 0);
                        break;
                    } while (System.currentTimeMillis() < endTime);
                }
                RegionTestCase.this.waitForInvalidate(entry, tilt);
                TestCase.assertTrue((boolean)list.waitForInvocation(333));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionIdleDestroy() throws CacheException, InterruptedException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        String name = this.getUniqueName();
        int timeout = 800;
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        ExpirationAttributes expire = new ExpirationAttributes(800, ExpirationAction.DESTROY);
        factory.setRegionIdleTimeout(expire);
        factory.setStatisticsEnabled(true);
        RegionAttributes attrs = factory.create();
        Region region = null;
        ExpiryTask.suspendExpiration();
        try {
            long tilt;
            System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
            try {
                region = this.createRegion(name, attrs);
                region.put((Object)key, (Object)value);
                tilt = System.currentTimeMillis() + 800L;
                RegionTestCase.assertFalse((boolean)region.isDestroyed());
            }
            finally {
                ExpiryTask.permitExpiration();
            }
            this.waitForRegionDestroy(region, tilt);
        }
        finally {
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSnapshot() throws IOException, CacheException, ClassNotFoundException {
        final String name = this.getUniqueName();
        preSnapshotRegion = this.createRegion(name);
        boolean isDistributed = this.getRegionAttributes().getScope().isDistributed();
        if (isDistributed) {
            RegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("create presnapshot region"){

                @Override
                public void run2() throws CacheException {
                    preSnapshotRegion = RegionTestCase.this.createRegion(name);
                }
            });
        }
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                preSnapshotRegion.create((Object)String.valueOf(i), null);
                continue;
            }
            preSnapshotRegion.create((Object)String.valueOf(i), (Object)new Integer(i));
        }
        File file = new File(name + ".snap");
        FileOutputStream out = new FileOutputStream(file);
        try {
            preSnapshotRegion.saveSnapshot((OutputStream)out);
            RegionTestCase.assertEquals((Object)new Integer(5), (Object)preSnapshotRegion.get((Object)"5"));
            for (int i = 0; i < 10; ++i) {
                preSnapshotRegion.destroy((Object)String.valueOf(i));
            }
            RegionTestCase.assertTrue((preSnapshotRegion.keys().size() == 0 ? 1 : 0) != 0);
            FileInputStream in = new FileInputStream(file);
            preSnapshotRegion.loadSnapshot((InputStream)in);
            this.remoteTestPostSnapshot(name, true, false);
            if (isDistributed) {
                RegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("postSnapshot"){

                    @Override
                    public void run2() throws CacheException {
                        RegionTestCase.this.remoteTestPostSnapshot(name, false, false);
                    }
                });
            }
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRootSnapshot() throws IOException, CacheException, ClassNotFoundException {
        final String name = this.getUniqueName();
        preSnapshotRegion = this.createRootRegion(name, this.getRegionAttributes());
        boolean isDistributed = this.getRegionAttributes().getScope().isDistributed();
        if (isDistributed) {
            RegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("create presnapshot region"){

                @Override
                public void run2() throws CacheException {
                    preSnapshotRegion = RegionTestCase.this.createRootRegion(name, RegionTestCase.this.getRegionAttributes());
                }
            });
        }
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                preSnapshotRegion.create((Object)String.valueOf(i), null);
                continue;
            }
            preSnapshotRegion.create((Object)String.valueOf(i), (Object)new Integer(i));
        }
        File file = new File(name + ".snap");
        FileOutputStream out = new FileOutputStream(file);
        try {
            preSnapshotRegion.saveSnapshot((OutputStream)out);
            RegionTestCase.assertEquals((Object)new Integer(5), (Object)preSnapshotRegion.get((Object)"5"));
            for (int i = 0; i < 10; ++i) {
                preSnapshotRegion.destroy((Object)String.valueOf(i));
            }
            RegionTestCase.assertTrue((preSnapshotRegion.keys().size() == 0 ? 1 : 0) != 0);
            LogWriter log = this.getCache().getLogger();
            log.info("before loadSnapshot");
            FileInputStream in = new FileInputStream(file);
            preSnapshotRegion.loadSnapshot((InputStream)in);
            log.info("after loadSnapshot");
            log.info("before controller remoteTestPostSnapshot");
            this.remoteTestPostSnapshot(name, true, true);
            log.info("after controller remoteTestPostSnapshot");
            if (isDistributed) {
                log.info("before distributed remoteTestPostSnapshot");
                RegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("postSnapshot"){

                    @Override
                    public void run2() throws CacheException {
                        RegionTestCase.this.remoteTestPostSnapshot(name, false, true);
                    }
                });
                log.info("after distributed remoteTestPostSnapshot");
            }
        }
        finally {
            file.delete();
        }
    }

    public void remoteTestPostSnapshot(String name, boolean isController, boolean isRoot) throws CacheException {
        RegionTestCase.assertTrue((boolean)preSnapshotRegion.isDestroyed());
        try {
            preSnapshotRegion.get((Object)"0");
            RegionTestCase.fail((String)"Should have thrown a RegionReinitializedException");
        }
        catch (RegionReinitializedException regionReinitializedException) {
            // empty catch block
        }
        LogWriter log = this.getCache().getLogger();
        Region postSnapshotRegion = isRoot ? this.getRootRegion(name) : this.getRootRegion().getSubregion(name);
        RegionTestCase.assertNotNull((String)"Could not get reference to reinitialized region", (Object)postSnapshotRegion);
        boolean expectData = isController || postSnapshotRegion.getAttributes().getMirrorType().isMirrored() || postSnapshotRegion.getAttributes().getDataPolicy().isPreloaded();
        log.info("region has " + postSnapshotRegion.keys().size() + " entries");
        RegionTestCase.assertEquals((int)(expectData ? 10 : 0), (int)postSnapshotRegion.keys().size());
        RegionTestCase.assertEquals((Object)new Integer(3), (Object)postSnapshotRegion.get((Object)"3"));
        if (expectData) {
            RegionTestCase.assertFalse((boolean)postSnapshotRegion.containsValueForKey((Object)"9"));
            RegionTestCase.assertTrue((boolean)postSnapshotRegion.containsKey((Object)"9"));
        }
    }

    static {
        preSnapshotRegion = null;
    }

    static class CountExpiry
    implements CustomExpiry,
    Declarable {
        static final HashMap invokeCounts = new HashMap();
        final String special;
        final ExpirationAttributes specialAtt;

        protected CountExpiry(String flagged, ExpirationAttributes att) {
            this.special = flagged;
            this.specialAtt = att;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            Object key = entry.getKey();
            Class<CountExpiry> clazz = CountExpiry.class;
            synchronized (CountExpiry.class) {
                Integer count = (Integer)invokeCounts.get(key);
                if (count == null) {
                    invokeCounts.put(key, new Integer(1));
                } else {
                    invokeCounts.put(key, new Integer(count + 1));
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (key.equals(this.special)) {
                    return this.specialAtt;
                }
                return null;
            }
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    protected class TestExpiry
    implements CustomExpiry,
    Declarable {
        final String special;
        final ExpirationAttributes specialAtt;

        protected TestExpiry(String flagged, ExpirationAttributes att) {
            this.special = flagged;
            this.specialAtt = att;
        }

        public ExpirationAttributes getExpiry(Region.Entry entry) {
            if (entry.getKey().equals(this.special)) {
                return this.specialAtt;
            }
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }
}

