/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class SearchAndLoadTest
extends CacheTestCase {
    static boolean loaderInvoked;
    static boolean remoteLoaderInvoked;
    static int remoteLoaderInvokedCount;
    static boolean netSearchCalled;
    static boolean netSearchHit;
    static boolean netWriteInvoked;
    static boolean operationWasCreate;
    static boolean originWasRemote;
    static int writerInvocationCount;
    protected static TestCacheListener listener;
    protected static TestCacheLoader loader;
    protected static TestCacheWriter writer;

    public SearchAndLoadTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                host.getVM(v).invoke(new SerializableRunnable("Clean up"){

                    @Override
                    public void run() {
                        SearchAndLoadTest.cleanup();
                    }
                });
            }
        }
        SearchAndLoadTest.cleanup();
        super.tearDown2();
    }

    protected static void cleanup() {
        listener = null;
        loader = null;
        writer = null;
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEarlyAck(false);
        return factory.create();
    }

    public void testNetSearch() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "NetSearchKey";
        final Integer value = new Integer(440);
        vm0.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setStatisticsEnabled(true);
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                    region.create((Object)"NetSearchKey", null);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setStatisticsEnabled(true);
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                    region.put((Object)"NetSearchKey", (Object)value);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm2.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setStatisticsEnabled(true);
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                    region.create((Object)"NetSearchKey", null);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Get a value"){

            @Override
            public void run() {
                try {
                    Object result = null;
                    result = SearchAndLoadTest.this.getRootRegion().getSubregion(name).get((Object)"NetSearchKey");
                    TestCase.assertEquals((Object)value, (Object)result);
                }
                catch (CacheLoaderException cle) {
                    DistributedTestCase.fail("While Get a value", cle);
                }
                catch (TimeoutException te) {
                    DistributedTestCase.fail("While Get a value", te);
                }
            }
        });
    }

    public void testNetLoadNoLoaders() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "B";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEarlyAck(false);
                SearchAndLoadTest.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new SerializableRunnable("Get with No Loaders defined"){

            @Override
            public void run() {
                try {
                    Object result = SearchAndLoadTest.this.getRootRegion().getSubregion(name).get((Object)"B");
                    TestCase.assertNull((Object)result);
                }
                catch (CacheLoaderException cle) {
                    DistributedTestCase.fail("While getting value for ACK region", cle);
                }
                catch (TimeoutException te) {
                    DistributedTestCase.fail("While getting value for ACK region", te);
                }
            }
        });
    }

    public void testNetLoad() throws CacheException, InterruptedException {
        SearchAndLoadTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "B";
        final Integer value = new Integer(43);
        loaderInvoked = false;
        remoteLoaderInvoked = false;
        vm0.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    loaderInvoked = false;
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                    region.create((Object)"B", null);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setCacheLoader(new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            remoteLoaderInvoked = true;
                            return value;
                        }

                        public void close() {
                        }
                    });
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Get a value from remote loader"){

            @Override
            public void run() {
                for (int i = 0; i < 1; ++i) {
                    try {
                        Object result = SearchAndLoadTest.this.getRootRegion().getSubregion(name).get((Object)"B");
                        TestCase.assertEquals((Object)value, (Object)result);
                        TestCase.assertEquals((Object)new Boolean(loaderInvoked), (Object)Boolean.FALSE);
                        continue;
                    }
                    catch (CacheLoaderException cle) {
                        DistributedTestCase.fail("While getting value for ACK region", cle);
                        continue;
                    }
                    catch (TimeoutException te) {
                        DistributedTestCase.fail("While getting value for ACK region", te);
                    }
                }
            }
        });
    }

    public void testEmptyNetLoad() throws CacheException, InterruptedException {
        SearchAndLoadTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "B";
        Integer value = new Integer(43);
        loaderInvoked = false;
        remoteLoaderInvoked = false;
        remoteLoaderInvokedCount = 0;
        vm0.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                loaderInvoked = false;
                remoteLoaderInvoked = false;
                remoteLoaderInvokedCount = 0;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                    region.create((Object)"B", null);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        SerializableRunnable installLoader = new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                loaderInvoked = false;
                remoteLoaderInvoked = false;
                remoteLoaderInvokedCount = 0;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setCacheLoader(new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            remoteLoaderInvoked = true;
                            ++remoteLoaderInvokedCount;
                            return null;
                        }

                        public void close() {
                        }
                    });
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        };
        vm1.invoke(installLoader);
        vm2.invoke(installLoader);
        vm0.invoke(new SerializableRunnable("Get a value from remote loader"){

            @Override
            public void run() {
                for (int i = 0; i < 1; ++i) {
                    try {
                        Object result = SearchAndLoadTest.this.getRootRegion().getSubregion(name).get((Object)"B");
                        TestCase.assertEquals(null, (Object)result);
                        TestCase.assertEquals((boolean)false, (boolean)loaderInvoked);
                        continue;
                    }
                    catch (CacheLoaderException cle) {
                        DistributedTestCase.fail("While getting value for ACK region", cle);
                        continue;
                    }
                    catch (TimeoutException te) {
                        DistributedTestCase.fail("While getting value for ACK region", te);
                    }
                }
            }
        });
        boolean xor = SearchAndLoadTest.vmRemoteLoaderInvoked(vm1) ^ SearchAndLoadTest.vmRemoteLoaderInvoked(vm2);
        SearchAndLoadTest.assertEquals((String)("vm1=" + SearchAndLoadTest.vmRemoteLoaderInvoked(vm1) + " vm2=" + SearchAndLoadTest.vmRemoteLoaderInvoked(vm2) + " vm1Count=" + SearchAndLoadTest.vmRemoteLoaderInvokedCount(vm1) + " vm2Count=" + SearchAndLoadTest.vmRemoteLoaderInvokedCount(vm2)), (boolean)true, (boolean)xor);
        int total = SearchAndLoadTest.vmRemoteLoaderInvokedCount(vm1) + SearchAndLoadTest.vmRemoteLoaderInvokedCount(vm2);
        SearchAndLoadTest.assertEquals((String)("vm1=" + SearchAndLoadTest.vmRemoteLoaderInvokedCount(vm1) + " vm2=" + SearchAndLoadTest.vmRemoteLoaderInvokedCount(vm2)), (int)1, (int)total);
    }

    public static boolean vmRemoteLoaderInvoked(VM vm) {
        Boolean v = (Boolean)vm.invoke(SearchAndLoadTest.class, "fetchRemoteLoaderInvoked");
        return v;
    }

    public static int vmRemoteLoaderInvokedCount(VM vm) {
        Integer v = (Integer)vm.invoke(SearchAndLoadTest.class, "fetchRemoteLoaderInvokedCount");
        return v;
    }

    public static Boolean fetchRemoteLoaderInvoked() {
        return remoteLoaderInvoked;
    }

    public static Integer fetchRemoteLoaderInvokedCount() {
        return new Integer(remoteLoaderInvokedCount);
    }

    public void testLocalLoad() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "C";
        final Integer value = new Integer(44);
        remoteLoaderInvoked = false;
        loaderInvoked = false;
        vm0.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                remoteLoaderInvoked = false;
                loaderInvoked = false;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setCacheLoader(new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            loaderInvoked = true;
                            return value;
                        }

                        public void close() {
                        }
                    });
                    Region region = SearchAndLoadTest.this.createRegion(name, factory.create());
                    region.create((Object)"C", null);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                remoteLoaderInvoked = false;
                loaderInvoked = false;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setEarlyAck(false);
                    factory.setCacheLoader(new CacheLoader(){

                        public Object load(LoaderHelper helper) {
                            remoteLoaderInvoked = true;
                            return value;
                        }

                        public void close() {
                        }
                    });
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Get a value from local loader"){

            @Override
            public void run() {
                try {
                    Object result = SearchAndLoadTest.this.getRootRegion().getSubregion(name).get((Object)"C");
                    TestCase.assertEquals((Object)value, (Object)result);
                    TestCase.assertEquals((Object)new Boolean(loaderInvoked), (Object)Boolean.TRUE);
                    TestCase.assertEquals((Object)new Boolean(remoteLoaderInvoked), (Object)Boolean.FALSE);
                }
                catch (CacheLoaderException cacheLoaderException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
    }

    public void testNetWrite() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        String objectName = "Gemfire7";
        final Integer value = new Integer(483);
        vm0.invoke(new SerializableRunnable("Create ACK Region with cacheWriter"){

            @Override
            public void run() {
                netWriteInvoked = false;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setCacheWriter(new CacheWriter(){

                        public void beforeCreate(EntryEvent e) throws CacheWriterException {
                            netWriteInvoked = true;
                        }

                        public void beforeUpdate(EntryEvent e) throws CacheWriterException {
                            netWriteInvoked = true;
                        }

                        public void beforeDestroy(EntryEvent e) throws CacheWriterException {
                        }

                        public void beforeRegionDestroy(RegionEvent e) throws CacheWriterException {
                        }

                        public void beforeRegionClear(RegionEvent e) throws CacheWriterException {
                        }

                        public void close() {
                        }
                    });
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                loaderInvoked = false;
                remoteLoaderInvoked = false;
                netWriteInvoked = false;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Do a put operation resulting in cache writer notification in other vm"){

            @Override
            public void run() {
                try {
                    SearchAndLoadTest.this.getRootRegion().getSubregion(name).put((Object)"Gemfire7", (Object)value);
                    try {
                        Object result = SearchAndLoadTest.this.getRootRegion().getSubregion(name).get((Object)"Gemfire7");
                        TestCase.assertEquals((Object)result, (Object)value);
                    }
                    catch (CacheLoaderException cacheLoaderException) {
                    }
                    catch (TimeoutException timeoutException) {}
                }
                catch (CacheWriterException cacheWriterException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
        vm0.invoke(new SerializableRunnable("ensure that cache writer was invoked"){

            @Override
            public void run() {
                TestCase.assertTrue((String)"expected cache writer to be invoked", (boolean)netWriteInvoked);
            }
        });
    }

    public void testOneHopNetWrite() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "Region";
        String objectName = "Object7";
        final Integer value = new Integer(483);
        final Integer updateValue = new Integer(484);
        vm0.invoke(new SerializableRunnable("Create replicated region with cacheWriter"){

            @Override
            public void run() {
                netWriteInvoked = false;
                operationWasCreate = false;
                originWasRemote = false;
                writerInvocationCount = 0;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    factory.setCacheWriter(new CacheWriter(){

                        public void beforeCreate(EntryEvent e) throws CacheWriterException {
                            e.getRegion().getCache().getLogger().info("cache writer beforeCreate invoked for " + e);
                            netWriteInvoked = true;
                            operationWasCreate = true;
                            originWasRemote = e.isOriginRemote();
                            ++writerInvocationCount;
                        }

                        public void beforeUpdate(EntryEvent e) throws CacheWriterException {
                            e.getRegion().getCache().getLogger().info("cache writer beforeUpdate invoked for " + e);
                            netWriteInvoked = true;
                            operationWasCreate = false;
                            originWasRemote = e.isOriginRemote();
                            ++writerInvocationCount;
                        }

                        public void beforeDestroy(EntryEvent e) throws CacheWriterException {
                        }

                        public void beforeRegionDestroy(RegionEvent e) throws CacheWriterException {
                        }

                        public void beforeRegionClear(RegionEvent e) throws CacheWriterException {
                        }

                        public void close() {
                        }
                    });
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating replicated region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create empty Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.EMPTY);
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating empty region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("do a put that should be proxied in the other vm and invoke its cache writer"){

            @Override
            public void run() {
                try {
                    SearchAndLoadTest.this.getRootRegion().getSubregion(name).put((Object)"Object7", (Object)value);
                }
                catch (CacheWriterException cacheWriterException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
        vm0.invoke(new SerializableRunnable("ensure that cache writer was invoked with correct settings in event"){

            @Override
            public void run() {
                TestCase.assertTrue((String)"expected cache writer to be invoked", (boolean)netWriteInvoked);
                TestCase.assertTrue((String)"expected originRemote to be true", (boolean)originWasRemote);
                TestCase.assertTrue((String)"expected event to be create", (boolean)operationWasCreate);
                TestCase.assertEquals((String)"expected only one cache writer invocation", (int)1, (int)writerInvocationCount);
                netWriteInvoked = false;
                writerInvocationCount = 0;
            }
        });
        vm1.invoke(new SerializableRunnable("do an update that should be proxied in the other vm and invoke its cache writer"){

            @Override
            public void run() {
                try {
                    SearchAndLoadTest.this.getRootRegion().getSubregion(name).put((Object)"Object7", (Object)updateValue);
                }
                catch (CacheWriterException cacheWriterException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
        vm0.invoke(new SerializableRunnable("ensure that cache writer was invoked with correct settings in event"){

            @Override
            public void run() {
                TestCase.assertTrue((String)"expected cache writer to be invoked", (boolean)netWriteInvoked);
                TestCase.assertTrue((String)"expected originRemote to be true", (boolean)originWasRemote);
                TestCase.assertTrue((String)"expected event to be create", (boolean)operationWasCreate);
                TestCase.assertEquals((String)"expected only one cache writer invocation", (int)1, (int)writerInvocationCount);
            }
        });
    }

    public void testOneHopNetWriteRemoteWriter() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String name = this.getUniqueName() + "Region";
        String objectName = "Object7";
        final Integer value = new Integer(483);
        final Integer updateValue = new Integer(484);
        vm0.invoke(new SerializableRunnable("Create replicate Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating empty region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create empty Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.EMPTY);
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating empty region", ex);
                }
            }
        });
        vm2.invoke(new SerializableRunnable("Create replicated region with cacheWriter"){

            @Override
            public void run() {
                netWriteInvoked = false;
                operationWasCreate = false;
                originWasRemote = false;
                writerInvocationCount = 0;
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.EMPTY);
                    factory.setCacheWriter(new CacheWriter(){

                        public void beforeCreate(EntryEvent e) throws CacheWriterException {
                            e.getRegion().getCache().getLogger().info("cache writer beforeCreate invoked for " + e);
                            netWriteInvoked = true;
                            operationWasCreate = true;
                            originWasRemote = e.isOriginRemote();
                            ++writerInvocationCount;
                        }

                        public void beforeUpdate(EntryEvent e) throws CacheWriterException {
                            e.getRegion().getCache().getLogger().info("cache writer beforeUpdate invoked for " + e);
                            netWriteInvoked = true;
                            operationWasCreate = false;
                            originWasRemote = e.isOriginRemote();
                            ++writerInvocationCount;
                        }

                        public void beforeDestroy(EntryEvent e) throws CacheWriterException {
                        }

                        public void beforeRegionDestroy(RegionEvent e) throws CacheWriterException {
                        }

                        public void beforeRegionClear(RegionEvent e) throws CacheWriterException {
                        }

                        public void close() {
                        }
                    });
                    SearchAndLoadTest.this.createRegion(name, factory.create());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating replicated region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("do a put that should be proxied in the other vm and invoke its cache writer"){

            @Override
            public void run() {
                try {
                    SearchAndLoadTest.this.getRootRegion().getSubregion(name).put((Object)"Object7", (Object)value);
                }
                catch (CacheWriterException cacheWriterException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
        vm2.invoke(new SerializableRunnable("ensure that cache writer was invoked with correct settings in event"){

            @Override
            public void run() {
                TestCase.assertTrue((String)"expected cache writer to be invoked", (boolean)netWriteInvoked);
                TestCase.assertTrue((String)"expected originRemote to be true", (boolean)originWasRemote);
                TestCase.assertTrue((String)"expected event to be create", (boolean)operationWasCreate);
                TestCase.assertEquals((String)"expected only one cache writer invocation", (int)1, (int)writerInvocationCount);
                netWriteInvoked = false;
                writerInvocationCount = 0;
            }
        });
        vm1.invoke(new SerializableRunnable("do an update that should be proxied in the other vm and invoke its cache writer"){

            @Override
            public void run() {
                try {
                    SearchAndLoadTest.this.getRootRegion().getSubregion(name).put((Object)"Object7", (Object)updateValue);
                }
                catch (CacheWriterException cacheWriterException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        });
        vm2.invoke(new SerializableRunnable("ensure that cache writer was invoked with correct settings in event"){

            @Override
            public void run() {
                TestCase.assertTrue((String)"expected cache writer to be invoked", (boolean)netWriteInvoked);
                TestCase.assertTrue((String)"expected originRemote to be true", (boolean)originWasRemote);
                TestCase.assertTrue((String)"expected event to be create", (boolean)operationWasCreate);
                TestCase.assertEquals((String)"expected only one cache writer invocation", (int)1, (int)writerInvocationCount);
            }
        });
    }
}

