/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;

public class TestDiskRegion {
    private static LRUStatistics getLRUStats(Region region) {
        LocalRegion l = (LocalRegion)region;
        return l.getEvictionController().getLRUHelper().getStats();
    }

    public static void main(String[] args) throws Exception {
        DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
        Cache cache = CacheFactory.create((DistributedSystem)system);
        AttributesFactory factory = new AttributesFactory();
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)2, (ObjectSizer)null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File user_dir = new File(System.getProperty("user.dir"));
        if (!user_dir.exists()) {
            user_dir.mkdir();
        }
        File[] dirs1 = new File[]{user_dir};
        DiskStore ds1 = dsf.setDiskDirs(dirs1).create("TestDiskRegion");
        factory.setDiskStoreName("TestDiskRegion");
        LocalRegion region = (LocalRegion)cache.createRegion("TestDiskRegion", factory.create());
        DiskRegion dr = region.getDiskRegion();
        Assert.assertTrue((dr != null ? 1 : 0) != 0);
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = TestDiskRegion.getLRUStats((Region)region);
        Assert.assertTrue((diskStats != null ? 1 : 0) != 0);
        Assert.assertTrue((lruStats != null ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            region.put((Object)new Integer(i), (Object)String.valueOf(i));
        }
        Assert.assertTrue((diskStats.getWrites() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((diskStats.getReads() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((lruStats.getEvictions() == 0L ? 1 : 0) != 0);
        int total = 0;
        while (lruStats.getEvictions() <= 0L) {
            System.out.println("total puts " + total + ", evictions " + lruStats.getEvictions() + ", total entry size " + lruStats.getCounter());
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        Assert.assertTrue((diskStats.getWrites() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((diskStats.getReads() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((lruStats.getEvictions() == 1L ? 1 : 0) != 0);
        System.out.println("----------  Finished Putting -------------");
        Object value = region.get((Object)new Integer(0));
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertTrue((((int[])value)[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((diskStats.getWrites() == 2L ? 1 : 0) != 0, (Object)String.valueOf(diskStats.getWrites()));
        Assert.assertTrue((diskStats.getReads() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((lruStats.getEvictions() == 2L ? 1 : 0) != 0, (Object)String.valueOf(lruStats.getEvictions()));
        System.out.println("----------  Getting ALL -------------");
        for (int i = 0; i < total; ++i) {
            System.out.println("total gets " + i + ", evictions " + lruStats.getEvictions() + ", total entry size " + lruStats.getCounter());
            int[] array = (int[])region.get((Object)new Integer(i));
            Assert.assertTrue((array != null ? 1 : 0) != 0);
            Assert.assertTrue((i == array[0] ? 1 : 0) != 0);
        }
        System.out.println("---------  Updating  --------------");
        long startEvictions = lruStats.getEvictions();
        for (int i = 0; i < 10; ++i) {
            region.put((Object)new Integer(i), (Object)new int[251]);
            long expected = startEvictions + 1L + (long)i;
            long actual = lruStats.getEvictions();
            Assert.assertTrue((expected == actual ? 1 : 0) != 0, (Object)("For " + i + " expected " + expected + ", got " + actual));
        }
        System.out.println("Done.  Waiting for stats to be written...");
        Thread.sleep(5000L);
    }

    public static void main1(String[] args) throws Exception {
        DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
        Cache cache = CacheFactory.create((DistributedSystem)system);
        AttributesFactory factory = new AttributesFactory();
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)2, (ObjectSizer)null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        factory.setCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterUpdate(EntryEvent event) {
                System.out.println("UPDATE: " + event.getKey() + " -> (" + event.getOldValue() + " -> " + event.getNewValue() + ")");
            }
        });
        LocalRegion region = (LocalRegion)cache.createRegion("TestDiskRegion", factory.create());
        DiskRegion dr = region.getDiskRegion();
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = TestDiskRegion.getLRUStats((Region)region);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Hit enter to perform action");
        int i = 0;
        while (true) {
            br.readLine();
            Integer key = new Integer(i);
            byte[] value = new byte[200000];
            region.put((Object)key, (Object)value);
            System.out.println(key + " -> " + value + " evictions = " + lruStats.getEvictions() + ", writes = " + diskStats.getWrites());
            ++i;
        }
    }

    public static void main4(String[] args) throws Exception {
        DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
        Cache cache = CacheFactory.create((DistributedSystem)system);
        AttributesFactory factory = new AttributesFactory();
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)2, (ObjectSizer)null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        LocalRegion region = (LocalRegion)cache.createRegion("TestDiskRegion", factory.create());
        for (int i = 0; i < 100000; ++i) {
            System.out.println(i);
            region.put((Object)String.valueOf(i), (Object)String.valueOf(i).getBytes());
        }
    }

    public static void main5(String[] args) throws Exception {
        DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
        Cache cache = CacheFactory.create((DistributedSystem)system);
        AttributesFactory factory = new AttributesFactory();
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)2, (ObjectSizer)null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        LocalRegion region = (LocalRegion)cache.createRegion("TestDiskRegion", factory.create());
        LRUStatistics lruStats = TestDiskRegion.getLRUStats((Region)region);
        for (int i = 0; i < 10000; ++i) {
            int[] array = new int[1000];
            array[0] = i;
            try {
                region.put((Object)array, (Object)new Integer(i));
                continue;
            }
            catch (IllegalStateException ex) {
                System.out.println("Ran out of space: " + ex);
                return;
            }
        }
        String s = "Limit is " + lruStats.getLimit() + " evictions are " + lruStats.getEvictions();
        throw new RuntimeException(s);
    }
}

