/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeMembership;
import com.gemstone.gemfire.cache.util.BridgeMembershipEvent;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.cache.util.UniversalMembershipListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.cache.tier.InternalBridgeMembership;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class UniversalMembershipListenerAdapterDUnitTest
extends BridgeTestCase {
    protected static final boolean CLIENT = true;
    protected static final boolean SERVER = false;
    protected static final int JOINED = 0;
    protected static final int LEFT = 1;
    protected static final int CRASHED = 2;
    private static final int BRIEF_PAUSE_MILLIS = 2000;
    private static final int JOIN_FAIL_MILLIS = 120000;
    private static final int CONNECT_WAIT_MILLIS = 5000;
    private static final int SYNC_ASYNC_EVENT_WAIT_MILLIS = 2000;
    private static final int ASYNC_EVENT_WAIT_MILLIS = 120000;
    protected static int testServerEventsInSystemClient_port;
    protected static int testServerEventsInLonerClient_port;

    public UniversalMembershipListenerAdapterDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        InternalBridgeMembership.unregisterAllListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdaptedBridgeEvents() throws Exception {
        this.getSystem();
        final boolean[] fired = new boolean[1];
        final DistributedMember[] member = new DistributedMember[1];
        final String[] memberId = new String[1];
        UniversalMembershipListenerAdapter listener = new UniversalMembershipListenerAdapter(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)fired[0]);
                TestCase.assertNull((Object)member[0]);
                TestCase.assertNull((Object)memberId[0]);
                fired[0] = true;
                member[0] = event.getDistributedMember();
                memberId[0] = event.getMemberId();
                ((Object)((Object)this)).notify();
            }

            public void memberLeft(SystemMembershipEvent event) {
            }

            public void memberCrashed(SystemMembershipEvent event) {
            }
        };
        TestDistributedMember clientJoined = new TestDistributedMember("clientJoined");
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        UniversalMembershipListenerAdapter universalMembershipListenerAdapter = listener;
        synchronized (universalMembershipListenerAdapter) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)fired[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientJoined, (Object)member[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoDuplicates() throws Exception {
        this.getSystem();
        final boolean[] fired = new boolean[3];
        final DistributedMember[] member = new DistributedMember[3];
        final String[] memberId = new String[3];
        UniversalMembershipListenerAdapter listener = new UniversalMembershipListenerAdapter(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)fired[0]);
                TestCase.assertNull((Object)member[0]);
                TestCase.assertNull((Object)memberId[0]);
                fired[0] = true;
                member[0] = event.getDistributedMember();
                memberId[0] = event.getMemberId();
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)fired[1]);
                TestCase.assertNull((Object)member[1]);
                TestCase.assertNull((Object)memberId[1]);
                fired[1] = true;
                member[1] = event.getDistributedMember();
                memberId[1] = event.getMemberId();
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)fired[2]);
                TestCase.assertNull((Object)member[2]);
                TestCase.assertNull((Object)memberId[2]);
                fired[2] = true;
                member[2] = event.getDistributedMember();
                memberId[2] = event.getMemberId();
                ((Object)((Object)this)).notify();
            }
        };
        TestDistributedMember memberA = new TestDistributedMember("memberA");
        InternalBridgeMembership.notifyJoined((DistributedMember)memberA, (boolean)true);
        UniversalMembershipListenerAdapter universalMembershipListenerAdapter = listener;
        synchronized (universalMembershipListenerAdapter) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)fired[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)memberA, (Object)member[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)memberA.getId(), (String)memberId[0]);
        fired[0] = false;
        member[0] = null;
        memberId[0] = null;
        InternalBridgeMembership.notifyJoined((DistributedMember)memberA, (boolean)true);
        UniversalMembershipListenerAdapterDUnitTest.pause(2000);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)fired[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)member[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberId[0]);
        InternalBridgeMembership.notifyLeft((DistributedMember)memberA, (boolean)true);
        universalMembershipListenerAdapter = listener;
        synchronized (universalMembershipListenerAdapter) {
            if (!fired[1]) {
                listener.wait(2000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)fired[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)memberA, (Object)member[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)memberA.getId(), (String)memberId[1]);
        fired[1] = false;
        member[1] = null;
        memberId[1] = null;
        InternalBridgeMembership.notifyLeft((DistributedMember)memberA, (boolean)true);
        UniversalMembershipListenerAdapterDUnitTest.pause(2000);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)fired[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)member[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberId[1]);
        InternalBridgeMembership.notifyJoined((DistributedMember)memberA, (boolean)true);
        universalMembershipListenerAdapter = listener;
        synchronized (universalMembershipListenerAdapter) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)fired[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)memberA, (Object)member[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)memberA.getId(), (String)memberId[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLonerClientEventsInServer() throws Exception {
        try {
            this.doTestLonerClientEventsInServer();
        }
        finally {
            UniversalMembershipListenerAdapterDUnitTest.disconnectAllFromDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestLonerClientEventsInServer() throws Exception {
        final boolean[] firedSystem = new boolean[3];
        final DistributedMember[] memberSystem = new DistributedMember[3];
        final String[] memberIdSystem = new String[3];
        boolean[] isClientSystem = new boolean[3];
        final boolean[] firedAdapter = new boolean[3];
        final DistributedMember[] memberAdapter = new DistributedMember[3];
        final String[] memberIdAdapter = new String[3];
        final boolean[] isClientAdapter = new boolean[3];
        final boolean[] firedBridge = new boolean[3];
        final DistributedMember[] memberBridge = new DistributedMember[3];
        final String[] memberIdBridge = new String[3];
        final boolean[] isClientBridge = new boolean[3];
        SystemMembershipListener systemListener = new SystemMembershipListener(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)firedSystem[0]);
                TestCase.assertNull((Object)memberSystem[0]);
                TestCase.assertNull((Object)memberIdSystem[0]);
                firedSystem[0] = true;
                memberSystem[0] = event.getDistributedMember();
                memberIdSystem[0] = event.getMemberId();
                this.notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)firedSystem[1]);
                TestCase.assertNull((Object)memberSystem[1]);
                TestCase.assertNull((Object)memberIdSystem[1]);
                firedSystem[1] = true;
                memberSystem[1] = event.getDistributedMember();
                memberIdSystem[1] = event.getMemberId();
                this.notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)firedSystem[2]);
                TestCase.assertNull((Object)memberSystem[2]);
                TestCase.assertNull((Object)memberIdSystem[2]);
                firedSystem[2] = true;
                memberSystem[2] = event.getDistributedMember();
                memberIdSystem[2] = event.getMemberId();
                this.notify();
            }
        };
        UniversalMembershipListenerAdapter adapter = new UniversalMembershipListenerAdapter(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)firedAdapter[0]);
                TestCase.assertNull((Object)memberAdapter[0]);
                TestCase.assertNull((Object)memberIdAdapter[0]);
                TestCase.assertFalse((boolean)isClientAdapter[0]);
                firedAdapter[0] = true;
                memberAdapter[0] = event.getDistributedMember();
                memberIdAdapter[0] = event.getMemberId();
                isClientAdapter[0] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)firedAdapter[1]);
                TestCase.assertNull((Object)memberAdapter[1]);
                TestCase.assertNull((Object)memberIdAdapter[1]);
                TestCase.assertFalse((boolean)isClientAdapter[1]);
                firedAdapter[1] = true;
                memberAdapter[1] = event.getDistributedMember();
                memberIdAdapter[1] = event.getMemberId();
                isClientAdapter[1] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                TestCase.assertFalse((boolean)firedAdapter[2]);
                TestCase.assertNull((Object)memberAdapter[2]);
                TestCase.assertNull((Object)memberIdAdapter[2]);
                TestCase.assertFalse((boolean)isClientAdapter[2]);
                firedAdapter[2] = true;
                memberAdapter[2] = event.getDistributedMember();
                memberIdAdapter[2] = event.getMemberId();
                isClientAdapter[2] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                ((Object)((Object)this)).notify();
            }
        };
        BridgeMembershipListener bridgeListener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                TestCase.assertFalse((boolean)firedBridge[0]);
                TestCase.assertNull((Object)memberBridge[0]);
                TestCase.assertNull((Object)memberIdBridge[0]);
                TestCase.assertFalse((boolean)isClientBridge[0]);
                firedBridge[0] = true;
                memberBridge[0] = event.getMember();
                memberIdBridge[0] = event.getMemberId();
                isClientBridge[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                TestCase.assertFalse((boolean)firedBridge[1]);
                TestCase.assertNull((Object)memberBridge[1]);
                TestCase.assertNull((Object)memberIdBridge[1]);
                TestCase.assertFalse((boolean)isClientBridge[1]);
                firedBridge[1] = true;
                memberBridge[1] = event.getMember();
                memberIdBridge[1] = event.getMemberId();
                isClientBridge[1] = event.isClient();
                this.notify();
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                TestCase.assertFalse((boolean)firedBridge[2]);
                TestCase.assertNull((Object)memberBridge[2]);
                TestCase.assertNull((Object)memberIdBridge[2]);
                TestCase.assertFalse((boolean)isClientBridge[2]);
                firedBridge[2] = true;
                memberBridge[2] = event.getMember();
                memberIdBridge[2] = event.getMemberId();
                isClientBridge[2] = event.isClient();
                this.notify();
            }
        };
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[1];
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] Create BridgeServer");
        this.getSystem();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        Region region = this.createRegion(name, factory.create());
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)region);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        ports[0] = this.startBridgeServer(0);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        String serverMemberId = UniversalMembershipListenerAdapterDUnitTest.getMemberId();
        DistributedMember serverMember = UniversalMembershipListenerAdapterDUnitTest.getDistributedMember();
        final Properties serverProperties = this.getSystem().getProperties();
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] ports[0]=" + ports[0]);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] serverMemberId=" + serverMemberId);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] serverMember=" + serverMember);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)bridgeListener);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)this.getSystem(), null);
        AdminDistributedSystem adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        adminDS.connect();
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)adminDS.waitToBeConnected(5000L));
        adminDS.addMembershipListener(systemListener);
        adapter.registerMembershipListener(adminDS);
        CacheSerializableRunnable createBridgeClient = new CacheSerializableRunnable("Create bridge client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testLonerClientEventsInServer] create bridge client");
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                config.setProperty("locators", "");
                UniversalMembershipListenerAdapterDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), ports, false, -1, -1, null);
                UniversalMembershipListenerAdapterDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name));
            }
        };
        CacheSerializableRunnable createSystemBridgeClient = new CacheSerializableRunnable("Create system bridge client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testLonerClientEventsInServer] create system bridge client");
                UniversalMembershipListenerAdapterDUnitTest.this.getSystem(serverProperties);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), ports, false, -1, -1, null);
                UniversalMembershipListenerAdapterDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name));
            }
        };
        vm0.invoke(createBridgeClient);
        String clientMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        DistributedMember clientMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        Object object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] assert server detected client join");
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(new SerializableRunnable("Wait for client to fully connect"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testLonerClientEventsInServer] wait for client to fully connect");
                String pl = UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
                PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
                UniversalMembershipListenerAdapterDUnitTest.this.waitForClientToFullyConnect(pi);
            }
        });
        vm0.invoke(new SerializableRunnable("Close bridge client region"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testLonerClientEventsInServer] close bridge client region");
                UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).close();
                PoolManager.close();
            }
        });
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[1]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[1]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] assert server detected client left");
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(createBridgeClient);
        clientMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        clientMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] assert server detected client re-join");
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(new SerializableRunnable("Wait for client to fully connect"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testLonerClientEventsInServer] wait for client to fully connect");
                String pl = UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
                PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
                UniversalMembershipListenerAdapterDUnitTest.this.waitForClientToFullyConnect(pi);
            }
        });
        ServerConnection.setForceClientCrashEvent((boolean)true);
        try {
            vm0.invoke(new SerializableRunnable("Stop bridge client"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testLonerClientEventsInServer] Stop bridge client");
                    UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).close();
                    PoolManager.close();
                }
            });
            object = adapter;
            synchronized (object) {
                if (!firedAdapter[2]) {
                    adapter.wait(120000L);
                }
            }
            object = bridgeListener;
            synchronized (object) {
                if (!firedBridge[2]) {
                    bridgeListener.wait(120000L);
                }
            }
            UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testLonerClientEventsInServer] assert server detected client crashed");
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientAdapter[2]);
        }
        finally {
            ServerConnection.setForceClientCrashEvent((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSystemClientEventsInServer() throws Exception {
        try {
            this.doTestSystemClientEventsInServer();
        }
        finally {
            UniversalMembershipListenerAdapterDUnitTest.disconnectAllFromDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSystemClientEventsInServer() throws Exception {
        final boolean[] firedSystem = new boolean[3];
        final DistributedMember[] memberSystem = new DistributedMember[3];
        final String[] memberIdSystem = new String[3];
        boolean[] isClientSystem = new boolean[3];
        final boolean[] firedAdapter = new boolean[3];
        final DistributedMember[] memberAdapter = new DistributedMember[3];
        final String[] memberIdAdapter = new String[3];
        final boolean[] isClientAdapter = new boolean[3];
        final boolean[] firedBridge = new boolean[3];
        final DistributedMember[] memberBridge = new DistributedMember[3];
        final String[] memberIdBridge = new String[3];
        final boolean[] isClientBridge = new boolean[3];
        final boolean[] firedSystemDuplicate = new boolean[3];
        final boolean[] firedAdapterDuplicate = new boolean[3];
        final boolean[] firedBridgeDuplicate = new boolean[3];
        SystemMembershipListener systemListener = new SystemMembershipListener(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                firedSystemDuplicate[0] = firedSystem[0];
                firedSystem[0] = true;
                memberSystem[0] = event.getDistributedMember();
                memberIdSystem[0] = event.getMemberId();
                this.notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                firedSystemDuplicate[1] = firedSystem[1];
                firedSystem[1] = true;
                memberSystem[1] = event.getDistributedMember();
                memberIdSystem[1] = event.getMemberId();
                this.notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                firedSystemDuplicate[2] = firedSystem[2];
                firedSystem[2] = true;
                memberSystem[2] = event.getDistributedMember();
                memberIdSystem[2] = event.getMemberId();
                this.notify();
            }
        };
        UniversalMembershipListenerAdapter adapter = new UniversalMembershipListenerAdapter(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] memberJoined >" + event.getMemberId() + "<");
                firedAdapterDuplicate[0] = firedAdapter[0];
                firedAdapter[0] = true;
                memberAdapter[0] = event.getDistributedMember();
                memberIdAdapter[0] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[0] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] memberLeft >" + event.getMemberId() + "<");
                firedAdapterDuplicate[1] = firedAdapter[1];
                firedAdapter[1] = true;
                memberAdapter[1] = event.getDistributedMember();
                memberIdAdapter[1] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[1] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] memberCrashed >" + event.getMemberId() + "<");
                firedAdapterDuplicate[2] = firedAdapter[2];
                firedAdapter[2] = true;
                memberAdapter[2] = event.getDistributedMember();
                memberIdAdapter[2] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[2] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }
        };
        BridgeMembershipListener bridgeListener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                firedBridgeDuplicate[0] = firedBridge[0];
                firedBridge[0] = true;
                memberBridge[0] = event.getMember();
                memberIdBridge[0] = event.getMemberId();
                isClientBridge[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                firedBridgeDuplicate[1] = firedBridge[1];
                firedBridge[1] = true;
                memberBridge[1] = event.getMember();
                memberIdBridge[1] = event.getMemberId();
                isClientBridge[1] = event.isClient();
                this.notify();
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                firedBridgeDuplicate[2] = firedBridge[2];
                firedBridge[2] = true;
                memberBridge[2] = event.getMember();
                memberIdBridge[2] = event.getMemberId();
                isClientBridge[2] = event.isClient();
                this.notify();
            }
        };
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[1];
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] Create BridgeServer");
        this.getSystem();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        Region region = this.createRegion(name, factory.create());
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)region);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        ports[0] = this.startBridgeServer(0);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        String serverMemberId = UniversalMembershipListenerAdapterDUnitTest.getMemberId();
        DistributedMember serverMember = UniversalMembershipListenerAdapterDUnitTest.getDistributedMember();
        final Properties serverProperties = this.getSystem().getProperties();
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] ports[0]=" + ports[0]);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] serverMemberId=" + serverMemberId);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] serverMember=" + serverMember);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)bridgeListener);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)this.getSystem(), null);
        AdminDistributedSystem adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        adminDS.connect();
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)adminDS.waitToBeConnected(5000L));
        adminDS.addMembershipListener(systemListener);
        adapter.registerMembershipListener(adminDS);
        CacheSerializableRunnable createBridgeClient = new CacheSerializableRunnable("Create bridge client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] create system bridge client");
                TestCase.assertTrue((boolean)UniversalMembershipListenerAdapterDUnitTest.this.getSystem(serverProperties).isConnected());
                TestCase.assertFalse((boolean)UniversalMembershipListenerAdapterDUnitTest.this.getCache().isClosed());
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), ports, false, -1, -1, null);
                UniversalMembershipListenerAdapterDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name));
            }
        };
        vm0.invoke(createBridgeClient);
        String clientMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        DistributedMember clientMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        Object object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        object = systemListener;
        synchronized (object) {
            if (!firedSystem[0]) {
                systemListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] assert server detected client join");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(new SerializableRunnable("Wait for client to fully connect"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] wait for client to fully connect");
                String pl = UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
                PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
                UniversalMembershipListenerAdapterDUnitTest.this.waitForClientToFullyConnect(pi);
            }
        });
        vm0.invoke(new SerializableRunnable("Close bridge client region"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] close bridge client region");
                UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).close();
                PoolManager.close();
            }
        });
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[1]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[1]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] assert server detected client left");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(createBridgeClient);
        clientMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        clientMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] assert server detected client re-join");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(new SerializableRunnable("Wait for client to fully connect"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] wait for client to fully connect");
                String pl = UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
                PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
                UniversalMembershipListenerAdapterDUnitTest.this.waitForClientToFullyConnect(pi);
            }
        });
        vm0.invoke(new SerializableRunnable("Disconnect bridge client"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] disconnect bridge client");
                CacheTestCase.closeCache();
                CacheTestCase.disconnectFromDS();
            }
        });
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[1]) {
                adapter.wait(120000L);
            }
        }
        object = systemListener;
        synchronized (object) {
            if (!firedSystem[1]) {
                systemListener.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[1]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] assert server detected client left");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(createBridgeClient);
        clientMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        clientMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = systemListener;
        synchronized (object) {
            if (!firedSystem[0]) {
                systemListener.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] assert server detected client re-join");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(new SerializableRunnable("Wait for client to fully connect"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] wait for client to fully connect");
                String pl = UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
                PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
                UniversalMembershipListenerAdapterDUnitTest.this.waitForClientToFullyConnect(pi);
            }
        });
        ServerConnection.setForceClientCrashEvent((boolean)true);
        try {
            vm0.invoke(new SerializableRunnable("Close bridge client region"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[doTestSystemClientEventsInServer] close bridge client region");
                    UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name).close();
                    PoolManager.close();
                }
            });
            object = adapter;
            synchronized (object) {
                if (!firedAdapter[2]) {
                    adapter.wait(120000L);
                }
            }
            object = bridgeListener;
            synchronized (object) {
                if (!firedBridge[2]) {
                    bridgeListener.wait(120000L);
                }
            }
            UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[doTestSystemClientEventsInServer] assert server detected client crashed");
            this.assertFalse(firedSystemDuplicate);
            this.assertFalse(firedAdapterDuplicate);
            this.assertFalse(firedBridgeDuplicate);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientBridge[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)clientMember, (Object)memberAdapter[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)clientMemberId, (String)memberIdAdapter[2]);
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)isClientAdapter[2]);
        }
        finally {
            ServerConnection.setForceClientCrashEvent((boolean)false);
        }
    }

    protected void waitForClientToFullyConnect(PoolImpl pool) {
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[waitForClientToFullyConnect]");
        long failMillis = System.currentTimeMillis() + 120000L;
        boolean fullyConnected = false;
        while (!fullyConnected) {
            UniversalMembershipListenerAdapterDUnitTest.pause(100);
            fullyConnected = pool.getConnectionCount() >= pool.getMinConnections();
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((String)("Client failed to create " + pool.getMinConnections() + " connections within " + 120000 + " milliseconds. Only " + pool.getConnectionCount() + " connections were created."), (System.currentTimeMillis() < failMillis ? 1 : 0) != 0);
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[waitForClientToFullyConnect] fullyConnected=" + fullyConnected);
    }

    private void resetArraysForTesting(boolean[] fired, DistributedMember[] member, String[] memberId, boolean[] isClient) {
        for (int i = 0; i < fired.length; ++i) {
            fired[i] = false;
            member[i] = null;
            memberId[i] = null;
            isClient[i] = false;
        }
    }

    private void assertFalse(boolean[] array) {
        this.assertFalse(null, array);
    }

    private void assertFalse(String msg, boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (msg == null) {
                UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)array[i]);
                continue;
            }
            UniversalMembershipListenerAdapterDUnitTest.assertFalse((String)msg, (boolean)array[i]);
        }
    }

    private void assertTrue(boolean[] array) {
        this.assertTrue(null, array);
    }

    private void assertTrue(String msg, boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (msg == null) {
                UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)array[i]);
                continue;
            }
            UniversalMembershipListenerAdapterDUnitTest.assertTrue((String)msg, (boolean)array[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerEventsInSystemClient() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                this.doTestServerEventsInSystemClient();
                break;
            }
            catch (AssertionFailedError e) {
                if (i >= 3) {
                    throw e;
                }
                UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("testServerEventsInSystemClient about to repeat after attempt " + i + " threw AFE (see bug 37482).");
                continue;
            }
            finally {
                UniversalMembershipListenerAdapterDUnitTest.disconnectAllFromDS();
            }
        }
    }

    private static int getTestServerEventsInSystemClient_port() {
        return testServerEventsInSystemClient_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestServerEventsInSystemClient() throws Exception {
        Object object;
        final boolean[] firedSystem = new boolean[3];
        final DistributedMember[] memberSystem = new DistributedMember[3];
        final String[] memberIdSystem = new String[3];
        boolean[] isClientSystem = new boolean[3];
        final boolean[] firedAdapter = new boolean[3];
        final DistributedMember[] memberAdapter = new DistributedMember[3];
        final String[] memberIdAdapter = new String[3];
        final boolean[] isClientAdapter = new boolean[3];
        final boolean[] firedBridge = new boolean[3];
        final DistributedMember[] memberBridge = new DistributedMember[3];
        final String[] memberIdBridge = new String[3];
        final boolean[] isClientBridge = new boolean[3];
        final boolean[] firedSystemDuplicate = new boolean[3];
        final boolean[] firedAdapterDuplicate = new boolean[3];
        final boolean[] firedBridgeDuplicate = new boolean[3];
        SystemMembershipListener systemListener = new SystemMembershipListener(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                firedSystemDuplicate[0] = firedSystem[0];
                firedSystem[0] = true;
                memberSystem[0] = event.getDistributedMember();
                memberIdSystem[0] = event.getMemberId();
                this.notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                firedSystemDuplicate[1] = firedSystem[1];
                firedSystem[1] = true;
                memberSystem[1] = event.getDistributedMember();
                memberIdSystem[1] = event.getMemberId();
                this.notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                firedSystemDuplicate[2] = firedSystem[2];
                firedSystem[2] = true;
                memberSystem[2] = event.getDistributedMember();
                memberIdSystem[2] = event.getMemberId();
                this.notify();
            }
        };
        UniversalMembershipListenerAdapter adapter = new UniversalMembershipListenerAdapter(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testServerEventsInSystemClient] memberJoined >" + event.getMemberId() + "<");
                firedAdapterDuplicate[0] = firedAdapter[0];
                firedAdapter[0] = true;
                memberAdapter[0] = event.getDistributedMember();
                memberIdAdapter[0] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[0] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testServerEventsInSystemClient] memberLeft >" + event.getMemberId() + "<");
                firedAdapterDuplicate[1] = firedAdapter[1];
                firedAdapter[1] = true;
                memberAdapter[1] = event.getDistributedMember();
                memberIdAdapter[1] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[1] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testServerEventsInSystemClient] memberCrashed >" + event.getMemberId() + "<");
                firedAdapterDuplicate[2] = firedAdapter[2];
                firedAdapter[2] = true;
                memberAdapter[2] = event.getDistributedMember();
                memberIdAdapter[2] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[2] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }
        };
        BridgeMembershipListener bridgeListener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                firedBridgeDuplicate[0] = firedBridge[0];
                firedBridge[0] = true;
                memberBridge[0] = event.getMember();
                memberIdBridge[0] = event.getMemberId();
                isClientBridge[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                firedBridgeDuplicate[1] = firedBridge[1];
                firedBridge[1] = true;
                memberBridge[1] = event.getMember();
                memberIdBridge[1] = event.getMemberId();
                isClientBridge[1] = event.isClient();
                this.notify();
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                firedBridgeDuplicate[2] = firedBridge[2];
                firedBridge[2] = true;
                memberBridge[2] = event.getMember();
                memberIdBridge[2] = event.getMemberId();
                isClientBridge[2] = event.isClient();
                this.notify();
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[]{AvailablePort.getRandomAvailablePort((int)0)};
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] create system bridge client");
        this.getSystem();
        final Properties clientProperties = UniversalMembershipListenerAdapterDUnitTest.getSystemProperties();
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)bridgeListener);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)this.getSystem(), null);
        AdminDistributedSystem adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        adminDS.connect();
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)adminDS.waitToBeConnected(5000L));
        adminDS.addMembershipListener(systemListener);
        adapter.registerMembershipListener(adminDS);
        CacheSerializableRunnable createBridgeServer = new CacheSerializableRunnable("Create BridgeServer"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testServerEventsInSystemClient] Create BridgeServer");
                UniversalMembershipListenerAdapterDUnitTest.this.getSystem(clientProperties);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region = UniversalMembershipListenerAdapterDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)region);
                TestCase.assertNotNull((Object)UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name));
                try {
                    testServerEventsInSystemClient_port = UniversalMembershipListenerAdapterDUnitTest.this.startBridgeServer(ports[0]);
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error((Throwable)e);
                    TestCase.fail((String)e.getMessage());
                }
            }
        };
        vm0.invoke(createBridgeServer);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((int)ports[0], (int)vm0.invokeInt(UniversalMembershipListenerAdapterDUnitTest.class, "getTestServerEventsInSystemClient_port"));
        String serverMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        DistributedMember serverMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] ports[0]=" + ports[0]);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] serverMemberId=" + serverMemberId);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] serverMember=" + serverMember);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        BridgeTestCase.configureConnectionPool(factory, UniversalMembershipListenerAdapterDUnitTest.getServerHostName(host), ports, false, -1, -1, null);
        this.createRegion(name, factory.create());
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        Object object2 = systemListener;
        synchronized (object2) {
            if (!firedSystem[0]) {
                systemListener.wait(120000L);
            }
        }
        object2 = adapter;
        synchronized (object2) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object2 = bridgeListener;
        synchronized (object2) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] assert client detected server join");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] wait for client to fully connect");
        String pl = this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
        PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
        this.waitForClientToFullyConnect(pi);
        LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
        bgexecLogger.info("<ExpectedException action=add>java.io.IOException</ExpectedException>");
        DistributedTestCase.ExpectedException ex = UniversalMembershipListenerAdapterDUnitTest.addExpectedException(ServerConnectivityException.class.getName());
        try {
            vm0.invoke(new SerializableRunnable("Disconnect bridge server"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testServerEventsInSystemClient] disconnect bridge server");
                    CacheTestCase.closeCache();
                    CacheTestCase.disconnectFromDS();
                }
            });
            object = systemListener;
            synchronized (object) {
                if (!firedSystem[1]) {
                    systemListener.wait(120000L);
                }
            }
            object = adapter;
            synchronized (object) {
                if (!firedAdapter[1]) {
                    adapter.wait(120000L);
                }
            }
            object = bridgeListener;
            synchronized (object) {
                if (!firedBridge[1]) {
                    bridgeListener.wait(120000L);
                }
            }
        }
        finally {
            bgexecLogger.info("<ExpectedException action=remove>java.io.IOException</ExpectedException>");
            ex.remove();
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] assert client detected server crashed");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((String)"Please update testServerEventsInSystemClient to handle memberLeft for BridgeServer.", (boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((String)"this intermittently fails", (boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(createBridgeServer);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((int)ports[0], (int)vm0.invokeInt(UniversalMembershipListenerAdapterDUnitTest.class, "getTestServerEventsInSystemClient_port"));
        serverMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        serverMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] ports[0]=" + ports[0]);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] serverMemberId=" + serverMemberId);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] serverMember=" + serverMember);
        object = systemListener;
        synchronized (object) {
            if (!firedSystem[0]) {
                systemListener.wait(120000L);
            }
        }
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInSystemClient] assert client detected server re-join");
        this.assertFalse(firedSystemDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdSystem[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientSystem[2]);
        this.resetArraysForTesting(firedSystem, memberSystem, memberIdSystem, isClientSystem);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerEventsInLonerClient() throws Exception {
        try {
            this.doTestServerEventsInLonerClient();
        }
        finally {
            UniversalMembershipListenerAdapterDUnitTest.disconnectAllFromDS();
        }
    }

    private static int getTestServerEventsInLonerClient_port() {
        return testServerEventsInLonerClient_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestServerEventsInLonerClient() throws Exception {
        Object object;
        final boolean[] firedAdapter = new boolean[3];
        final DistributedMember[] memberAdapter = new DistributedMember[3];
        final String[] memberIdAdapter = new String[3];
        final boolean[] isClientAdapter = new boolean[3];
        final boolean[] firedBridge = new boolean[3];
        final DistributedMember[] memberBridge = new DistributedMember[3];
        final String[] memberIdBridge = new String[3];
        final boolean[] isClientBridge = new boolean[3];
        final boolean[] firedAdapterDuplicate = new boolean[3];
        final boolean[] firedBridgeDuplicate = new boolean[3];
        UniversalMembershipListenerAdapter adapter = new UniversalMembershipListenerAdapter(){

            public synchronized void memberJoined(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testServerEventsInLonerClient] memberJoined >" + event.getMemberId() + "<");
                firedAdapterDuplicate[0] = firedAdapter[0];
                firedAdapter[0] = true;
                memberAdapter[0] = event.getDistributedMember();
                memberIdAdapter[0] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[0] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberLeft(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testServerEventsInLonerClient] memberLeft >" + event.getMemberId() + "<");
                firedAdapterDuplicate[1] = firedAdapter[1];
                firedAdapter[1] = true;
                memberAdapter[1] = event.getDistributedMember();
                memberIdAdapter[1] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[1] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }

            public synchronized void memberCrashed(SystemMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testServerEventsInLonerClient] memberCrashed >" + event.getMemberId() + "<");
                firedAdapterDuplicate[2] = firedAdapter[2];
                firedAdapter[2] = true;
                memberAdapter[2] = event.getDistributedMember();
                memberIdAdapter[2] = event.getMemberId();
                if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
                    isClientAdapter[2] = ((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient();
                }
                ((Object)((Object)this)).notify();
            }
        };
        BridgeMembershipListener bridgeListener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                firedBridgeDuplicate[0] = firedBridge[0];
                firedBridge[0] = true;
                memberBridge[0] = event.getMember();
                memberIdBridge[0] = event.getMemberId();
                isClientBridge[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                firedBridgeDuplicate[1] = firedBridge[1];
                firedBridge[1] = true;
                memberBridge[1] = event.getMember();
                memberIdBridge[1] = event.getMemberId();
                isClientBridge[1] = event.isClient();
                this.notify();
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                firedBridgeDuplicate[2] = firedBridge[2];
                firedBridge[2] = true;
                memberBridge[2] = event.getMember();
                memberIdBridge[2] = event.getMemberId();
                isClientBridge[2] = event.isClient();
                this.notify();
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[]{AvailablePort.getRandomAvailablePort((int)0)};
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] create loner bridge client");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] create system bridge client");
        this.getSystem();
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)bridgeListener);
        CacheSerializableRunnable createBridgeServer = new CacheSerializableRunnable("Create BridgeServer"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testServerEventsInLonerClient] Create BridgeServer");
                UniversalMembershipListenerAdapterDUnitTest.this.getSystem();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region = UniversalMembershipListenerAdapterDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)region);
                TestCase.assertNotNull((Object)UniversalMembershipListenerAdapterDUnitTest.this.getRootRegion().getSubregion(name));
                try {
                    testServerEventsInLonerClient_port = UniversalMembershipListenerAdapterDUnitTest.this.startBridgeServer(ports[0]);
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error((Throwable)e);
                    TestCase.fail((String)e.getMessage());
                }
            }
        };
        vm0.invoke(createBridgeServer);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((int)ports[0], (int)vm0.invokeInt(UniversalMembershipListenerAdapterDUnitTest.class, "getTestServerEventsInLonerClient_port"));
        String serverMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        DistributedMember serverMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] ports[0]=" + ports[0]);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] serverMemberId=" + serverMemberId);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] serverMember=" + serverMember);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        BridgeTestCase.configureConnectionPool(factory, UniversalMembershipListenerAdapterDUnitTest.getServerHostName(host), ports, false, -1, -1, null);
        this.createRegion(name, factory.create());
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        Object object2 = adapter;
        synchronized (object2) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object2 = bridgeListener;
        synchronized (object2) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] assert client detected server join");
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] wait for client to fully connect");
        String pl = this.getRootRegion().getSubregion(name).getAttributes().getPoolName();
        PoolImpl pi = (PoolImpl)PoolManager.find((String)pl);
        this.waitForClientToFullyConnect(pi);
        String expected = "java.io.IOException";
        String addExpected = "<ExpectedException action=add>" + expected + "</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>" + expected + "</ExpectedException>";
        String expected2 = "java.net.ConnectException";
        String addExpected2 = "<ExpectedException action=add>" + expected2 + "</ExpectedException>";
        String removeExpected2 = "<ExpectedException action=remove>" + expected2 + "</ExpectedException>";
        LogWriter lw = this.getSystem().getLogWriter();
        lw.info(addExpected);
        lw.info(addExpected2);
        try {
            vm0.invoke(new SerializableRunnable("Disconnect bridge server"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testServerEventsInLonerClient] disconnect bridge server");
                    CacheTestCase.closeCache();
                }
            });
            object = adapter;
            synchronized (object) {
                if (!firedAdapter[1]) {
                    adapter.wait(120000L);
                }
            }
            object = bridgeListener;
            synchronized (object) {
                if (!firedBridge[1] && !firedBridge[2]) {
                    bridgeListener.wait(120000L);
                }
            }
        }
        finally {
            lw.info(removeExpected);
            lw.info(removeExpected2);
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] assert client detected server crashed");
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((String)"Please update testServerEventsInLonerClient to handle memberLeft for BridgeServer.", (boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((String)"Please update testServerEventsInLonerClient to handle BridgeServer LEFT", (boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
        vm0.invoke(createBridgeServer);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((int)ports[0], (int)vm0.invokeInt(UniversalMembershipListenerAdapterDUnitTest.class, "getTestServerEventsInLonerClient_port"));
        serverMemberId = (String)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getMemberId");
        serverMember = (DistributedMember)vm0.invoke(UniversalMembershipListenerAdapterDUnitTest.class, "getDistributedMember");
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] ports[0]=" + ports[0]);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] serverMemberId=" + serverMemberId);
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] serverMember=" + serverMember);
        object = adapter;
        synchronized (object) {
            if (!firedAdapter[0]) {
                adapter.wait(120000L);
            }
        }
        object = bridgeListener;
        synchronized (object) {
            if (!firedBridge[0]) {
                bridgeListener.wait(120000L);
            }
        }
        UniversalMembershipListenerAdapterDUnitTest.getLogWriter().info("[testServerEventsInLonerClient] assert client detected server re-join");
        this.assertFalse(firedAdapterDuplicate);
        this.assertFalse(firedBridgeDuplicate);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdBridge[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientBridge[2]);
        this.resetArraysForTesting(firedBridge, memberBridge, memberIdBridge, isClientBridge);
        UniversalMembershipListenerAdapterDUnitTest.assertTrue((boolean)firedAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((Object)serverMember, (Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertEquals((String)serverMemberId, (String)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertNotNull((Object)memberIdAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[0]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[1]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)firedAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertNull((Object)memberIdAdapter[2]);
        UniversalMembershipListenerAdapterDUnitTest.assertFalse((boolean)isClientAdapter[2]);
        this.resetArraysForTesting(firedAdapter, memberAdapter, memberIdAdapter, isClientAdapter);
    }

    static final class TestDistributedMember
    implements DistributedMember {
        private final String host;

        public TestDistributedMember(String host) {
            this.host = host;
        }

        public String getName() {
            return "";
        }

        public String getHost() {
            return this.host;
        }

        public Set getRoles() {
            return new HashSet();
        }

        public int getProcessId() {
            return 0;
        }

        public String getId() {
            return this.host;
        }

        public int compareTo(DistributedMember o) {
            if (o == null || !(o instanceof TestDistributedMember)) {
                throw new InternalGemFireException("Invalidly comparing TestDistributedMember to " + o);
            }
            TestDistributedMember tds = (TestDistributedMember)o;
            return this.getHost().compareTo(tds.getHost());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TestDistributedMember)) {
                return false;
            }
            return this.compareTo((TestDistributedMember)obj) == 0;
        }

        public int hashCode() {
            return this.getHost().hashCode();
        }

        public DurableClientAttributes getDurableClientAttributes() {
            return null;
        }

        public List<String> getGroups() {
            return Collections.emptyList();
        }
    }
}

