/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessStreamReader;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import dunit.DistributedTestCase;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractLauncherDUnitTestCase
extends CacheTestCase {
    protected static final int TIMEOUT_MILLISECONDS = 300000;
    protected static final int INTERVAL_MILLISECONDS = 100;
    protected volatile transient ServerSocket socket;
    protected volatile transient File pidFile;
    protected volatile transient File stopRequestFile;
    protected volatile transient File statusRequestFile;
    protected volatile transient File statusFile;

    public AbstractLauncherDUnitTestCase(String name) {
        super(name);
    }

    @Override
    public final void setUp() throws Exception {
        super.setUp();
        AbstractLauncherDUnitTestCase.disconnectFromDS();
        System.setProperty("gemfire.mcast-port", Integer.toString(0));
        this.subSetUp();
    }

    @Override
    public final void tearDown2() throws Exception {
        System.clearProperty("gemfire.mcast-port");
        System.clearProperty("cache-xml-file");
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.delete(this.pidFile);
        this.pidFile = null;
        this.delete(this.stopRequestFile);
        this.stopRequestFile = null;
        this.delete(this.statusRequestFile);
        this.statusRequestFile = null;
        this.delete(this.statusFile);
        this.statusFile = null;
        this.subTearDown();
    }

    protected abstract void subSetUp() throws Exception;

    protected abstract void subTearDown() throws Exception;

    protected void delete(final File file) {
        AbstractLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                if (file == null) {
                    return true;
                }
                try {
                    FileUtil.delete((File)file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return !file.exists();
            }

            @Override
            public String description() {
                return "deleting " + file;
            }
        }, 10000L, 1000L, true);
    }

    protected boolean isPidAlive(int pid) {
        for (VirtualMachineDescriptor vm : VirtualMachine.list()) {
            if (!vm.id().equals(String.valueOf(pid))) continue;
            return true;
        }
        return false;
    }

    protected void waitForPidToStop(final int pid, boolean throwOnTimeout) {
        AbstractLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !AbstractLauncherDUnitTestCase.this.isPidAlive(pid);
            }

            @Override
            public String description() {
                return "waiting for pid " + pid + " to die";
            }
        }, 300000L, 100L, throwOnTimeout);
    }

    protected void waitForPidToStop(int pid) {
        this.waitForPidToStop(pid, true);
    }

    protected void waitForFileToDelete(final File file, boolean throwOnTimeout) {
        if (file == null) {
            return;
        }
        AbstractLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !file.exists();
            }

            @Override
            public String description() {
                return "waiting for file " + file + " to delete";
            }
        }, 300000L, 100L, throwOnTimeout);
    }

    protected void waitForFileToDelete(File file) {
        this.waitForFileToDelete(file, true);
    }

    protected static int getPid() throws PidUnavailableException {
        return ProcessUtils.identifyPid();
    }

    protected ProcessStreamReader.InputListener createLoggingListener(final String name, final String header) {
        return new ProcessStreamReader.InputListener(){

            public void notifyInputLine(String line) {
                DistributedTestCase.getLogWriter().info("[" + header + "]" + line);
            }

            public String toString() {
                return name;
            }
        };
    }

    protected ProcessStreamReader.InputListener createCollectionListener(final String name, String header, final List<String> lines) {
        return new ProcessStreamReader.InputListener(){

            public void notifyInputLine(String line) {
                lines.add(line);
            }

            public String toString() {
                return name;
            }
        };
    }

    protected ProcessStreamReader.InputListener createExpectedListener(final String name, String header, final String expected, final AtomicBoolean atomic) {
        return new ProcessStreamReader.InputListener(){

            public void notifyInputLine(String line) {
                if (line.contains(expected)) {
                    atomic.set(true);
                }
            }

            public String toString() {
                return name;
            }
        };
    }

    protected void writeGemfireProperties(Properties gemfireProperties, File gemfirePropertiesFile) throws IOException {
        if (!gemfirePropertiesFile.exists()) {
            gemfireProperties.store(new FileWriter(gemfirePropertiesFile), "Configuration settings for the GemFire Server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readPid(File pidFile) throws IOException {
        int n;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(pidFile));
            n = Integer.parseInt(StringUtils.trim((String)reader.readLine()));
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close((Closeable)reader);
        return n;
    }

    protected void writePid(File pidFile, int pid) throws IOException {
        FileWriter writer = new FileWriter(pidFile);
        writer.write(String.valueOf(pid));
        writer.write("\n");
        writer.flush();
        writer.close();
    }

    protected void waitForFileToExist(final File file, boolean throwOnTimeout) {
        AbstractLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return file.exists();
            }

            @Override
            public String description() {
                return "waiting for file to exist: " + file;
            }
        }, 300000L, 100L, throwOnTimeout);
    }

    protected void waitForFileToExist(File file) {
        this.waitForFileToExist(file, true);
    }
}

