/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.AbstractLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.LocatorLauncher;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import java.io.IOException;

public abstract class AbstractLocatorLauncherDUnitTestCase
extends AbstractLauncherDUnitTestCase {
    protected volatile transient int locatorPort;
    protected volatile transient LocatorLauncher launcher;

    public AbstractLocatorLauncherDUnitTestCase(String name) {
        super(name);
    }

    @Override
    public final void subSetUp() throws Exception {
        final int port = AvailablePortHelper.getRandomAvailableTCPPort();
        AbstractLocatorLauncherDUnitTestCase.overrideDefaultPort(port);
        AbstractLocatorLauncherDUnitTestCase.invokeInEveryVM(new SerializableRunnable("overrideDefaultPort"){

            @Override
            public void run() {
                AbstractLocatorLauncherDUnitTestCase.overrideDefaultPort(port);
            }
        });
        this.locatorPort = port;
        this.subSetUp1();
    }

    @Override
    public final void subTearDown() throws Exception {
        this.cleanupLocatorLauncher();
        this.locatorPort = 0;
        AbstractLocatorLauncherDUnitTestCase.restoreDefaultPort();
        AbstractLocatorLauncherDUnitTestCase.invokeInEveryVM(new SerializableRunnable("restoreDefaultPort"){

            @Override
            public void run() {
                AbstractLocatorLauncherDUnitTestCase.restoreDefaultPort();
            }
        });
        this.subTearDown1();
    }

    protected abstract void subSetUp1() throws Exception;

    protected abstract void subTearDown1() throws Exception;

    protected void cleanupLocatorLauncher() {
        try {
            if (this.launcher != null) {
                this.launcher.stop();
                this.launcher = null;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void waitForLocatorToStart(final LocatorLauncher launcher, long timeout, long interval, boolean throwOnTimeout) {
        AbstractLocatorLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    LocatorLauncher.LocatorState LocatorState2 = launcher.status();
                    return LocatorState2 != null && AbstractLauncher.Status.ONLINE.equals((Object)LocatorState2.getStatus());
                }
                catch (RuntimeException e) {
                    return false;
                }
            }

            @Override
            public String description() {
                return "waiting for local  to start: " + launcher.status();
            }
        }, timeout, interval, throwOnTimeout);
    }

    protected void waitForLocatorToStart(LocatorLauncher launcher, long timeout, boolean throwOnTimeout) {
        this.waitForLocatorToStart(launcher, timeout, 100L, throwOnTimeout);
    }

    protected void waitForLocatorToStart(LocatorLauncher launcher, boolean throwOnTimeout) {
        this.waitForLocatorToStart(launcher, 300000L, 100L, throwOnTimeout);
    }

    protected void waitForLocatorToStart(LocatorLauncher launcher) {
        this.waitForLocatorToStart(launcher, 300000L, 100L, true);
    }

    protected static void waitForLocatorToStart(int port, long timeout, long interval, boolean throwOnTimeout) throws IOException {
        final LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setPort(Integer.valueOf(port)).build();
        AbstractLocatorLauncherDUnitTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    LocatorLauncher.LocatorState locatorState = locatorLauncher.status();
                    return locatorState != null && AbstractLauncher.Status.ONLINE.equals((Object)locatorState.getStatus());
                }
                catch (RuntimeException e) {
                    return false;
                }
            }

            @Override
            public String description() {
                return "Waiting for Locator in other process to start.";
            }
        }, timeout, interval, throwOnTimeout);
    }

    protected static void overrideDefaultPort(int port) {
        System.setProperty("gemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT", String.valueOf(port));
    }

    protected static void restoreDefaultPort() {
        System.clearProperty("gemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT");
    }
}

