/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.internal.Assert;
import hydra.blackboard.Blackboard;

public class DistributedLockBlackboard
extends Blackboard {
    public static int Count;
    public static int IsLocked;
    public static DistributedLockBlackboard blackboard;

    public DistributedLockBlackboard() {
    }

    public DistributedLockBlackboard(String name, String type) {
        super(name, type, DistributedLockBlackboard.class);
    }

    public static DistributedLockBlackboard getInstance() {
        if (blackboard == null) {
            DistributedLockBlackboard.initialize();
        }
        return blackboard;
    }

    private static synchronized void initialize() {
        if (blackboard == null) {
            blackboard = new DistributedLockBlackboard("DistributedLockBlackboard", "rmi");
        }
    }

    public void initCount() {
        this.getSharedCounters().zero(Count);
    }

    public void incCount() {
        this.getSharedCounters().increment(Count);
    }

    public long getCount() {
        return this.getSharedCounters().read(Count);
    }

    public void setIsLocked(boolean isLocked) {
        if (isLocked) {
            this.getSharedCounters().setIfLarger(IsLocked, 1L);
        } else {
            this.getSharedCounters().setIfSmaller(IsLocked, 0L);
        }
    }

    public boolean getIsLocked() {
        long isLocked = this.getSharedCounters().read(IsLocked);
        Assert.assertTrue((isLocked == 0L || isLocked == 1L ? 1 : 0) != 0, (Object)("DistributedLockBlackboard internal error - IsLocked is " + isLocked));
        return isLocked == 1L;
    }

    public static void printBlackboard() {
        DistributedLockBlackboard.getInstance().print();
    }
}

