/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedLockBlackboard;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.LeaseExpiredException;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.locks.DLockGrantor;
import com.gemstone.gemfire.distributed.internal.locks.DLockRemoteToken;
import com.gemstone.gemfire.distributed.internal.locks.DLockRequestProcessor;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.DLockToken;
import com.gemstone.gemfire.distributed.internal.locks.RemoteThread;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.concurrent.AB;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import com.gemstone.gemfire.internal.util.StopWatch;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.ClientMgr;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class DistributedLockServiceTest
extends DistributedTestCase {
    protected static DistributedSystem dlstSystem;
    private static DistributedLockBlackboard blackboard;
    protected static Object monitor;
    private int hits = 0;
    private int completes = 0;
    private boolean done;
    private boolean got;
    protected static DistributedLockService dls_testFairness;
    protected static int[] count_testFairness;
    protected static volatile boolean stop_testFairness;
    protected static volatile boolean[] done_testFairness;
    private InternalDistributedMember lockGrantor;
    volatile boolean started = false;
    volatile boolean gotLock = false;
    volatile Throwable exception = null;
    volatile Throwable throwable = null;
    volatile boolean wasFlagSet = false;
    protected static BasicLockClient suspendClientSuspendLockingBehaves;
    protected static BasicLockClient lockClientSuspendLockingBehaves;
    volatile boolean startedThread1_testReleaseOrphanedGrant;
    volatile boolean releaseThread1_testReleaseOrphanedGrant;
    volatile boolean startedThread2_testReleaseOrphanedGrant;
    volatile boolean gotLockThread2_testReleaseOrphanedGrant;
    static volatile Thread threadVM1_testReleaseOrphanedGrant_Remote;
    static volatile Thread threadVM2_testReleaseOrphanedGrant_Remote;
    static volatile boolean startedThreadVM1_testReleaseOrphanedGrant_Remote;
    static volatile boolean releaseThreadVM1_testReleaseOrphanedGrant_Remote;
    static volatile boolean unlockedThreadVM1_testReleaseOrphanedGrant_Remote;
    static volatile boolean startedThreadVM2_testReleaseOrphanedGrant_Remote;
    static volatile boolean gotLockThreadVM2_testReleaseOrphanedGrant_Remote;
    static final AB testLockQuery_whileVM1Locks;

    public DistributedLockServiceTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        DistributedLockServiceTest.disconnectAllFromDS();
    }

    public static void caseTearDown() throws Exception {
        DistributedLockServiceTest.disconnectAllFromDS();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributedLockServiceTest.connectDistributedSystem();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                host.getVM(v).invoke(DistributedLockServiceTest.class, "connectDistributedSystem", null);
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        DistributedLockServiceTest.invokeInEveryVM(DistributedLockServiceTest.class, "destroyAllDLockServices");
        this.lockGrantor = null;
        super.tearDown2();
    }

    public static void destroyAllDLockServices() {
        DLockService.destroyAll();
        dlstSystem = null;
    }

    public static void remoteDumpAllDLockServices() {
        DLockService.dumpAllServices((LogWriterI18n)DistributedLockServiceTest.getLogWriter().convertToLogWriterI18n());
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = super.getDistributedSystemProperties();
        return props;
    }

    protected static void connectDistributedSystem() {
        dlstSystem = new DistributedLockServiceTest("dummy").getSystem();
    }

    public void testBasic() {
        String serviceName = this.getUniqueName();
        String objectName = "object";
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertFalse((boolean)service.isHeldByCurrentThread((Object)objectName));
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objectName, 3000L, -1L));
        DistributedLockServiceTest.assertTrue((boolean)service.isHeldByCurrentThread((Object)objectName));
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objectName, 3000L, -1L));
        DistributedLockServiceTest.assertTrue((boolean)service.isHeldByCurrentThread((Object)objectName));
        service.unlock((Object)objectName);
        DistributedLockServiceTest.assertTrue((boolean)service.isHeldByCurrentThread((Object)objectName));
        service.unlock((Object)objectName);
        DistributedLockServiceTest.assertFalse((boolean)service.isHeldByCurrentThread((Object)objectName));
        DistributedLockService.destroy((String)serviceName);
    }

    public void testCreateDestroy() throws Exception {
        final String serviceName = this.getUniqueName();
        String abc = "abc";
        DistributedLockServiceTest.assertNull((Object)DistributedLockService.getServiceNamed((String)serviceName));
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)this.getSystem());
        DistributedLockServiceTest.assertSame((Object)service, (Object)DistributedLockService.getServiceNamed((String)serviceName));
        DistributedLockService.destroy((String)serviceName);
        try {
            service.lock((Object)"abc", -1L, -1L);
            DistributedLockServiceTest.fail((String)"didn't get LockServiceDestroyedException");
        }
        catch (LockServiceDestroyedException lockServiceDestroyedException) {
            // empty catch block
        }
        service = DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertNull((String)("" + service), (Object)service);
        service = DistributedLockService.create((String)serviceName, (DistributedSystem)this.getSystem());
        DistributedLockServiceTest.assertTrue((!((DLockService)service).isDestroyed() ? 1 : 0) != 0);
        ((DLockService)service).checkDestroyed();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DistributedLockService dls = DistributedLockService.getServiceNamed((String)serviceName);
                TestCase.assertTrue((!((DLockService)dls).isDestroyed() ? 1 : 0) != 0);
                ((DLockService)dls).checkDestroyed();
                dls.lock((Object)"abc", -1L, -1L);
            }
        });
        thread.start();
        DistributedTestCase.join(thread, 30000L, DistributedLockServiceTest.getLogWriter());
        AsyncInvocation remoteWaitingThread = Host.getHost(0).getVM(0).invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockService dls = DistributedLockService.create((String)serviceName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                try {
                    dls.lock((Object)"abc", -1L, -1L);
                    TestCase.fail((String)"remoteWaitingThread got lock after dls destroyed");
                }
                catch (LockServiceDestroyedException expected) {
                    return;
                }
                TestCase.fail((String)"remoteWaitingThread lock failed to throw LockServiceDestroyedException");
            }
        });
        int retry = 10;
        for (int i = 0; i < retry; ++i) {
            try {
                Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

                    @Override
                    public void run() {
                        DistributedLockService.destroy((String)serviceName);
                    }
                });
                break;
            }
            catch (RMIException e) {
                if (i >= retry || !(e.getCause() instanceof IllegalArgumentException)) {
                    throw e;
                }
                DistributedLockServiceTest.sleep(1000L);
                continue;
            }
        }
        DistributedLockService.destroy((String)serviceName);
        DistributedTestCase.join(remoteWaitingThread, 10000L, DistributedLockServiceTest.getLogWriter());
        if (remoteWaitingThread.exceptionOccurred()) {
            Throwable e = remoteWaitingThread.getException();
            DistributedLockServiceTest.fail(e.getMessage(), e);
        }
        try {
            service.lock((Object)"abc", -1L, -1L);
            DistributedLockServiceTest.fail((String)"didn't get LockServiceDestroyedException");
        }
        catch (LockServiceDestroyedException lockServiceDestroyedException) {
            // empty catch block
        }
        service = DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertNull((String)("" + service), (Object)service);
    }

    public void testFairness() throws Exception {
        int vm;
        int i;
        final String serviceName = "testFairness_" + this.getUniqueName();
        final String lock = "lock";
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)lock, -1L, -1L));
        int[] vmThreads = new int[]{1, 4, 8, 16};
        this.forNumVMsInvoke(vmThreads.length, "remoteCreateService", new Object[]{serviceName});
        DistributedLockServiceTest.sleep(100L);
        for (i = 0; i < vmThreads.length; ++i) {
            vm = i;
            DistributedLockServiceTest.getLogWriter().info("[testFairness] lining up " + vmThreads[vm] + " threads in vm " + vm);
            int j = 0;
            while (j < vmThreads[vm]) {
                final int thread = j++;
                Host.getHost(0).getVM(vm).invokeAsync(new SerializableRunnable(){

                    @Override
                    public void run() {
                        try {
                            DistributedLockServiceTest.done_testFairness[thread] = false;
                            dls_testFairness = DistributedLockService.getServiceNamed((String)serviceName);
                            while (!stop_testFairness) {
                                TestCase.assertTrue((boolean)dls_testFairness.lock(lock, -1L, -1L));
                                int n = thread;
                                count_testFairness[n] = count_testFairness[n] + 1;
                                dls_testFairness.unlock(lock);
                            }
                            DistributedLockServiceTest.done_testFairness[thread] = true;
                        }
                        catch (VirtualMachineError e) {
                            SystemFailure.initiateFailure((Error)e);
                            throw e;
                        }
                        catch (Throwable t) {
                            DistributedTestCase.getLogWriter().warning(t);
                            TestCase.fail((String)t.getMessage());
                        }
                    }
                });
            }
        }
        DistributedLockServiceTest.sleep(500L);
        service.unlock((Object)lock);
        DistributedLockServiceTest.sleep(5000L);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)lock, -1L, -1L));
        i = 0;
        while (i < vmThreads.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    stop_testFairness = true;
                }
            });
        }
        service.unlock((Object)lock);
        i = 0;
        while (i < vmThreads.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    try {
                        boolean testIsDone = false;
                        while (!stop_testFairness || !testIsDone) {
                            testIsDone = true;
                            for (int i2 = 0; i2 < done_testFairness.length; ++i2) {
                                if (done_testFairness[i2]) continue;
                                testIsDone = false;
                            }
                        }
                        DistributedLockService.destroy((String)serviceName);
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Throwable t) {
                        TestCase.fail((String)t.getMessage());
                    }
                }
            });
        }
        int totalLocks = 0;
        int minLocks = Integer.MAX_VALUE;
        int maxLocks = 0;
        int numThreads = 0;
        for (int i2 = 0; i2 < vmThreads.length; ++i2) {
            int vm2 = i2;
            for (int j = 0; j < vmThreads[vm2]; ++j) {
                int thread = j;
                Integer count = (Integer)Host.getHost(0).getVM(vm2).invoke(DistributedLockServiceTest.class, "get_count_testFairness", new Object[]{new Integer(thread)});
                int numLocks = count;
                if (numLocks < minLocks) {
                    minLocks = numLocks;
                }
                if (numLocks > maxLocks) {
                    maxLocks = numLocks;
                }
                totalLocks += numLocks;
                ++numThreads;
            }
        }
        DistributedLockServiceTest.getLogWriter().info("[testFairness] totalLocks=" + totalLocks + " minLocks=" + minLocks + " maxLocks=" + maxLocks);
        int expectedLocks = totalLocks / numThreads + 1;
        int deviation = (int)((double)expectedLocks * 0.3);
        int lowThreshold = expectedLocks - deviation;
        int highThreshold = expectedLocks + deviation;
        DistributedLockServiceTest.getLogWriter().info("[testFairness] deviation=" + deviation + " expectedLocks=" + expectedLocks + " lowThreshold=" + lowThreshold + " highThreshold=" + highThreshold);
        DistributedLockServiceTest.assertTrue((String)"minLocks is less than lowThreshold", (minLocks >= lowThreshold ? 1 : 0) != 0);
        DistributedLockServiceTest.assertTrue((String)"maxLocks is greater than highThreshold", (maxLocks <= highThreshold ? 1 : 0) != 0);
    }

    public static Integer get_count_testFairness(Integer i) {
        return new Integer(count_testFairness[i]);
    }

    public void testOneGetsAndOthersTimeOut() {
        this.doOneGetsAndOthersTimeOut(1, 1);
        this.doOneGetsAndOthersTimeOut(4, 3);
    }

    private synchronized void assertGrantorIsConsistent(InternalDistributedMember id) {
        if (this.lockGrantor == null) {
            this.lockGrantor = id;
        } else {
            DistributedLockServiceTest.assertEquals((String)"assertGrantorIsConsistent failed", (Object)this.lockGrantor, (Object)id);
        }
    }

    public static InternalDistributedMember identifyLockGrantor(String serviceName) {
        DLockService service = (DLockService)DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertNotNull((Object)service);
        InternalDistributedMember grantor = service.getLockGrantorId().getLockGrantorMember();
        DistributedLockServiceTest.assertNotNull((Object)grantor);
        DistributedLockServiceTest.logInfo("In identifyLockGrantor - grantor is " + grantor);
        return grantor;
    }

    public static Boolean isLockGrantor(String serviceName) {
        DLockService service = (DLockService)DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertNotNull((Object)service);
        Boolean result = service.isLockGrantor();
        DistributedLockServiceTest.logInfo("In isLockGrantor: " + result);
        return result;
    }

    protected static void becomeLockGrantor(String serviceName) {
        DLockService service = (DLockService)DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertNotNull((Object)service);
        DistributedLockServiceTest.logInfo("About to call becomeLockGrantor...");
        service.becomeLockGrantor();
    }

    public void testGrantorSelection() {
        int numVMs = 4;
        String serviceName = "testGrantorSelection_" + this.getUniqueName();
        this.distributedCreateService(numVMs, serviceName);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ignore) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
        Object[] args = new Object[]{serviceName};
        Host host = Host.getHost(0);
        int vm = 0;
        while (vm < numVMs) {
            int finalvm = vm++;
            DistributedLockServiceTest.logInfo("VM " + finalvm + " in " + serviceName + " about to invoke");
            InternalDistributedMember id = (InternalDistributedMember)host.getVM(finalvm).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", args);
            DistributedLockServiceTest.logInfo("VM " + finalvm + " in " + serviceName + " got " + id);
            this.assertGrantorIsConsistent(id);
        }
    }

    public void testBasicGrantorRecovery() {
        int numVMs = 4;
        String serviceName = "testBasicGrantorRecovery_" + this.getUniqueName();
        this.distributedCreateService(numVMs, serviceName);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ignore) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
        Object[] args = new Object[]{serviceName};
        Host host = Host.getHost(0);
        int originalGrantor = 3;
        host.getVM(originalGrantor).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", args);
        int originalVM = -1;
        InternalDistributedMember oldGrantor = null;
        int vm = 0;
        while (vm < numVMs) {
            int finalvm;
            Boolean isGrantor;
            if (!(isGrantor = (Boolean)host.getVM(finalvm = vm++).invoke(DistributedLockServiceTest.class, "isLockGrantor", args)).booleanValue()) continue;
            originalVM = vm;
            oldGrantor = (InternalDistributedMember)host.getVM(finalvm).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", args);
            break;
        }
        DistributedLockServiceTest.assertTrue((originalVM == originalGrantor ? 1 : 0) != 0);
        host.getVM(originalVM).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.disconnectFromDS();
            }
        });
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ignore) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
        int attempts = 3;
        for (int attempt = 0; attempt < attempts; ++attempt) {
            try {
                for (int vm2 = 0; vm2 < numVMs; ++vm2) {
                    if (vm2 == originalVM) continue;
                    int finalvm = vm2;
                    DistributedLockServiceTest.logInfo("[testBasicGrantorRecovery] VM " + finalvm + " in " + serviceName + " about to invoke");
                    InternalDistributedMember id = (InternalDistributedMember)host.getVM(finalvm).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", args);
                    DistributedLockServiceTest.logInfo("[testBasicGrantorRecovery] VM " + finalvm + " in " + serviceName + " got " + id);
                    this.assertGrantorIsConsistent(id);
                    DistributedLockServiceTest.logInfo("[testBasicGrantorRecovery] new grantor " + id + " is not old grantor " + oldGrantor);
                    DistributedLockServiceTest.assertEquals((String)"New grantor must not equal the old grantor", (boolean)true, (!id.equals(oldGrantor) ? 1 : 0) != 0);
                }
                DistributedLockServiceTest.logInfo("[testBasicGrantorRecovery] succeeded attempt " + attempt);
                break;
            }
            catch (AssertionFailedError e) {
                DistributedLockServiceTest.logInfo("[testBasicGrantorRecovery] failed attempt " + attempt);
                if (attempt != attempts - 1) continue;
                throw e;
            }
        }
    }

    public void testLockFailover() {
        boolean originalGrantorVM = false;
        boolean oneVM = true;
        int twoVM = 2;
        String serviceName = "testLockFailover-" + this.getUniqueName();
        DistributedLockServiceTest.getLogWriter().fine("[testLockFailover] create services");
        Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "remoteCreateService", new Object[]{serviceName});
        Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "remoteCreateService", new Object[]{serviceName});
        Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "remoteCreateService", new Object[]{serviceName});
        Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", new Object[]{serviceName});
        Boolean isGrantor = (Boolean)Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "isLockGrantor", new Object[]{serviceName});
        DistributedLockServiceTest.assertEquals((String)"First member calling getLockGrantor failed to become grantor", (Object)Boolean.TRUE, (Object)isGrantor);
        DistributedLockServiceTest.getLogWriter().fine("[testLockFailover] get lock");
        Boolean locked = (Boolean)Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-0"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockFailover", (Object)Boolean.TRUE, (Object)locked);
        locked = (Boolean)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-2"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockFailover", (Object)Boolean.TRUE, (Object)locked);
        locked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockFailover", (Object)Boolean.TRUE, (Object)locked);
        DistributedLockServiceTest.getLogWriter().fine("[testLockFailover] disconnect originalGrantorVM");
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.disconnectFromDS();
            }
        });
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ignore) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
        DistributedLockServiceTest.getLogWriter().fine("[testLockFailover] release locks");
        Boolean unlocked = (Boolean)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-2"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockFailover", (Object)Boolean.TRUE, (Object)unlocked);
        unlocked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockFailover", (Object)Boolean.TRUE, (Object)unlocked);
        locked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-2"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockFailover", (Object)Boolean.TRUE, (Object)locked);
        locked = (Boolean)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockFailover", (Object)Boolean.TRUE, (Object)locked);
        unlocked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-2"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockFailover", (Object)Boolean.TRUE, (Object)unlocked);
        unlocked = (Boolean)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockFailover", (Object)Boolean.TRUE, (Object)unlocked);
        DistributedLockServiceTest.getLogWriter().fine("[testLockFailover] verify grantor identity");
        InternalDistributedMember oneID = (InternalDistributedMember)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", new Object[]{serviceName});
        InternalDistributedMember twoID = (InternalDistributedMember)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", new Object[]{serviceName});
        DistributedLockServiceTest.assertTrue((String)"Failed to identifyLockGrantor in testLockFailover", (oneID != null && twoID != null ? 1 : 0) != 0);
        DistributedLockServiceTest.assertEquals((String)"Failed grantor uniqueness in testLockFailover", (Object)oneID, (Object)twoID);
    }

    public void testLockThenBecomeLockGrantor() {
        boolean originalGrantorVM = false;
        boolean becomeGrantorVM = true;
        int thirdPartyVM = 2;
        String serviceName = "testLockThenBecomeLockGrantor-" + this.getUniqueName();
        DistributedLockServiceTest.getLogWriter().fine("[testLockThenBecomeLockGrantor] create services");
        Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "remoteCreateService", new Object[]{serviceName});
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException ignore) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
        Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "remoteCreateService", new Object[]{serviceName});
        Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "remoteCreateService", new Object[]{serviceName});
        Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", new Object[]{serviceName});
        Boolean isGrantor = (Boolean)Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "isLockGrantor", new Object[]{serviceName});
        DistributedLockServiceTest.assertEquals((String)"First member calling getLockGrantor failed to become grantor", (Object)Boolean.TRUE, (Object)isGrantor);
        DistributedLockServiceTest.getLogWriter().fine("[testLockThenBecomeLockGrantor] check control");
        Boolean check = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Check of control failed... unlock succeeded but nothing locked", (Object)Boolean.FALSE, (Object)check);
        DistributedLockServiceTest.getLogWriter().fine("[testLockThenBecomeLockGrantor] get lock");
        Boolean locked = (Boolean)Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-0"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockThenBecomeLockGrantor", (Object)Boolean.TRUE, (Object)locked);
        locked = (Boolean)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-2"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockThenBecomeLockGrantor", (Object)Boolean.TRUE, (Object)locked);
        locked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testLockThenBecomeLockGrantor", (Object)Boolean.TRUE, (Object)locked);
        DistributedLockServiceTest.getLogWriter().fine("[testLockThenBecomeLockGrantor] become lock grantor");
        Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "becomeLockGrantor", new Object[]{serviceName});
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException ignore) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
        isGrantor = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "isLockGrantor", new Object[]{serviceName});
        DistributedLockServiceTest.assertEquals((String)"Failed to become lock grantor", (Object)Boolean.TRUE, (Object)isGrantor);
        DistributedLockServiceTest.getLogWriter().fine("[testLockThenBecomeLockGrantor] release locks");
        Boolean unlocked = (Boolean)Host.getHost(0).getVM(0).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-0"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockThenBecomeLockGrantor", (Object)Boolean.TRUE, (Object)unlocked);
        unlocked = (Boolean)Host.getHost(0).getVM(2).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-2"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockThenBecomeLockGrantor", (Object)Boolean.TRUE, (Object)unlocked);
        unlocked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Failed to release lock in testLockThenBecomeLockGrantor", (Object)Boolean.TRUE, (Object)unlocked);
        unlocked = (Boolean)Host.getHost(0).getVM(1).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY-1"});
        DistributedLockServiceTest.assertEquals((String)"Transfer of tokens caused lock recursion in held lock", (Object)Boolean.FALSE, (Object)unlocked);
    }

    public void testBecomeLockGrantor() {
        Boolean isGrantor;
        int finalvm;
        int numVMs = 4;
        String serviceName = "testBecomeLockGrantor-" + this.getUniqueName();
        this.distributedCreateService(numVMs, serviceName);
        for (int vm = 0; vm < numVMs; ++vm) {
            int finalvm2 = vm;
            Boolean locked = (Boolean)Host.getHost(0).getVM(finalvm2).invoke(DistributedLockServiceTest.class, "lock", new Object[]{serviceName, "obj-" + vm});
            DistributedLockServiceTest.assertEquals((String)"Failed to get lock in testBecomeLockGrantor", (Object)Boolean.TRUE, (Object)locked);
        }
        Object[] args = new Object[]{serviceName};
        int originalVM = -1;
        InternalDistributedMember oldGrantor = null;
        int vm = 0;
        while (vm < numVMs) {
            finalvm = vm++;
            isGrantor = (Boolean)Host.getHost(0).getVM(finalvm).invoke(DistributedLockServiceTest.class, "isLockGrantor", args);
            if (!isGrantor.booleanValue()) continue;
            originalVM = vm;
            oldGrantor = (InternalDistributedMember)Host.getHost(0).getVM(finalvm).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", args);
            break;
        }
        DistributedLockServiceTest.getLogWriter().fine("[testBecomeLockGrantor] original grantor is " + oldGrantor);
        for (vm = 0; vm < numVMs; ++vm) {
            if (vm == originalVM) continue;
            finalvm = vm;
            Host.getHost(0).getVM(finalvm).invoke(DistributedLockServiceTest.class, "becomeLockGrantor", args);
            isGrantor = (Boolean)Host.getHost(0).getVM(finalvm).invoke(DistributedLockServiceTest.class, "isLockGrantor", args);
            DistributedLockServiceTest.assertEquals((String)"isLockGrantor is false after calling becomeLockGrantor", (Object)Boolean.TRUE, (Object)isGrantor);
            break;
        }
        DistributedLockServiceTest.getLogWriter().fine("[testBecomeLockGrantor] one vm has called becomeLockGrantor...");
        InternalDistributedMember newGrantor = null;
        int vm2 = 0;
        while (vm2 < numVMs) {
            int finalvm3 = vm2++;
            Boolean isGrantor2 = (Boolean)Host.getHost(0).getVM(finalvm3).invoke(DistributedLockServiceTest.class, "isLockGrantor", args);
            if (!isGrantor2.booleanValue()) continue;
            newGrantor = (InternalDistributedMember)Host.getHost(0).getVM(finalvm3).invoke(DistributedLockServiceTest.class, "identifyLockGrantor", args);
            break;
        }
        DistributedLockServiceTest.getLogWriter().fine("[testBecomeLockGrantor] new Grantor is " + newGrantor);
        DistributedLockServiceTest.assertEquals((boolean)false, (boolean)newGrantor.equals(oldGrantor));
        for (vm2 = 0; vm2 < numVMs; ++vm2) {
            int finalvm4 = vm2;
            Boolean unlocked = (Boolean)Host.getHost(0).getVM(finalvm4).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "obj-" + vm2});
            DistributedLockServiceTest.assertEquals((String)"Failed to unlock in testBecomeLockGrantor", (Object)Boolean.TRUE, (Object)unlocked);
        }
        DistributedLockServiceTest.getLogWriter().fine("[testBecomeLockGrantor] finished");
    }

    public void testTryLock() {
        Long waitMillis = new Long(100L);
        DistributedLockServiceTest.getLogWriter().fine("[testTryLock] create lock services");
        String serviceName = "testTryLock-" + this.getUniqueName();
        this.distributedCreateService(4, serviceName);
        DistributedLockServiceTest.getLogWriter().fine("[testTryLock] attempt to get tryLock");
        int lockCount = 0;
        for (int vm = 0; vm < 4; ++vm) {
            int finalvm = vm;
            Boolean locked = (Boolean)Host.getHost(0).getVM(finalvm).invoke(DistributedLockServiceTest.class, "tryLock", new Object[]{serviceName, "KEY", waitMillis});
            if (!locked.booleanValue()) continue;
            ++lockCount;
        }
        DistributedLockServiceTest.assertEquals((String)"More than one vm acquired the tryLock", (int)1, (int)lockCount);
        DistributedLockServiceTest.getLogWriter().fine("[testTryLock] unlock tryLock");
        int unlockCount = 0;
        for (int vm = 0; vm < 4; ++vm) {
            int finalvm = vm;
            Boolean unlocked = (Boolean)Host.getHost(0).getVM(finalvm).invoke(DistributedLockServiceTest.class, "unlock", new Object[]{serviceName, "KEY"});
            if (!unlocked.booleanValue()) continue;
            ++unlockCount;
        }
        DistributedLockServiceTest.assertEquals((String)"More than one vm unlocked the tryLock", (int)1, (int)unlockCount);
    }

    public void testOneGetsThenOtherGets() {
        this.doOneGetsThenOtherGets(1, 1);
        this.doOneGetsThenOtherGets(4, 3);
    }

    public void testLockDifferentNames() {
        String serviceName = this.getUniqueName();
        DistributedLockServiceTest.remoteCreateService(serviceName);
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj1", -1L, -1L));
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj2", -1L, -1L));
        service.unlock((Object)"obj1");
        service.unlock((Object)"obj2");
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(this.getClass(), "remoteCreateService", new Object[]{serviceName});
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"masterVMobj", -1L, -1L));
        DistributedLockServiceTest.assertEquals((Object)Boolean.TRUE, (Object)vm.invoke(this.getClass(), "getLockAndIncrement", new Object[]{serviceName, "otherVMobj", new Long(-1L), new Long(0L)}));
        service.unlock((Object)"masterVMobj");
    }

    public void testLocalGetLockAndIncrement() {
        String serviceName = this.getUniqueName();
        DistributedLockServiceTest.remoteCreateService(serviceName);
        DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertEquals((Object)Boolean.TRUE, (Object)DistributedLockServiceTest.getLockAndIncrement(serviceName, "localVMobj", -1L, 0L));
    }

    public void testRemoteGetLockAndIncrement() {
        String serviceName = this.getUniqueName();
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(this.getClass(), "remoteCreateService", new Object[]{serviceName});
        DistributedLockServiceTest.assertEquals((Object)Boolean.TRUE, (Object)vm.invoke(this.getClass(), "getLockAndIncrement", new Object[]{serviceName, "remoteVMobj", new Long(-1L), new Long(0L)}));
    }

    public void testLockSameNameDifferentService() {
        String serviceName1 = this.getUniqueName() + "_1";
        String serviceName2 = this.getUniqueName() + "_2";
        String objName = "obj";
        DistributedLockServiceTest.remoteCreateService(serviceName1);
        DistributedLockServiceTest.remoteCreateService(serviceName2);
        DistributedLockService service1 = DistributedLockService.getServiceNamed((String)serviceName1);
        DistributedLockService service2 = DistributedLockService.getServiceNamed((String)serviceName2);
        DistributedLockServiceTest.assertTrue((boolean)service1.lock((Object)objName, -1L, -1L));
        DistributedLockServiceTest.assertTrue((boolean)service2.lock((Object)objName, -1L, -1L));
        service1.unlock((Object)objName);
        service2.unlock((Object)objName);
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(this.getClass(), "remoteCreateService", new Object[]{serviceName1});
        vm.invoke(this.getClass(), "remoteCreateService", new Object[]{serviceName2});
        DistributedLockServiceTest.assertTrue((boolean)service1.lock((Object)objName, -1L, -1L));
        DistributedLockServiceTest.assertEquals((Object)Boolean.TRUE, (Object)vm.invoke(this.getClass(), "getLockAndIncrement", new Object[]{serviceName2, objName, new Long(-1L), new Long(0L)}));
        service1.unlock((Object)objName);
    }

    public void testLeaseDoesntExpire() throws InterruptedException {
        String serviceName = this.getUniqueName();
        final Integer objName = new Integer(3);
        DistributedLockServiceTest.remoteCreateService(serviceName);
        final DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objName, -1L, 60000L));
        final boolean[] resultHolder = new boolean[]{false};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                resultHolder[0] = !service.lock(objName, 1000L, -1L);
            }
        });
        thread.start();
        DistributedTestCase.join(thread, 30000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.assertTrue((boolean)resultHolder[0]);
        service.unlock((Object)objName);
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(this.getClass(), "remoteCreateService", new Object[]{serviceName});
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objName, -1L, 60000L));
        DistributedLockServiceTest.assertEquals((Object)Boolean.FALSE, (Object)vm.invoke(this.getClass(), "getLockAndIncrement", new Object[]{serviceName, objName, new Long(1000L), new Long(0L)}));
        service.unlock((Object)objName);
    }

    public void testLockUnlock() {
        String serviceName = this.getUniqueName();
        Integer objName = new Integer(42);
        DistributedLockServiceTest.remoteCreateService(serviceName);
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        service.lock((Object)objName, -1L, -1L);
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        service.unlock((Object)objName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
    }

    public void testLockExpireUnlock() {
        long leaseMs = 200L;
        long waitBeforeLockingMs = 210L;
        String serviceName = this.getUniqueName();
        Integer objName = new Integer(42);
        DistributedLockServiceTest.remoteCreateService(serviceName);
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        DistributedLockServiceTest.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        DistributedLockServiceTest.sleep(waitBeforeLockingMs);
        DistributedLockServiceTest.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        try {
            service.unlock((Object)objName);
            DistributedLockServiceTest.fail((String)"unlock should have thrown LeaseExpiredException");
        }
        catch (LeaseExpiredException leaseExpiredException) {
            // empty catch block
        }
    }

    public void testLockRecursion() {
        String serviceName = this.getUniqueName();
        Integer objName = new Integer(42);
        DistributedLockServiceTest.remoteCreateService(serviceName);
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, -1L));
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, -1L));
        service.unlock((Object)objName);
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        service.unlock((Object)objName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
    }

    public void testLockRecursionWithExpiration() {
        long leaseMs = 500L;
        long waitBeforeLockingMs = 750L;
        String serviceName = this.getUniqueName();
        Integer objName = new Integer(42);
        DistributedLockServiceTest.remoteCreateService(serviceName);
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        DistributedLockServiceTest.sleep(waitBeforeLockingMs);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        try {
            service.unlock((Object)objName);
            DistributedLockServiceTest.fail((String)"unlock should have thrown LeaseExpiredException");
        }
        catch (LeaseExpiredException leaseExpiredException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        service.unlock((Object)objName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        DistributedLockServiceTest.sleep(waitBeforeLockingMs);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        Assert.assertTrue((boolean)service.isHeldByCurrentThread((Object)objName));
        service.unlock((Object)objName);
        Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
    }

    public void testLeaseExpiresBeforeOtherLocks() throws InterruptedException {
        this.leaseExpiresTest(false);
    }

    public void testLeaseExpiresWhileOtherLocks() throws InterruptedException {
        this.leaseExpiresTest(true);
    }

    private void leaseExpiresTest(boolean tryToLockBeforeExpiration) throws InterruptedException {
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] prepping");
        long leaseMs = 100L;
        long waitBeforeLockingMs = tryToLockBeforeExpiration ? 50L : 110L;
        String serviceName = this.getUniqueName();
        final Integer objName = new Integer(3);
        DistributedLockServiceTest.remoteCreateService(serviceName);
        final DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] acquire first lock");
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        DistributedLockServiceTest.sleep(waitBeforeLockingMs);
        if (waitBeforeLockingMs > leaseMs) {
            Assert.assertTrue((!service.isHeldByCurrentThread((Object)objName) ? 1 : 0) != 0);
        }
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] acquire lock that expired");
        final boolean[] resultHolder = new boolean[]{false};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                resultHolder[0] = service.lock(objName, -1L, -1L);
                service.unlock(objName);
                Assert.assertTrue((!service.isHeldByCurrentThread(objName) ? 1 : 0) != 0);
            }
        });
        thread.start();
        DistributedTestCase.join(thread, 30000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.assertTrue((boolean)resultHolder[0]);
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] unlock should throw LeaseExpiredException");
        try {
            service.unlock((Object)objName);
            DistributedLockServiceTest.fail((String)"unlock should have thrown LeaseExpiredException");
        }
        catch (LeaseExpiredException leaseExpiredException) {
            // empty catch block
        }
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] create service in other vm");
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(this.getClass(), "remoteCreateService", new Object[]{serviceName});
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] acquire lock again and expire");
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)objName, -1L, leaseMs));
        DistributedLockServiceTest.sleep(waitBeforeLockingMs);
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] succeed lock in other vm");
        DistributedLockServiceTest.assertEquals((Object)Boolean.TRUE, (Object)vm.invoke(this.getClass(), "getLockAndIncrement", new Object[]{serviceName, objName, new Long(-1L), new Long(0L)}));
        DistributedLockServiceTest.getLogWriter().fine("[testLeaseExpires] unlock should throw LeaseExpiredException again");
        try {
            service.unlock((Object)objName);
            DistributedLockServiceTest.fail((String)"unlock should have thrown LeaseExpiredException");
        }
        catch (LeaseExpiredException leaseExpiredException) {
            // empty catch block
        }
    }

    public void testSuspendLockingAfterExpiration() throws Exception {
        DistributedLockServiceTest.getLogWriter().fine("[leaseExpiresThenSuspendTest]");
        long leaseMillis = 100L;
        long suspendWaitMillis = 10000L;
        final String serviceName = this.getUniqueName();
        final Integer key = new Integer(3);
        DistributedLockService dls = DistributedLockService.create((String)serviceName, (DistributedSystem)this.getSystem());
        DistributedLockServiceTest.assertTrue((boolean)dls.lock((Object)key, -1L, 100L));
        DistributedLockServiceTest.sleep(200L);
        DistributedLockServiceTest.getLogWriter().fine("[leaseExpiresThenSuspendTest] unlock should throw LeaseExpiredException");
        try {
            dls.unlock((Object)key);
            DistributedLockServiceTest.fail((String)"unlock should have thrown LeaseExpiredException");
        }
        catch (LeaseExpiredException leaseExpiredException) {
            // empty catch block
        }
        DistributedLockServiceTest.getLogWriter().fine("[leaseExpiresThenSuspendTest] call to suspend locking");
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockService dlock = DistributedLockService.create((String)serviceName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                dlock.suspendLocking(10000L);
                dlock.resumeLocking();
                TestCase.assertTrue((boolean)dlock.lock(key, -1L, 100L));
                dlock.unlock(key);
            }
        });
    }

    public void testLockInterruptiblyIsInterruptible() {
        this.started = false;
        this.gotLock = false;
        this.exception = null;
        this.throwable = null;
        DistributedLockServiceTest.getLogWriter().info("[testLockInterruptiblyIsInterruptible] get and hold the lock");
        String serviceName = this.getUniqueName();
        final DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        service.becomeLockGrantor();
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj", 1000L, -1L));
        DistributedLockServiceTest.getLogWriter().info("[testLockInterruptiblyIsInterruptible] call lockInterruptibly");
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedLockServiceTest.this.started = true;
                    DistributedLockServiceTest.this.gotLock = service.lockInterruptibly((Object)"obj", -1L, -1L);
                }
                catch (InterruptedException ex) {
                    DistributedLockServiceTest.this.exception = ex;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable t) {
                    DistributedLockServiceTest.this.throwable = t;
                }
            }
        });
        thread2.start();
        DistributedLockServiceTest.getLogWriter().info("[testLockInterruptiblyIsInterruptible] interrupt calling thread");
        while (!this.started) {
            Thread.yield();
        }
        thread2.interrupt();
        DistributedTestCase.join(thread2, 20000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testLockInterruptiblyIsInterruptible] verify failed to get lock");
        DistributedLockServiceTest.assertFalse((boolean)this.gotLock);
        if (this.throwable != null) {
            DistributedLockServiceTest.getLogWriter().warning("testLockInterruptiblyIsInterruptible threw unexpected Throwable", this.throwable);
        }
        DistributedLockServiceTest.assertNotNull((Object)this.exception);
        DistributedLockServiceTest.getLogWriter().info("[testLockInterruptiblyIsInterruptible] unlock the lock");
        service.unlock((Object)"obj");
        DistributedLockServiceTest.getLogWriter().info("[testLockInterruptiblyIsInterruptible] try to get lock with timeout should not fail");
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj", 5000L, -1L));
        DistributedLockService.destroy((String)serviceName);
    }

    public void testLockIsNotInterruptible() {
        DistributedLockServiceTest.getLogWriter().fine("[testLockIsNotInterruptible] lock in first thread");
        this.started = false;
        this.gotLock = false;
        this.exception = null;
        this.wasFlagSet = false;
        String serviceName = this.getUniqueName();
        final DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj", 1000L, -1L));
        DistributedLockServiceTest.getLogWriter().fine("[testLockIsNotInterruptible] attempt lock in second thread");
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedLockServiceTest.this.started = true;
                    DistributedLockServiceTest.this.gotLock = service.lock((Object)"obj", -1L, -1L);
                    DistributedTestCase.getLogWriter().fine("[testLockIsNotInterruptible] thread2 finished lock() - got " + DistributedLockServiceTest.this.gotLock);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable ex) {
                    DistributedTestCase.getLogWriter().warning("[testLockIsNotInterruptible] Caught...", ex);
                    DistributedLockServiceTest.this.exception = ex;
                }
                DistributedLockServiceTest.this.wasFlagSet = Thread.currentThread().isInterrupted();
            }
        });
        thread2.start();
        DistributedLockServiceTest.getLogWriter().fine("[testLockIsNotInterruptible] interrupt second thread");
        while (!this.started) {
            Thread.yield();
        }
        DistributedLockServiceTest.sleep(500L);
        thread2.interrupt();
        DistributedLockServiceTest.sleep(500L);
        DistributedLockServiceTest.assertFalse((boolean)this.gotLock);
        DistributedLockServiceTest.assertNull((Object)this.exception);
        DistributedLockServiceTest.getLogWriter().fine("[testLockIsNotInterruptible] unlock in first thread");
        service.unlock((Object)"obj");
        DistributedLockServiceTest.sleep(500L);
        DistributedTestCase.join(thread2, 20000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().fine("[testLockIsNotInterruptible] verify second thread got lock");
        DistributedLockServiceTest.assertNull((Object)this.exception);
        DistributedLockServiceTest.assertTrue((boolean)this.gotLock);
        DistributedLockServiceTest.assertTrue((boolean)this.wasFlagSet);
    }

    public void testSuspendLockingBasic() throws InterruptedException {
        final DistributedLockService service = DistributedLockService.create((String)this.getUniqueName(), (DistributedSystem)dlstSystem);
        try {
            service.resumeLocking();
            DistributedLockServiceTest.fail((String)"Didn't throw LockNotHeldException");
        }
        catch (LockNotHeldException lockNotHeldException) {
            // empty catch block
        }
        DistributedLockServiceTest.assertTrue((boolean)service.suspendLocking(-1L));
        service.resumeLocking();
        DistributedLockServiceTest.assertTrue((boolean)service.suspendLocking(1000L));
        try {
            service.suspendLocking(1L);
            DistributedLockServiceTest.fail((String)"didn't get IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        service.resumeLocking();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DistributedLockServiceTest.logInfo("new thread about to suspendLocking()");
                TestCase.assertTrue((boolean)service.suspendLocking(1000L));
            }
        });
        thread.start();
        DistributedTestCase.join(thread, 30000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.logInfo("main thread about to suspendLocking");
        DistributedLockServiceTest.assertTrue((!service.suspendLocking(1000L) ? 1 : 0) != 0);
    }

    public void testSuspendLockingProhibitsLocking() {
        final String name = this.getUniqueName();
        this.distributedCreateService(2, name);
        DistributedLockService service = DistributedLockService.getServiceNamed((String)name);
        VM vm1 = Host.getHost(0).getVM(1);
        DistributedLockServiceTest.assertTrue((boolean)vm1.invokeBoolean(DistributedLockServiceTest.class, "tryToLock", new Object[]{name}));
        DistributedLockServiceTest.assertTrue((boolean)service.suspendLocking(1000L));
        vm1.invoke(new SerializableRunnable("setDebugHandleSuspendTimeouts"){

            @Override
            public void run() {
                DLockService dls = (DLockService)DistributedLockService.getServiceNamed((String)name);
                TestCase.assertTrue((boolean)dls.isLockGrantor());
                DLockGrantor grantor = dls.getGrantorWithNoSync();
                grantor.setDebugHandleSuspendTimeouts(5000);
            }
        });
        DistributedLockServiceTest.assertTrue((!vm1.invokeBoolean(DistributedLockServiceTest.class, "tryToLock", new Object[]{name}) ? 1 : 0) != 0);
        service.resumeLocking();
        vm1.invoke(new SerializableRunnable("unsetDebugHandleSuspendTimeouts"){

            @Override
            public void run() {
                DLockService dls = (DLockService)DistributedLockService.getServiceNamed((String)name);
                TestCase.assertTrue((boolean)dls.isLockGrantor());
                DLockGrantor grantor = dls.getGrantorWithNoSync();
                grantor.setDebugHandleSuspendTimeouts(0);
            }
        });
        DistributedLockServiceTest.assertTrue((boolean)vm1.invokeBoolean(DistributedLockServiceTest.class, "tryToLock", new Object[]{name}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notestSuspendLockingBehaves() throws Exception {
        try {
            this.doTestSuspendLockingBehaves();
        }
        catch (Throwable throwable) {
            DistributedLockServiceTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    try {
                        if (suspendClientSuspendLockingBehaves != null) {
                            suspendClientSuspendLockingBehaves.stop();
                            suspendClientSuspendLockingBehaves = null;
                        }
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Throwable t) {
                        DistributedTestCase.getLogWriter().error("Error in testSuspendLockingBehaves finally", t);
                    }
                    try {
                        if (lockClientSuspendLockingBehaves != null) {
                            lockClientSuspendLockingBehaves.stop();
                            lockClientSuspendLockingBehaves = null;
                        }
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Throwable t) {
                        DistributedTestCase.getLogWriter().error("Error in testSuspendLockingBehaves finally", t);
                    }
                }
            });
            throw throwable;
        }
        DistributedLockServiceTest.invokeInEveryVM(new /* invalid duplicate definition of identical inner class */);
    }

    private void doTestSuspendLockingBehaves() throws Exception {
        final String dlsName = this.getUniqueName();
        VM vmGrantor = Host.getHost(0).getVM(0);
        VM vmOne = Host.getHost(0).getVM(1);
        VM vmTwo = Host.getHost(0).getVM(2);
        VM vmThree = Host.getHost(0).getVM(3);
        String key1 = "key1";
        SerializableRunnable createDLS = new SerializableRunnable("Create " + dlsName){

            @Override
            public void run() {
                DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                lockClientSuspendLockingBehaves = new BasicLockClient(dlsName, "key1");
                suspendClientSuspendLockingBehaves = new BasicLockClient(dlsName, "key1");
                TestCase.assertFalse((boolean)DistributedLockServiceTest.isLockGrantor(dlsName));
            }
        };
        SerializableRunnable suspendLocking = new SerializableRunnable("Suspend locking " + dlsName){

            @Override
            public void run() {
                suspendClientSuspendLockingBehaves.suspend();
            }
        };
        SerializableRunnable resumeLocking = new SerializableRunnable("Resume locking " + dlsName){

            @Override
            public void run() {
                suspendClientSuspendLockingBehaves.resume();
            }
        };
        SerializableRunnable lockKey = new SerializableRunnable("Get lock " + dlsName){

            @Override
            public void run() {
                lockClientSuspendLockingBehaves.lock();
            }
        };
        SerializableRunnable unlockKey = new SerializableRunnable("Unlock " + dlsName){

            @Override
            public void run() {
                lockClientSuspendLockingBehaves.unlock();
            }
        };
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] Create grantor " + dlsName);
        vmGrantor.invoke(new SerializableRunnable("Create grantor " + dlsName){

            @Override
            public void run() {
                DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                DistributedLockService.getServiceNamed((String)dlsName).lock((Object)"key1", -1L, -1L);
                DistributedLockService.getServiceNamed((String)dlsName).unlock((Object)"key1");
                TestCase.assertTrue((boolean)DistributedLockServiceTest.isLockGrantor(dlsName));
            }
        });
        vmOne.invoke(createDLS);
        vmTwo.invoke(createDLS);
        vmThree.invoke(createDLS);
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] line up vms for lock");
        vmOne.invoke(lockKey);
        AsyncInvocation vmTwoLocking = vmTwo.invokeAsync(lockKey);
        DistributedLockServiceTest.pause(2000);
        AsyncInvocation vmThreeLocking = vmThree.invokeAsync(lockKey);
        DistributedLockServiceTest.pause(2000);
        DistributedLockServiceTest.pause(100);
        DistributedLockServiceTest.assertTrue((boolean)vmTwoLocking.isAlive());
        DistributedLockServiceTest.pause(100);
        DistributedLockServiceTest.assertTrue((boolean)vmThreeLocking.isAlive());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] unlock so vmTwo can get key");
        vmOne.invoke(unlockKey);
        DistributedTestCase.join(vmTwoLocking, 10000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] start suspending requests");
        AsyncInvocation vmOneSuspending = vmOne.invokeAsync(suspendLocking);
        DistributedLockServiceTest.pause(2000);
        AsyncInvocation vmTwoSuspending = vmTwo.invokeAsync(suspendLocking);
        DistributedLockServiceTest.pause(2000);
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] unlock so vmThree can get key");
        vmTwo.invoke(unlockKey);
        DistributedTestCase.join(vmThreeLocking, 10000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] start another lock request");
        AsyncInvocation vmOneLockingAgain = vmOne.invokeAsync(lockKey);
        DistributedLockServiceTest.pause(2000);
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] let vmOne suspend locking");
        DistributedLockServiceTest.pause(100);
        DistributedLockServiceTest.assertTrue((boolean)vmOneSuspending.isAlive());
        vmThree.invoke(unlockKey);
        DistributedTestCase.join(vmOneSuspending, 10000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] line up vmThree for suspending");
        AsyncInvocation vmThreeSuspending = vmThree.invokeAsync(suspendLocking);
        DistributedLockServiceTest.pause(2000);
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] let vmTwo suspend locking");
        DistributedLockServiceTest.pause(100);
        DistributedLockServiceTest.assertTrue((boolean)vmTwoSuspending.isAlive());
        vmOne.invoke(resumeLocking);
        DistributedTestCase.join(vmTwoSuspending, 10000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] let vmOne get that lock");
        DistributedLockServiceTest.pause(100);
        DistributedLockServiceTest.assertTrue((boolean)vmOneLockingAgain.isAlive());
        vmTwo.invoke(resumeLocking);
        DistributedTestCase.join(vmOneLockingAgain, 10000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingBehaves] let vmThree suspend locking");
        DistributedLockServiceTest.pause(100);
        DistributedLockServiceTest.assertTrue((boolean)vmThreeSuspending.isAlive());
        vmOne.invoke(unlockKey);
        DistributedTestCase.join(vmThreeSuspending, 10000L, DistributedLockServiceTest.getLogWriter());
        vmThree.invoke(resumeLocking);
    }

    public void testSuspendLockingBlocksUntilNoLocks() throws InterruptedException {
        final String name = this.getUniqueName();
        this.distributedCreateService(2, name);
        final DistributedLockService service = DistributedLockService.getServiceNamed((String)name);
        VM vm1 = Host.getHost(0).getVM(1);
        vm1.invokeAsync(new SerializableRunnable("Lock & unlock in vm1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DistributedLockService service2 = DistributedLockService.getServiceNamed((String)name);
                TestCase.assertTrue((boolean)service2.lock((Object)"lock", -1L, -1L));
                Object object = monitor;
                synchronized (object) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException ex) {
                        System.out.println("Unexpected InterruptedException");
                        TestCase.fail((String)"interrupted");
                    }
                }
                service2.unlock((Object)"lock");
            }
        });
        Thread.sleep(100L);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DistributedLockServiceTest.this.setGot(service.suspendLocking(-1L));
                DistributedLockServiceTest.this.setDone(true);
                service.resumeLocking();
            }
        });
        this.setGot(false);
        this.setDone(false);
        thread.start();
        Thread.sleep(100L);
        DistributedLockServiceTest.assertFalse((String)("Before release, got: " + this.getGot() + ", done: " + this.getDone()), (this.getGot() || this.getDone() ? 1 : 0) != 0);
        vm1.invoke(new SerializableRunnable("notify vm1 to unlock"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            }
        });
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return DistributedLockServiceTest.this.getDone();
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
        if (!this.getGot() || !this.getDone()) {
            ClientMgr.printProcessStacks();
        }
        DistributedLockServiceTest.assertTrue((String)("After release, got: " + this.getGot() + ", done: " + this.getDone()), (this.getGot() && this.getDone() ? 1 : 0) != 0);
    }

    public void testSuspendLockingInterruptiblyIsInterruptible() {
        this.started = false;
        this.gotLock = false;
        this.exception = null;
        String name = this.getUniqueName();
        final DistributedLockService service = DistributedLockService.create((String)name, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.suspendLocking(1000L));
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedLockServiceTest.this.started = true;
                    DistributedLockServiceTest.this.gotLock = service.suspendLockingInterruptibly(-1L);
                }
                catch (InterruptedException ex) {
                    DistributedLockServiceTest.this.exception = ex;
                }
            }
        });
        thread2.start();
        while (!this.started) {
            Thread.yield();
        }
        thread2.interrupt();
        DistributedTestCase.join(thread2, 20000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.sleep(500L);
        DistributedLockServiceTest.assertFalse((boolean)this.gotLock);
        DistributedLockServiceTest.assertNotNull((Object)this.exception);
        service.resumeLocking();
        DistributedLockServiceTest.sleep(500L);
        DistributedLockServiceTest.assertTrue((boolean)service.suspendLocking(1000L));
        DistributedLockService.destroy((String)name);
    }

    public void testSuspendLockingIsNotInterruptible() {
        this.started = false;
        this.gotLock = false;
        this.exception = null;
        this.wasFlagSet = false;
        String name = this.getUniqueName();
        final DistributedLockService service = DistributedLockService.create((String)name, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.suspendLocking(1000L));
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedLockServiceTest.this.started = true;
                    DistributedLockServiceTest.this.gotLock = service.suspendLocking(-1L);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable ex) {
                    DistributedLockServiceTest.this.exception = ex;
                }
                DistributedLockServiceTest.this.wasFlagSet = Thread.currentThread().isInterrupted();
            }
        });
        thread2.start();
        while (!this.started) {
            Thread.yield();
        }
        thread2.interrupt();
        DistributedLockServiceTest.sleep(500L);
        DistributedLockServiceTest.assertFalse((boolean)this.gotLock);
        DistributedLockServiceTest.assertNull((Object)this.exception);
        service.resumeLocking();
        DistributedTestCase.join(thread2, 20000L, DistributedLockServiceTest.getLogWriter());
        DistributedLockServiceTest.getLogWriter().info("[testSuspendLockingIsNotInterruptible] gotLock=" + this.gotLock + " wasFlagSet=" + this.wasFlagSet + " exception=" + this.exception, this.exception);
        DistributedLockServiceTest.assertTrue((boolean)this.gotLock);
        DistributedLockServiceTest.assertNull((Object)this.exception);
        DistributedLockServiceTest.assertTrue((boolean)this.wasFlagSet);
    }

    public void testLockDestroyedService() {
        String serviceName = this.getUniqueName();
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockService.destroy((String)serviceName);
        try {
            boolean locked = service.lock((Object)"TEST", -1L, -1L);
            DistributedLockServiceTest.fail((String)("Lock of destroyed service returned: " + locked));
        }
        catch (LockServiceDestroyedException lockServiceDestroyedException) {
            // empty catch block
        }
    }

    public void testDepartedLastOwnerWithLease() {
        final String serviceName = this.getUniqueName();
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"key", -1L, -1L));
        service.unlock((Object)"key");
        VM otherVm = Host.getHost(0).getVM(0);
        otherVm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockService service2 = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
                service2.lock((Object)"key", -1L, 360000L);
                service2.unlock((Object)"key");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    TestCase.fail((String)"interrupted");
                }
                DistributedTestCase.disconnectFromDS();
            }
        });
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"key", -1L, -1L));
    }

    public void testDepartedLastOwnerNoLease() {
        final String serviceName = this.getUniqueName();
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"key", -1L, -1L));
        service.unlock((Object)"key");
        VM otherVm = Host.getHost(0).getVM(0);
        otherVm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockService service2 = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
                service2.lock((Object)"key", -1L, -1L);
                service2.unlock((Object)"key");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    TestCase.fail((String)"interrupted");
                }
                DistributedTestCase.disconnectFromDS();
            }
        });
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"key", -1L, -1L));
    }

    public void testBug32461() throws Exception {
        DistributedLockServiceTest.getLogWriter().fine("[testBug32461] prepping");
        final String serviceName = this.getUniqueName();
        final String objName = "32461";
        boolean VM_A = false;
        boolean VM_B = true;
        int VM_C = 2;
        DistributedLockServiceTest.getLogWriter().fine("[testBug32461] VM-A locks/unlocks '32461'");
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockServiceTest.remoteCreateService(serviceName);
                DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
                TestCase.assertTrue((boolean)service.lock(objName, -1L, Long.MAX_VALUE));
                service.unlock(objName);
            }
        });
        DistributedLockServiceTest.getLogWriter().fine("[testBug32461] VM_B leases '32461' and disconnects");
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockServiceTest.remoteCreateService(serviceName);
                DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
                TestCase.assertTrue((boolean)service.lock(objName, -1L, Long.MAX_VALUE));
                DistributedLockService.destroy((String)serviceName);
                DistributedTestCase.disconnectFromDS();
            }
        });
        DistributedLockServiceTest.getLogWriter().fine("[testBug32461] VM_C attempts to lock '32461'");
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockServiceTest.remoteCreateService(serviceName);
                DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
                TestCase.assertTrue((boolean)service.lock(objName, -1L, -1L));
                service.unlock(objName);
            }
        });
    }

    public void testNoStuckLock() {
        final String serviceName = this.getUniqueName();
        final String keyWithLease = "key-with-lease";
        final String keyNoLease = "key-no-lease";
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)keyWithLease, -1L, -1L));
        service.unlock((Object)keyWithLease);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)keyNoLease, -1L, -1L));
        service.unlock((Object)keyNoLease);
        VM otherVm = Host.getHost(0).getVM(0);
        otherVm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedLockService service2 = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
                service2.lock(keyWithLease, -1L, 360000L);
                service2.lock(keyNoLease, -1L, -1L);
                DistributedTestCase.disconnectFromDS();
            }
        });
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)keyWithLease, -1L, -1L));
        service.unlock((Object)keyWithLease);
        DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)keyNoLease, -1L, -1L));
        service.unlock((Object)keyNoLease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseOrphanedGrant_Local() {
        DLockRequestProcessor.setDebugReleaseOrphanedGrant((boolean)true);
        DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)false);
        try {
            this.startedThread2_testReleaseOrphanedGrant = false;
            this.gotLockThread2_testReleaseOrphanedGrant = false;
            this.releaseThread1_testReleaseOrphanedGrant = false;
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Local] create lock service");
            String serviceName = this.getUniqueName();
            final DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
            Thread thread1 = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Local] get the lock");
                    TestCase.assertTrue((boolean)service.lock((Object)"obj", -1L, -1L));
                    DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)true);
                    DistributedLockServiceTest.this.startedThread1_testReleaseOrphanedGrant = true;
                    Thread thread = Thread.currentThread();
                    synchronized (thread) {
                        while (!DistributedLockServiceTest.this.releaseThread1_testReleaseOrphanedGrant) {
                            try {
                                Thread.currentThread().wait();
                            }
                            catch (InterruptedException ignore) {
                                TestCase.fail((String)"interrupted");
                            }
                        }
                    }
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Local] unlock the lock");
                    service.unlock((Object)"obj");
                }
            });
            thread1.start();
            while (!this.startedThread1_testReleaseOrphanedGrant) {
                Thread.yield();
            }
            Thread thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Local] call lockInterruptibly");
                        DistributedLockServiceTest.this.startedThread2_testReleaseOrphanedGrant = true;
                        TestCase.assertFalse((boolean)service.lockInterruptibly((Object)"obj", -1L, -1L));
                    }
                    catch (InterruptedException expected) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            thread2.start();
            while (!this.startedThread2_testReleaseOrphanedGrant) {
                Thread.yield();
            }
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Local] release 1st thread");
            DistributedLockServiceTest.sleep(500L);
            Thread thread = thread1;
            synchronized (thread) {
                this.releaseThread1_testReleaseOrphanedGrant = true;
                thread1.notifyAll();
            }
            DistributedLockServiceTest.sleep(500L);
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Local] interrupt 2nd thread");
            thread2.interrupt();
            DistributedTestCase.join(thread2, 20000L, DistributedLockServiceTest.getLogWriter());
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Local] process lock response");
            DistributedLockServiceTest.sleep(500L);
            DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)false);
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Local] verify lock not held");
            DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj", 1000L, -1L));
        }
        finally {
            DLockRequestProcessor.setDebugReleaseOrphanedGrant((boolean)false);
            DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)false);
        }
    }

    public void testReleaseOrphanedGrant_Remote() {
        this.doTestReleaseOrphanedGrant_Remote(false);
    }

    public void testReleaseOrphanedGrant_RemoteWithDestroy() {
        this.doTestReleaseOrphanedGrant_Remote(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestReleaseOrphanedGrant_Remote(final boolean destroyLockService) {
        VM vm1 = Host.getHost(0).getVM(0);
        VM vm2 = Host.getHost(0).getVM(1);
        try {
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Remote] create lock service");
            final String serviceName = this.getUniqueName();
            DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
            DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj", -1L, -1L));
            service.unlock((Object)"obj");
            vm1.invokeAsync(new SerializableRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] get the lock");
                    threadVM1_testReleaseOrphanedGrant_Remote = Thread.currentThread();
                    DistributedLockServiceTest.connectDistributedSystem();
                    DistributedLockService service_vm1 = DistributedLockService.create((String)serviceName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                    TestCase.assertTrue((boolean)service_vm1.lock((Object)"obj", -1L, -1L));
                    Thread thread = threadVM1_testReleaseOrphanedGrant_Remote;
                    synchronized (thread) {
                        while (!releaseThreadVM1_testReleaseOrphanedGrant_Remote) {
                            try {
                                startedThreadVM1_testReleaseOrphanedGrant_Remote = true;
                                Thread.currentThread().wait();
                            }
                            catch (InterruptedException ignore) {
                                TestCase.fail((String)"interrupted");
                            }
                        }
                    }
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] unlock the lock");
                    service_vm1.unlock((Object)"obj");
                    unlockedThreadVM1_testReleaseOrphanedGrant_Remote = true;
                }
            });
            vm1.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    while (!startedThreadVM1_testReleaseOrphanedGrant_Remote) {
                        Thread.yield();
                    }
                }
            });
            DistributedLockServiceTest.sleep(500L);
            vm2.invokeAsync(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] call lockInterruptibly");
                    threadVM2_testReleaseOrphanedGrant_Remote = Thread.currentThread();
                    DistributedLockService service_vm2 = DistributedLockService.create((String)serviceName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                    startedThreadVM2_testReleaseOrphanedGrant_Remote = true;
                    try {
                        DLockRequestProcessor.setDebugReleaseOrphanedGrant((boolean)true);
                        DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)true);
                        TestCase.assertFalse((boolean)service_vm2.lockInterruptibly((Object)"obj", -1L, -1L));
                    }
                    catch (InterruptedException expected) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            vm2.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    while (!startedThreadVM2_testReleaseOrphanedGrant_Remote) {
                        Thread.yield();
                    }
                }
            });
            DistributedLockServiceTest.sleep(500L);
            vm1.invoke(new SerializableRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] release 1st thread");
                    Thread thread = threadVM1_testReleaseOrphanedGrant_Remote;
                    synchronized (thread) {
                        releaseThreadVM1_testReleaseOrphanedGrant_Remote = true;
                        threadVM1_testReleaseOrphanedGrant_Remote.notifyAll();
                    }
                }
            });
            DistributedLockServiceTest.sleep(500L);
            vm2.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] interrupt 2nd thread");
                    threadVM2_testReleaseOrphanedGrant_Remote.interrupt();
                    DistributedTestCase.join(threadVM2_testReleaseOrphanedGrant_Remote, 300000L, DistributedTestCase.getLogWriter());
                    if (destroyLockService) {
                        DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] destroy lock service");
                        DistributedLockService.destroy((String)serviceName);
                        TestCase.assertNull((Object)DistributedLockService.getServiceNamed((String)serviceName));
                    }
                }
            });
            DistributedLockServiceTest.sleep(500L);
            vm2.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] process lock response");
                    DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)false);
                }
            });
            DistributedLockServiceTest.sleep(500L);
            DistributedLockServiceTest.getLogWriter().info("[testReleaseOrphanedGrant_Remote] verify lock not held");
            DistributedLockServiceTest.assertTrue((boolean)service.lock((Object)"obj", 1000L, -1L));
            vm2.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testReleaseOrphanedGrant_Remote] clean up DebugReleaseOrphanedGrant");
                    DLockRequestProcessor.setDebugReleaseOrphanedGrant((boolean)false);
                    DLockRequestProcessor.setWaitToProcessDLockResponse((boolean)false);
                }
            });
        }
        catch (Throwable throwable) {
            vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public void testDestroyLockServiceAfterGrantResponse() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String serviceName = this.getUniqueName();
        vm0.invoke(new SerializableRunnable("Create the grantor"){

            @Override
            public void run() {
                DistributedLockServiceTest.connectDistributedSystem();
                DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
                TestCase.assertTrue((boolean)service.lock((Object)"obj", -1L, -1L));
                service.unlock((Object)"obj");
            }
        });
        DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

            public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                if (message instanceof DLockRequestProcessor.DLockResponseMessage) {
                    DistributedLockService.destroy((String)serviceName);
                }
            }
        });
        DistributedLockServiceTest.connectDistributedSystem();
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        try {
            service.lock((Object)"obj", -1L, -1L);
            DistributedLockServiceTest.fail((String)"The lock service should have been destroyed");
        }
        catch (LockServiceDestroyedException lockServiceDestroyedException) {
            // empty catch block
        }
        vm0.invoke(new SerializableRunnable("check to make sure the lock is not orphaned"){

            @Override
            public void run() {
                DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
                TestCase.assertTrue((boolean)service.lock((Object)"obj", -1L, -1L));
                service.unlock((Object)"obj");
            }
        });
    }

    public void testDestroyLockServiceBeforeGrantRequest() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        final String serviceName = this.getUniqueName();
        vm0.invoke(new SerializableRunnable("Create the grantor"){

            @Override
            public void run() {
                DistributedLockServiceTest.connectDistributedSystem();
                DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
                TestCase.assertTrue((boolean)service.lock((Object)"obj", -1L, -1L));
                service.unlock((Object)"obj");
            }
        });
        DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

            public void beforeSendMessage(DistributionManager dm, DistributionMessage message) {
                if (message instanceof DLockRequestProcessor.DLockRequestMessage) {
                    DistributedLockService.destroy((String)serviceName);
                }
            }
        });
        DistributedLockServiceTest.connectDistributedSystem();
        DistributedLockService service = DistributedLockService.create((String)serviceName, (DistributedSystem)dlstSystem);
        try {
            service.lock((Object)"obj", -1L, -1L);
            DistributedLockServiceTest.fail((String)"The lock service should have been destroyed");
        }
        catch (LockServiceDestroyedException lockServiceDestroyedException) {
            // empty catch block
        }
        vm0.invoke(new SerializableRunnable("check to make sure the lock is not orphaned"){

            @Override
            public void run() {
                DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
                TestCase.assertTrue((boolean)service.lock((Object)"obj", -1L, -1L));
                service.unlock((Object)"obj");
            }
        });
    }

    protected synchronized boolean getDone() {
        return this.done;
    }

    protected synchronized void setDone(boolean done) {
        this.done = done;
    }

    private synchronized boolean getGot() {
        return this.got;
    }

    protected synchronized void setGot(boolean got) {
        this.got = got;
    }

    protected static Boolean lock(String serviceName, Object name) {
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        boolean locked = service.lock(name, 1000L, -1L);
        return locked;
    }

    protected static Boolean tryLock(String serviceName, Object name, Long wait) {
        DLockService service = DLockService.getInternalServiceNamed((String)serviceName);
        boolean locked = service.lock(name, wait.longValue(), -1L, true);
        return locked;
    }

    protected static Boolean unlock(String serviceName, Object name) {
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        try {
            service.unlock(name);
            return Boolean.TRUE;
        }
        catch (LockNotHeldException e) {
            return Boolean.FALSE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    protected static Boolean tryToLock(String serviceName) {
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        boolean locked = service.lock((Object)"obj", 1000L, -1L);
        if (locked) {
            service.unlock((Object)"obj");
        }
        return locked;
    }

    private void doOneGetsAndOthersTimeOut(int numVMs, int numThreadsPerVM) {
        final String serviceName = this.getUniqueName() + "-" + numVMs + "-" + numThreadsPerVM;
        String objectName = "obj";
        DistributedLockServiceTest.logInfo("Starting testtt " + serviceName);
        this.distributedCreateService(numVMs, serviceName);
        this.hits = 0;
        this.completes = 0;
        blackboard.initCount();
        blackboard.setIsLocked(false);
        long timeout = 1000L;
        long holdTime = timeout * 5L;
        final Object[] args = new Object[]{serviceName, "obj", new Long(timeout), new Long(holdTime)};
        final Host host = Host.getHost(0);
        for (int vm = 0; vm < numVMs; ++vm) {
            final int finalvm = vm;
            for (int thread = 0; thread < numThreadsPerVM; ++thread) {
                final int finalthread = thread;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DistributedLockServiceTest.logInfo("VM " + finalvm + ", thread " + finalthread + " in " + serviceName + " about to invoke");
                        Boolean result = (Boolean)host.getVM(finalvm).invoke(DistributedLockServiceTest.class, "getLockAndIncrement", args);
                        DistributedLockServiceTest.logInfo("VM " + finalvm + ", thread " + finalthread + " in " + serviceName + " got " + result);
                        if (result.booleanValue()) {
                            DistributedLockServiceTest.this.incHits();
                        }
                        DistributedLockServiceTest.this.incCompletes();
                    }
                }, "doOneGetsAndOthersTimeOut-" + thread).start();
            }
        }
        long start = System.currentTimeMillis();
        while (this.completes < numVMs * numThreadsPerVM && System.currentTimeMillis() - start < holdTime * 10L) {
            DistributedLockServiceTest.sleep(200L);
        }
        if (this.hits != 1) {
            ClientMgr.printProcessStacks();
        }
        DistributedLockServiceTest.assertEquals((String)"number of VMs that got ownership is wrong", (int)1, (int)this.hits);
        DistributedLockServiceTest.assertEquals((String)"number of threads that completed is wrong", (int)(numVMs * numThreadsPerVM), (int)this.completes);
        long count = blackboard.getCount();
        DistributedLockServiceTest.assertEquals((String)"Final entry value wrong", (long)1L, (long)count);
        DistributedLockServiceTest.logInfo("Done testtt " + serviceName);
    }

    private void doOneGetsThenOtherGets(int numVMs, int numThreadsPerVM) {
        final String serviceName = this.getUniqueName() + "-" + numVMs + "-" + numThreadsPerVM;
        String objectName = "obj";
        DistributedLockServiceTest.logInfo("Starting testtt " + serviceName);
        this.distributedCreateService(numVMs, serviceName);
        this.hits = 0;
        this.completes = 0;
        blackboard.initCount();
        blackboard.setIsLocked(false);
        long timeout = 1000 * numVMs * numThreadsPerVM;
        timeout = Math.max(timeout, 10000L);
        final Object[] args = new Object[]{serviceName, "obj", new Long(timeout), new Long(0L)};
        final Host host = Host.getHost(0);
        for (int vm = 0; vm < numVMs; ++vm) {
            final int finalvm = vm;
            int thread = 0;
            while (thread < numThreadsPerVM) {
                final int finalthread = thread++;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DistributedLockServiceTest.logInfo("VM " + finalvm + ", thread " + finalthread + " in " + serviceName + " about to invoke");
                        Boolean result = (Boolean)host.getVM(finalvm).invoke(DistributedLockServiceTest.class, "getLockAndIncrement", args);
                        DistributedLockServiceTest.logInfo("VM " + finalvm + ", thread " + finalthread + " in " + serviceName + " got result " + result);
                        if (result.booleanValue()) {
                            DistributedLockServiceTest.this.incHits();
                        }
                        DistributedLockServiceTest.this.incCompletes();
                    }
                }).start();
            }
        }
        long start = System.currentTimeMillis();
        while (this.completes < numVMs * numThreadsPerVM) {
            if (System.currentTimeMillis() - start >= timeout * 2L) {
                DistributedLockServiceTest.logInfo("Test serviceName timed out");
                break;
            }
            DistributedLockServiceTest.sleep(200L);
        }
        DistributedLockServiceTest.assertEquals((String)"number of threads that completed is wrong", (int)(numVMs * numThreadsPerVM), (int)this.completes);
        if (this.hits != numVMs * numThreadsPerVM) {
            ClientMgr.printProcessStacks();
        }
        DistributedLockServiceTest.assertEquals((String)"number of VMs that got ownership is wrong", (int)(numVMs * numThreadsPerVM), (int)this.hits);
        long count = blackboard.getCount();
        DistributedLockServiceTest.assertEquals((String)"Blackboard.getCount() wrong", (long)(numVMs * numThreadsPerVM), (long)count);
        DistributedLockServiceTest.logInfo("Done testtt " + serviceName);
    }

    public void testTokenCleanup() throws Exception {
        final String dlsName = this.getUniqueName();
        VM vmGrantor = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        String key1 = "key1";
        vmGrantor.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testTokenCleanup] vmGrantor creates grantor");
                DistributedLockServiceTest.connectDistributedSystem();
                DLockService dls = (DLockService)DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertTrue((boolean)dls.isLockGrantor());
                TestCase.assertNotNull((Object)dls.getToken((Object)"key1"));
                dls.unlock((Object)"key1");
                TestCase.assertNotNull((Object)dls.getToken((Object)"key1"));
                dls.freeResources((Object)"key1");
                DLockToken token = dls.getToken((Object)"key1");
                TestCase.assertNull((String)("Failed with bug 38180: " + token), (Object)token);
                Collection tokens = dls.getTokens();
                TestCase.assertEquals((String)("Failed with bug 38180: tokens=" + tokens), (int)0, (int)tokens.size());
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testTokenCleanup] vm1 locks key1");
                DistributedLockServiceTest.connectDistributedSystem();
                DLockService dls = (DLockService)DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertFalse((boolean)dls.isLockGrantor());
                TestCase.assertNotNull((Object)dls.getToken((Object)"key1"));
                dls.unlock((Object)"key1");
                TestCase.assertNotNull((Object)dls.getToken((Object)"key1"));
                dls.freeResources((Object)"key1");
                DLockToken token = dls.getToken((Object)"key1");
                TestCase.assertNull((String)("Failed with bug 38180: " + token), (Object)token);
                Collection tokens = dls.getTokens();
                TestCase.assertEquals((String)("Failed with bug 38180: tokens=" + tokens), (int)0, (int)tokens.size());
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testTokenCleanup] vm1 tests recursion");
                DistributedLockServiceTest.connectDistributedSystem();
                DLockService dls = (DLockService)DistributedLockService.getServiceNamed((String)dlsName);
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertEquals((int)1, (int)dls.getToken((Object)"key1").getUsageCount());
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertEquals((int)2, (int)dls.getToken((Object)"key1").getUsageCount());
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertEquals((int)3, (int)dls.getToken((Object)"key1").getUsageCount());
                DLockToken token0 = dls.getToken((Object)"key1");
                TestCase.assertNotNull((Object)token0);
                Collection tokens = dls.getTokens();
                TestCase.assertTrue((boolean)tokens.contains(token0));
                TestCase.assertEquals((int)1, (int)tokens.size());
                dls.unlock((Object)"key1");
                TestCase.assertEquals((int)2, (int)dls.getToken((Object)"key1").getUsageCount());
                dls.freeResources((Object)"key1");
                DLockToken token1 = dls.getToken((Object)"key1");
                TestCase.assertNotNull((Object)token1);
                TestCase.assertEquals((Object)token0, (Object)token1);
                tokens = dls.getTokens();
                TestCase.assertTrue((boolean)tokens.contains(token1));
                TestCase.assertEquals((int)1, (int)tokens.size());
                dls.unlock((Object)"key1");
                TestCase.assertEquals((int)1, (int)dls.getToken((Object)"key1").getUsageCount());
                dls.freeResources((Object)"key1");
                TestCase.assertNotNull((Object)dls.getToken((Object)"key1"));
                DLockToken token2 = dls.getToken((Object)"key1");
                TestCase.assertNotNull((Object)token2);
                TestCase.assertEquals((Object)token0, (Object)token2);
                tokens = dls.getTokens();
                TestCase.assertTrue((boolean)tokens.contains(token2));
                TestCase.assertEquals((int)1, (int)tokens.size());
                dls.unlock((Object)"key1");
                TestCase.assertEquals((int)0, (int)dls.getToken((Object)"key1").getUsageCount());
                dls.freeResources((Object)"key1");
                DLockToken token3 = dls.getToken((Object)"key1");
                TestCase.assertNull((String)("Failed with bug 38180: " + token3), (Object)token3);
                tokens = dls.getTokens();
                TestCase.assertEquals((String)("Failed with bug 38180: tokens=" + tokens), (int)0, (int)tokens.size());
            }
        });
    }

    public void testGrantTokenCleanup() throws Exception {
        final String dlsName = this.getUniqueName();
        VM vmGrantor = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        String key1 = "key1";
        vmGrantor.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testGrantTokenCleanup] vmGrantor creates grantor");
                DistributedLockServiceTest.connectDistributedSystem();
                DistributedLockService dls = DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertTrue((boolean)dls.isLockGrantor());
                DLockGrantor grantor = ((DLockService)dls).getGrantor();
                TestCase.assertNotNull((Object)grantor);
                DLockGrantor.DLockGrantToken grantToken = grantor.getGrantToken((Object)"key1");
                TestCase.assertNotNull((Object)grantToken);
                DistributedTestCase.getLogWriter().info("[testGrantTokenCleanup] vmGrantor unlocks key1");
                dls.unlock((Object)"key1");
                TestCase.assertNull((Object)grantor.getGrantToken((Object)"key1"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockQuery() throws Exception {
        final String dlsName = this.getUniqueName();
        VM vmGrantor = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        String key1 = "key1";
        vmGrantor.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testLockQuery] vmGrantor creates grantor");
                DistributedLockServiceTest.connectDistributedSystem();
                DLockService dls = (DLockService)DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                TestCase.assertTrue((boolean)dls.isLockGrantor());
                dls.unlock((Object)"key1");
                dls.freeResources((Object)"key1");
            }
        });
        AsyncInvocation whileVM1Locks = null;
        try {
            whileVM1Locks = vm1.invokeAsync(new SerializableRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testLockQuery] vm1 locks key1");
                    DistributedLockServiceTest.connectDistributedSystem();
                    DLockService dls = (DLockService)DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                    TestCase.assertTrue((boolean)dls.lock((Object)"key1", -1L, -1L));
                    TestCase.assertFalse((boolean)dls.isLockGrantor());
                    try {
                        AB aB = testLockQuery_whileVM1Locks;
                        synchronized (aB) {
                            testLockQuery_whileVM1Locks.set(true);
                            testLockQuery_whileVM1Locks.notifyAll();
                            long maxWait = 10000L;
                            StopWatch timer = new StopWatch(true);
                            while (testLockQuery_whileVM1Locks.get()) {
                                long timeLeft = maxWait - timer.elapsedTimeMillis();
                                if (timeLeft > 0L) {
                                    testLockQuery_whileVM1Locks.wait(timeLeft);
                                    continue;
                                }
                                TestCase.fail((String)"Test attempted to wait too long");
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        DistributedTestCase.fail(e.getMessage(), e);
                    }
                    DistributedTestCase.getLogWriter().info("[testLockQuery] vm1 unlocks key1");
                    dls.unlock((Object)"key1");
                    dls.freeResources((Object)"key1");
                }
            });
            final DistributedMember vm1Member = (DistributedMember)vm1.invoke(new SerializableCallable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    DistributedTestCase.getLogWriter().info("[testLockQuery] vm1 waits for locking thread");
                    AB aB = testLockQuery_whileVM1Locks;
                    synchronized (aB) {
                        long maxWait = 10000L;
                        StopWatch timer = new StopWatch(true);
                        while (!testLockQuery_whileVM1Locks.get()) {
                            long timeLeft = maxWait - timer.elapsedTimeMillis();
                            if (timeLeft > 0L) {
                                testLockQuery_whileVM1Locks.wait(timeLeft);
                                continue;
                            }
                            TestCase.fail((String)"Test attempted to wait too long");
                        }
                    }
                    return DistributedLockServiceTest.this.getSystem().getDistributedMember();
                }
            });
            DistributedLockServiceTest.assertNotNull((Object)vm1Member);
            vmGrantor.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testLockQuery] vmGrantor tests local query");
                    DLockService dls = (DLockService)DistributedLockService.getServiceNamed((String)dlsName);
                    DLockRemoteToken result = dls.queryLock((Object)"key1");
                    TestCase.assertNotNull((Object)result);
                    TestCase.assertEquals((Object)"key1", (Object)result.getName());
                    TestCase.assertTrue((result.getLeaseId() != -1 ? 1 : 0) != 0);
                    TestCase.assertEquals((long)Long.MAX_VALUE, (long)result.getLeaseExpireTime());
                    RemoteThread lesseeThread = result.getLesseeThread();
                    TestCase.assertNotNull((Object)lesseeThread);
                    TestCase.assertEquals((Object)vm1Member, (Object)lesseeThread.getDistributedMember());
                    TestCase.assertEquals((Object)vm1Member, (Object)result.getLessee());
                }
            });
            vm2.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testLockQuery] vm2 tests remote query");
                    DistributedLockServiceTest.connectDistributedSystem();
                    DLockService dls = (DLockService)DistributedLockService.create((String)dlsName, (DistributedSystem)DistributedLockServiceTest.this.getSystem());
                    DLockRemoteToken result = dls.queryLock((Object)"key1");
                    TestCase.assertNotNull((Object)result);
                    TestCase.assertEquals((Object)"key1", (Object)result.getName());
                    TestCase.assertTrue((result.getLeaseId() != -1 ? 1 : 0) != 0);
                    TestCase.assertEquals((long)Long.MAX_VALUE, (long)result.getLeaseExpireTime());
                    RemoteThread lesseeThread = result.getLesseeThread();
                    TestCase.assertNotNull((Object)lesseeThread);
                    TestCase.assertEquals((Object)vm1Member, (Object)lesseeThread.getDistributedMember());
                    TestCase.assertEquals((Object)vm1Member, (Object)result.getLessee());
                }
            });
            vm1.invoke(new SerializableRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testLockQuery] vm1 notifies/releases key1");
                    AB aB = testLockQuery_whileVM1Locks;
                    synchronized (aB) {
                        testLockQuery_whileVM1Locks.set(false);
                        testLockQuery_whileVM1Locks.notifyAll();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            vm1.invoke(new /* invalid duplicate definition of identical inner class */);
            DistributedTestCase.join(whileVM1Locks, 10000L, DistributedLockServiceTest.getLogWriter());
            if (whileVM1Locks.exceptionOccurred()) {
                DistributedLockServiceTest.fail("Test failed", whileVM1Locks.getException());
            }
            throw throwable;
        }
        DistributedTestCase.join(whileVM1Locks, 10000L, DistributedLockServiceTest.getLogWriter());
        if (whileVM1Locks.exceptionOccurred()) {
            DistributedLockServiceTest.fail("Test failed", whileVM1Locks.getException());
        }
        vmGrantor.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testLockQuery] vmGrantor tests negative query");
                DLockService dls = (DLockService)DistributedLockService.getServiceNamed((String)dlsName);
                DLockRemoteToken result = dls.queryLock((Object)"key1");
                TestCase.assertNotNull((Object)result);
                TestCase.assertEquals((Object)"key1", (Object)result.getName());
                TestCase.assertEquals((int)-1, (int)result.getLeaseId());
                TestCase.assertEquals((long)0L, (long)result.getLeaseExpireTime());
                TestCase.assertNull((Object)result.getLesseeThread());
                TestCase.assertNull((Object)result.getLessee());
            }
        });
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testLockQuery] vm2 tests negative query");
                DLockService dls = (DLockService)DistributedLockService.getServiceNamed((String)dlsName);
                DLockRemoteToken result = dls.queryLock((Object)"key1");
                TestCase.assertNotNull((Object)result);
                TestCase.assertEquals((Object)"key1", (Object)result.getName());
                TestCase.assertEquals((int)-1, (int)result.getLeaseId());
                TestCase.assertEquals((long)0L, (long)result.getLeaseExpireTime());
                TestCase.assertNull((Object)result.getLesseeThread());
                TestCase.assertNull((Object)result.getLessee());
            }
        });
    }

    private void distributedCreateService(int numVMs, String serviceName) {
        this.forNumVMsInvoke(numVMs, "remoteCreateService", new Object[]{serviceName});
        DistributedLockServiceTest.remoteCreateService(serviceName);
    }

    protected static void remoteCreateService(String name) {
        DistributedLockService newService = DistributedLockService.create((String)name, (DistributedSystem)dlstSystem);
        DistributedLockServiceTest.logInfo("Created " + newService);
    }

    private static Object getLockAndIncrement(String serviceName, Object objectName, long timeout, long holdTime) {
        DistributedLockServiceTest.logInfo("[getLockAndIncrement] In getLockAndIncrement");
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        boolean got = service.lock(objectName, timeout, -1L);
        DistributedLockServiceTest.logInfo("[getLockAndIncrement] In getLockAndIncrement - got is " + got);
        if (got) {
            if (blackboard.getIsLocked()) {
                String msg = "obtained lock on " + serviceName + "/" + objectName + " but blackboard was locked, grantor=" + ((DLockService)service).getLockGrantorId() + ", isGrantor=" + ((DLockService)service).isLockGrantor();
                DistributedLockServiceTest.logInfo("[getLockAndIncrement] In getLockAndIncrement: " + msg);
                DistributedLockServiceTest.fail((String)msg);
            }
            blackboard.setIsLocked(true);
            long count = blackboard.getCount();
            DistributedLockServiceTest.logInfo("[getLockAndIncrement] In getLockAndIncrement - count is " + count + " for " + serviceName + "/" + objectName);
            DistributedLockServiceTest.sleep(holdTime);
            blackboard.incCount();
            blackboard.setIsLocked(false);
            DistributedLockServiceTest.logInfo("[getLockAndIncrement] In getLockAndIncrement: cleared blackboard lock for " + serviceName + "/" + objectName);
            service.unlock(objectName);
        }
        DistributedLockServiceTest.logInfo("[getLockAndIncrement] Returning from getLockAndIncrement");
        return new Boolean(got);
    }

    protected synchronized void incHits() {
        ++this.hits;
    }

    protected synchronized void incCompletes() {
        ++this.completes;
    }

    protected static void logInfo(String msg) {
        dlstSystem.getLogWriter().fine(msg);
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            DistributedLockServiceTest.fail((String)"interrupted");
        }
    }

    public void forNumVMsInvoke(int numVMs, String methodName, Object[] args) {
        Host host = Host.getHost(0);
        for (int i = 0; i < numVMs; ++i) {
            DistributedLockServiceTest.logInfo("Invoking " + methodName + "on VM#" + i);
            host.getVM(i).invoke(this.getClass(), methodName, args);
        }
    }

    static {
        blackboard = DistributedLockBlackboard.getInstance();
        monitor = new Object();
        count_testFairness = new int[16];
        done_testFairness = new boolean[16];
        Arrays.fill(done_testFairness, true);
        testLockQuery_whileVM1Locks = CFactory.createAB();
    }

    public static class BasicLockClient
    implements Runnable {
        private static final Integer LOCK = new Integer(1);
        private static final Integer UNLOCK = new Integer(2);
        private static final Integer SUSPEND = new Integer(3);
        private static final Integer RESUME = new Integer(4);
        private static final Integer STOP = new Integer(5);
        private final Object sync = new Object();
        private final Thread thread;
        private final String dlsName;
        private final String key;
        private final LinkedList requests = new LinkedList();
        private final Map operationsMap = new HashMap();
        private final Map throwables = new HashMap();
        private final Set completedRequests = new HashSet();
        private int latestRequest = 0;
        private boolean stayinAlive = true;

        public BasicLockClient(String dlsName, String key) {
            this.dlsName = dlsName;
            this.key = key;
            this.thread = new Thread(this);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            DistributedTestCase.getLogWriter().info("BasicLockClient running");
            while (this.stayinAlive) {
                var1_1 = this.sync;
                synchronized (var1_1) {
                    if (this.requests.size() > 0) {
                        requestId = (Integer)this.requests.removeFirst();
                        operationId = (Integer)this.operationsMap.get(requestId);
                        try {
                            switch (operationId) {
                                case 1: {
                                    DistributedTestCase.getLogWriter().info("BasicLockClient lock");
                                    TestCase.assertTrue((boolean)DistributedLockService.getServiceNamed((String)this.dlsName).lock((Object)this.key, -1L, -1L));
                                    ** break;
lbl15:
                                    // 1 sources

                                    break;
                                }
                                case 2: {
                                    DistributedTestCase.getLogWriter().info("BasicLockClient unlock");
                                    DistributedLockService.getServiceNamed((String)this.dlsName).unlock((Object)this.key);
                                    ** break;
lbl20:
                                    // 1 sources

                                    break;
                                }
                                case 3: {
                                    DistributedTestCase.getLogWriter().info("BasicLockClient suspendLocking");
                                    TestCase.assertTrue((boolean)DistributedLockService.getServiceNamed((String)this.dlsName).suspendLocking(-1L));
                                    ** break;
lbl25:
                                    // 1 sources

                                    break;
                                }
                                case 4: {
                                    DistributedTestCase.getLogWriter().info("BasicLockClient resumeLocking");
                                    DistributedLockService.getServiceNamed((String)this.dlsName).resumeLocking();
                                    ** break;
lbl30:
                                    // 1 sources

                                    break;
                                }
                                case 5: {
                                    DistributedTestCase.getLogWriter().info("BasicLockClient stopping");
                                    this.stayinAlive = false;
                                    break;
                                }
                                ** default:
lbl36:
                                // 1 sources

                                break;
                            }
                        }
                        catch (VirtualMachineError e) {
                            SystemFailure.initiateFailure((Error)e);
                            throw e;
                        }
                        catch (Throwable t) {
                            this.throwables.put(requestId, t);
                        }
                        finally {
                            this.completedRequests.add(requestId);
                            this.sync.notify();
                        }
                    }
                    try {
                        this.sync.wait();
                    }
                    catch (InterruptedException e) {
                        DistributedTestCase.getLogWriter().info("BasicLockClient interrupted");
                        this.stayinAlive = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() throws Error {
            try {
                Object object = this.sync;
                synchronized (object) {
                    ++this.latestRequest;
                    Integer requestId = new Integer(this.latestRequest);
                    this.operationsMap.put(requestId, LOCK);
                    this.requests.add(requestId);
                    this.sync.notify();
                    long maxWait = System.currentTimeMillis() + 2000L;
                    while (!this.completedRequests.contains(requestId)) {
                        long waitMillis = maxWait - System.currentTimeMillis();
                        TestCase.assertTrue((waitMillis > 0L ? 1 : 0) != 0);
                        this.sync.wait(waitMillis);
                    }
                    Throwable t = (Throwable)this.throwables.get(requestId);
                    if (t != null) {
                        throw new Error(t);
                    }
                }
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() throws Error {
            try {
                Object object = this.sync;
                synchronized (object) {
                    ++this.latestRequest;
                    Integer requestId = new Integer(this.latestRequest);
                    this.operationsMap.put(requestId, UNLOCK);
                    this.requests.add(requestId);
                    this.sync.notify();
                    long maxWait = System.currentTimeMillis() + 2000L;
                    while (!this.completedRequests.contains(requestId)) {
                        long waitMillis = maxWait - System.currentTimeMillis();
                        TestCase.assertTrue((waitMillis > 0L ? 1 : 0) != 0);
                        this.sync.wait(waitMillis);
                    }
                    Throwable t = (Throwable)this.throwables.get(requestId);
                    if (t != null) {
                        throw new Error(t);
                    }
                }
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend() throws Error {
            try {
                Object object = this.sync;
                synchronized (object) {
                    ++this.latestRequest;
                    Integer requestId = new Integer(this.latestRequest);
                    this.operationsMap.put(requestId, SUSPEND);
                    this.requests.add(requestId);
                    this.sync.notify();
                    long maxWait = System.currentTimeMillis() + 2000L;
                    while (!this.completedRequests.contains(requestId)) {
                        long waitMillis = maxWait - System.currentTimeMillis();
                        TestCase.assertTrue((waitMillis > 0L ? 1 : 0) != 0);
                        this.sync.wait(waitMillis);
                    }
                    Throwable t = (Throwable)this.throwables.get(requestId);
                    if (t != null) {
                        throw new Error(t);
                    }
                }
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() throws Error {
            try {
                Object object = this.sync;
                synchronized (object) {
                    ++this.latestRequest;
                    Integer requestId = new Integer(this.latestRequest);
                    this.operationsMap.put(requestId, RESUME);
                    this.requests.add(requestId);
                    this.sync.notify();
                    long maxWait = System.currentTimeMillis() + 2000L;
                    while (!this.completedRequests.contains(requestId)) {
                        long waitMillis = maxWait - System.currentTimeMillis();
                        TestCase.assertTrue((waitMillis > 0L ? 1 : 0) != 0);
                        this.sync.wait(waitMillis);
                    }
                    Throwable t = (Throwable)this.throwables.get(requestId);
                    if (t != null) {
                        throw new Error(t);
                    }
                }
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws Error {
            try {
                Object object = this.sync;
                synchronized (object) {
                    ++this.latestRequest;
                    Integer requestId = new Integer(this.latestRequest);
                    this.operationsMap.put(requestId, STOP);
                    this.requests.add(requestId);
                    this.sync.notify();
                    long maxWait = System.currentTimeMillis() + 2000L;
                    while (!this.completedRequests.contains(requestId)) {
                        long waitMillis = maxWait - System.currentTimeMillis();
                        TestCase.assertTrue((waitMillis > 0L ? 1 : 0) != 0);
                        this.sync.wait(waitMillis);
                    }
                    Throwable t = (Throwable)this.throwables.get(requestId);
                    if (t != null) {
                        throw new Error(t);
                    }
                }
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
    }
}

