/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.DistributedSystem;
import java.io.PrintStream;
import java.util.Properties;

public class DistributedSystemConnectPerf {
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java DistributedSystemConnectPerf [options] port iterations");
        err.println("  port          Port on which locator runs");
        err.println("  iterations    Number of times to connect/disconnect");
        err.println("Where options are:");
        err.println("  -wait time    Time (in milliseconds) connection is open");
        err.println("");
        err.println("This program measures the amount of time it takes to connect/disconnect to a DistributedSystem");
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        int port = -1;
        int iterations = -1;
        int wait = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-wait")) {
                if (++i >= args.length) {
                    DistributedSystemConnectPerf.usage("Missing wait time");
                    continue;
                }
                try {
                    wait = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    DistributedSystemConnectPerf.usage("Malformed wait time: " + args[i]);
                }
                continue;
            }
            if (port == -1) {
                try {
                    port = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    DistributedSystemConnectPerf.usage("Malformed port: " + args[i]);
                }
                continue;
            }
            if (iterations == -1) {
                try {
                    iterations = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    DistributedSystemConnectPerf.usage("Malformed iterations: " + args[i]);
                }
                continue;
            }
            DistributedSystemConnectPerf.usage("Extraneous command line: " + args[i]);
        }
        if (port == -1) {
            DistributedSystemConnectPerf.usage("Missing port");
        } else if (iterations == -1) {
            DistributedSystemConnectPerf.usage("Missing iterations");
        }
        System.setProperty("DistributionManager.VERBOSE", "true");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "info");
        props.setProperty("locators", "localhost[" + port + "]");
        long totalConnect = 0L;
        long totalDisconnect = 0L;
        for (int i = 0; i < iterations; ++i) {
            long start = System.currentTimeMillis();
            DistributedSystem system = DistributedSystem.connect((Properties)props);
            long delta = System.currentTimeMillis() - start;
            totalConnect += delta;
            out.println("** Connected to DistributedSystem (took " + delta + " ms)");
            Thread.sleep(wait);
            start = System.currentTimeMillis();
            system.disconnect();
            delta = System.currentTimeMillis() - start;
            totalDisconnect += delta;
            out.println("** Disconnected from DistributedSystem (took " + delta + " ms)");
        }
        out.println("** Average connect time took: " + totalConnect / (long)iterations + " ms");
        out.println("** Average disconnect time took: " + totalDisconnect / (long)iterations + " ms");
        System.exit(0);
    }
}

