/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.AbstractLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.AbstractServerLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.ServerLauncher;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessStreamReader;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.org.jgroups.util.GFLogWriter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import quickstart.ProcessWrapper;

public class ServerLauncherRemoteDUnitTest
extends AbstractServerLauncherDUnitTestCase {
    protected volatile transient Process process;
    protected volatile transient ProcessStreamReader processOutReader;
    protected volatile transient ProcessStreamReader processErrReader;
    protected volatile transient File workingDirectory = null;

    public ServerLauncherRemoteDUnitTest(String name) {
        super(name);
    }

    @Override
    protected final void subSetUp1() throws Exception {
        this.subSetUp2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void subTearDown1() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.processOutReader != null && this.processOutReader.isRunning()) {
            this.processOutReader.stop();
        }
        if (this.processErrReader != null && this.processErrReader.isRunning()) {
            this.processErrReader.stop();
        }
        if (this.workingDirectory != null) {
            this.workingDirectory = null;
        }
        this.subTearDown2();
    }

    protected void subSetUp2() throws Exception {
    }

    protected void subTearDown2() throws Exception {
    }

    protected AbstractLauncher.Status getExpectedStopStatusForNotRunning() {
        return AbstractLauncher.Status.NOT_RESPONDING;
    }

    public void testIsAttachAPIFound() throws Exception {
        ProcessControllerFactory factory = new ProcessControllerFactory();
        ServerLauncherRemoteDUnitTest.assertTrue((boolean)factory.isAttachAPIFound());
        ServerLauncherRemoteDUnitTest.invokeInEveryVM(new SerializableRunnable("isAttachAPIFound"){

            @Override
            public void run() {
                ProcessControllerFactory factory = new ProcessControllerFactory();
                TestCase.assertTrue((boolean)factory.isAttachAPIFound());
            }
        });
    }

    public void broken_testRunningServerOutlivesForkingProcess() throws Throwable {
        Throwable failure;
        block6: {
            ServerLauncher dirLauncher;
            int pid;
            block5: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                File file = new File(this.workingDirectory, ServerLauncherForkingProcess.class.getSimpleName().concat(".log"));
                ProcessWrapper pw = new ProcessWrapper(ServerLauncherForkingProcess.class);
                pw.execute(null, this.workingDirectory).waitFor(true);
                failure = null;
                pid = 0;
                String serverName = ServerLauncherForkingProcess.class.getSimpleName() + "_server";
                dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart(dirLauncher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = serverName + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncher.ServerState actualStatus = dirLauncher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)actualStatus);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    ServerLauncherRemoteDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    ServerLauncherRemoteDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertEquals((String)this.workingDirectory.getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    ServerLauncherRemoteDUnitTest.assertEquals(ServerLauncherForkingProcess.getJvmArguments(), (Object)actualStatus.getJvmArguments());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)(this.workingDirectory.getCanonicalPath() + File.separator + serverName + ".log"), (String)actualStatus.getLogFile());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)serverName, (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartCreatesPidFile() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncher.ServerState serverState = this.launcher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)serverState);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)serverState.getStatus());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartDeletesStaleControlFiles() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.stopRequestFile = new File(this.workingDirectory, ProcessType.SERVER.getStopRequestFileName());
                this.stopRequestFile.createNewFile();
                ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.stopRequestFile.exists());
                this.statusRequestFile = new File(this.workingDirectory, ProcessType.SERVER.getStatusRequestFileName());
                this.statusRequestFile.createNewFile();
                ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.statusRequestFile.exists());
                this.statusFile = new File(this.workingDirectory, ProcessType.SERVER.getStatusFileName());
                this.statusFile.createNewFile();
                ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.statusFile.exists());
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    this.waitForFileToDelete(this.stopRequestFile);
                    this.waitForFileToDelete(this.statusRequestFile);
                    this.waitForFileToDelete(this.statusFile);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartOverwritesStalePidFile() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                ServerLauncherRemoteDUnitTest.assertTrue((String)(this.getUniqueName() + " is broken if PID == Integer.MAX_VALUE"), (ProcessUtils.identifyPid() != Integer.MAX_VALUE ? 1 : 0) != 0);
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                this.writePid(this.pidFile, Integer.MAX_VALUE);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherRemoteDUnitTest.assertFalse((pid == Integer.MAX_VALUE ? 1 : 0) != 0);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingDisableDefaultServerLeavesPortFree() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ServerLauncherRemoteDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-Dgemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT=" + this.serverPort);
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    ServerLauncherRemoteDUnitTest.assertEquals((String)("Port should be \"\" instead of " + portString), (String)"", (String)portString);
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingDisableDefaultServerSkipsPortCheck() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.serverPort, 50, null, (GFLogWriter)ServerLauncherRemoteDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                ServerLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-Dgemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT=" + this.serverPort);
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    ServerLauncherRemoteDUnitTest.assertEquals((String)("Port should be \"\" instead of " + portString), (String)"", (String)portString);
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        ServerLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingForceOverwritesExistingPidFile() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                int otherPid = ServerLauncherRemoteDUnitTest.getPid();
                ServerLauncherRemoteDUnitTest.assertTrue((String)("Pid " + otherPid + " should be alive"), (boolean)this.isPidAlive(otherPid));
                this.writePid(this.pidFile, otherPid);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                command.add("--force");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherRemoteDUnitTest.assertTrue((pid != otherPid ? 1 : 0) != 0);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingServerPortInUseFails() throws Throwable {
        Throwable failure;
        block12: {
            ServerLauncher dirLauncher;
            AtomicBoolean outputContainedExpectedString;
            block11: {
                block10: {
                    this.workingDirectory = new File(this.getUniqueName());
                    this.workingDirectory.mkdir();
                    ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                    this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.serverPort, 50, null, (GFLogWriter)ServerLauncherRemoteDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                    ArrayList<String> jvmArguments = new ArrayList<String>();
                    jvmArguments.add("-D" + this.getUniqueName() + "=true");
                    jvmArguments.add("-Dgemfire.log-level=config");
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                    for (String jvmArgument : jvmArguments) {
                        command.add(jvmArgument);
                    }
                    command.add("-cp");
                    command.add(System.getProperty("java.class.path"));
                    command.add(ServerLauncher.class.getName());
                    command.add(ServerLauncher.Command.START.getName());
                    command.add(this.getUniqueName());
                    command.add("--redirect-output");
                    command.add("--server-port=" + this.serverPort);
                    String expectedString = "java.net.BindException";
                    outputContainedExpectedString = new AtomicBoolean();
                    this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                    this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createExpectedListener("sysout", this.getUniqueName() + "#sysout", expectedString, outputContainedExpectedString)).start();
                    this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createExpectedListener("syserr", this.getUniqueName() + "#syserr", expectedString, outputContainedExpectedString)).start();
                    failure = null;
                    dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                    try {
                        int code = this.process.waitFor();
                        ServerLauncherRemoteDUnitTest.assertEquals((String)("Expected exit code 1 but was " + code), (int)1, (int)code);
                    }
                    catch (Throwable e) {
                        ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                try {
                    ServerLauncher.ServerState serverState = dirLauncher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)serverState);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)serverState.getStatus());
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertFalse((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            ServerLauncherRemoteDUnitTest.assertTrue((boolean)outputContainedExpectedString.get());
            ServerLauncher.ServerState status = null;
            try {
                status = dirLauncher.stop();
            }
            catch (Throwable logFileName) {
                // empty catch block
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingServerPortOverridesCacheXml() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.workingDirectory.isDirectory());
                CacheCreation creation = new CacheCreation();
                RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
                attrs.setScope(Scope.DISTRIBUTED_ACK);
                attrs.setDataPolicy(DataPolicy.REPLICATE);
                creation.createRegion(this.getUniqueName(), (RegionAttributes)attrs);
                creation.addCacheServer().setPort(freeTCPPorts[0]);
                this.cacheXmlFile = new File(this.workingDirectory, this.getUniqueName() + ".xml");
                boolean useSchema = false;
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(this.cacheXmlFile), true);
                CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)false, (String)"7_5");
                pw.close();
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                jvmArguments.add("-Dgemfire.cache-xml-file=" + this.cacheXmlFile.getCanonicalPath());
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--redirect-output");
                command.add("--server-port=" + freeTCPPorts[1]);
                String expectedString = "java.net.BindException";
                AtomicBoolean outputContainedExpectedString = new AtomicBoolean();
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createExpectedListener("sysout", this.getUniqueName() + "#sysout", expectedString, outputContainedExpectedString)).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createExpectedListener("syserr", this.getUniqueName() + "#syserr", expectedString, outputContainedExpectedString)).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)freeTCPPorts[0], (int)0));
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)freeTCPPorts[1], (int)0));
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    int port = Integer.valueOf(portString);
                    ServerLauncherRemoteDUnitTest.assertEquals((String)("Port should be " + freeTCPPorts[1] + " instead of " + port), (int)freeTCPPorts[1], (int)port);
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingServerPortUsedInsteadOfDefaultCacheXml() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                CacheCreation creation = new CacheCreation();
                RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
                attrs.setScope(Scope.DISTRIBUTED_ACK);
                attrs.setDataPolicy(DataPolicy.REPLICATE);
                creation.createRegion(this.getUniqueName(), (RegionAttributes)attrs);
                creation.addCacheServer();
                this.cacheXmlFile = new File(this.workingDirectory, this.getUniqueName() + ".xml");
                boolean useSchema = false;
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(this.cacheXmlFile), true);
                CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)false, (String)"7_5");
                pw.close();
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                jvmArguments.add("-Dgemfire.cache-xml-file=" + this.cacheXmlFile.getCanonicalPath());
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--redirect-output");
                command.add("--server-port=" + this.serverPort);
                String expectedString = "java.net.BindException";
                AtomicBoolean outputContainedExpectedString = new AtomicBoolean();
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createExpectedListener("sysout", this.getUniqueName() + "#sysout", "java.net.BindException", outputContainedExpectedString)).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createExpectedListener("syserr", this.getUniqueName() + "#syserr", "java.net.BindException", outputContainedExpectedString)).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    int port = Integer.valueOf(portString);
                    ServerLauncherRemoteDUnitTest.assertEquals((String)("Port should be " + this.serverPort + " instead of " + port), (int)this.serverPort, (int)port);
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithDefaultPortInUseFails() throws Throwable {
        Throwable failure;
        block12: {
            ServerLauncher dirLauncher;
            AtomicBoolean outputContainedExpectedString;
            block11: {
                block10: {
                    this.workingDirectory = new File(this.getUniqueName());
                    this.workingDirectory.mkdir();
                    ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                    String expectedString = "java.net.BindException";
                    outputContainedExpectedString = new AtomicBoolean();
                    this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.serverPort, 50, null, (GFLogWriter)ServerLauncherRemoteDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                    ArrayList<String> jvmArguments = new ArrayList<String>();
                    jvmArguments.add("-Dgemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT=" + this.serverPort);
                    jvmArguments.add("-D" + this.getUniqueName() + "=true");
                    jvmArguments.add("-Dgemfire.log-level=config");
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                    for (String jvmArgument : jvmArguments) {
                        command.add(jvmArgument);
                    }
                    command.add("-cp");
                    command.add(System.getProperty("java.class.path"));
                    command.add(ServerLauncher.class.getName());
                    command.add(ServerLauncher.Command.START.getName());
                    command.add(this.getUniqueName());
                    command.add("--redirect-output");
                    this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                    this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createExpectedListener("sysout", this.getUniqueName() + "#sysout", expectedString, outputContainedExpectedString)).start();
                    this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createExpectedListener("syserr", this.getUniqueName() + "#syserr", expectedString, outputContainedExpectedString)).start();
                    failure = null;
                    dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                    try {
                        int code = this.process.waitFor();
                        ServerLauncherRemoteDUnitTest.assertEquals((String)("Expected exit code 1 but was " + code), (int)1, (int)code);
                    }
                    catch (Throwable e) {
                        ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                try {
                    ServerLauncher.ServerState serverState = dirLauncher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)serverState);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)serverState.getStatus());
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertFalse((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            ServerLauncherRemoteDUnitTest.assertTrue((boolean)outputContainedExpectedString.get());
            ServerLauncher.ServerState status = null;
            try {
                status = dirLauncher.stop();
            }
            catch (Throwable logFileName) {
                // empty catch block
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithExistingPidFileFails() throws Throwable {
        Throwable failure;
        block12: {
            ServerLauncher dirLauncher;
            block11: {
                block10: {
                    this.workingDirectory = new File(this.getUniqueName());
                    this.workingDirectory.mkdir();
                    ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    int realPid = Host.getHost(0).getVM(3).invokeInt(ProcessUtils.class, "identifyPid");
                    ServerLauncherRemoteDUnitTest.assertFalse((String)("Remote pid shouldn't be the same as local pid " + realPid), (realPid == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                    this.writePid(this.pidFile, realPid);
                    ArrayList<String> jvmArguments = new ArrayList<String>();
                    jvmArguments.add("-D" + this.getUniqueName() + "=true");
                    jvmArguments.add("-Dgemfire.log-level=config");
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                    for (String jvmArgument : jvmArguments) {
                        command.add(jvmArgument);
                    }
                    command.add("-cp");
                    command.add(System.getProperty("java.class.path"));
                    command.add(ServerLauncher.class.getName());
                    command.add(ServerLauncher.Command.START.getName());
                    command.add(this.getUniqueName());
                    command.add("--disable-default-server");
                    command.add("--redirect-output");
                    this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                    this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                    this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                    failure = null;
                    dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                    try {
                        this.waitForServerToStart(dirLauncher, 10000L, false);
                    }
                    catch (Throwable e) {
                        ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                try {
                    ServerLauncher.ServerState serverState = dirLauncher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)serverState);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)serverState.getStatus());
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertFalse((String)("Log file should not exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            ServerLauncher.ServerState status = null;
            try {
                status = dirLauncher.stop();
            }
            catch (Throwable logFileName) {
                // empty catch block
            }
            try {
                AbstractLauncher.Status theStatus = status.getStatus();
                ServerLauncherRemoteDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.STARTING ? 1 : 0) != 0);
                ServerLauncherRemoteDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.ONLINE ? 1 : 0) != 0);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingPid() throws Throwable {
        Throwable failure;
        block9: {
            ServerLauncher pidLauncher;
            int pid;
            block8: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                pidLauncher = null;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    pidLauncher = new ServerLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)pidLauncher);
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    ServerLauncher.ServerState actualStatus = pidLauncher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)actualStatus);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    ServerLauncherRemoteDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    ServerLauncherRemoteDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertEquals((String)this.workingDirectory.getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    ServerLauncherRemoteDUnitTest.assertEquals(jvmArguments, (Object)actualStatus.getJvmArguments());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)(this.workingDirectory.getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                if (pidLauncher == null) {
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                } else {
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)pidLauncher.stop().getStatus());
                }
                this.waitForPidToStop(pid);
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)this.launcher);
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)this.launcher.isRunning());
                    ServerLauncher.ServerState actualStatus = this.launcher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)actualStatus);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    ServerLauncherRemoteDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    ServerLauncherRemoteDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertEquals((String)this.workingDirectory.getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    ServerLauncherRemoteDUnitTest.assertEquals(jvmArguments, (Object)actualStatus.getJvmArguments());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)(this.workingDirectory.getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    ServerLauncherRemoteDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusWithEmptyPidFile() throws Exception {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
        ServerLauncherRemoteDUnitTest.assertTrue((String)(this.pidFile + " already exists"), (boolean)this.pidFile.createNewFile());
        ServerLauncher dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        try {
            dirLauncher.status();
            ServerLauncherRemoteDUnitTest.fail((String)"Status should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            String expected = "Invalid pid 'null' found in " + this.pidFile.getCanonicalPath();
            ServerLauncherRemoteDUnitTest.assertEquals((String)("Message was " + e.getMessage() + " instead of " + expected), (String)expected, (String)e.getMessage());
        }
    }

    public void testStatusWithNoPidFile() throws Exception {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        ServerLauncher dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        ServerLauncher.ServerState serverState = dirLauncher.status();
        ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)serverState.getStatus());
    }

    public void testStatusWithStalePidFile() throws Exception {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
        boolean pid = false;
        ServerLauncherRemoteDUnitTest.assertFalse((boolean)ProcessUtils.isProcessAlive((int)0));
        this.writePid(this.pidFile, 0);
        ServerLauncher dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        try {
            dirLauncher.status();
            ServerLauncherRemoteDUnitTest.fail((String)"Status should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            String expected = "Invalid pid '0' found in " + this.pidFile.getCanonicalPath();
            ServerLauncherRemoteDUnitTest.assertEquals((String)("Message was " + e.getMessage() + " instead of " + expected), (String)expected, (String)e.getMessage());
        }
    }

    public void testStopUsingPid() throws Throwable {
        Throwable failure;
        block9: {
            ServerLauncher pidLauncher;
            int pid;
            block8: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createLoggingListener("sysout", this.getUniqueName() + "#sysout")).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createLoggingListener("syserr", this.getUniqueName() + "#syserr")).start();
                failure = null;
                pid = 0;
                pidLauncher = null;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    pidLauncher = new ServerLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)pidLauncher);
                    ServerLauncherRemoteDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    ServerLauncher.ServerState status = pidLauncher.status();
                    ServerLauncherRemoteDUnitTest.assertNotNull((Object)status);
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)status.getStatus());
                    ServerLauncherRemoteDUnitTest.assertEquals((int)pid, (int)status.getPid());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                if (pidLauncher == null) {
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                } else {
                    ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)pidLauncher.stop().getStatus());
                }
                this.waitForPidToStop(pid);
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStopUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                ServerLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--disable-default-server");
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForServerToStart();
                    this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                ServerLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
                ServerLauncherRemoteDUnitTest.assertFalse((String)"PID file still exists!", (boolean)this.pidFile.exists());
            }
            catch (Throwable e) {
                ServerLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    protected void waitForServerToStart() {
        ServerLauncherRemoteDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    TestCase.assertNotNull((Object)ServerLauncherRemoteDUnitTest.this.process);
                    try {
                        int value = ServerLauncherRemoteDUnitTest.this.process.exitValue();
                        TestCase.fail((String)("Process has died with exit value " + value + " while waiting for it to start."));
                    }
                    catch (IllegalThreadStateException value) {
                        // empty catch block
                    }
                    ServerLauncher.ServerState serverState = ServerLauncherRemoteDUnitTest.this.launcher.status();
                    TestCase.assertNotNull((Object)serverState);
                    return AbstractLauncher.Status.ONLINE.equals((Object)serverState.getStatus());
                }
                catch (RuntimeException e) {
                    return false;
                }
            }

            @Override
            public String description() {
                return "waiting for local Server to start: " + ServerLauncherRemoteDUnitTest.this.launcher.status();
            }
        }, 300000L, 100L, true);
    }

    public static class ServerLauncherForkingProcess {
        public static List<String> getJvmArguments() {
            ArrayList<String> jvmArguments = new ArrayList<String>();
            jvmArguments.add("-Dgemfire.log-level=config");
            jvmArguments.add("-Dgemfire.mcast-port=0");
            return jvmArguments;
        }

        public static void main(String ... args) throws IOException, PidUnavailableException {
            File file = new File(System.getProperty("user.dir"), ServerLauncherForkingProcess.class.getSimpleName().concat(".log"));
            file.createNewFile();
            LocalLogWriter logWriter = new LocalLogWriter(Integer.MIN_VALUE, new PrintStream(new FileOutputStream(file, true)));
            logWriter.info(ServerLauncherForkingProcess.class.getSimpleName() + "#main PID is " + AbstractLauncherDUnitTestCase.getPid());
            try {
                List<String> jvmArguments = ServerLauncherForkingProcess.getJvmArguments();
                TestCase.assertTrue((jvmArguments.size() == 2 ? 1 : 0) != 0);
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(ServerLauncher.class.getName());
                command.add(ServerLauncher.Command.START.getName());
                command.add(ServerLauncherForkingProcess.class.getSimpleName() + "_server");
                command.add("--disable-default-server");
                command.add("--redirect-output");
                logWriter.info(ServerLauncherForkingProcess.class.getSimpleName() + "#main command: " + command);
                logWriter.info(ServerLauncherForkingProcess.class.getSimpleName() + "#main starting...");
                Process forkedProcess = new ProcessBuilder(command).start();
                logWriter.info(ServerLauncherForkingProcess.class.getSimpleName() + "#main exiting...");
                System.exit(0);
            }
            catch (Throwable t) {
                logWriter.info(ServerLauncherForkingProcess.class.getSimpleName() + "#main error: " + t, t);
                System.exit(-1);
            }
        }
    }
}

