/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.ServerLauncher;
import com.gemstone.gemfire.distributed.ServerLauncherRemoteDUnitTest;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessStreamReader;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.lang.AttachAPINotFoundException;
import dunit.SerializableRunnable;
import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;

public class ServerLauncherRemoteFileDUnitTest
extends ServerLauncherRemoteDUnitTest {
    public ServerLauncherRemoteFileDUnitTest(String name) {
        super(name);
    }

    @Override
    protected void subSetUp2() throws Exception {
        ServerLauncherRemoteFileDUnitTest.disableAttachApi();
        ServerLauncherRemoteFileDUnitTest.invokeInEveryVM(new SerializableRunnable("disableAttachApi"){

            @Override
            public void run() {
                ServerLauncherRemoteFileDUnitTest.disableAttachApi();
            }
        });
    }

    @Override
    protected void subTearDown2() throws Exception {
        ServerLauncherRemoteFileDUnitTest.enableAttachApi();
        ServerLauncherRemoteFileDUnitTest.invokeInEveryVM(new SerializableRunnable("enableAttachApi"){

            @Override
            public void run() {
                ServerLauncherRemoteFileDUnitTest.enableAttachApi();
            }
        });
    }

    @Override
    public void testIsAttachAPIFound() throws Exception {
        ProcessControllerFactory factory = new ProcessControllerFactory();
        ServerLauncherRemoteFileDUnitTest.assertFalse((boolean)factory.isAttachAPIFound());
        ServerLauncherRemoteFileDUnitTest.invokeInEveryVM(new SerializableRunnable("isAttachAPIFound"){

            @Override
            public void run() {
                ProcessControllerFactory factory = new ProcessControllerFactory();
                TestCase.assertFalse((boolean)factory.isAttachAPIFound());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStatusUsingPid() throws Throwable {
        int pid;
        Throwable failure;
        block12: {
            this.workingDirectory = new File(this.getUniqueName());
            this.workingDirectory.mkdir();
            ServerLauncherRemoteFileDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
            ArrayList<String> jvmArguments = new ArrayList<String>();
            jvmArguments.add("-D" + this.getUniqueName() + "=true");
            jvmArguments.add("-Dgemfire.log-level=config");
            ArrayList<String> command = new ArrayList<String>();
            command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
            for (String jvmArgument : jvmArguments) {
                command.add(jvmArgument);
            }
            command.add("-cp");
            command.add(System.getProperty("java.class.path"));
            command.add(ServerLauncher.class.getName());
            command.add(ServerLauncher.Command.START.getName());
            command.add(this.getUniqueName());
            command.add("--disable-default-server");
            command.add("--redirect-output");
            this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
            this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
            this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
            failure = null;
            pid = 0;
            ServerLauncher pidLauncher = null;
            this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
            try {
                this.waitForServerToStart();
                this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                ServerLauncherRemoteFileDUnitTest.assertTrue((boolean)this.pidFile.exists());
                pid = this.readPid(this.pidFile);
                ServerLauncherRemoteFileDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                ServerLauncherRemoteFileDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                String logFileName = this.getUniqueName() + ".log";
                ServerLauncherRemoteFileDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                pidLauncher = new ServerLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                ServerLauncherRemoteFileDUnitTest.assertNotNull((Object)pidLauncher);
                ServerLauncherRemoteFileDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                try {
                    pidLauncher.status();
                    ServerLauncherRemoteFileDUnitTest.fail((String)"FileProcessController should have thrown AttachAPINotFoundException");
                }
                catch (AttachAPINotFoundException attachAPINotFoundException) {}
            }
            catch (Throwable e) {
                ServerLauncherRemoteFileDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        try {
            ServerLauncherRemoteFileDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
            this.waitForPidToStop(pid, true);
            this.waitForFileToDelete(this.pidFile);
        }
        catch (Throwable e) {
            ServerLauncherRemoteFileDUnitTest.getLogWriter().error(e);
            if (failure == null) {
                failure = e;
            }
        }
        finally {
            new File(ProcessType.SERVER.getStatusRequestFileName()).delete();
        }
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStopUsingPid() throws Throwable {
        int pid;
        Throwable failure;
        block12: {
            this.workingDirectory = new File(this.getUniqueName());
            this.workingDirectory.mkdir();
            ServerLauncherRemoteFileDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
            ArrayList<String> jvmArguments = new ArrayList<String>();
            jvmArguments.add("-D" + this.getUniqueName() + "=true");
            jvmArguments.add("-Dgemfire.log-level=config");
            ArrayList<String> command = new ArrayList<String>();
            command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
            for (String jvmArgument : jvmArguments) {
                command.add(jvmArgument);
            }
            command.add("-cp");
            command.add(System.getProperty("java.class.path"));
            command.add(ServerLauncher.class.getName());
            command.add(ServerLauncher.Command.START.getName());
            command.add(this.getUniqueName());
            command.add("--disable-default-server");
            command.add("--redirect-output");
            this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
            this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createLoggingListener("sysout", this.getUniqueName() + "#sysout")).start();
            this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createLoggingListener("syserr", this.getUniqueName() + "#syserr")).start();
            failure = null;
            pid = 0;
            ServerLauncher pidLauncher = null;
            this.launcher = new ServerLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
            try {
                this.waitForServerToStart();
                this.pidFile = new File(this.workingDirectory, ProcessType.SERVER.getPidFileName());
                ServerLauncherRemoteFileDUnitTest.assertTrue((boolean)this.pidFile.exists());
                pid = this.readPid(this.pidFile);
                ServerLauncherRemoteFileDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                ServerLauncherRemoteFileDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                String logFileName = this.getUniqueName() + ".log";
                ServerLauncherRemoteFileDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                pidLauncher = new ServerLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                ServerLauncherRemoteFileDUnitTest.assertNotNull((Object)pidLauncher);
                ServerLauncherRemoteFileDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                try {
                    pidLauncher.stop();
                    ServerLauncherRemoteFileDUnitTest.fail((String)"FileProcessController should have thrown AttachAPINotFoundException");
                }
                catch (AttachAPINotFoundException attachAPINotFoundException) {}
            }
            catch (Throwable e) {
                ServerLauncherRemoteFileDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        try {
            ServerLauncherRemoteFileDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
            this.waitForPidToStop(pid);
            this.waitForFileToDelete(this.pidFile);
        }
        catch (Throwable e) {
            ServerLauncherRemoteFileDUnitTest.getLogWriter().error(e);
            if (failure == null) {
                failure = e;
            }
        }
        finally {
            new File(ProcessType.SERVER.getStopRequestFileName()).delete();
        }
        if (failure != null) {
            throw failure;
        }
    }

    private static void disableAttachApi() {
        System.setProperty("gemfire.test.ProcessControllerFactory.DisableAttachApi", "true");
    }

    private static void enableAttachApi() {
        System.clearProperty("gemfire.test.ProcessControllerFactory.DisableAttachApi");
    }
}

