/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SystemAdmin;
import dunit.DistributedTestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class SystemAdminDUnitTest
extends DistributedTestCase {
    public SystemAdminDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.disconnect();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.disconnect();
    }

    public void disconnect() {
        system = null;
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.isConnected()) {
            SystemAdminDUnitTest.getLogWriter().info("disconnecting(3)");
            sys.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrintStacks() throws Exception {
        Properties p = this.getAllDistributedSystemProperties(this.getDistributedSystemProperties());
        try {
            SystemAdmin inst = new SystemAdmin();
            SystemAdmin.setDistributedSystemProperties((Properties)p);
            String filename2 = this.getUniqueName() + "2.txt";
            ArrayList<String> options = new ArrayList<String>(1);
            options.add(filename2);
            inst.printStacks("print-stacks", options, true);
            this.checkStackDumps(filename2, false);
            this.disconnect();
            String filename1 = this.getUniqueName() + "1.txt";
            options.clear();
            options.add(filename1);
            inst.printStacks("print-stacks", options, false);
            this.checkStackDumps(filename1, true);
        }
        finally {
            DistributionManager.isDedicatedAdminVM = false;
            DistributionManager.isCommandLineAdminVM = false;
            SystemAdmin.setDistributedSystemProperties(null);
        }
    }

    private void checkStackDumps(String filename, boolean isPruned) throws IOException {
        String line;
        boolean setting;
        File file = new File(filename);
        if (!file.exists()) {
            SystemAdminDUnitTest.fail((String)"printStacks did not create a stack dump");
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        boolean foundManagementTask = setting = !isPruned;
        boolean foundGCThread = setting;
        boolean foundFunctionThread = setting;
        do {
            if ((line = in.readLine()) == null) continue;
            if (line.contains("GemFire Garbage Collection")) {
                foundGCThread = true;
                continue;
            }
            if (line.contains("Management Task")) {
                foundManagementTask = true;
                continue;
            }
            if (!line.contains("Function Execution Processor")) continue;
            foundFunctionThread = true;
        } while (line != null);
        if (isPruned) {
            SystemAdminDUnitTest.assertFalse((String)("found a GemFire Garbage Collection thread in stack dump in " + filename), (boolean)foundGCThread);
            SystemAdminDUnitTest.assertFalse((String)("found a Management Task thread in stack dump in " + filename), (boolean)foundManagementTask);
            SystemAdminDUnitTest.assertFalse((String)("found a Function Excecution Processor thread in stack dump in " + filename), (boolean)foundFunctionThread);
        } else {
            SystemAdminDUnitTest.assertTrue((String)("found no GemFire Garbage Collection thread in stack dump in " + filename), (boolean)foundGCThread);
            SystemAdminDUnitTest.assertTrue((String)("found no Management Task thread in stack dump in " + filename), (boolean)foundManagementTask);
            SystemAdminDUnitTest.assertTrue((String)("found no Function Excecution Processor thread in stack dump in " + filename), (boolean)foundFunctionThread);
        }
        file.delete();
    }
}

