/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.SystemMemberType;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.internal.AgentConfigImpl;
import com.gemstone.gemfire.admin.jmx.internal.AgentImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.AbstractDistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigSnapshot;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.HostHelper;
import hydra.Log;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class AgentTest
extends CacheTestCase {
    private Agent agent = null;
    protected MBeanServerConnection mbs = null;
    private DistributionConfig dsCfg = null;
    private static boolean firstTime = true;
    private File agentPropsFile = null;

    public AgentTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        if (firstTime) {
            AgentTest.disconnectFromDS();
            firstTime = false;
        }
        DistributionManager.isDedicatedAdminVM = true;
        boolean done = false;
        try {
            super.setUp();
            this.populateCache();
            this.dsCfg = new DistributionConfigSnapshot(this.getSystem().getConfig());
            this.agentPropsFile = File.createTempFile("agenttest", "properties");
            this.agentPropsFile.deleteOnExit();
            System.setProperty("gfAgentPropertyFile", this.agentPropsFile.getAbsolutePath());
            String httpPort = String.valueOf(AvailablePort.getRandomAvailablePort((int)0));
            Properties agentProps = new Properties();
            agentProps.setProperty("http-port", httpPort);
            agentProps.setProperty("rmi-enabled", "false");
            agentProps.setProperty("mcast-port", String.valueOf(this.dsCfg.getMcastPort()));
            agentProps.setProperty("locators", this.dsCfg.getLocators());
            agentProps.setProperty("log-file", this.getUniqueName() + "-agent.log");
            agentProps.setProperty("log-level", AgentTest.getDUnitLogLevel());
            agentProps.setProperty("auto-connect", "false");
            this.agent = new AgentImpl((AgentConfig)new AgentConfigImpl(agentProps));
            this.agent.start();
            Log.getLogWriter().info("JMX Agent started successfully...");
            this.mbs = this.agent.getMBeanServer();
            ObjectName agentName = new ObjectName("GemFire:type=Agent");
            AgentTest.assertTrue((boolean)this.mbs.isRegistered(agentName));
            this.dumpMBean(agentName);
            this.mbs.setAttribute(agentName, new Attribute("mcastPort", new Integer(this.dsCfg.getMcastPort())));
            this.mbs.setAttribute(agentName, new Attribute("mcastAddress", HostHelper.getHostAddress(this.dsCfg.getMcastAddress())));
            this.mbs.setAttribute(agentName, new Attribute("bindAddress", this.dsCfg.getBindAddress()));
            this.mbs.setAttribute(agentName, new Attribute("locators", this.dsCfg.getLocators()));
            this.mbs.invoke(agentName, "connectToSystem", new Object[0], new String[0]);
            Log.getLogWriter().info("JMX Agent connected to distributed system successfully...");
            AgentTest.pause(5000);
            done = true;
        }
        finally {
            if (!done) {
                DistributionManager.isDedicatedAdminVM = false;
            }
        }
    }

    private void checkAttributes(ObjectName n, String[] expected) throws Exception {
        this.checkAttributes(n, expected, new ArrayList());
    }

    private void checkAttributes(ObjectName n, String[] expected, List attrNullAllowed) throws Exception {
        MBeanInfo info = this.mbs.getMBeanInfo(n);
        if (expected != null) {
            HashSet<String> atts = new HashSet<String>(Arrays.asList(AgentTest.getFeatureNames(info.getAttributes())));
            for (int i = 0; i < expected.length; ++i) {
                if (atts.remove(expected[i])) continue;
                AgentTest.fail((String)("The attribute " + expected[i] + " did not exist on " + n + " (" + atts + ") - make sure it's defined in SystemMemberRegion.java and admin/jmx/mbeans-descriptors.xml"));
            }
            if (!atts.isEmpty()) {
                StringBuffer msg = new StringBuffer();
                Iterator<String> it = atts.iterator();
                while (it.hasNext()) {
                    msg.append((Object)it.next());
                    msg.append(' ');
                }
                AgentTest.fail((String)("Unexpected attributes " + msg.toString() + "on modelMBean " + n + " (" + atts + ")"));
            }
        }
        this.checkAttributeGettors(n, expected, attrNullAllowed);
    }

    private void checkOps(ObjectName n, String[] expected) throws Exception {
        MBeanInfo info = this.mbs.getMBeanInfo(n);
        HashSet<String> ops = new HashSet<String>(Arrays.asList(AgentTest.getFeatureNames(info.getOperations())));
        for (int i = 0; i < expected.length; ++i) {
            if (ops.remove(expected[i])) continue;
            AgentTest.fail((String)("The operation " + expected[i] + " did not exist on " + n));
        }
        if (!ops.isEmpty()) {
            StringBuffer msg = new StringBuffer();
            Iterator<String> it = ops.iterator();
            while (it.hasNext()) {
                msg.append((Object)it.next());
                msg.append(' ');
            }
            AgentTest.fail((String)("Unexpected operations " + msg.toString() + "on modelMBean " + n));
        }
    }

    private static String[] getFeatureNames(MBeanFeatureInfo[] features) {
        String[] result = new String[features.length];
        for (int i = 0; i < features.length; ++i) {
            result[i] = features[i].getName();
        }
        return result;
    }

    private void dumpMBean(ObjectName n) throws Exception {
        int i;
        MBeanInfo info = this.mbs.getMBeanInfo(n);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.println("DUMP: modelMBean info for: " + n);
        pw.println("  className=" + info.getClassName());
        pw.println("  description=\"" + info.getDescription() + "\"");
        MBeanAttributeInfo[] atts = info.getAttributes();
        for (i = 0; i < atts.length; ++i) {
            pw.println("    att: " + atts[i].getName() + " type=" + atts[i].getType() + (atts[i].isReadable() ? "" : " UNREADABLE") + (atts[i].isWritable() ? "" : " READONLY") + " desc=\"" + atts[i].getDescription() + "\"");
        }
        MBeanOperationInfo[] ops = info.getOperations();
        for (i = 0; i < ops.length; ++i) {
            String impact = "";
            switch (ops[i].getImpact()) {
                case 1: {
                    impact = "ACTION";
                    break;
                }
                case 2: {
                    impact = "ACTION/INFO";
                    break;
                }
                case 0: {
                    impact = "INFO";
                    break;
                }
                case 3: {
                    impact = "UNKNOWN";
                }
            }
            pw.println("    op: " + ops[i].getName() + " impact=" + impact + " returns=" + ops[i].getReturnType() + " desc=\"" + ops[i].getDescription() + "\"");
        }
        pw.flush();
        AgentTest.getLogWriter().info(sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            ObjectName agentName = new ObjectName("GemFire:type=Agent");
            this.mbs.invoke(agentName, "disconnectFromSystem", new Object[0], new String[0]);
            this.mbs.invoke(agentName, "stop", new Object[0], new String[0]);
            this.mbs = null;
            System.setProperty("gfAgentPropertyFile", "agent.properties");
            if (this.agentPropsFile != null) {
                this.agentPropsFile.delete();
                this.agentPropsFile = null;
            }
            super.tearDown2();
            AgentTest.assertFalse((boolean)this.agent.isConnected());
            AgentTest.disconnectAllFromDS();
        }
        finally {
            DistributionManager.isDedicatedAdminVM = false;
        }
    }

    public void testAgent() throws Exception {
        AgentTest.getLogWriter().info("[testAgent] enter");
        this.agent.getLogWriter().info("[testAgent] agent logWriter");
        ObjectName mbeanName = new ObjectName("GemFire:type=Agent");
        AgentTest.assertTrue((boolean)this.mbs.isRegistered(mbeanName));
        this.dumpMBean(mbeanName);
        this.checkAttributes(mbeanName, new String[]{"autoConnect", "connected", "mcastPort", "mcastAddress", "bindAddress", "locators", "membershipPortRange", "logFile", "logLevel", "logFileSizeLimit", "logDiskSpaceLimit", "propertyFile", "version", "systemId", "sslEnabled", "sslProtocols", "sslCiphers", "sslAuthenticationRequired", "sslProperties"});
        this.checkOps(mbeanName, new String[]{"getLog", "connectToSystem", "disconnectFromSystem", "stop", "saveProperties", "addSSLProperty", "removeSSLProperty", "manageDistributedSystem"});
        AgentTest.assertEquals((Object)new Integer(this.dsCfg.getMcastPort()), (Object)this.mbs.getAttribute(mbeanName, "mcastPort"));
        AgentTest.assertEquals((Object)HostHelper.getHostAddress(this.dsCfg.getMcastAddress()), (Object)this.mbs.getAttribute(mbeanName, "mcastAddress"));
        AgentTest.assertEquals((Object)this.dsCfg.getBindAddress(), (Object)this.mbs.getAttribute(mbeanName, "bindAddress"));
        AgentTest.assertEquals((Object)this.dsCfg.getLocators(), (Object)this.mbs.getAttribute(mbeanName, "locators"));
        this.mbs.invoke(mbeanName, "getLog", new Class[0], new String[0]);
        AgentTest.assertTrue((boolean)(this.mbs.getAttribute(mbeanName, "version") instanceof String));
    }

    private void checkAttributeSettor(ObjectName mbeanName, String attName, Object newValue) throws Exception {
        Object origValue = this.mbs.getAttribute(mbeanName, attName);
        this.mbs.setAttribute(mbeanName, new Attribute(attName, newValue));
        AgentTest.assertEquals((Object)newValue, (Object)this.mbs.getAttribute(mbeanName, attName));
        this.mbs.setAttribute(mbeanName, new Attribute(attName, origValue));
    }

    public void testAdminDistributedSystem() throws Exception {
        ObjectName mbeanName = null;
        Set<ObjectName> names = this.mbs.queryNames(null, null);
        for (ObjectName on : names) {
            String v = on.getKeyProperty("type");
            if (v == null || !v.equals("AdminDistributedSystem")) continue;
            if (mbeanName != null) {
                AgentTest.fail((String)"Found more than one AdminDistributedSystem modelMBean");
                continue;
            }
            mbeanName = on;
        }
        if (mbeanName == null) {
            AgentTest.fail((String)"Did not find a AdminDistributedSystem modelMBean");
        }
        AgentTest.assertTrue((boolean)this.mbs.isRegistered(mbeanName));
        this.dumpMBean(mbeanName);
        this.checkAttributes(mbeanName, new String[]{"id", "systemName", "remoteCommand", "mcastPort", "mcastAddress", "locators", "membershipPortRange", "alertLevel", "refreshInterval", "refreshIntervalForStatAlerts", "canPersistStatAlertDefs", "missingPersistentMembers"});
        this.checkOps(mbeanName, new String[]{"start", "stop", "waitToBeConnected", "manageCacheServer", "manageCacheServers", "manageCacheVm", "manageCacheVms", "manageSystemMemberApplications", "monitorGemFireHealth", "displayMergedLogs", "getLicense", "getLatestAlert", "manageDistributionLocator", "manageDistributionLocators", "createDistributionLocator", "manageSystemMember", "getAllStatAlertDefinitions", "updateAlertDefinition", "updateAlertDefinitionForMember", "removeAlertDefinition", "isAlertDefinitionCreated", "revokePersistentMember", "shutDownAllMembers"});
        this.mbs.getAttribute(mbeanName, "id");
        this.checkAttributeSettor(mbeanName, "remoteCommand", "ssh {HOST} {CMD}");
        AgentTest.assertEquals((Object)new Integer(this.dsCfg.getMcastPort()), (Object)this.mbs.getAttribute(mbeanName, "mcastPort"));
        AgentTest.getLogWriter().info("id = " + this.mbs.getAttribute(mbeanName, "id"));
        AgentTest.getLogWriter().info("mcastAddress = " + this.mbs.getAttribute(mbeanName, "mcastAddress"));
        AgentTest.getLogWriter().info("this.dsCfg.getLocators() = " + this.dsCfg.getLocators());
        AgentTest.assertEquals((Object)HostHelper.getHostAddress(this.dsCfg.getMcastAddress()), (Object)this.mbs.getAttribute(mbeanName, "mcastAddress"));
        AgentTest.assertEquals((Object)this.dsCfg.getLocators(), (Object)this.mbs.getAttribute(mbeanName, "locators"));
        final ObjectName nam = mbeanName;
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    ObjectName[] appNames = (ObjectName[])AgentTest.this.mbs.invoke(nam, "manageSystemMemberApplications", new Object[0], new String[0]);
                    return appNames.length == 4;
                }
                catch (Exception e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 2000L, 200L, true);
        ObjectName[] appNames = (ObjectName[])this.mbs.invoke(mbeanName, "manageSystemMemberApplications", new Object[0], new String[0]);
        AgentTest.assertEquals((int)4, (int)appNames.length);
        for (int i = 0; i < appNames.length; ++i) {
            this.checkApp(appNames[i], false);
        }
        ObjectName healthName = (ObjectName)this.mbs.invoke(mbeanName, "monitorGemFireHealth", new Object[0], new String[0]);
        AgentTest.assertNotNull((String)("Got null health MBean for AdminDistributedSystem " + mbeanName), (Object)healthName);
        this.checkHealth(healthName);
        this.mbs.invoke(mbeanName, "displayMergedLogs", new Object[0], new String[0]);
        this.mbs.invoke(mbeanName, "getLicense", new Object[0], new String[0]);
        final String oldAlert = (String)this.mbs.invoke(mbeanName, "getLatestAlert", new Object[0], new String[0]);
        if (!oldAlert.equals("") && oldAlert.indexOf("Could not rename") == -1 && oldAlert.indexOf("resulted in a non-positive timestamp delta") == -1) {
            AgentTest.assertEquals((String)"", (String)oldAlert);
        }
        String msg = "TESTING A VERY UNIQUE AgentTest MESSAGE " + new Date();
        Host host = Host.getHost(0);
        this.writeLogMessage(msg, host.getVM(0));
        final ObjectName nam2 = mbeanName;
        DistributedTestCase.WaitCriterion ev2 = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    String latestAlert = (String)AgentTest.this.mbs.invoke(nam2, "getLatestAlert", new Object[0], new String[0]);
                    return !latestAlert.equals(oldAlert);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev2, 5000L, 200L, true);
        String latestAlert = (String)this.mbs.invoke(mbeanName, "getLatestAlert", new Object[0], new String[0]);
        AgentTest.assertTrue((String)("unexpected alert msg: " + latestAlert), (latestAlert.indexOf(msg) > -1 ? 1 : 0) != 0);
    }

    private void checkApp(ObjectName appName, boolean hasProxy) throws Exception {
        ObjectName mbeanName = appName;
        if (appName.toString().indexOf(SystemMemberType.MANAGER.getName()) < 0) {
            AgentTest.assertTrue((String)("An mbean named \"" + mbeanName + "\" is not registered"), (boolean)this.mbs.isRegistered(mbeanName));
            this.dumpMBean(mbeanName);
            this.checkAttributes(mbeanName, this.getAppAttributes());
            this.checkOps(mbeanName, this.getAppOps());
        }
        Object origValue = this.mbs.getAttribute(mbeanName, "refreshInterval");
        this.checkAttributeSettor(mbeanName, "archive-disk-space-limit", new Integer(1));
        this.checkAttributeSettor(mbeanName, "archive-file-size-limit", new Integer(1));
        this.checkAttributeSettor(mbeanName, "log-disk-space-limit", new Integer(1));
        this.checkAttributeSettor(mbeanName, "log-file-size-limit", new Integer(1));
        this.checkAttributeSettor(mbeanName, "log-level", AgentTest.getDUnitLogLevel());
        this.checkAttributeSettor(mbeanName, "statistic-sample-rate", new Integer(1001));
        this.checkAttributeSettor(mbeanName, "statistic-sampling-enabled", Boolean.FALSE);
        MBeanException ex = null;
        try {
            this.checkAttributeSettor(mbeanName, "refreshInterval", new Integer(0));
        }
        catch (MBeanException mbEx) {
            ex = mbEx;
        }
        AgentTest.assertTrue((String)"RefreshInterval cannot be reset. An Exception is expected", (ex != null ? 1 : 0) != 0);
        this.mbs.invoke(mbeanName, "getLog", new Object[0], new String[0]);
        this.mbs.invoke(mbeanName, "getLicense", new Object[0], new String[0]);
        AgentTest.assertTrue((boolean)(this.mbs.getAttribute(mbeanName, "version") instanceof String));
        this.mbs.invoke(mbeanName, "refreshConfig", new Object[0], new String[0]);
        ObjectName[] statNames = (ObjectName[])this.mbs.invoke(mbeanName, "manageStats", new Object[0], new String[0]);
        for (int i = 0; i < statNames.length; ++i) {
            this.checkStatResource(appName, statNames[i]);
        }
        ObjectName cacheName = (ObjectName)this.mbs.invoke(mbeanName, "manageCache", new Object[0], new String[0]);
        this.checkCache(cacheName, hasProxy);
    }

    private void checkHealth(ObjectName healthName) throws Exception {
        ObjectName mbeanName = healthName;
        AgentTest.assertTrue((String)("An mbean named \"" + mbeanName + "\" is not registered"), (boolean)this.mbs.isRegistered(mbeanName));
        this.dumpMBean(mbeanName);
        this.checkAttributes(mbeanName, this.getHealthAttributes());
        this.checkOps(mbeanName, this.getHealthOps());
        this.checkAttributeGettors(mbeanName, this.getHealthAttributes());
        AgentTest.assertEquals((Object)GemFireHealth.GOOD_HEALTH, (Object)this.mbs.getAttribute(mbeanName, "health"));
    }

    private void checkCache(ObjectName cacheName, boolean hasProxy) throws Exception {
        ObjectName mbeanName = cacheName;
        AgentTest.assertTrue((boolean)this.mbs.isRegistered(mbeanName));
        this.dumpMBean(mbeanName);
        this.checkAttributes(mbeanName, new String[]{"name", "closed", "lockLease", "lockTimeout", "rootRegionNames", "searchTimeout", "upTime", "server", "updateTime", "netsearchesCompleted", "netloadsCompleted", "loadTime", "gets", "netloadTime", "updates", "regions", "entries", "retries", "invalidates", "getInitialImagesInProgress", "destroys", "loadsCompleted", "loadsInProgress", "getInitialImageKeysReceived", "netsearchTime", "getInitialImageTime", "netsearchesInProgress", "getTime", "putTime", "getInitialImageTransactionsReceived", "getInitialImagesCompleted", "puts", "putallTime", "putalls", "creates", "eventQueueSize", "eventQueueThrottleCount", "eventQueueThrottleTime", "eventThreads", "misses", "netloadsInProgress", "txFailureTime", "txCommitTime", "txCommits", "txRollbackLifeTime", "txRollbackTime", "txRollbackChanges", "txRollbacks", "txFailureChanges", "txSuccessLifeTime", "txFailures", "txFailedLifeTime", "txCommitChanges", "txConflictCheckTime", "cacheListenerCallsCompleted", "cacheListenerCallsInProgress", "cacheListenerCallTime", "cacheWriterCallsCompleted", "cacheWriterCallsInProgress", "cacheWriterCallTime", "queryExecutionTime", "queryExecutions", "queryResultsHashCollisionProbeTime", "queryResultsHashCollisions", "partitionedRegionQueryRetries", "indexUpdateInProgress", "indexUpdateCompleted", "indexUpdateTime", "reliableQueuedOps", "reliableRegionsQueuing", "reliableRegionsMissing", "reliableQueueMax", "reliableQueueSize", "reliableRegions", "reliableRegionsMissingFullAccess", "reliableRegionsMissingLimitedAccess", "reliableRegionsMissingNoAccess", "eventsQueued", "partitionedRegions", "clears", "diskTasksWaiting", "evictorJobsStarted", "evictorJobsCompleted", "evictorQueueSize", "evictWorkTime", "nonSingleHopsCount", "metaDataRefreshCount", "deltaUpdates", "deltaUpdatesTime", "deltaFailedUpdates", "deltasPrepared", "deltasPreparedTime", "deltasSent", "deltaFullValuesSent", "deltaFullValuesRequested", "conflatedEvents", "tombstones", "tombstoneGCs", "replicatedTombstonesSize", "nonReplicatedTombstonesSize", "clearTimeouts", "importedEntries", "importTime", "exportedEntries", "exportTime", "compressTime", "compressions", "preCompressedBytes", "decompressions", "postCompressedBytes", "decompressTime", "evictByCriteria_evaluations", "txRemoteRollbackLifeTime", "txRemoteFailureTime", "txRemoteRollbackTime", "txRemoteCommits", "txRemoteFailedLifeTime", "evictByCriteria_evaluationTime", "txRemoteCommitTime", "evictByCriteria_evictionsInProgress", "deltaGetInitialImagesCompleted", "evictByCriteria_evictions", "evictByCriteria_evictionTime", "txRemoteSuccessLifeTime", "txRemoteFailureChanges", "txRemoteRollbacks", "txRemoteFailures", "txRemoteRollbackChanges", "txRemoteCommitChanges"});
        ArrayList<String> ops = new ArrayList<String>();
        ops.add("refresh");
        ops.add("manageRegion");
        ops.add("getStatistics");
        ops.add("manageBridgeServer");
        ops.add("manageBridgeServers");
        ops.add("manageCacheServer");
        ops.add("manageCacheServers");
        ops.add("getSnapshot");
        ops.add("getRegionSnapshot");
        if (hasProxy) {
            ops.add("startCacheProxy");
            ops.add("stopCacheProxy");
        }
        String[] array = new String[ops.size()];
        ops.toArray(array);
        this.checkOps(mbeanName, array);
        AgentTest.assertEquals((Object)Boolean.FALSE, (Object)this.mbs.getAttribute(mbeanName, "closed"));
        this.checkAttributeSettor(mbeanName, "lockLease", new Integer(66));
        this.checkAttributeSettor(mbeanName, "lockTimeout", new Integer(66));
        this.checkAttributeSettor(mbeanName, "searchTimeout", new Integer(66));
        Integer oldValue = (Integer)this.mbs.getAttribute(mbeanName, "upTime");
        Thread.sleep(2000L);
        AgentTest.assertEquals((Object)oldValue, (Object)this.mbs.getAttribute(mbeanName, "upTime"));
        this.mbs.invoke(mbeanName, "refresh", new Object[0], new String[0]);
        Integer newValue = (Integer)this.mbs.getAttribute(mbeanName, "upTime");
        AgentTest.assertTrue((String)("expected " + newValue + " > " + oldValue), (newValue.compareTo(oldValue) > 0 ? 1 : 0) != 0);
        Set roots = (Set)this.mbs.getAttribute(mbeanName, "rootRegionNames");
        for (String regName : roots) {
            ObjectName regionOName = (ObjectName)this.mbs.invoke(mbeanName, "manageRegion", new Object[]{regName}, new String[]{"java.lang.String"});
            this.checkRegion(regionOName, cacheName);
        }
    }

    private void checkRegion(ObjectName regOName, ObjectName cacheName) throws Exception {
        ObjectName mbeanName = regOName;
        AgentTest.assertTrue((boolean)this.mbs.isRegistered(mbeanName));
        this.dumpMBean(mbeanName);
        ArrayList<String> attrNullAllowed = new ArrayList<String>();
        attrNullAllowed.add("partitionAttributes");
        this.checkAttributes(mbeanName, new String[]{"name", "fullPath", "userAttribute", "cacheLoader", "cacheWriter", "evictionAttributes", "cacheListener", "keyConstraint", "regionTimeToLiveTimeLimit", "regionTimeToLiveAction", "entryTimeToLiveTimeLimit", "earlyAck", "entryTimeToLiveAction", "regionIdleTimeoutTimeLimit", "regionIdleTimeoutAction", "entryIdleTimeoutTimeLimit", "entryIdleTimeoutAction", "mirrorType", "scope", "initialCapacity", "dataPolicy", "loadFactor", "concurrencyLevel", "statisticsEnabled", "entryCount", "subregionCount", "lastModifiedTime", "lastAccessedTime", "hitCount", "missCount", "hitRatio", "subregionNames", "subregionFullPaths", "persistBackup", "diskWriteAttributes", "diskDirs", "membershipAttributes", "subscriptionAttributes", "partitionAttributes", "concurrencyChecksEnabled"}, attrNullAllowed);
        this.checkOps(mbeanName, new String[]{"refresh", "getCacheListeners"});
        this.mbs.invoke(mbeanName, "refresh", new Object[0], new String[0]);
        Set subs = (Set)this.mbs.getAttribute(mbeanName, "subregionNames");
        AgentTest.assertEquals((Object)new Integer(subs.size()), (Object)this.mbs.getAttribute(mbeanName, "subregionCount"));
        String regName = (String)this.mbs.getAttribute(mbeanName, "name");
        Iterator it = subs.iterator();
        while (it.hasNext()) {
            String subregName = regName + "/" + (String)it.next();
            ObjectName subRegOName = (ObjectName)this.mbs.invoke(cacheName, "manageRegion", new Object[]{subregName}, new String[]{"java.lang.String"});
            this.checkRegion(subRegOName, mbeanName);
        }
        String[] listeners = (String[])this.mbs.invoke(mbeanName, "getCacheListeners", new Object[0], new String[0]);
        AgentTest.assertTrue((listeners.length == 0 ? 1 : 0) != 0);
    }

    private void checkStatResource(ObjectName appName, ObjectName srName) throws Exception {
        ObjectName mbeanName = srName;
        AgentTest.assertTrue((boolean)this.mbs.isRegistered(mbeanName));
        this.dumpMBean(mbeanName);
        this.checkAttributes(mbeanName, null);
        this.checkOps(mbeanName, new String[]{"refresh", "getStatistics"});
        AgentTest.assertNotNull((Object)this.mbs.getAttribute(mbeanName, "name"));
        AgentTest.assertNotNull((Object)this.mbs.getAttribute(mbeanName, "description"));
        String appId = (String)this.mbs.getAttribute(appName, "id");
        AgentTest.assertNotNull((Object)appId);
        String mbrName = (String)this.mbs.getAttribute(appName, "name");
        AgentTest.assertNotNull((Object)mbrName);
        String owner = (String)this.mbs.getAttribute(mbeanName, "owner");
        if (!mbrName.equals(owner) && !appId.equals(owner)) {
            AgentTest.fail((String)("Owner should be '" + mbrName + "' or '" + appId + "' instead of: " + owner));
        }
        Object origValue = this.mbs.getAttribute(mbeanName, "refreshInterval");
        MBeanException ex = null;
        try {
            this.checkAttributeSettor(mbeanName, "refreshInterval", new Integer(0));
        }
        catch (MBeanException mbEx) {
            ex = mbEx;
        }
        AgentTest.assertTrue((String)"RefreshInterval cannot be reset. An Exception is expected", (ex != null ? 1 : 0) != 0);
        this.mbs.invoke(mbeanName, "refresh", new Object[0], new String[0]);
        this.mbs.invoke(mbeanName, "getStatistics", new Object[0], new String[0]);
    }

    private void checkAttributeGettors(ObjectName mbeanName, String[] atts) throws Exception {
        this.checkAttributeGettors(mbeanName, atts, new ArrayList());
    }

    private void checkAttributeGettors(ObjectName mbeanName, String[] atts, List attrNullAllowed) throws Exception {
        if (atts == null) {
            MBeanInfo info = this.mbs.getMBeanInfo(mbeanName);
            atts = AgentTest.getFeatureNames(info.getAttributes());
        }
        for (int i = 0; i < atts.length; ++i) {
            Object res = this.mbs.getAttribute(mbeanName, atts[i]);
            if (attrNullAllowed.contains(atts[i]) || res != null) continue;
            AgentTest.fail((String)("getAttribute " + atts[i] + " returned null"));
        }
    }

    private String[] getAppAttributes() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList("hasCache", "id", "version", "host", "refreshInterval", "distributedMember"));
        l.addAll(Arrays.asList(AbstractDistributionConfig._getAttNames()));
        return l.toArray(new String[l.size()]);
    }

    private String[] getHealthAttributes() {
        return new String[]{"health", "healthStatus"};
    }

    private String[] getHealthOps() {
        return new String[]{"resetHealth", "getDiagnosis", "manageGemFireHealthConfig"};
    }

    private String[] getAppOps() {
        return new String[]{"getLog", "getLicense", "manageStats", "manageCache", "refreshConfig", "getRoles", "manageStat", "getConfiguration"};
    }

    private String[] getManagerOps() {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList("waitToStart", "waitToStop", "start", "stop", "manageConnectionStats", "manageManagerStats", "manageSharedClassStats", "createProperties", "removeProperties"));
        l.addAll(Arrays.asList(this.getAppOps()));
        return l.toArray(new String[l.size()]);
    }

    private void populateCache() {
        AttributesFactory fact = new AttributesFactory();
        fact.setScope(Scope.DISTRIBUTED_NO_ACK);
        final RegionAttributes rAttr = fact.create();
        SerializableRunnable populator = new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    AgentTest.this.createRegion("cdm-testSubRegion1", rAttr);
                    AgentTest.this.createRegion("cdm-testSubRegion2", rAttr);
                    AgentTest.this.createRegion("cdm-testSubRegion3", rAttr);
                    AgentTest.this.remoteCreateEntry("", "cacheObj1", null);
                    StringBuffer val = new StringBuffer("userDefValue1");
                    AgentTest.this.remoteCreateEntry("", "cacheObj2", val);
                }
                catch (CacheException ce) {
                    TestCase.fail((String)("Exception while populating cache:\n" + (Object)((Object)ce)));
                }
            }
        };
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(populator);
            }
        }
    }

    protected void remoteCreateEntry(String regionName, String entryName, Object value) throws CacheException {
        Region root = this.getRootRegion();
        Region region = root.getSubregion(regionName);
        region.create((Object)entryName, value);
        AgentTest.getLogWriter().info("Put value " + value + " in entry " + entryName + " in region '" + region.getFullPath() + "'");
    }

    protected static void remoteWriteLogMessage(String msg) {
        InternalDistributedSystem.getAnyInstance().getLogWriter().severe(msg);
    }

    private void writeLogMessage(String msg, VM vm) {
        vm.invoke(this.getClass(), "remoteWriteLogMessage", new Object[]{msg});
    }
}

