/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Config;
import com.gemstone.gemfire.internal.admin.Alert;
import com.gemstone.gemfire.internal.admin.AlertListener;
import com.gemstone.gemfire.internal.admin.ApplicationVM;
import com.gemstone.gemfire.internal.admin.DLockInfo;
import com.gemstone.gemfire.internal.admin.EntryValueNode;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.GfManagerAgentConfig;
import com.gemstone.gemfire.internal.admin.GfManagerAgentFactory;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.admin.TransportConfig;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import junit.framework.TestCase;

public class ConsoleDistributionManagerTest
extends CacheTestCase
implements AlertListener {
    protected GfManagerAgent agent = null;
    private static boolean firstTime = true;

    public ConsoleDistributionManagerTest(String name) {
        super(name);
    }

    public void alert(Alert alert) {
        ConsoleDistributionManagerTest.getLogWriter().info("DEBUG: alert=" + alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        boolean finishedSetup = false;
        try {
            if (firstTime) {
                ConsoleDistributionManagerTest.disconnectFromDS();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    ConsoleDistributionManagerTest.fail((String)"interrupted");
                }
                firstTime = false;
            }
            DistributionManager.isDedicatedAdminVM = true;
            super.setUp();
            this.populateCache();
            RemoteTransportConfig transport = null;
            boolean created = !this.isConnectedToDS();
            InternalDistributedSystem ds = this.getSystem();
            transport = new RemoteTransportConfig(ds.getConfig());
            if (created) {
                ConsoleDistributionManagerTest.disconnectFromDS();
            }
            this.agent = GfManagerAgentFactory.getManagerAgent((GfManagerAgentConfig)new GfManagerAgentConfig(null, (TransportConfig)transport, null, 1000, (AlertListener)this, null));
            if (!this.agent.isConnected()) {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ConsoleDistributionManagerTest.this.agent.isConnected();
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
            }
            finishedSetup = true;
        }
        finally {
            if (!finishedSetup) {
                try {
                    this.agent.disconnect();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {}
                try {
                    super.tearDown2();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {}
                try {
                    ConsoleDistributionManagerTest.disconnectFromDS();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable throwable) {}
                DistributionManager.isDedicatedAdminVM = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            this.agent.disconnect();
            super.tearDown2();
            ConsoleDistributionManagerTest.disconnectFromDS();
        }
        finally {
            DistributionManager.isDedicatedAdminVM = false;
        }
    }

    public void testGetDistributionVMType() {
        DM dm = this.agent.getDM();
        InternalDistributedMember ipaddr = dm.getId();
        ConsoleDistributionManagerTest.assertEquals((int)12, (int)ipaddr.getVmKind());
    }

    public void testAgent() {
        ConsoleDistributionManagerTest.assertEquals((String)"expected empty peer array", (int)0, (int)this.agent.listPeers().length);
        int systemCount = 0;
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            systemCount += host.getSystemCount();
        }
        this.agent.disconnect();
        ConsoleDistributionManagerTest.assertTrue((String)"agent should have been disconnected", (!this.agent.isConnected() ? 1 : 0) != 0);
    }

    public void testApplications() throws Exception {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ApplicationVM[] apps = ConsoleDistributionManagerTest.this.agent.listApplications();
                return apps.length >= 4;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        ApplicationVM[] apps = this.agent.listApplications();
        for (int i = 0; i < apps.length; ++i) {
            InetAddress host = apps[i].getHost();
            String appHostName = host.getHostName();
            try {
                InetAddress appHost = InetAddress.getByName(appHostName);
                ConsoleDistributionManagerTest.assertEquals((Object)appHost, (Object)host);
            }
            catch (UnknownHostException ex) {
                ConsoleDistributionManagerTest.fail((String)("Lookup of address for host " + appHostName + " failed because " + ex));
            }
            StatResource[] stats = apps[i].getStats(null);
            ConsoleDistributionManagerTest.assertTrue((stats.length > 0 ? 1 : 0) != 0);
            Config conf = apps[i].getConfig();
            String[] attNames = conf.getAttributeNames();
            boolean foundIt = false;
            for (int j = 0; j < attNames.length; ++j) {
                if (!attNames[j].equals("statistic-sampling-enabled")) continue;
                foundIt = true;
                ConsoleDistributionManagerTest.assertEquals((String)conf.getAttribute(attNames[j]), (String)"true");
                break;
            }
            ConsoleDistributionManagerTest.assertTrue((boolean)foundIt);
            String[] logs = apps[i].getSystemLogs();
            ConsoleDistributionManagerTest.assertTrue((logs.length > 0 ? 1 : 0) != 0);
            ConsoleDistributionManagerTest.assertTrue((logs[0].length() > 0 ? 1 : 0) != 0);
            VM vm = this.findVMForAdminObject((GemFireVM)apps[i]);
            ConsoleDistributionManagerTest.assertNotNull((Object)vm);
            String lockName = "cdm_testlock" + i;
            ConsoleDistributionManagerTest.assertTrue((boolean)this.acquireDistLock(vm, lockName));
            DLockInfo[] locks = apps[i].getDistributedLockInfo();
            ConsoleDistributionManagerTest.assertTrue((locks.length > 0 ? 1 : 0) != 0);
            boolean foundLock = false;
            for (int j = 0; j < locks.length; ++j) {
                if (!locks[j].getLockName().equals(lockName)) continue;
                foundLock = true;
                ConsoleDistributionManagerTest.assertTrue((boolean)locks[j].isAcquired());
            }
            ConsoleDistributionManagerTest.assertTrue((boolean)foundLock);
            Region[] roots = apps[i].getRootRegions();
            if (roots.length == 0) {
                ConsoleDistributionManagerTest.getLogWriter().info("DEBUG: testApplications: apps[" + i + "]=" + apps[i] + " did not have a root region");
                continue;
            }
            Region root = roots[0];
            ConsoleDistributionManagerTest.assertNotNull((Object)root);
            ConsoleDistributionManagerTest.assertEquals((String)"root", (String)root.getName());
            ConsoleDistributionManagerTest.assertEquals((String)"/root", (String)root.getFullPath());
            RegionAttributes attributes = root.getAttributes();
            ConsoleDistributionManagerTest.assertNotNull((Object)attributes);
            if (attributes.getStatisticsEnabled()) {
                ConsoleDistributionManagerTest.assertNotNull((Object)root.getStatistics());
            }
            Set subregions = root.subregions(false);
            ConsoleDistributionManagerTest.assertEquals((int)3, (int)subregions.size());
            ConsoleDistributionManagerTest.assertEquals((int)2, (int)root.keys().size());
            Region.Entry entry = root.getEntry((Object)"cacheObj1");
            ConsoleDistributionManagerTest.assertNotNull((Object)entry);
            if (attributes.getStatisticsEnabled()) {
                ConsoleDistributionManagerTest.assertNotNull((Object)entry.getStatistics());
            }
            ConsoleDistributionManagerTest.assertTrue((boolean)entry.getValue().equals("null"));
            entry = root.getEntry((Object)"cacheObj2");
            ConsoleDistributionManagerTest.assertNotNull((Object)entry);
            Object val = entry.getValue();
            ConsoleDistributionManagerTest.assertTrue((boolean)(val instanceof String));
            ConsoleDistributionManagerTest.assertTrue((((String)val).indexOf("java.lang.StringBuffer") != -1 ? 1 : 0) != 0);
            apps[i].setCacheInspectionMode(300);
            entry = root.getEntry((Object)"cacheObj2");
            ConsoleDistributionManagerTest.assertNotNull((Object)entry);
            val = entry.getValue();
            ConsoleDistributionManagerTest.assertTrue((boolean)(val instanceof EntryValueNode));
            EntryValueNode node = (EntryValueNode)val;
            String type = node.getType();
            ConsoleDistributionManagerTest.assertTrue((type.indexOf("java.lang.StringBuffer") != -1 ? 1 : 0) != 0);
            ConsoleDistributionManagerTest.assertTrue((!node.isPrimitiveOrString() ? 1 : 0) != 0);
            EntryValueNode[] fields = node.getChildren();
            ConsoleDistributionManagerTest.assertNotNull((Object)fields);
            ConsoleDistributionManagerTest.getLogWriter().warning("The tests use StringBuffers for values which might be implmented differently in jdk 1.5");
            int lastIdx = apps.length - 1;
            if (i != lastIdx) continue;
            final int expectedSize = subregions.size() - 1;
            final Region r = (Region)subregions.iterator().next();
            final Region rr = root;
            r.destroyRegion();
            DistributedTestCase.WaitCriterion ev2 = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Set s = rr.subregions(false);
                    return s.size() == expectedSize;
                }

                @Override
                public String description() {
                    return "Waited 20 seconds for region " + r.getFullPath() + "to be destroyed.";
                }
            };
            DistributedTestCase.waitForCriterion(ev2, 20000L, 200L, true);
        }
    }

    private void populateCache() {
        AttributesFactory fact = new AttributesFactory();
        fact.setScope(Scope.DISTRIBUTED_NO_ACK);
        final RegionAttributes rAttr = fact.create();
        SerializableRunnable populator = new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    ConsoleDistributionManagerTest.this.createRegion("cdm-testSubRegion1", rAttr);
                    ConsoleDistributionManagerTest.this.createRegion("cdm-testSubRegion2", rAttr);
                    ConsoleDistributionManagerTest.this.createRegion("cdm-testSubRegion3", rAttr);
                    ConsoleDistributionManagerTest.this.remoteCreateEntry("", "cacheObj1", null);
                    StringBuffer val = new StringBuffer("userDefValue1");
                    ConsoleDistributionManagerTest.this.remoteCreateEntry("", "cacheObj2", val);
                }
                catch (CacheException ce) {
                    TestCase.fail((String)("Exception while populating cache:\n" + (Object)((Object)ce)));
                }
            }
        };
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(populator);
            }
        }
    }

    protected void remoteCreateEntry(String regionName, String entryName, Object value) throws CacheException {
        Region root = this.getRootRegion();
        Region region = root.getSubregion(regionName);
        region.create((Object)entryName, value);
        ConsoleDistributionManagerTest.getLogWriter().info("Put value " + value + " in entry " + entryName + " in region '" + region.getFullPath() + "'");
    }

    protected static long remoteGetConId() {
        return InternalDistributedSystem.getAnyInstance().getId();
    }

    private boolean acquireDistLock(VM vm, String lockName) {
        return vm.invokeBoolean(this.getClass(), "remoteAcquireDistLock", new Object[]{lockName});
    }

    protected static boolean remoteAcquireDistLock(String lockName) {
        String serviceName = "cdmtest_service";
        DistributedLockService service = DistributedLockService.getServiceNamed((String)serviceName);
        if (service == null) {
            service = DistributedLockService.create((String)serviceName, (DistributedSystem)InternalDistributedSystem.getAnyInstance());
        }
        ConsoleDistributionManagerTest.assertNotNull((Object)service);
        try {
            return service.lock((Object)lockName, 1000L, 3000L);
        }
        catch (Exception e) {
            throw new RuntimeException("DEBUG: remoteAcquireDistLock", e);
        }
    }

    private VM findVMForAdminObject(GemFireVM adminObj) {
        for (int i = 0; i < Host.getHostCount(); ++i) {
            Host host = Host.getHost(i);
            for (int j = 0; j < host.getVMCount(); ++j) {
                VM vm = host.getVM(j);
                InternalDistributedMember id = this.getJavaGroupsIdForVM(vm);
                if (!adminObj.getId().equals(id)) continue;
                return vm;
            }
        }
        return null;
    }

    private InternalDistributedMember getJavaGroupsIdForVM(VM vm) {
        return (InternalDistributedMember)vm.invoke(this.getClass(), "remoteGetJavaGroupsIdForVM");
    }

    protected static InternalDistributedMember remoteGetJavaGroupsIdForVM() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        return sys.getDistributionManager().getDistributionManagerId();
    }
}

