/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.shared.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateMessage
extends SerialDistributionMessage {
    private static final DateFormat format = new SimpleDateFormat("M/dd/yyyy hh:mm:ss.SSS");
    private Date date;
    private static final Version[] dsfidVersions = new Version[0];

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void process(DistributionManager dm) {
        Assert.assertTrue((this.date != null ? 1 : 0) != 0);
        System.out.println(format.format(this.date));
    }

    public void reset() {
        this.date = null;
    }

    public int getDSFID() {
        return Integer.MAX_VALUE;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject((Object)this.date, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.date = (Date)DataSerializer.readObject((DataInput)in);
    }

    public String toString() {
        return format.format(this.date);
    }

    public Version[] getSerializationVersions() {
        return dsfidVersions;
    }
}

