/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.protocols.GemFireTimeSync;
import com.gemstone.org.jgroups.stack.Protocol;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;

public class GemFireTimeSyncServiceDUnitTest
extends DistributedTestCase {
    public GemFireTimeSyncServiceDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCoordinatorSyncThreadCancellation() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = GemFireTimeSyncServiceDUnitTest.getServerHostName(host);
        final Properties props = new Properties();
        props.setProperty("locators", host0 + "[" + locatorPort + "]");
        props.setProperty("mcast-port", "0");
        props.setProperty("jmx-manager", "false");
        props.setProperty("enable-network-partition-detection", "true");
        props.setProperty("log-level", GemFireTimeSyncServiceDUnitTest.getDUnitLogLevel());
        props.put("member-timeout", "2000");
        try {
            vm0.invoke(new CacheSerializableRunnable("Starting vm0"){

                @Override
                public void run2() {
                    try {
                        DistributedTestCase.system.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    File myLocatorLogFile = new File("locator-" + locatorPort + ".log");
                    try {
                        Locator.startLocatorAndDS((int)locatorPort, (File)myLocatorLogFile, (Properties)props);
                    }
                    catch (IOException e) {
                        DistributedTestCase.fail("New locator startup failed on port: " + locatorPort, e);
                    }
                }
            });
            vm1.invoke(new CacheSerializableRunnable("Starting vm1"){

                @Override
                public void run2() {
                    DistributedTestCase.disconnectFromDS();
                    DistributedSystem.connect((Properties)props);
                }
            });
            vm2.invoke(new CacheSerializableRunnable("Starting vm1"){

                @Override
                public void run2() {
                    DistributedTestCase.disconnectFromDS();
                    DistributedSystem.connect((Properties)props);
                }
            });
            vm0.invoke(new CacheSerializableRunnable("Shutdown my locator"){

                @Override
                public void run2() throws CacheException {
                    Locator loc = (Locator)InternalLocator.getLocators().iterator().next();
                    InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                    JChannel jchannel = MembershipManagerHelper.getJChannel((DistributedSystem)system);
                    Protocol prot = jchannel.getProtocolStack().findProtocol("GemFireTimeSync");
                    GemFireTimeSync gts = (GemFireTimeSync)prot;
                    TestCase.assertFalse((boolean)gts.isServiceThreadCancelledForTest());
                    loc.stop();
                    system.disconnect();
                }
            });
            vm1.invoke(new CacheSerializableRunnable("Verify vm1 coordinator"){

                @Override
                public void run2() {
                    InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                    DistributedMember coord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
                    TestCase.assertTrue((boolean)coord.equals(system.getDistributedMember()));
                }
            });
            vm1.invoke(new CacheSerializableRunnable("Verify vm1 coordinator"){

                @Override
                public void run2() {
                    InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                    DistributedMember coord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
                    TestCase.assertTrue((boolean)coord.equals(system.getDistributedMember()));
                    JChannel jchannel = MembershipManagerHelper.getJChannel((DistributedSystem)system);
                    Protocol prot = jchannel.getProtocolStack().findProtocol("GemFireTimeSync");
                    GemFireTimeSync gts = (GemFireTimeSync)prot;
                    for (int maxAttempts = 20; maxAttempts > 0 && gts.isServiceThreadCancelledForTest(); --maxAttempts) {
                        DistributedTestCase.pause(100);
                    }
                    TestCase.assertFalse((boolean)gts.isServiceThreadCancelledForTest());
                }
            });
            vm0.invoke(new CacheSerializableRunnable("Restart my locator and verify it's coordinator again"){

                @Override
                public void run2() throws CacheException {
                    try {
                        Locator.startLocatorAndDS((int)locatorPort, null, (Properties)props);
                    }
                    catch (IOException e) {
                        DistributedTestCase.fail("Restart of new locator failed on port: " + locatorPort, e);
                    }
                    InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                    DistributedMember coord = MembershipManagerHelper.getCoordinator((DistributedSystem)system);
                    TestCase.assertTrue((boolean)coord.equals(system.getDistributedMember()));
                    JChannel jchannel = MembershipManagerHelper.getJChannel((DistributedSystem)system);
                    Protocol prot = jchannel.getProtocolStack().findProtocol("GemFireTimeSync");
                    GemFireTimeSync gts = (GemFireTimeSync)prot;
                    for (int maxAttempts = 20; maxAttempts > 0 && gts.isServiceThreadCancelledForTest(); --maxAttempts) {
                        DistributedTestCase.pause(100);
                    }
                    TestCase.assertFalse((boolean)gts.isServiceThreadCancelledForTest());
                }
            });
            vm1.invoke(new CacheSerializableRunnable("Verify vm1 is not coordinator"){

                @Override
                public void run2() throws CacheException {
                    InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                    JChannel jchannel = MembershipManagerHelper.getJChannel((DistributedSystem)system);
                    Protocol prot = jchannel.getProtocolStack().findProtocol("GemFireTimeSync");
                    GemFireTimeSync gts = (GemFireTimeSync)prot;
                    TestCase.assertTrue((boolean)gts.isServiceThreadCancelledForTest());
                }
            });
            vm0.invoke(new CacheSerializableRunnable("Shutdown locator"){

                @Override
                public void run2() throws CacheException {
                    try {
                        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
                        if (system != null) {
                            system.disconnect();
                        }
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Stoping locator failed", e);
                    }
                }
            });
            vm1.invoke(new CacheSerializableRunnable("Shutdown vm1"){

                @Override
                public void run2() throws CacheException {
                    try {
                        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
                        if (system != null) {
                            system.disconnect();
                        }
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Stoping vm1 failed", e);
                    }
                }
            });
            vm2.invoke(new CacheSerializableRunnable("Shutdown vm2"){

                @Override
                public void run2() throws CacheException {
                    try {
                        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
                        if (system != null) {
                            system.disconnect();
                        }
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Stoping vm2 failed", e);
                    }
                }
            });
        }
        catch (Exception ex) {
            try {
                GemFireTimeSyncServiceDUnitTest.fail("Test failed!", ex);
                vm0.invoke(new /* invalid duplicate definition of identical inner class */);
                vm1.invoke(new /* invalid duplicate definition of identical inner class */);
                vm2.invoke(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                vm0.invoke(new /* invalid duplicate definition of identical inner class */);
                vm1.invoke(new /* invalid duplicate definition of identical inner class */);
                vm2.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }
}

