/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import dunit.DistributedTestCase;
import hydra.BasePrms;
import hydra.TestConfig;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class MessagingPerf
extends DistributedTestCase {
    private boolean usesGemFire;

    public MessagingPerf(String name, boolean usesGemFire) {
        super(name);
        this.usesGemFire = usesGemFire;
    }

    @Override
    public void setUp() throws Exception {
        if (this.usesGemFire) {
            super.setUp();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        if (this.usesGemFire) {
            super.tearDown2();
        }
    }

    public abstract void testSendingMessages() throws InterruptedException;

    public static class Prms
    extends BasePrms {
        public static Long messageCount;
        public static Long warmupCount;
        public static Long byteSize;
        public static Long local;

        public static long getMessageCount() {
            return TestConfig.tab().longAt(messageCount, 100L);
        }

        public static long getWarmupCount() {
            return TestConfig.tab().longAt(warmupCount, 100L);
        }

        public static int getByteSize() {
            return TestConfig.tab().intAt(byteSize, 100);
        }

        public static boolean getLocal() {
            return TestConfig.tab().booleanAt(local, false);
        }

        static {
            BasePrms.setValues(Prms.class);
        }
    }

    public static class Message
    extends DistributionMessage {
        public long begin;
        public long number;
        public byte[] bytes = new byte[Prms.getByteSize()];

        public void process(DistributionManager dm) {
        }

        public int getProcessorType() {
            return 0;
        }

        public int getDSFID() {
            return Integer.MAX_VALUE;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeLong(this.begin);
            out.writeLong(this.number);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.begin = in.readLong();
            this.number = in.readLong();
        }

        public String toString() {
            return "Message " + this.number + " begun at " + this.begin;
        }
    }
}

