/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class ProductUseLogDUnitTest
extends DistributedTestCase {
    public ProductUseLogDUnitTest(String name) {
        super(name);
    }

    public void testMembershipMonitoring() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        int locatorPort = AvailablePort.getRandomAvailablePort((int)1);
        Properties p = new Properties();
        p.put("start-locator", "localhost[" + locatorPort + "],peer=false");
        InternalDistributedSystem system = this.getSystem(p);
        InternalLocator locator = (InternalLocator)Locator.getLocator();
        ProductUseLogDUnitTest.assertTrue((boolean)locator.isServerLocator());
        File logFile = new File("locator" + locatorPort + "views.log");
        ProductUseLogDUnitTest.assertTrue((boolean)logFile.exists());
        ProductUseLogDUnitTest.assertTrue((boolean)logFile.exists());
        vm0.invoke(new SerializableRunnable("get system"){

            @Override
            public void run() {
                InternalDistributedSystem system = ProductUseLogDUnitTest.this.getSystem();
                Cache cache = CacheFactory.create((DistributedSystem)system);
                CacheServer server = cache.addCacheServer();
                try {
                    server.start();
                }
                catch (IOException e) {
                    DistributedTestCase.fail("failed to start server", e);
                }
            }
        });
        system.disconnect();
        String logContents = this.readFile(logFile);
        ProductUseLogDUnitTest.assertTrue((String)("expected " + logFile + " to contain a View"), (boolean)logContents.contains("View"));
        ProductUseLogDUnitTest.assertTrue((String)("expected " + logFile + " to contain 'server summary'"), (boolean)logContents.contains("server summary"));
    }

    private String readFile(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder(10000);
        while ((line = reader.readLine()) != null) {
            sb.append(line).append(File.separator);
        }
        return sb.toString();
    }

    @Override
    public void tearDown2() {
        ProductUseLogDUnitTest.disconnectAllFromDS();
    }
}

