/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.deadlock.DeadlockDetector;
import com.gemstone.gemfire.distributed.internal.deadlock.GemFireDeadlockDetector;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class GemFireDeadlockDetectorDUnitTest
extends CacheTestCase {
    private static final Set<Thread> stuckThreads = Collections.synchronizedSet(new HashSet());
    private static final Lock lock = new ReentrantLock();

    @Override
    public void tearDown2() throws Exception {
        GemFireDeadlockDetectorDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                for (Thread thread : stuckThreads) {
                    thread.interrupt();
                }
            }
        });
    }

    public GemFireDeadlockDetectorDUnitTest(String name) {
        super(name);
    }

    public void testNoDeadlock() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        GemFireDeadlockDetectorDUnitTest.disconnectAllFromDS();
        this.createCache(vm0);
        this.createCache(vm1);
        this.getSystem();
        GemFireDeadlockDetector detect = new GemFireDeadlockDetector();
        GemFireDeadlockDetectorDUnitTest.assertEquals(null, (Object)detect.find().findCycle());
    }

    public void testDistributedDeadlockWithFunction() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.getSystem();
        InternalDistributedMember member1 = this.createCache(vm0);
        InternalDistributedMember member2 = this.createCache(vm1);
        this.lockTheLocks(vm0, member2);
        this.lockTheLocks(vm1, member1);
        Thread.sleep(5000L);
        GemFireDeadlockDetector detect = new GemFireDeadlockDetector();
        LinkedList deadlock = detect.find().findCycle();
        GemFireDeadlockDetectorDUnitTest.getLogWriter().info("Deadlock=" + DeadlockDetector.prettyFormat((Collection)deadlock));
        GemFireDeadlockDetectorDUnitTest.assertEquals((int)8, (int)deadlock.size());
    }

    private void lockTheLocks(VM vm0, final InternalDistributedMember member) {
        vm0.invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                lock.lock();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
                ResultCollector collector = FunctionService.onMember((DistributedMember)member).execute((Function)new TestFunction());
                collector.getResult();
                lock.unlock();
            }
        });
    }

    public void testDistributedDeadlockWithDLock() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.lockTheDLocks(vm0, "one", "two");
        this.lockTheDLocks(vm1, "two", "one");
        this.getSystem();
        GemFireDeadlockDetector detect = new GemFireDeadlockDetector();
        LinkedList deadlock = null;
        for (int i = 0; i < 60 && (deadlock = detect.find().findCycle()) == null; ++i) {
            Thread.sleep(1000L);
        }
        GemFireDeadlockDetectorDUnitTest.assertTrue((deadlock != null ? 1 : 0) != 0);
        GemFireDeadlockDetectorDUnitTest.getLogWriter().info("Deadlock=" + DeadlockDetector.prettyFormat((Collection)deadlock));
        GemFireDeadlockDetectorDUnitTest.assertEquals((int)4, (int)deadlock.size());
    }

    private void lockTheDLocks(VM vm, final String first, final String second) {
        vm.invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                GemFireDeadlockDetectorDUnitTest.this.getCache();
                DistributedLockService dls = DistributedLockService.create((String)"deadlock_test", (DistributedSystem)GemFireDeadlockDetectorDUnitTest.this.getSystem());
                dls.lock((Object)first, 10000L, -1L);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                dls.lock((Object)second, 10000L, -1L);
            }
        });
    }

    private InternalDistributedMember createCache(VM vm) {
        return (InternalDistributedMember)vm.invoke(new SerializableCallable(){

            public Object call() {
                GemFireDeadlockDetectorDUnitTest.this.getCache();
                return GemFireDeadlockDetectorDUnitTest.this.getSystem().getDistributedMember();
            }
        });
    }

    private static class TestFunction
    implements Function {
        private static final int LOCK_WAIT_TIME = 1000;

        private TestFunction() {
        }

        public boolean hasResult() {
            return true;
        }

        public void execute(FunctionContext context) {
            try {
                stuckThreads.add(Thread.currentThread());
                lock.tryLock(1000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.getResultSender().lastResult(null);
        }

        public String getId() {
            return this.getClass().getCanonicalName();
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }
}

