/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.locks.DLockGrantor;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;

public class DLockGrantorHelper {
    public static void forceDepartureOf(DistributedLockService dlock, InternalDistributedMember member) {
        DLockGrantor grantor = null;
        try {
            grantor = DLockGrantor.waitForGrantor((DLockService)((DLockService)dlock));
            if (grantor != null) {
                grantor.handleDepartureOf(member, false);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean hasWaitingRequests(DistributedLockService dlock, Object name) {
        DLockGrantor grantor = null;
        try {
            grantor = DLockGrantor.waitForGrantor((DLockService)((DLockService)dlock));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (grantor != null) {
            return grantor.hasWaitingRequests(name);
        }
        return false;
    }

    public static Object getSuspendLockingToken() {
        return DLockService.SUSPEND_LOCKING_TOKEN;
    }
}

