/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxWriter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import junit.framework.TestCase;

public class ClassNotFoundExceptionDUnitTest
extends CacheTestCase {
    public ClassNotFoundExceptionDUnitTest(String name) {
        super(name);
    }

    public void testDataSerializable() throws InterruptedException {
        this.doTest(new ObjectFactory(){

            @Override
            public Object get() {
                return new ClassNotFoundDataSerializable();
            }
        });
    }

    public void testPdx() throws InterruptedException {
        this.doTest(new ObjectFactory(){

            @Override
            public Object get() {
                return new ClassNotFoundPdx(false);
            }
        });
    }

    public void doTest(final ObjectFactory objectFactory) throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int port1 = this.createServerRegion(vm0);
        int port2 = this.createServerRegion(vm1);
        this.createClientRegion(vm2, port1);
        this.createClientRegion(vm3, port2);
        SerializableRunnable putKey = new SerializableRunnable(){

            @Override
            public void run() {
                block5: {
                    Region region = ClassNotFoundExceptionDUnitTest.this.getCache().getRegion("testSimplePdx");
                    region.put((Object)"a", (Object)"b");
                    region.put((Object)"b", (Object)"b");
                    for (int i = 0; i < 10; ++i) {
                        region.put((Object)i, (Object)i);
                    }
                    if (!region.containsKey((Object)"test")) {
                        region.put((Object)"test", objectFactory.get());
                    }
                    try {
                        region.put(objectFactory.get(), objectFactory.get());
                        TestCase.fail((String)"Should have received an exception");
                    }
                    catch (SerializationException i) {
                    }
                    catch (ServerOperationException expected) {
                        if (expected.getCause() instanceof SerializationException || expected.getCause() instanceof ClassNotFoundException) break block5;
                        throw expected;
                    }
                }
            }
        };
        SerializableRunnable getValue = new SerializableRunnable(){

            @Override
            public void run() {
                block3: {
                    Region region = ClassNotFoundExceptionDUnitTest.this.getCache().getRegion("testSimplePdx");
                    try {
                        TestCase.assertNotNull((Object)region.get((Object)"test"));
                        TestCase.fail((String)"Should have received an exception");
                    }
                    catch (SerializationException serializationException) {
                    }
                    catch (ServerOperationException expected) {
                        if (expected.getCause() instanceof SerializationException || expected.getCause() instanceof ClassNotFoundException) break block3;
                        throw expected;
                    }
                }
            }
        };
        SerializableRunnable registerInterest = new SerializableRunnable(){

            @Override
            public void run() {
                block4: {
                    Region region = ClassNotFoundExceptionDUnitTest.this.getCache().getRegion("testSimplePdx");
                    try {
                        ArrayList<Object> keys = new ArrayList<Object>();
                        for (int i = 0; i < 1000; ++i) {
                            keys.add(i);
                        }
                        keys.add("test");
                        region.getAll(keys);
                        TestCase.fail((String)"Should have received an exception");
                    }
                    catch (SerializationException expected) {
                        System.out.println("hi");
                    }
                    catch (ServerOperationException expected) {
                        if (expected.getCause() instanceof SerializationException || expected.getCause() instanceof ClassNotFoundException) break block4;
                        throw expected;
                    }
                }
            }
        };
        vm2.invoke(putKey);
        vm1.invoke(getValue);
        vm3.invoke(getValue);
        vm3.invoke(registerInterest);
        vm1.invoke(putKey);
    }

    private int createServerRegion(VM vm) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                af.setPartitionAttributes(paf.create());
                ClassNotFoundExceptionDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = ClassNotFoundExceptionDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void createClientRegion(final VM vm, final int port) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port);
                cf.setPoolSubscriptionEnabled(true);
                ClientCache cache = ClassNotFoundExceptionDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("testSimplePdx");
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    private static interface ObjectFactory
    extends Serializable {
        public Object get();
    }

    public static class ClassNotFoundPdx
    implements PdxSerializable {
        public ClassNotFoundPdx(boolean throwIt) {
        }

        public ClassNotFoundPdx() throws ClassNotFoundException {
            if (!CachedDeserializableFactory.preferObject()) {
                throw new ClassNotFoundException("Test Exception");
            }
        }

        public void toData(PdxWriter writer) {
            writer.writeString("field1", "string");
        }

        public void fromData(PdxReader reader) {
        }
    }

    private static class ClassNotFoundDataSerializable
    implements DataSerializable {
        public void toData(DataOutput out) throws IOException {
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new ClassNotFoundException("Test exception");
        }
    }
}

