/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.admin.ClientStatsManager;
import com.gemstone.gemfire.internal.admin.remote.ClientHealthStats;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class ClientStatsManagerDUnitTest
extends AdminDUnitTestCase {
    private static final long MAX_WAIT = 60000L;

    public ClientStatsManagerDUnitTest(String name) {
        super(name);
    }

    public void testStats() throws Exception {
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startBridgeServer(vm0, serverPort);
        vm1.invoke(new SerializableRunnable("SetupBridgeClient"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("locators", "");
                ClientStatsManagerDUnitTest.this.getSystem(props);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Class<ClientStatsManager> clazz = ClientStatsManager.class;
                synchronized (ClientStatsManager.class) {
                    ClientStatsManager.lastInitializedCache = null;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), new int[]{serverPort}, false, -1, 1, null, 1000, -1, false, -1, 1000);
                    Cache cache = ClientStatsManagerDUnitTest.this.getCache();
                    Region region = cache.createRegion(ClientStatsManagerDUnitTest.class.getName(), factory.create());
                    region.put((Object)"key", (Object)"value");
                    region.get((Object)"key2");
                    return;
                }
            }
        });
        this.checkForClientStats(1, 1);
    }

    public void testTwoPools() throws Exception {
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startBridgeServer(vm0, serverPort);
        vm1.invoke(new SerializableRunnable("SetupBridgeClient"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("locators", "");
                ClientStatsManagerDUnitTest.this.getSystem(props);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Class<ClientStatsManager> clazz = ClientStatsManager.class;
                synchronized (ClientStatsManager.class) {
                    ClientStatsManager.lastInitializedCache = null;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), new int[]{serverPort}, false, -1, 1, null, 1000, -1, false, -1, 1000);
                    Cache cache = ClientStatsManagerDUnitTest.this.getCache();
                    Region region = cache.createRegion(ClientStatsManagerDUnitTest.class.getName(), factory.create());
                    region.put((Object)"key", (Object)"value");
                    region.get((Object)"key2");
                    return;
                }
            }
        });
        this.checkForClientStats(1, 1);
        vm1.invoke(new SerializableRunnable("CreateNewPool"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cache cache = ClientStatsManagerDUnitTest.this.getCache();
                Region oldRegion = cache.getRegion(ClientStatsManagerDUnitTest.class.getName());
                Pool oldPool = PoolManager.find((Region)oldRegion);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Class<ClientStatsManager> clazz = ClientStatsManager.class;
                synchronized (ClientStatsManager.class) {
                    ClientStatsManager.lastInitializedCache = null;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    BridgeTestCase.configureConnectionPoolWithName(factory, DistributedTestCase.getServerHostName(host), new int[]{serverPort}, false, -1, 1, null, "pool2", 1000, -1, false, -1, 1000);
                    Region newRegion = cache.createRegion(ClientStatsManagerDUnitTest.class.getName() + "-2", factory.create());
                    oldRegion.close();
                    oldPool.destroy();
                    newRegion.put((Object)"key", (Object)"value");
                    newRegion.get((Object)"key2");
                    return;
                }
            }
        });
        this.checkForClientStats(2, 2);
    }

    private void checkForClientStats(final int puts, final int gets) throws Exception, AdminException, InterruptedException {
        final AdminDistributedSystem ds = this.getAdminDistributedSystem();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return ds.getSystemMemberApplications().length != 0;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "Expected some system member applications";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        SystemMember[] members = ds.getSystemMemberApplications();
        final SystemMemberCacheImpl serverCache = (SystemMemberCacheImpl)members[0].getCache();
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                GemFireMemberStatus status = serverCache.getSnapshot();
                if (status.getClientHealthStats().size() == 0) {
                    return false;
                }
                try {
                    Map clientHealthStats = status.getClientHealthStats();
                    Assert.assertEquals((int)1, (int)clientHealthStats.size());
                    ClientHealthStats stats = (ClientHealthStats)clientHealthStats.values().iterator().next();
                    Assert.assertEquals((int)puts, (int)stats.getNumOfPuts());
                    Assert.assertEquals((int)gets, (int)stats.getNumOfGets());
                    return true;
                }
                catch (AssertionFailedError e) {
                    return false;
                }
            }

            @Override
            public String description() {
                GemFireMemberStatus status = serverCache.getSnapshot();
                if (status.getClientHealthStats().size() == 0) {
                    return "expected client health stats to exist";
                }
                Map clientHealthStats = status.getClientHealthStats();
                if (clientHealthStats.size() != 1) {
                    return "expected one client health stats";
                }
                ClientHealthStats stats = (ClientHealthStats)clientHealthStats.values().iterator().next();
                return "Expected puts to be " + puts + " but it was " + stats.getNumOfPuts() + " expected gets to be " + gets + " but it was " + stats.getNumOfGets();
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    private void startBridgeServer(VM vm, final int serverPort) {
        vm.invoke(new SerializableCallable("SetupBridgeServer"){

            public Object call() throws IOException {
                Cache cache = ClientStatsManagerDUnitTest.this.getCache();
                BridgeServer bridge = cache.addBridgeServer();
                bridge.setPort(serverPort);
                bridge.start();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                cache.createRegion(ClientStatsManagerDUnitTest.class.getName(), factory.create());
                cache.createRegion(ClientStatsManagerDUnitTest.class.getName() + "-2", factory.create());
                return null;
            }
        });
    }
}

