/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class Bug33726DUnitTest
extends DistributedTestCase {
    static boolean[] flags = new boolean[2];
    static Cache cache = null;
    static DistributedSystem ds = null;
    static boolean isOK = false;

    public Bug33726DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(Bug33726DUnitTest.class, "closeCache");
        vm1.invoke(Bug33726DUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        try {
            cache.close();
            cache = null;
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testAfterRegionCreate() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(Bug33726DUnitTest.class, "createCacheAndPopulateRegion1");
        vm1.invoke(Bug33726DUnitTest.class, "createCacheAndRegion2");
        boolean pass = vm1.invokeBoolean(Bug33726DUnitTest.class, "testFlag");
        Bug33726DUnitTest.assertTrue((String)"The test failed", (boolean)pass);
    }

    public static void createCacheAndPopulateRegion1() {
        try {
            ds = new Bug33726DUnitTest("temp").getSystem(new Properties());
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.GLOBAL);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr = factory.create();
            Region region = cache.createRegion("testRegion", attr);
            Region subRegion = region.createSubregion("testSubRegion", attr);
            for (int i = 1; i < 100; ++i) {
                region.put((Object)new Integer(i), (Object)new Integer(i));
                subRegion.put((Object)new Integer(i), (Object)new Integer(i));
            }
        }
        catch (Exception ex) {
            Bug33726DUnitTest.fail((String)("Creation of cache failed due to " + ex));
            ex.printStackTrace();
        }
    }

    public static void createCacheAndRegion2() {
        try {
            ds = new Bug33726DUnitTest("temp").getSystem(new Properties());
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setCacheListener((CacheListener)new TestCacheListener());
            factory.setScope(Scope.GLOBAL);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr = factory.create();
            Region region = cache.createRegion("testRegion", attr);
            region.createSubregion("testSubRegion", attr);
        }
        catch (Exception ex) {
            Bug33726DUnitTest.fail((String)("failed due to " + ex));
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testFlag() {
        if (isOK) {
            return isOK;
        }
        Class<Bug33726DUnitTest> clazz = Bug33726DUnitTest.class;
        synchronized (Bug33726DUnitTest.class) {
            if (isOK) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return isOK;
            }
            try {
                Bug33726DUnitTest.class.wait(120000L);
            }
            catch (InterruptedException ie) {
                Bug33726DUnitTest.fail((String)"interrupted");
            }
            return isOK;
        }
    }

    public static class TestCacheListener
    extends CacheListenerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void afterRegionCreate(RegionEvent event) {
            Region region = event.getRegion();
            if (((LocalRegion)region).isInitialized()) {
                String regionPath = event.getRegion().getFullPath();
                if (regionPath.indexOf("/testRegion/testSubRegion") >= 0) {
                    Bug33726DUnitTest.flags[1] = true;
                } else if (regionPath.indexOf("/testRegion") >= 0) {
                    Bug33726DUnitTest.flags[0] = true;
                }
            }
            if (!flags[0] || !flags[1]) return;
            isOK = true;
            Class<Bug33726DUnitTest> clazz = Bug33726DUnitTest.class;
            synchronized (Bug33726DUnitTest.class) {
                Bug33726DUnitTest.class.notify();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

