/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.AbstractOplogDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.concurrent.CustomEntryConcurrentHashMap;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;

public class Bug37377DUnitTest
extends CacheTestCase {
    protected static String regionName = "TestRegion";
    static Properties props = new Properties();
    protected static DistributedSystem distributedSystem = null;
    private static VM vm0 = null;
    private static VM vm1 = null;
    protected static Cache cache = null;
    protected static File[] dirs = null;
    private static final int maxEntries = 10000;

    public Bug37377DUnitTest(String name) {
        super(name);
        File file1 = new File(name + "1");
        file1.mkdir();
        file1.deleteOnExit();
        File file2 = new File(name + "2");
        file2.mkdir();
        file2.deleteOnExit();
        dirs = new File[2];
        Bug37377DUnitTest.dirs[0] = file1;
        Bug37377DUnitTest.dirs[1] = file2;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
    }

    @Override
    public void tearDown2() throws Exception {
        vm1.invoke(this.destroyRegion());
        vm0.invoke(this.destroyRegion());
        super.tearDown2();
    }

    private CacheSerializableRunnable createCacheForVM0() {
        CacheSerializableRunnable createCache = new CacheSerializableRunnable("createCache"){

            @Override
            public void run2() {
                try {
                    distributedSystem = new Bug37377DUnitTest("vm0_diskReg").getSystem(props);
                    TestCase.assertTrue((distributedSystem != null ? 1 : 0) != 0);
                    cache = CacheFactory.create((DistributedSystem)distributedSystem);
                    TestCase.assertTrue((cache != null ? 1 : 0) != 0);
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    factory.setDiskSynchronous(false);
                    factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(dirs).create("Bug37377DUnitTest").getName());
                    RegionAttributes attr = factory.create();
                    cache.createRegion(regionName, attr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)"Error Creating cache / region ");
                }
            }
        };
        return createCache;
    }

    private CacheSerializableRunnable createCacheForVM1() {
        CacheSerializableRunnable createCache = new CacheSerializableRunnable("createCache"){

            @Override
            public void run2() {
                try {
                    distributedSystem = new Bug37377DUnitTest("vm1_diskReg").getSystem(props);
                    TestCase.assertTrue((distributedSystem != null ? 1 : 0) != 0);
                    cache = CacheFactory.create((DistributedSystem)distributedSystem);
                    TestCase.assertTrue((String)"cache found null", (cache != null ? 1 : 0) != 0);
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    factory.setDiskSynchronous(false);
                    factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(dirs).create("Bug37377DUnitTest").getName());
                    RegionAttributes attr = factory.create();
                    DistributedRegion distRegion = new DistributedRegion(regionName, attr, null, (GemFireCacheImpl)cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null));
                    ((AbstractRegionMap)distRegion.entries).setEntryFactory(TestAbstractDiskRegionEntry.getEntryFactory());
                    LocalRegion region = (LocalRegion)((GemFireCacheImpl)cache).createVMRegion(regionName, attr, new InternalRegionArguments().setInternalMetaRegion((LocalRegion)distRegion).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null));
                    TestCase.assertTrue((String)"Local Region is null", (region != null ? 1 : 0) != 0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Error Creating cache / region " + ex));
                }
            }
        };
        return createCache;
    }

    private CacheSerializableRunnable putSomeEntries() {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("putSomeEntries"){

            @Override
            public void run2() {
                TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                Region rgn = cache.getRegion(regionName);
                for (int i = 0; i < 10000; ++i) {
                    rgn.put((Object)new Long(i), (Object)new Long(i));
                }
            }
        };
        return puts;
    }

    private CacheSerializableRunnable destroyRegion() {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("destroyRegion"){

            @Override
            public void run2() {
                try {
                    TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                    Region rgn = cache.getRegion(regionName);
                    rgn.localDestroyRegion();
                    cache.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return puts;
    }

    private CacheSerializableRunnable closeCacheForVM(final int vmNo) {
        CacheSerializableRunnable cclose = new CacheSerializableRunnable("closeCacheForVM"){

            @Override
            public void run2() {
                if (vmNo == 0) {
                    cache.getRegion(regionName).localDestroyRegion();
                }
                TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                cache.close();
            }
        };
        return cclose;
    }

    private CacheSerializableRunnable closeCacheInVM() {
        CacheSerializableRunnable cclose = new CacheSerializableRunnable("closeCacheInVM"){

            @Override
            public void run2() {
                cache.getRegion(regionName).localDestroyRegion();
                TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                cache.close();
            }
        };
        return cclose;
    }

    private CacheSerializableRunnable verifyExtraEntryFromOpLogs() {
        CacheSerializableRunnable verify = new CacheSerializableRunnable("verifyExtraEntryFromOpLogs"){

            @Override
            public void run2() {
                TestCase.assertTrue((String)"Cache is found as null ", (cache != null ? 1 : 0) != 0);
                Region rgn = cache.getRegion(regionName);
                TestCase.assertEquals((int)0, (int)rgn.size());
            }
        };
        return verify;
    }

    public void testGIIputWithClear() {
        vm0.invoke(this.createCacheForVM0());
        vm0.invoke(this.putSomeEntries());
        AsyncInvocation as1 = vm1.invokeAsync(this.createCacheForVM1());
        Bug37377DUnitTest.pause(10000);
        DistributedTestCase.join(as1, 30000L, Bug37377DUnitTest.getLogWriter());
        vm0.invoke(this.closeCacheForVM(0));
        vm1.invoke(this.closeCacheForVM(1));
        vm1.invoke(this.createCacheForVM1());
        vm1.invoke(this.verifyExtraEntryFromOpLogs());
    }

    static class TestAbstractDiskRegionEntry
    extends AbstractOplogDiskRegionEntry {
        private static RegionEntryFactory factory = new RegionEntryFactory(){

            public final RegionEntry createEntry(RegionEntryContext r, Object key, Object value) {
                return new TestAbstractDiskRegionEntry(r, key, value);
            }

            public final Class getEntryClass() {
                return TestAbstractDiskRegionEntry.class;
            }

            public RegionEntryFactory makeVersioned() {
                return this;
            }

            public RegionEntryFactory makeOnHeap() {
                return this;
            }
        };
        private Object key;
        private volatile Object value;

        protected TestAbstractDiskRegionEntry(RegionEntryContext r, Object key, Object value) {
            super(r, value);
            this.key = key;
        }

        public void processVersionTag(EntryEvent ev) {
        }

        public void makeTombstone(LocalRegion r) {
        }

        public boolean initialImageInit(LocalRegion r, long lastModifiedTime, Object newValue, boolean create, boolean wasRecovered, boolean versionTagAccepted) throws RegionClearedException {
            RegionEventImpl event = new RegionEventImpl((Region)r, Operation.REGION_CLEAR, null, true, (DistributedMember)r.cache.getMyId());
            ((DistributedRegion)r).cmnClearRegion(event, false, false);
            boolean result = super.initialImageInit(r, lastModifiedTime, newValue, create, wasRecovered, versionTagAccepted);
            TestCase.fail((String)"expected RegionClearedException");
            return result;
        }

        public static RegionEntryFactory getEntryFactory() {
            return factory;
        }

        public Object getRawKey() {
            return this.key;
        }

        protected void _setRawKey(Object key) {
            this.key = key;
        }

        protected Object getValueField() {
            return this.value;
        }

        protected void setValueField(Object v) {
            this.value = v;
        }

        public DiskId getDiskId() {
            return null;
        }

        public int updateAsyncEntrySize(EnableLRU capacityController) {
            return 0;
        }

        public int getEntryHash() {
            return 0;
        }

        public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
            return null;
        }

        public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        }

        public void setDiskId(RegionEntry oldRe) {
        }

        protected void initialize(RegionEntryContext context, Object value) {
        }

        protected long getlastModifiedField() {
            return 0L;
        }

        protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
            return false;
        }

        protected void setEntryHash(int v) {
        }
    }
}

