/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import junit.framework.TestCase;

public class Bug41091DUnitTest
extends CacheTestCase {
    public Bug41091DUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        Bug41091DUnitTest.disconnectAllFromDS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm3);
        this.startLocatorInVM(vm3, locatorPort);
        try {
            SerializableRunnable createRegion = new SerializableRunnable("create the region"){

                @Override
                public void run() {
                    DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                        public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                            if (message instanceof InitialImageOperation.RequestImageMessage) {
                                InitialImageOperation.RequestImageMessage rim = (InitialImageOperation.RequestImageMessage)message;
                                Region region = Bug41091DUnitTest.this.getCache().getRegion(rim.regionPath);
                                if (region instanceof BucketRegion) {
                                    Bug41091DUnitTest.this.getCache().close();
                                }
                            }
                        }
                    });
                    Properties props = new Properties();
                    props.setProperty("enable-network-partition-detection", "true");
                    props.setProperty("locators", DistributedTestCase.getServerHostName(host) + "[" + locatorPort + "]");
                    Bug41091DUnitTest.this.getSystem(props);
                    Cache cache = Bug41091DUnitTest.this.getCache();
                    AttributesFactory af = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    cache.createRegion("region", af.create());
                }
            };
            vm0.invoke(createRegion);
            vm1.invoke(createRegion);
            vm2.invoke(new SerializableRunnable("create an entry"){

                @Override
                public void run() {
                    Properties props = new Properties();
                    props.setProperty("enable-network-partition-detection", "true");
                    props.setProperty("locators", DistributedTestCase.getServerHostName(host) + "[" + locatorPort + "]");
                    Bug41091DUnitTest.this.getSystem(props);
                    Cache cache = Bug41091DUnitTest.this.getCache();
                    AttributesFactory af = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    paf.setLocalMaxMemory(0);
                    af.setPartitionAttributes(paf.create());
                    Region region = cache.createRegion("region", af.create());
                    region.put((Object)0, (Object)"a");
                }
            });
        }
        catch (Throwable throwable) {
            SerializableRunnable stopLocator = new SerializableRunnable("Stop locator"){

                @Override
                public void run() {
                    TestCase.assertTrue((boolean)Locator.hasLocator());
                    Locator.getLocator().stop();
                    TestCase.assertFalse((boolean)Locator.hasLocator());
                }
            };
            vm3.invoke(stopLocator);
            throw throwable;
        }
        SerializableRunnable stopLocator = new /* invalid duplicate definition of identical inner class */;
        vm3.invoke(stopLocator);
    }

    protected void startLocatorInVM(final VM vm, final int locatorPort) {
        vm.invoke(new SerializableRunnable("Create Locator"){
            final String testName;
            {
                super(x0);
                this.testName = Bug41091DUnitTest.this.getUniqueName();
            }

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(0));
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                props.setProperty("enable-network-partition-detection", "true");
                try {
                    File logFile = new File(this.testName + "-locator" + locatorPort + ".log");
                    InetAddress bindAddr = null;
                    try {
                        bindAddr = InetAddress.getByName(DistributedTestCase.getServerHostName(vm.getHost()));
                    }
                    catch (UnknownHostException uhe) {
                        DistributedTestCase.fail("While resolving bind address ", uhe);
                    }
                    Locator locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, (InetAddress)bindAddr, (Properties)props);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + locatorPort, ex);
                }
            }
        });
    }
}

