/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.ManageBucketMessage;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class Bug41733DUnitTest
extends CacheTestCase {
    public Bug41733DUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        Bug41733DUnitTest.disconnectAllFromDS();
        super.tearDown2();
    }

    public void testCrashAfterBucketCreation() throws Throwable {
        VM vm1;
        block2: {
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            vm1 = host.getVM(1);
            vm0.invoke(new SerializableRunnable("Install observer"){

                @Override
                public void run() {
                    DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                        public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                            if (message instanceof ManageBucketMessage.ManageBucketReplyMessage) {
                                DistributedTestCase.disconnectFromDS();
                            }
                        }
                    });
                }
            });
            this.createPR(vm0, 0);
            this.putData(vm0, 0, 2, "a");
            this.createPR(vm1, 0);
            try {
                this.putData(vm0, 3, 4, "a");
                Bug41733DUnitTest.fail((String)"should have received a cache closed exception");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof DistributedSystemDisconnectedException) break block2;
                throw e;
            }
        }
        Bug41733DUnitTest.assertEquals(Collections.singleton(3), this.getBucketList(vm1));
        this.putData(vm1, 3, 4, "a");
    }

    public void testCrashDuringBucketCreation() throws Throwable {
        VM vm1;
        block2: {
            Host host = Host.getHost(0);
            final VM vm0 = host.getVM(0);
            vm1 = host.getVM(1);
            vm1.invoke(new SerializableRunnable("Install observer"){

                @Override
                public void run() {
                    DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                        public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                            if (message instanceof ManageBucketMessage) {
                                vm0.invoke(DistributedTestCase.class, "disconnectFromDS");
                            }
                        }
                    });
                }
            });
            this.createPR(vm0, 0);
            this.putData(vm0, 0, 2, "a");
            this.createPR(vm1, 0);
            try {
                this.putData(vm0, 3, 4, "a");
                Bug41733DUnitTest.fail((String)"should have received a cache closed exception");
            }
            catch (RMIException e) {
                if (e.getCause() instanceof DistributedSystemDisconnectedException) break block2;
                throw e;
            }
        }
        Bug41733DUnitTest.assertEquals(Collections.singleton(3), this.getBucketList(vm1));
        this.putData(vm1, 3, 4, "a");
    }

    private void createPR(VM vm0, final int redundancy) {
        vm0.invoke(new SerializableRunnable("Create PR"){

            @Override
            public void run() {
                Cache cache = Bug41733DUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(redundancy);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PARTITION);
                cache.createRegion("region", af.create());
            }
        });
    }

    protected void putData(VM vm, final int startKey, final int endKey, final String value) {
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = Bug41733DUnitTest.this.getCache();
                Region region = cache.getRegion("region");
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }

    protected Set<Integer> getBucketList(VM vm0) {
        return this.getBucketList(vm0, "region");
    }

    protected Set<Integer> getBucketList(VM vm0, final String regionName) {
        SerializableCallable getBuckets = new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = Bug41733DUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                return new TreeSet(region.getDataStore().getAllLocalBucketIds());
            }
        };
        return (Set)vm0.invoke(getBuckets);
    }
}

