/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class Bug41957DUnitTest
extends BridgeTestCase {
    public Bug41957DUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        Bug41957DUnitTest.disconnectAllFromDS();
    }

    public void testBug41957() {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        String serverHost = Bug41957DUnitTest.getServerHostName(server.getHost());
        this.createBridgeServer(server, mcastPort, regionName, serverPort, false);
        this.createBridgeClient(client, regionName, serverHost, new int[]{serverPort});
        client.invoke(new CacheSerializableRunnable("register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = Bug41957DUnitTest.this.getRootRegion(regionName);
                int ENTRIES_ON_SERVER = 10;
                for (int i = 1; i <= ENTRIES_ON_SERVER; ++i) {
                    region.registerInterest((Object)("k" + i), InterestResultPolicy.KEYS_VALUES);
                }
                TestCase.assertEquals((int)2, (int)region.size());
            }
        });
        this.stopBridgeServer(server);
    }

    private void createBridgeServer(VM server, final int mcastPort, final String regionName, final int serverPort, final boolean createPR) {
        server.invoke(new CacheSerializableRunnable("Create server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", String.valueOf(mcastPort));
                config.setProperty("locators", "");
                Bug41957DUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setCacheLoader((CacheLoader)new BridgeTestCase.BridgeServerCacheLoader());
                if (createPR) {
                    factory.setDataPolicy(DataPolicy.PARTITION);
                    factory.setPartitionAttributes(new PartitionAttributesFactory().create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = Bug41957DUnitTest.this.createRootRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                }
                int ENTRIES_ON_SERVER = 10;
                for (int i = 1; i <= ENTRIES_ON_SERVER; ++i) {
                    region.create((Object)("k" + i), (Object)("v" + i));
                }
                try {
                    Bug41957DUnitTest.this.startBridgeServer(serverPort);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("While starting CacheServer", e);
                }
            }
        });
    }

    private void createBridgeClient(VM client, final String regionName, final String serverHost, final int[] serverPorts) {
        client.invoke(new CacheSerializableRunnable("Create client"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                config.setProperty("locators", "");
                Bug41957DUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                PoolFactory pf = PoolManager.createFactory();
                pf.setSubscriptionEnabled(true);
                for (int i = 0; i < serverPorts.length; ++i) {
                    pf.addServer(serverHost, serverPorts[i]);
                }
                pf.create("myPool");
                int ENTRIES_ON_CLIENT = 2;
                factory.setPoolName("myPool");
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)ENTRIES_ON_CLIENT));
                Bug41957DUnitTest.this.createRootRegion(regionName, factory.create());
            }
        });
    }

    private void stopBridgeServer(VM server) {
        server.invoke(new CacheSerializableRunnable("Stop Server"){

            @Override
            public void run2() throws CacheException {
                Bug41957DUnitTest.this.stopBridgeServers(Bug41957DUnitTest.this.getCache());
            }
        });
    }
}

