/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;

public class Bug42055DUnitTest
extends CacheTestCase {
    public Bug42055DUnitTest(String name) {
        super(name);
    }

    public void testPROverflow() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableCallable createDataRegion = new SerializableCallable("createDataRegion"){

            public Object call() throws Exception {
                Cache cache = Bug42055DUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                Region region = cache.createRegion("region1", attr.create());
                return null;
            }
        };
        vm0.invoke(createDataRegion);
        SerializableRunnable createEmptyRegion = new SerializableRunnable("createEmptyRegion"){

            @Override
            public void run() {
                Cache cache = Bug42055DUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setLocalMaxMemory(0);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setDataPolicy(DataPolicy.PARTITION);
                attr.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                Region region = cache.createRegion("region1", attr.create());
            }
        };
        vm1.invoke(createEmptyRegion);
    }
}

