/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.Map;
import junit.framework.TestCase;

public class Bug45164DUnitTest
extends CacheTestCase {
    private static final int count = 10000;
    private static final int stride = 3;

    public Bug45164DUnitTest(String name) {
        super(name);
    }

    public void testIterateWhileDestroy() throws Throwable {
        SerializableRunnable destroy = new SerializableRunnable(){

            @Override
            public void run() {
                Region region = Bug45164DUnitTest.this.getCache().getRegion("test");
                for (int j = 0; j < 3333; j += 3) {
                    region.destroy((Object)j);
                }
            }
        };
        SerializableRunnable iterate = new SerializableRunnable(){

            @Override
            public void run() {
                Region region = Bug45164DUnitTest.this.getCache().getRegion("test");
                int i = 0;
                for (Map.Entry entry : region.entrySet()) {
                    ++i;
                    if (entry != null) continue;
                    TestCase.fail((String)("Element " + i + " is null"));
                }
            }
        };
        Host h = Host.getHost(0);
        AsyncInvocation async1 = h.getVM(1).invokeAsync(destroy);
        AsyncInvocation async2 = h.getVM(2).invokeAsync(iterate);
        async1.getResult();
        async2.getResult();
    }

    @Override
    public void setUp() throws Exception {
        SerializableRunnable create = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = Bug45164DUnitTest.this.getCache(new CacheFactory());
                Region region = cache.createRegionFactory(RegionShortcut.PARTITION).create("test");
                if (region == null) {
                    DistributedTestCase.getLogWriter().error("oops!");
                }
            }
        };
        SerializableRunnable load = new SerializableRunnable(){

            @Override
            public void run() {
                Region region = Bug45164DUnitTest.this.getCache().getRegion("test");
                for (int i = 0; i < 10000; ++i) {
                    region.put((Object)i, (Object)i);
                }
            }
        };
        Host h = Host.getHost(0);
        h.getVM(1).invoke(create);
        h.getVM(2).invoke(create);
        h.getVM(3).invoke(create);
        h.getVM(1).invoke(load);
    }
}

