/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class CacheAdvisorTest
extends CacheTestCase {
    private transient VM[] vms;
    private transient InternalDistributedMember[] ids;

    public CacheAdvisorTest(String name) {
        super(name);
    }

    protected InternalDistributedMember getDistributionManagerId() {
        Cache cache = this.getCache();
        DistributedSystem ds = cache.getDistributedSystem();
        return ((InternalDistributedSystem)ds).getDistributionManager().getId();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ArrayList<VM> vmList = new ArrayList<VM>();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vmList.add(vm);
                idList.add(vm.invoke(this, "getDistributionManagerId"));
            }
        }
        this.vms = vmList.toArray(new VM[vmList.size()]);
        this.ids = idList.toArray(new InternalDistributedMember[idList.size()]);
    }

    public void testGenericAdvice() throws Exception {
        final RegionAttributes attrs = new AttributesFactory().create();
        CacheAdvisorTest.assertTrue((boolean)attrs.getScope().isDistributedNoAck());
        CacheAdvisorTest.assertTrue((boolean)attrs.getScope().isDistributed());
        final String rgnName = this.getUniqueName();
        for (int i = 0; i < this.vms.length; ++i) {
            this.vms[i].invoke(new CacheSerializableRunnable("CacheAdvisorTest.testGenericAdvice;createRegion"){

                @Override
                public void run2() throws CacheException {
                    CacheAdvisorTest.this.createRegion(rgnName, attrs);
                }
            });
        }
        HashSet<InternalDistributedMember> expected = new HashSet<InternalDistributedMember>(Arrays.asList(this.ids));
        DistributedRegion rgn = (DistributedRegion)this.createRegion(rgnName, attrs);
        DistributedRegion rootRgn = (DistributedRegion)this.getRootRegion();
        Set actual = rootRgn.getDistributionAdvisor().adviseGeneric();
        CacheAdvisorTest.assertEquals((String)("Unexpected advice for root region=" + rootRgn), expected, (Object)actual);
        actual = rgn.getDistributionAdvisor().adviseGeneric();
        CacheAdvisorTest.assertEquals((String)("Unexpected advice for subregion=" + rgn), expected, (Object)actual);
    }

    public void testNetWriteAdvice() throws Exception {
        final String rgnName = this.getUniqueName();
        HashSet<InternalDistributedMember> expected = new HashSet<InternalDistributedMember>();
        int i = 0;
        while (i < this.vms.length) {
            VM vm = this.vms[i];
            InternalDistributedMember id = this.ids[i];
            if (i % 2 == 0) {
                expected.add(id);
            }
            final int index = i++;
            vm.invoke(new CacheSerializableRunnable("CacheAdvisorTest.testNetWriteAdvice"){

                @Override
                public void run2() throws CacheException {
                    AttributesFactory fac = new AttributesFactory();
                    if (index % 2 == 0) {
                        fac.setCacheWriter((CacheWriter)new CacheWriterAdapter());
                    }
                    CacheAdvisorTest.this.createRegion(rgnName, fac.create());
                }
            });
        }
        RegionAttributes attrs = new AttributesFactory().create();
        DistributedRegion rgn = (DistributedRegion)this.createRegion(rgnName, attrs);
        CacheAdvisorTest.assertEquals(expected, (Object)rgn.getCacheDistributionAdvisor().adviseNetWrite());
    }

    public void testNetLoadAdvice() throws Exception {
        final String rgnName = this.getUniqueName();
        HashSet<InternalDistributedMember> expected = new HashSet<InternalDistributedMember>();
        int i = 0;
        while (i < this.vms.length) {
            VM vm = this.vms[i];
            InternalDistributedMember id = this.ids[i];
            if (i % 2 == 1) {
                expected.add(id);
            }
            final int index = i++;
            vm.invoke(new CacheSerializableRunnable("CacheAdvisorTest.testNetLoadAdvice"){

                @Override
                public void run2() throws CacheException {
                    AttributesFactory fac = new AttributesFactory();
                    if (index % 2 == 1) {
                        fac.setCacheLoader(new CacheLoader(){

                            public Object load(LoaderHelper helper) throws CacheLoaderException {
                                return null;
                            }

                            public void close() {
                            }
                        });
                    }
                    CacheAdvisorTest.this.createRegion(rgnName, fac.create());
                }
            });
        }
        RegionAttributes attrs = new AttributesFactory().create();
        DistributedRegion rgn = (DistributedRegion)this.createRegion(rgnName, attrs);
        CacheAdvisorTest.assertEquals(expected, (Object)rgn.getCacheDistributionAdvisor().adviseNetLoad());
    }

    public void testNetLoadAdviceWithAttributesMutator() throws Exception {
        final String rgnName = this.getUniqueName();
        AttributesFactory fac = new AttributesFactory();
        fac.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attrs = fac.create();
        DistributedRegion rgn = (DistributedRegion)this.createRegion(rgnName, attrs);
        CacheAdvisorTest.invokeInEveryVM(new CacheSerializableRunnable("CachAdvisorTest.testNetLoadAdviceWithAttributesMutator;createRegion"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory f = new AttributesFactory();
                f.setScope(Scope.DISTRIBUTED_ACK);
                CacheAdvisorTest.this.createRegion(rgnName, f.create());
            }
        });
        HashSet<InternalDistributedMember> expected = new HashSet<InternalDistributedMember>();
        for (int i = 1; i < this.vms.length; i += 2) {
            VM vm = this.vms[i];
            final int numVMsMinusOne = this.vms.length;
            InternalDistributedMember id = this.ids[i];
            expected.add(id);
            vm.invoke(new CacheSerializableRunnable("CacheAdvisorTest.testNetLoadAdviceWithAttributesMutator;mutate"){

                @Override
                public void run2() throws CacheException {
                    Region rgn1 = CacheAdvisorTest.this.getRootRegion().getSubregion(rgnName);
                    TestCase.assertEquals((int)numVMsMinusOne, (int)((DistributedRegion)rgn1).getDistributionAdvisor().adviseGeneric().size());
                    AttributesMutator mut = rgn1.getAttributesMutator();
                    mut.setCacheLoader(new CacheLoader(){

                        public Object load(LoaderHelper helper) throws CacheLoaderException {
                            return null;
                        }

                        public void close() {
                        }
                    });
                }
            });
        }
        CacheAdvisorTest.assertEquals(expected, (Object)rgn.getCacheDistributionAdvisor().adviseNetLoad());
    }

    private void basicTestClose(Operation op) throws Exception {
        final RegionAttributes attrs = new AttributesFactory().create();
        final String rgnName = this.getUniqueName();
        for (int i = 0; i < this.vms.length; ++i) {
            this.vms[i].invoke(new CacheSerializableRunnable("CacheAdvisorTest.basicTestClose; createRegion"){

                @Override
                public void run2() throws CacheException {
                    CacheAdvisorTest.this.createRegion(rgnName, attrs);
                }
            });
        }
        DistributedRegion rgn = (DistributedRegion)this.createRegion(rgnName, attrs);
        HashSet<InternalDistributedMember> expected = new HashSet<InternalDistributedMember>(Arrays.asList(this.ids));
        CacheAdvisorTest.assertEquals(expected, (Object)rgn.getDistributionAdvisor().adviseGeneric());
        final InternalDistributedMember myMemberId = this.getSystem().getDistributionManager().getId();
        CacheAdvisorTest.invokeInEveryVM(new CacheSerializableRunnable("CacheAdvisorTest.basicTestClose;verify1"){

            @Override
            public void run2() throws CacheException {
                DistributedRegion rgn1 = (DistributedRegion)CacheAdvisorTest.this.getRootRegion();
                TestCase.assertTrue((boolean)rgn1.getDistributionAdvisor().adviseGeneric().contains(myMemberId));
                rgn1 = (DistributedRegion)rgn1.getSubregion(rgnName);
                TestCase.assertTrue((boolean)rgn1.getDistributionAdvisor().adviseGeneric().contains(myMemberId));
            }
        });
        if (op.equals(Operation.CACHE_CLOSE)) {
            CacheAdvisorTest.closeCache();
        } else if (op.equals(Operation.REGION_CLOSE)) {
            this.getRootRegion().close();
        } else if (op.equals(Operation.REGION_LOCAL_DESTROY)) {
            this.getRootRegion().localDestroyRegion();
        } else {
            CacheAdvisorTest.fail((String)("expected op(" + op + ") to be CACHE_CLOSE, REGION_CLOSE, or REGION_LOCAL_DESTROY"));
        }
        final InternalDistributedMember closedMemberId = this.getSystem().getDistributionManager().getId();
        CacheAdvisorTest.invokeInEveryVM(new CacheSerializableRunnable("CacheAdvisorTest.basicTestClose;verify"){

            @Override
            public void run2() throws CacheException {
                DistributedRegion rgn1 = (DistributedRegion)CacheAdvisorTest.this.getRootRegion();
                TestCase.assertTrue((!rgn1.getDistributionAdvisor().adviseGeneric().contains(closedMemberId) ? 1 : 0) != 0);
                rgn1 = (DistributedRegion)rgn1.getSubregion(rgnName);
                TestCase.assertTrue((!rgn1.getDistributionAdvisor().adviseGeneric().contains(closedMemberId) ? 1 : 0) != 0);
            }
        });
    }

    public void testRegionClose() throws Exception {
        this.basicTestClose(Operation.REGION_CLOSE);
    }

    public void testRegionLocalDestroy() throws Exception {
        this.basicTestClose(Operation.REGION_LOCAL_DESTROY);
    }

    public void testCacheClose() throws Exception {
        this.basicTestClose(Operation.CACHE_CLOSE);
    }
}

