/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class ClientServerGetAllDUnitTest
extends BridgeTestCase {
    public ClientServerGetAllDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        ClientServerGetAllDUnitTest.disconnectAllFromDS();
    }

    public void testGetAllFromServer() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        String serverHost = ClientServerGetAllDUnitTest.getServerHostName(server.getHost());
        this.createBridgeServer(server, mcastPort, regionName, serverPort, false);
        this.createBridgeClient(client, regionName, serverHost, new int[]{serverPort});
        client.invoke(new CacheSerializableRunnable("Get all entries from server"){

            @Override
            public void run2() throws CacheException {
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    keys.add("key-" + i);
                }
                keys.add(BridgeTestCase.NON_EXISTENT_KEY);
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                Map result = region.getAll(keys);
                TestCase.assertEquals((int)6, (int)result.size());
                for (String key : keys) {
                    TestCase.assertTrue((boolean)result.containsKey(key));
                    Object value = result.get(key);
                    if (!key.equals(BridgeTestCase.NON_EXISTENT_KEY)) {
                        TestCase.assertEquals((Object)key, value);
                        continue;
                    }
                    TestCase.assertEquals(null, value);
                }
                TestCase.assertEquals(null, (Object)region.get((Object)BridgeTestCase.NON_EXISTENT_KEY));
            }
        });
        this.stopBridgeServer(server);
    }

    public void testGetSomeFromServer() throws Exception {
        this.testGetFromServer(2);
    }

    public void testGetAllFromClient() throws Exception {
        this.testGetFromServer(5);
    }

    public void testGetAllFromServerWithPR() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int server1Port = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server1);
        int server2Port = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server2);
        String serverHost = ClientServerGetAllDUnitTest.getServerHostName(server1.getHost());
        this.createBridgeServer(server1, mcastPort, regionName, server1Port, true);
        this.createBridgeServer(server2, mcastPort, regionName, server2Port, true);
        this.createBridgeClient(client, regionName, serverHost, new int[]{server1Port, server2Port});
        client.invoke(new CacheSerializableRunnable("Get all entries from server"){

            @Override
            public void run2() throws CacheException {
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                for (int i = 0; i < 200; ++i) {
                    region.put((Object)i, (Object)i);
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    keys.add("key-" + i);
                }
                keys.add(BridgeTestCase.NON_EXISTENT_KEY);
                Map result = region.getAll(keys);
                TestCase.assertEquals((int)6, (int)result.size());
                for (String key : keys) {
                    TestCase.assertTrue((boolean)result.containsKey(key));
                    Object value = result.get(key);
                    if (!key.equals(BridgeTestCase.NON_EXISTENT_KEY)) {
                        TestCase.assertEquals((Object)key, value);
                        continue;
                    }
                    TestCase.assertEquals(null, value);
                }
                TestCase.assertEquals(null, (Object)region.get((Object)BridgeTestCase.NON_EXISTENT_KEY));
            }
        });
        this.stopBridgeServer(server1);
        this.stopBridgeServer(server2);
    }

    private void testGetFromServer(final int numLocalValues) {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        String serverHost = ClientServerGetAllDUnitTest.getServerHostName(server.getHost());
        this.createBridgeServer(server, mcastPort, regionName, serverPort, false);
        this.createBridgeClient(client, regionName, serverHost, new int[]{serverPort});
        client.invoke(new CacheSerializableRunnable("Put entries from client"){

            @Override
            public void run2() throws CacheException {
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                for (int i = 0; i < numLocalValues; ++i) {
                    region.put((Object)("key-" + i), (Object)("value-from-client-" + i));
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("Get all entries from server"){

            @Override
            public void run2() throws CacheException {
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    keys.add("key-" + i);
                }
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                Map result = region.getAll(keys);
                TestCase.assertEquals((int)5, (int)result.size());
                int i = 0;
                for (String key : keys) {
                    TestCase.assertTrue((boolean)result.containsKey(key));
                    Object value = result.get(key);
                    if (i < numLocalValues) {
                        TestCase.assertEquals((Object)("value-from-client-" + i), value);
                    } else {
                        TestCase.assertEquals((Object)key, value);
                    }
                    ++i;
                }
            }
        });
        ClientServerGetAllDUnitTest.addExpectedException("Server unreachable", client);
        this.stopBridgeServer(server);
    }

    public void testGetAllWithExtraKeyFromServer() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        final String regionName = this.getUniqueName();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int serverPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(server);
        String serverHost = ClientServerGetAllDUnitTest.getServerHostName(server.getHost());
        int numLocalValues = 101;
        this.createBridgeServerWithoutLoader(server, mcastPort, regionName, serverPort, false);
        this.createBridgeClient(client, regionName, serverHost, new int[]{serverPort});
        client.invoke(new CacheSerializableRunnable("Put entries from client"){

            @Override
            public void run2() throws CacheException {
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                for (int i = 0; i < 101; ++i) {
                    region.put((Object)("key-" + i), (Object)("value-from-client-" + i));
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("Put entries from server"){

            @Override
            public void run2() throws CacheException {
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                for (int i = 101; i < 202; ++i) {
                    region.put((Object)("key-" + i), (Object)("value-from-server-" + i));
                }
                region.getCache().getLogger().fine("The region entries in server " + region.entrySet());
            }
        });
        client.invoke(new CacheSerializableRunnable("Get all entries from server"){

            @Override
            public void run2() throws CacheException {
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 0; i < 303; ++i) {
                    keys.add("key-" + i);
                }
                Region region = ClientServerGetAllDUnitTest.this.getRootRegion(regionName);
                region.getCache().getLogger().fine("The region entries in client before getAll " + region.entrySet());
                TestCase.assertEquals((int)region.entrySet().size(), (int)101);
                Map result = region.getAll(keys);
                TestCase.assertEquals((int)region.entrySet().size(), (int)202);
                region.getCache().getLogger().fine("The region entries in client after getAll " + region.entrySet());
                TestCase.assertEquals((int)303, (int)result.size());
                int i = 0;
                for (String key : keys) {
                    TestCase.assertTrue((boolean)result.containsKey(key));
                    Object value = result.get(key);
                    if (i < 101) {
                        TestCase.assertEquals((Object)("value-from-client-" + i), value);
                    } else if (i < 202) {
                        TestCase.assertEquals((Object)("value-from-server-" + i), value);
                    } else {
                        TestCase.assertEquals(null, value);
                    }
                    ++i;
                }
            }
        });
        this.stopBridgeServer(server);
    }

    private void createBridgeServer(VM server, final int mcastPort, final String regionName, final int serverPort, final boolean createPR) {
        server.invoke(new CacheSerializableRunnable("Create server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", String.valueOf(mcastPort));
                config.setProperty("locators", "");
                ClientServerGetAllDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setCacheLoader((CacheLoader)new BridgeTestCase.BridgeServerCacheLoader());
                if (createPR) {
                    factory.setDataPolicy(DataPolicy.PARTITION);
                    factory.setPartitionAttributes(new PartitionAttributesFactory().create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = ClientServerGetAllDUnitTest.this.createRootRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                }
                try {
                    ClientServerGetAllDUnitTest.this.startBridgeServer(serverPort);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("While starting CacheServer", e);
                }
            }
        });
    }

    private void createBridgeServerWithoutLoader(VM server, final int mcastPort, final String regionName, final int serverPort, final boolean createPR) {
        server.invoke(new CacheSerializableRunnable("Create server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", String.valueOf(mcastPort));
                config.setProperty("locators", "");
                ClientServerGetAllDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                if (createPR) {
                    factory.setDataPolicy(DataPolicy.PARTITION);
                    factory.setPartitionAttributes(new PartitionAttributesFactory().create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = ClientServerGetAllDUnitTest.this.createRootRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                }
                try {
                    ClientServerGetAllDUnitTest.this.startBridgeServer(serverPort);
                    System.out.println("Started bridger server ");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("While starting CacheServer", e);
                }
            }
        });
    }

    private void createBridgeClient(VM client, final String regionName, final String serverHost, final int[] serverPorts) {
        client.invoke(new CacheSerializableRunnable("Create client"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                config.setProperty("locators", "");
                ClientServerGetAllDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                PoolFactory pf = PoolManager.createFactory();
                for (int i = 0; i < serverPorts.length; ++i) {
                    pf.addServer(serverHost, serverPorts[i]);
                }
                pf.create("myPool");
                factory.setPoolName("myPool");
                ClientServerGetAllDUnitTest.this.createRootRegion(regionName, factory.create());
            }
        });
    }

    private void stopBridgeServer(VM server) {
        server.invoke(new CacheSerializableRunnable("Stop Server"){

            @Override
            public void run2() throws CacheException {
                ClientServerGetAllDUnitTest.this.stopBridgeServers(ClientServerGetAllDUnitTest.this.getCache());
            }
        });
    }
}

