/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.internal.DestroyOp;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class ConcurrentMapOpsDUnitTest
extends CacheTestCase {
    protected static final String REP_REG_NAME = "repRegion";
    protected static final String PR_REG_NAME = "prRegion";
    private static final int MAX_ENTRIES = 113;

    private void createRegions(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ConcurrentMapOpsDUnitTest.this.createReplicateRegion();
                ConcurrentMapOpsDUnitTest.this.createPartitionedRegion();
                return null;
            }
        });
    }

    private void createRedundantRegions(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).setConcurrencyChecksEnabled(true).create(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_REDUNDANT).setConcurrencyChecksEnabled(true).create(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                return null;
            }
        });
    }

    protected Region createReplicateRegion() {
        return this.getCache().createRegionFactory(RegionShortcut.REPLICATE).setConcurrencyChecksEnabled(true).create(REP_REG_NAME);
    }

    protected Region createPartitionedRegion() {
        return this.getCache().createRegionFactory(RegionShortcut.PARTITION).setConcurrencyChecksEnabled(true).create(PR_REG_NAME);
    }

    private Integer createRegionsAndStartServer(VM vm) {
        return this.createRegionsAndStartServer(vm, false);
    }

    private Integer createRegionsAndStartServer(VM vm, final boolean withRedundancy) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                if (withRedundancy) {
                    ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_REDUNDANT).create(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                } else {
                    ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION).create(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                }
                int port = AvailablePort.getRandomAvailablePort((int)0);
                CacheServer s = ConcurrentMapOpsDUnitTest.this.getCache().addCacheServer();
                s.setPort(port);
                s.start();
                return port;
            }
        });
    }

    private void createEmptyRegion(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PROXY).setConcurrencyChecksEnabled(true).create(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                ConcurrentMapOpsDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION_PROXY).setConcurrencyChecksEnabled(true).create(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                return null;
            }
        });
    }

    private void createClientRegionWithRI(VM vm, int port, boolean isEmpty) {
        this.createClientRegion(vm, port, isEmpty, true, -1);
    }

    private void createClientRegion(VM vm, int port1, boolean isEmpty, int port2) {
        this.createClientRegion(vm, port1, isEmpty, false, port2);
    }

    private void createClientRegion(VM vm, final int port1, final boolean isEmpty, final boolean ri, final int port2) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolServer("localhost", port1);
                if (port2 > 0) {
                    ccf.addPoolServer("localhost", port2);
                }
                ccf.setPoolSubscriptionEnabled(true);
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache cCache = ConcurrentMapOpsDUnitTest.this.getClientCache(ccf);
                ClientRegionFactory crf = cCache.createClientRegionFactory(isEmpty ? ClientRegionShortcut.PROXY : ClientRegionShortcut.CACHING_PROXY);
                Region r = crf.create(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = crf.create(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                if (ri) {
                    r.registerInterestRegex(".*");
                    pr.registerInterestRegex(".*");
                }
                return null;
            }
        });
    }

    public ConcurrentMapOpsDUnitTest(String name) {
        super(name);
    }

    public void testBug42164() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        int port1 = this.createRegionsAndStartServer(vm1);
        int port2 = this.createRegionsAndStartServer(vm2);
        this.createClientRegionWithRI(client1, port1, true);
        this.createClientRegionWithRI(client2, port2, true);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getGemfireCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getGemfireCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                for (int i = 0; i < 113; ++i) {
                    r.put((Object)i, (Object)("value" + i));
                    pr.put((Object)i, (Object)("value" + i));
                }
                return null;
            }
        });
        SerializableCallable addListener = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                r.getAttributesMutator().addCacheListener((CacheListener)new NotInvokedListener());
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                pr.getAttributesMutator().addCacheListener((CacheListener)new NotInvokedListener());
                return null;
            }
        };
        vm1.invoke(addListener);
        vm2.invoke(addListener);
        SerializableCallable addListenerToClient = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                r.getAttributesMutator().addCacheListener((CacheListener)new NotInvokedListener());
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                pr.getAttributesMutator().addCacheListener((CacheListener)new NotInvokedListener());
                return null;
            }
        };
        client1.invoke(addListenerToClient);
        client2.invoke(addListenerToClient);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int i;
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                for (i = 0; i < 113; ++i) {
                    TestCase.assertEquals((Object)("value" + i), (Object)r.putIfAbsent((Object)i, (Object)"value"));
                    TestCase.assertEquals((Object)("value" + i), (Object)pr.putIfAbsent((Object)i, (Object)"value"));
                }
                for (i = 0; i < 113; ++i) {
                    TestCase.assertFalse((boolean)r.replace((Object)i, (Object)"value", (Object)"newValue"));
                    TestCase.assertFalse((boolean)pr.replace((Object)i, (Object)"value", (Object)"newValue"));
                }
                for (i = 114; i < 226; ++i) {
                    TestCase.assertNull((Object)r.replace((Object)i, (Object)("value" + i)));
                    TestCase.assertNull((Object)pr.replace((Object)i, (Object)("value" + i)));
                }
                for (i = 114; i < 226; ++i) {
                    TestCase.assertFalse((boolean)r.remove((Object)i, (Object)("value" + i)));
                    TestCase.assertFalse((boolean)pr.remove((Object)i, (Object)("value" + i)));
                }
                return null;
            }
        });
    }

    public void testBug42162() {
        this.dotestConcOps(false);
    }

    public void testBug42162EmptyClient() {
        this.dotestConcOps(true);
    }

    private void dotestConcOps(final boolean emptyClient) {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server);
        this.createClientRegion(client, port1, emptyClient, -1);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                r.registerInterestRegex(".*");
                pr.registerInterestRegex(".*");
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                r.put((Object)"key0", (Object)"value");
                pr.put((Object)"key0", (Object)"value");
                TestCase.assertNull((Object)r.putIfAbsent((Object)"keyForNull", null));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"keyForNull", null));
                TestCase.assertEquals((Object)"value", (Object)r.putIfAbsent((Object)"key0", null));
                TestCase.assertEquals((Object)"value", (Object)pr.putIfAbsent((Object)"key0", null));
                TestCase.assertTrue((boolean)r.containsKey((Object)"keyForNull"));
                TestCase.assertTrue((boolean)pr.containsKey((Object)"keyForNull"));
                TestCase.assertFalse((boolean)r.containsValueForKey((Object)"keyForNull"));
                TestCase.assertFalse((boolean)pr.containsValueForKey((Object)"keyForNull"));
                r.put((Object)"key0", (Object)"value");
                pr.put((Object)"key0", (Object)"value");
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() {
                final Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                final Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    AssertionFailedError e = null;

                    @Override
                    public boolean done() {
                        try {
                            if (!emptyClient) {
                                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                                TestCase.assertTrue((boolean)pr.containsKey((Object)"key0"));
                                TestCase.assertTrue((boolean)r.containsKey((Object)"keyForNull"));
                                TestCase.assertTrue((boolean)pr.containsKey((Object)"keyForNull"));
                                TestCase.assertFalse((boolean)r.containsValueForKey((Object)"keyForNull"));
                                TestCase.assertFalse((boolean)pr.containsValueForKey((Object)"keyForNull"));
                            }
                            TestCase.assertEquals((Object)"value", (Object)r.putIfAbsent((Object)"key0", null));
                            TestCase.assertEquals((Object)"value", (Object)pr.putIfAbsent((Object)"key0", null));
                            TestCase.assertNull((Object)r.putIfAbsent((Object)"keyForNull", null));
                            TestCase.assertNull((Object)pr.putIfAbsent((Object)"keyForNull", null));
                            TestCase.assertNull((Object)r.putIfAbsent((Object)"clientNullKey", null));
                            TestCase.assertNull((Object)pr.putIfAbsent((Object)"clientNullKey", null));
                        }
                        catch (AssertionFailedError ex) {
                            r.getCache().getLoggerI18n().fine("SWAP:caught ", (Throwable)ex);
                            this.e = ex;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return "timeout " + (Object)((Object)this.e);
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertTrue((boolean)r.containsKey((Object)"clientNullKey"));
                TestCase.assertTrue((boolean)pr.containsKey((Object)"clientNullKey"));
                TestCase.assertFalse((boolean)r.containsValueForKey((Object)"clientNullKey"));
                TestCase.assertFalse((boolean)pr.containsValueForKey((Object)"clientNullKey"));
                TestCase.assertNotNull((Object)r.replace((Object)"key0", (Object)"value2"));
                TestCase.assertNotNull((Object)pr.replace((Object)"key0", (Object)"value2"));
                TestCase.assertTrue((boolean)r.replace((Object)"keyForNull", null, (Object)"newValue"));
                TestCase.assertTrue((boolean)pr.replace((Object)"keyForNull", null, (Object)"newValue"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() {
                final Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                final Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    AssertionFailedError e = null;

                    @Override
                    public boolean done() {
                        try {
                            TestCase.assertEquals((Object)"value2", (Object)r.putIfAbsent((Object)"key0", null));
                            TestCase.assertEquals((Object)"value2", (Object)pr.putIfAbsent((Object)"key0", null));
                            TestCase.assertEquals((Object)"newValue", (Object)r.putIfAbsent((Object)"keyForNull", null));
                            TestCase.assertEquals((Object)"newValue", (Object)pr.putIfAbsent((Object)"keyForNull", null));
                            TestCase.assertEquals((Object)"value2", (Object)r.replace((Object)"key0", (Object)"value"));
                            TestCase.assertEquals((Object)"value2", (Object)pr.replace((Object)"key0", (Object)"value"));
                            TestCase.assertNull((Object)r.replace((Object)"NoKeyOnServer", (Object)"value"));
                            TestCase.assertNull((Object)r.replace((Object)"NoKeyOnServer", (Object)"value"));
                            TestCase.assertTrue((boolean)r.replace((Object)"clientNullKey", null, (Object)"newValue"));
                            TestCase.assertTrue((boolean)pr.replace((Object)"clientNullKey", null, (Object)"newValue"));
                        }
                        catch (AssertionFailedError ex) {
                            this.e = ex;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return "timeout " + this.e.getMessage();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertEquals((Object)"newValue", (Object)r.get((Object)"clientNullKey"));
                TestCase.assertEquals((Object)"newValue", (Object)pr.get((Object)"clientNullKey"));
                return null;
            }
        });
    }

    public void testNullValueFromNonEmptyClients() {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server);
        this.createClientRegion(client, port1, true, -1);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                r.create((Object)"createKey", null);
                pr.create((Object)"createKey", null);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"putAbsentKey", null));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"putAbsentKey", null));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertEquals((Object)r.get((Object)"createKey"), (Object)r.get((Object)"putAbsentKey"));
                TestCase.assertEquals((Object)pr.get((Object)"createKey"), (Object)pr.get((Object)"putAbsentKey"));
                TestCase.assertFalse((boolean)r.containsKey((Object)"createKey"));
                TestCase.assertFalse((boolean)pr.containsKey((Object)"createKey"));
                TestCase.assertEquals((boolean)r.containsKey((Object)"createKey"), (boolean)r.containsKey((Object)"putAbsentKey"));
                TestCase.assertEquals((boolean)pr.containsKey((Object)"createKey"), (boolean)pr.containsKey((Object)"putAbsentKey"));
                return null;
            }
        });
    }

    public void testPutIfAbsent() {
        this.doPutIfAbsentWork(false);
    }

    public void testPutIfAbsentCS() {
        this.doPutIfAbsentWork(true);
    }

    private void doPutIfAbsentWork(final boolean cs) {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(2);
        if (cs) {
            int port1 = this.createRegionsAndStartServer(vm1);
            this.createClientRegion(vm2, port1, false, -1);
        } else {
            this.createRegions(vm1);
            this.createRegions(vm2);
        }
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertNull((Object)r.putIfAbsent((Object)"keyForClient", (Object)"value"));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"keyForClient", (Object)"value"));
                TestCase.assertEquals((Object)"value", (Object)r.putIfAbsent((Object)"key0", (Object)"value2"));
                TestCase.assertEquals((Object)"value", (Object)pr.putIfAbsent((Object)"key0", (Object)"value2"));
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertEquals((Object)"value", (Object)r.putIfAbsent((Object)"key0", (Object)"value2"));
                TestCase.assertEquals((Object)"value", (Object)pr.putIfAbsent((Object)"key0", (Object)"value2"));
                if (cs) {
                    r.get((Object)"key0");
                    pr.get((Object)"key0");
                }
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                TestCase.assertTrue((boolean)pr.containsKey((Object)"key0"));
                TestCase.assertTrue((boolean)r.containsValueForKey((Object)"key0"));
                TestCase.assertTrue((boolean)pr.containsValueForKey((Object)"key0"));
                return null;
            }
        });
    }

    public void testRemove() {
        this.doRemoveWork(false);
    }

    public void testRemoveCS() {
        this.doRemoveWork(true);
    }

    private void doRemoveWork(boolean cs) {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(2);
        if (cs) {
            int port1 = this.createRegionsAndStartServer(vm1);
            this.createClientRegion(vm2, port1, true, -1);
        } else {
            this.createRegions(vm1);
            this.createRegions(vm2);
        }
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertNull((Object)r.putIfAbsent((Object)"keyForClient", (Object)"value"));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"keyForClient", (Object)"value"));
                TestCase.assertFalse((boolean)r.remove((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertFalse((boolean)pr.remove((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertFalse((boolean)r.remove((Object)"key0", (Object)"newValue"));
                TestCase.assertFalse((boolean)pr.remove((Object)"key0", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.remove((Object)"key0", (Object)"value"));
                TestCase.assertTrue((boolean)pr.remove((Object)"key0", (Object)"value"));
                TestCase.assertFalse((boolean)r.containsKey((Object)"key0"));
                TestCase.assertFalse((boolean)pr.containsKey((Object)"key0"));
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertFalse((boolean)r.remove((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertFalse((boolean)pr.remove((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertFalse((boolean)r.remove((Object)"keyForClient", (Object)"newValue"));
                TestCase.assertFalse((boolean)pr.remove((Object)"keyForClient", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.remove((Object)"keyForClient", (Object)"value"));
                TestCase.assertTrue((boolean)pr.remove((Object)"keyForClient", (Object)"value"));
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertFalse((boolean)r.containsKey((Object)"keyForClient"));
                TestCase.assertFalse((boolean)pr.containsKey((Object)"keyForClient"));
                return null;
            }
        });
    }

    public void testReplaceCS() {
        this.doReplaceWork(true);
    }

    public void testReplace() {
        this.doReplaceWork(false);
    }

    private void doReplaceWork(boolean cs) {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(2);
        if (cs) {
            int port1 = this.createRegionsAndStartServer(vm1);
            this.createClientRegion(vm2, port1, true, -1);
        } else {
            this.createRegions(vm1);
            this.createRegions(vm2);
        }
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertNull((Object)r.putIfAbsent((Object)"keyForClient", (Object)"value"));
                TestCase.assertNull((Object)pr.putIfAbsent((Object)"keyForClient", (Object)"value"));
                TestCase.assertNull((Object)r.replace((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertNull((Object)pr.replace((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertEquals((Object)"value", (Object)r.replace((Object)"key0", (Object)"value2"));
                TestCase.assertEquals((Object)"value", (Object)pr.replace((Object)"key0", (Object)"value2"));
                TestCase.assertFalse((boolean)r.replace((Object)"key0", (Object)"value", (Object)"newValue"));
                TestCase.assertFalse((boolean)pr.replace((Object)"key0", (Object)"value", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.replace((Object)"key0", (Object)"value2", (Object)"newValue"));
                TestCase.assertTrue((boolean)pr.replace((Object)"key0", (Object)"value2", (Object)"newValue"));
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertNull((Object)r.replace((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertNull((Object)pr.replace((Object)"nonExistentkey", (Object)"value"));
                TestCase.assertEquals((Object)"value", (Object)r.replace((Object)"keyForClient", (Object)"value2"));
                TestCase.assertEquals((Object)"value", (Object)pr.replace((Object)"keyForClient", (Object)"value2"));
                TestCase.assertFalse((boolean)r.replace((Object)"keyForClient", (Object)"value", (Object)"newValue"));
                TestCase.assertFalse((boolean)pr.replace((Object)"keyForClient", (Object)"value", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.replace((Object)"keyForClient", (Object)"value2", (Object)"newValue"));
                TestCase.assertTrue((boolean)pr.replace((Object)"keyForClient", (Object)"value2", (Object)"newValue"));
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.REP_REG_NAME);
                Region pr = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(ConcurrentMapOpsDUnitTest.PR_REG_NAME);
                TestCase.assertFalse((boolean)r.containsKey((Object)"nonExistentkey"));
                TestCase.assertFalse((boolean)pr.containsKey((Object)"nonExistentkey"));
                return null;
            }
        });
    }

    public void testBug42167() {
        this.do42167Work(false, REP_REG_NAME);
    }

    public void testBug42167PR() {
        this.do42167Work(false, PR_REG_NAME);
    }

    public void testBug42167Empty() {
        this.do42167Work(true, REP_REG_NAME);
    }

    public void testBug42167EmptyPR() {
        this.do42167Work(true, PR_REG_NAME);
    }

    private void do42167Work(final boolean emptyClient, final String regionName) {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server);
        this.createClientRegion(client, port1, emptyClient, -1);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                r.put((Object)"key0", (Object)"value");
                r.put((Object)"key2", (Object)"value2");
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertEquals((Object)"value", (Object)r.get((Object)"key0"));
                if (!emptyClient) {
                    r.localDestroy((Object)"key0");
                    TestCase.assertFalse((boolean)r.containsKey((Object)"key0"));
                }
                ConcurrentMapOpsDUnitTest.this.getCache().getLogger().fine("SWAP:doingRemove");
                TestCase.assertTrue((boolean)r.remove((Object)"key0", (Object)"value"));
                ConcurrentMapOpsDUnitTest.this.getCache().getLogger().fine("Bruce:doingExtraRemoves.  Bug #47010");
                DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = false;
                TestCase.assertTrue((r.remove((Object)"key0") == null ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND);
                DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = false;
                TestCase.assertFalse((boolean)r.remove((Object)"key0", (Object)"value"));
                TestCase.assertTrue((boolean)DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND);
                DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = false;
                TestCase.assertTrue((r.destroy((Object)"key0") == null ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND);
                DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = false;
                TestCase.assertTrue((r.remove((Object)"nonExistentKey1") == null ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND);
                DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = false;
                TestCase.assertFalse((boolean)r.remove((Object)"nonExistentKey2", (Object)"value"));
                TestCase.assertTrue((boolean)DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND);
                DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = false;
                TestCase.assertTrue((r.destroy((Object)"nonExistentKey3") == null ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND);
                ConcurrentMapOpsDUnitTest.this.getCache().getLogger().fine("SWAP:doingReplace");
                TestCase.assertEquals((Object)"value2", (Object)r.replace((Object)"key2", (Object)"newValue2"));
                ConcurrentMapOpsDUnitTest.this.getCache().getLogger().fine("SWAP:doingReplace2");
                TestCase.assertEquals(null, (Object)r.replace((Object)"key0", (Object)"newValue"));
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key4", (Object)"value4"));
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertFalse((boolean)r.containsKey((Object)"key0"));
                TestCase.assertFalse((boolean)r.containsValueForKey((Object)"key0"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key2"));
                TestCase.assertEquals((Object)"newValue2", (Object)r.get((Object)"key2"));
                r.getCache().getLogger().fine("SWAP:doingGet");
                TestCase.assertEquals((Object)"value4", (Object)r.get((Object)"key4"));
                return null;
            }
        });
    }

    public void testBug42189() {
        this.doBug42189Work(REP_REG_NAME);
    }

    public void testBug42189PR() {
        this.doBug42189Work(PR_REG_NAME);
    }

    private void doBug42189Work(final String regionName) {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server);
        this.createClientRegion(client, port1, false, -1);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                r.create((Object)"key0", null);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                Object v = r.get((Object)"key0");
                TestCase.assertNull((String)("expected null but was " + v), (Object)v);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"key0"));
                Object v = r.get((Object)"key0");
                TestCase.assertNull((String)("expected null but was " + v), (Object)v);
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                TestCase.assertFalse((boolean)r.containsValueForKey((Object)"key0"));
                return null;
            }
        });
    }

    public void _testBug42195() {
        this.doPutIfAbsentPutsKeyInLocalClientCacheWork(REP_REG_NAME);
    }

    public void _testBug42195PR() {
        this.doPutIfAbsentPutsKeyInLocalClientCacheWork(PR_REG_NAME);
    }

    private void doPutIfAbsentPutsKeyInLocalClientCacheWork(final String regionName) {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server);
        this.createClientRegion(client, port1, false, -1);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertEquals((Object)"value", (Object)r.putIfAbsent((Object)"key0", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"key0"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                TestCase.assertTrue((boolean)r.containsValueForKey((Object)"key0"));
                return null;
            }
        });
    }

    public void testReplacePutsKeyInLocalClientCache() {
        this.doReplacePutsKeyInLocalClientCacheWork(REP_REG_NAME);
    }

    public void testReplacePutsKeyInLocalClientCachePR() {
        this.doReplacePutsKeyInLocalClientCacheWork(PR_REG_NAME);
    }

    private void doReplacePutsKeyInLocalClientCacheWork(final String regionName) {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server);
        this.createClientRegion(client, port1, false, -1);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key0", (Object)"value"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                TestCase.assertNull((Object)r.putIfAbsent((Object)"key2", (Object)"value2"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key2"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                TestCase.assertEquals((Object)"value", (Object)r.replace((Object)"key0", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"key0"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key0"));
                TestCase.assertTrue((boolean)r.containsValueForKey((Object)"key0"));
                TestCase.assertFalse((boolean)r.replace((Object)"key2", (Object)"DontReplace", (Object)"newValue"));
                TestCase.assertTrue((boolean)r.replace((Object)"key2", (Object)"value2", (Object)"newValu2"));
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"key2"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"key2"));
                TestCase.assertTrue((boolean)r.containsValueForKey((Object)"key2"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                String key = "bug42221";
                r.putIfAbsent((Object)"bug42221", null);
                TestCase.assertTrue((boolean)r.containsKey((Object)"bug42221"));
                Object result = r.replace((Object)"bug42221", (Object)"not null");
                TestCase.assertEquals(null, (Object)result);
                TestCase.assertTrue((boolean)r.containsKey((Object)"bug42221"));
                TestCase.assertEquals((Object)r.get((Object)"bug42221"), (Object)"not null");
                r.remove((Object)"bug42221");
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                String key = "bug42242";
                r.putIfAbsent((Object)"bug42242", null);
                TestCase.assertTrue((boolean)r.containsKey((Object)"bug42242"));
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"bug42242"));
                boolean result = r.remove((Object)"bug42242", null);
                TestCase.assertTrue((boolean)result);
                TestCase.assertFalse((boolean)r.containsKey((Object)"bug42242"));
                TestCase.assertFalse((boolean)r.containsKeyOnServer((Object)"bug42242"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                String key = "bug42242b";
                r.putIfAbsent((Object)"bug42242b", null);
                TestCase.assertTrue((boolean)r.containsKey((Object)"bug42242b"));
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"bug42242b"));
                boolean result = r.replace((Object)"bug42242b", null, (Object)"new value");
                TestCase.assertTrue((boolean)result);
                result = r.remove((Object)"bug42242b", (Object)"new value");
                TestCase.assertTrue((boolean)result);
                TestCase.assertFalse((boolean)r.containsKey((Object)"bug42242b"));
                TestCase.assertFalse((boolean)r.containsKeyOnServer((Object)"bug42242b"));
                return null;
            }
        });
        String key = "bug42242c";
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                r.registerInterest((Object)"ALL_KEYS");
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                r.putIfAbsent((Object)"bug42242c", null);
                TestCase.assertTrue((boolean)r.containsKey((Object)"bug42242c"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                final Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                DistributedTestCase.WaitCriterion w = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "waiting for server operation to reach client";
                    }

                    @Override
                    public boolean done() {
                        return r.containsKey((Object)"bug42242c");
                    }
                };
                DistributedTestCase.waitForCriterion(w, 10000L, 200L, true);
                TestCase.assertTrue((boolean)r.containsKeyOnServer((Object)"bug42242c"));
                boolean result = r.remove((Object)"bug42242c", null);
                TestCase.assertTrue((boolean)result);
                TestCase.assertFalse((boolean)r.containsKey((Object)"bug42242c"));
                TestCase.assertFalse((boolean)r.containsKeyOnServer((Object)"bug42242c"));
                return null;
            }
        });
    }

    public void testWithDelta() {
        this.doTestWithDeltaWork(false, REP_REG_NAME);
    }

    public void testWithDeltaPR() {
        this.doTestWithDeltaWork(false, PR_REG_NAME);
    }

    public void testWithDeltaCS() {
        this.doTestWithDeltaWork(true, REP_REG_NAME);
    }

    public void testWithDeltaPRCS() {
        this.doTestWithDeltaWork(true, PR_REG_NAME);
    }

    private void doTestWithDeltaWork(boolean clientServer, final String regName) {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        if (clientServer) {
            int port = this.createRegionsAndStartServer(vm1);
            this.createClientRegion(vm2, port, false, -1);
        } else {
            this.createRegions(vm1);
            this.createRegions(vm2);
        }
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regName);
                CustomerDelta c = new CustomerDelta("cust1", "addr1");
                TestCase.assertNull((Object)r.putIfAbsent((Object)"k1", (Object)c));
                CustomerDelta newc = new CustomerDelta(c);
                newc.setAddress("updatedAddress");
                TestCase.assertEquals((Object)c, (Object)r.putIfAbsent((Object)"k1", (Object)c));
                TestCase.assertEquals((Object)c, (Object)r.replace((Object)"k1", (Object)newc));
                TestCase.assertFalse((boolean)r.replace((Object)"k1", (Object)c, (Object)newc));
                TestCase.assertTrue((boolean)r.replace((Object)"k1", (Object)newc, (Object)c));
                TestCase.assertFalse((boolean)r.remove((Object)"k1", (Object)newc));
                TestCase.assertTrue((boolean)r.remove((Object)"k1", (Object)c));
                return null;
            }
        });
    }

    public void testRetriedPutIfAbsent() throws Exception {
        this.doRetriedOperation(Operation.PUT_IF_ABSENT, false);
    }

    public void testRetriedReplace() throws Exception {
        this.doRetriedOperation(Operation.REPLACE, false);
    }

    public void testRetriedRemove() throws Exception {
        this.doRetriedOperation(Operation.REMOVE, false);
    }

    public void testRetriedPutIfAbsentPR() throws Exception {
        this.doRetriedOperation(Operation.PUT_IF_ABSENT, false);
    }

    public void testRetriedReplacePR() throws Exception {
        this.doRetriedOperation(Operation.REPLACE, false);
    }

    public void testRetriedRemovePR() throws Exception {
        this.doRetriedOperation(Operation.REMOVE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetriedOperation(final Operation op, boolean usePR) {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        int port1 = this.createRegionsAndStartServer(server1, true);
        int port2 = this.createRegionsAndStartServer(server2, true);
        final String regionName = usePR ? PR_REG_NAME : REP_REG_NAME;
        this.createClientRegion(client, port1, false, port2);
        SerializableCallable getID = new SerializableCallable("get DM ID"){

            public Object call() {
                return ConcurrentMapOpsDUnitTest.this.getSystem().getDistributedMember();
            }
        };
        final DistributedMember server1ID = (DistributedMember)server1.invoke(getID);
        final DistributedMember server2ID = (DistributedMember)server2.invoke(getID);
        HashSet<DistributedTestCase.ExpectedException> exceptions = new HashSet<DistributedTestCase.ExpectedException>();
        exceptions.add(ConcurrentMapOpsDUnitTest.addExpectedException("Membership: requesting removal", server1));
        exceptions.add(ConcurrentMapOpsDUnitTest.addExpectedException("Membership: requesting removal", server2));
        exceptions.add(ConcurrentMapOpsDUnitTest.addExpectedException("ForcedDisconnect", server1));
        exceptions.add(ConcurrentMapOpsDUnitTest.addExpectedException("ForcedDisconnect", server2));
        try {
            server1.invoke(new SerializableCallable("install crasher in server1"){

                public Object call() throws Exception {
                    Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                    r.put((Object)"key0", (Object)"value");
                    if (op == Operation.PUT_IF_ABSENT) {
                        r.destroy((Object)"key0");
                    }
                    r.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter(){

                        private void killSender(EntryEvent event) {
                            if (event.isOriginRemote()) {
                                JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)ConcurrentMapOpsDUnitTest.this.getSystem());
                                mgr.requestMemberRemoval(server2ID, "removing for test");
                                try {
                                    mgr.waitForDeparture(server2ID);
                                }
                                catch (Exception e) {
                                    TestCase.fail((String)("failed to stop the other server for this test:" + e.getMessage()));
                                }
                            }
                        }

                        public void afterCreate(EntryEvent event) {
                            ConcurrentMapOpsDUnitTest.this.getCache().getLogger().info("afterCreate invoked with " + event);
                            this.killSender(event);
                        }

                        public void afterUpdate(EntryEvent event) {
                            ConcurrentMapOpsDUnitTest.this.getCache().getLogger().info("afterUpdate invoked with " + event);
                            this.killSender(event);
                        }

                        public void afterDestroy(EntryEvent event) {
                            ConcurrentMapOpsDUnitTest.this.getCache().getLogger().info("afterDestroy invoked with " + event);
                            this.killSender(event);
                        }
                    });
                    return null;
                }
            });
            server2.invoke(new SerializableCallable("install crasher in server2"){

                public Object call() throws Exception {
                    Region r = ConcurrentMapOpsDUnitTest.this.getCache().getRegion(regionName);
                    r.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter(){

                        private void killSender(EntryEvent event) {
                            if (event.isOriginRemote()) {
                                JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)ConcurrentMapOpsDUnitTest.this.getSystem());
                                mgr.requestMemberRemoval(server1ID, "removing for test");
                                try {
                                    mgr.waitForDeparture(server1ID);
                                }
                                catch (Exception e) {
                                    TestCase.fail((String)("failed to stop the other server for this test:" + e.getMessage()));
                                }
                            }
                        }

                        public void afterCreate(EntryEvent event) {
                            ConcurrentMapOpsDUnitTest.this.getCache().getLogger().info("afterCreate invoked with " + event);
                            this.killSender(event);
                        }

                        public void afterUpdate(EntryEvent event) {
                            ConcurrentMapOpsDUnitTest.this.getCache().getLogger().info("afterUpdate invoked with " + event);
                            this.killSender(event);
                        }

                        public void afterDestroy(EntryEvent event) {
                            ConcurrentMapOpsDUnitTest.this.getCache().getLogger().info("afterDestroy invoked with " + event);
                            this.killSender(event);
                        }
                    });
                    return null;
                }
            });
            client.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    GemFireCacheImpl cache = (GemFireCacheImpl)ConcurrentMapOpsDUnitTest.this.getCache();
                    Region r = cache.getRegion(regionName);
                    if (op == Operation.PUT_IF_ABSENT) {
                        TestCase.assertTrue((String)"expected putIfAbsent to succeed and return null", (r.putIfAbsent((Object)"key0", (Object)"newvalue") == null ? 1 : 0) != 0);
                    } else if (op == Operation.REMOVE) {
                        TestCase.assertTrue((String)"expected remove operation to succeed and return true", (boolean)r.remove((Object)"key0", (Object)"value"));
                    } else if (op == Operation.REPLACE) {
                        TestCase.assertTrue((String)"expected replace operation to succeed and return true", (boolean)r.replace((Object)"key0", (Object)"value", (Object)"newvalue"));
                    }
                }
            });
        }
        finally {
            ConcurrentMapOpsDUnitTest.disconnectAllFromDS();
            for (DistributedTestCase.ExpectedException ex : exceptions) {
                ex.remove();
            }
        }
    }

    private static class CustomerDelta
    implements Serializable,
    Delta {
        private String name;
        private String address;
        private boolean nameChanged;
        private boolean addressChanged;

        public CustomerDelta(CustomerDelta o) {
            this.address = o.address;
            this.name = o.name;
        }

        public CustomerDelta(String name, String address) {
            this.name = name;
            this.address = address;
        }

        public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
            boolean addressC;
            boolean nameC = in.readBoolean();
            if (nameC) {
                this.name = in.readUTF();
            }
            if (addressC = in.readBoolean()) {
                this.address = in.readUTF();
            }
        }

        public boolean hasDelta() {
            return this.nameChanged || this.addressChanged;
        }

        public void toDelta(DataOutput out) throws IOException {
            if (this.nameChanged) {
                out.writeBoolean(this.nameChanged);
                out.writeUTF(this.name);
            }
            if (this.addressChanged) {
                out.writeBoolean(this.addressChanged);
                out.writeUTF(this.address);
            }
        }

        public void setName(String name) {
            this.nameChanged = true;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAddress(String address) {
            this.addressChanged = true;
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CustomerDelta)) {
                return false;
            }
            CustomerDelta other = (CustomerDelta)obj;
            return this.name.equals(other.name) && this.address.equals(other.address);
        }

        public int hashCode() {
            return this.address.hashCode() + this.name.hashCode();
        }
    }

    static class NotInvokedListener
    extends AbstractConcMapOpsListener {
        NotInvokedListener() {
        }

        @Override
        void validate(EntryEvent event) {
            TestCase.fail((String)"should not be called");
        }
    }

    static abstract class AbstractConcMapOpsListener
    implements CacheListener<Integer, String> {
        AbstractConcMapOpsListener() {
        }

        public void afterCreate(EntryEvent<Integer, String> event) {
            this.validate(event);
        }

        public void afterDestroy(EntryEvent<Integer, String> event) {
            this.validate(event);
        }

        public void afterInvalidate(EntryEvent<Integer, String> event) {
            this.validate(event);
        }

        public void afterRegionClear(RegionEvent<Integer, String> event) {
        }

        public void afterRegionCreate(RegionEvent<Integer, String> event) {
        }

        public void afterRegionDestroy(RegionEvent<Integer, String> event) {
        }

        public void afterRegionInvalidate(RegionEvent<Integer, String> event) {
        }

        public void afterRegionLive(RegionEvent<Integer, String> event) {
        }

        public void afterUpdate(EntryEvent<Integer, String> event) {
            this.validate(event);
        }

        public void close() {
        }

        abstract void validate(EntryEvent var1);
    }

    static enum OP {
        PUTIFABSENT,
        REPLACE,
        REMOVE;

    }
}

