/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.Properties;

public class ConnectDisconnectDUnitTest
extends CacheTestCase {
    private DistributedTestCase.ExpectedException ex;
    static int LOCATOR_PORT;
    static String LOCATORS_STRING;
    static int[] locatorPorts;

    public ConnectDisconnectDUnitTest(String name) {
        super(name);
    }

    public void testManyConnectsAndDisconnects() throws Throwable {
        for (int i = 0; i < 50; ++i) {
            ConnectDisconnectDUnitTest.getLogWriter().info("Test run: " + i);
            this.runOnce();
            this.tearDown();
            this.setUp();
        }
    }

    public void setLocatorPorts(int[] ports) {
        String locators = "";
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                locators = locators + ",";
            }
            locators = locators + "localhost[" + ports[i] + "]";
        }
        final String locators_string = locators;
        for (int i = 0; i < ports.length; ++i) {
            final int port = ports[i];
            Host.getHost(0).getVM(i).invoke(new SerializableRunnable("set locator port"){

                @Override
                public void run() {
                    LOCATOR_PORT = port;
                    LOCATORS_STRING = locators_string;
                }
            });
        }
        locatorPorts = ports;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        if (locatorPorts != null) {
            for (int i = 0; i < locatorPorts.length; ++i) {
                this.deleteStateFile(locatorPorts[i]);
            }
        }
    }

    private void deleteStateFile(int port) {
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
    }

    public void runOnce() throws Throwable {
        int i;
        int numVMs = 4;
        VM[] vms = new VM[numVMs];
        for (int i2 = 0; i2 < numVMs; ++i2) {
            vms[i2] = Host.getHost(0).getVM(i2);
        }
        AsyncInvocation[] asyncs = new AsyncInvocation[numVMs];
        for (i = 0; i < numVMs; ++i) {
            asyncs[i] = vms[i].invokeAsync(new SerializableRunnable("Create a cache"){

                @Override
                public void run() {
                    ConnectDisconnectDUnitTest.this.getCache();
                }
            });
        }
        for (i = 0; i < numVMs; ++i) {
            asyncs[i].getResult();
        }
        ConnectDisconnectDUnitTest.disconnectAllFromDS();
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = super.getDistributedSystemProperties();
        props.setProperty("log-level", "info");
        props.setProperty("conserve-sockets", "false");
        if (LOCATOR_PORT > 0) {
            props.setProperty("start-locator", "localhost[" + LOCATOR_PORT + "]");
            props.setProperty("locators", LOCATORS_STRING);
        }
        return props;
    }
}

