/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TestDelta;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class DeltaFaultInDUnitTest
extends CacheTestCase {
    public DeltaFaultInDUnitTest(String name) {
        super(name);
    }

    public void test() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        boolean copyOnRead = false;
        boolean clone = true;
        SerializableCallable createDataRegion = new SerializableCallable("createDataRegion"){

            public Object call() throws Exception {
                Cache cache = DeltaFaultInDUnitTest.this.getCache();
                cache.setCopyOnRead(false);
                cache.createDiskStoreFactory().create("DeltaFaultInDUnitTestData");
                AttributesFactory attr = new AttributesFactory();
                attr.setDiskStoreName("DeltaFaultInDUnitTestData");
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setCloningEnabled(true);
                attr.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                Region region = cache.createRegion("region1", attr.create());
                return null;
            }
        };
        vm0.invoke(createDataRegion);
        SerializableRunnable createEmptyRegion = new SerializableRunnable("createEmptyRegion"){

            @Override
            public void run() {
                Cache cache = DeltaFaultInDUnitTest.this.getCache();
                cache.setCopyOnRead(false);
                AttributesFactory attr = new AttributesFactory();
                attr.setCloningEnabled(true);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setDataPolicy(DataPolicy.PARTITION);
                attr.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                Region region = cache.createRegion("region1", attr.create());
                region.put((Object)new Integer(0), (Object)new TestDelta(false, "initial"));
                region.put((Object)new Integer(0), (Object)new TestDelta(true, "initial_plus_some_more_data"));
            }
        };
        vm1.invoke(createEmptyRegion);
        vm0.invoke(new SerializableRunnable("doPut"){

            @Override
            public void run() {
                Cache cache = DeltaFaultInDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)new Integer(113), (Object)new TestDelta(false, "bogus"));
                region.get((Object)new Integer(113));
                long entriesEvicted = ((AbstractLRURegionMap)((PartitionedRegion)region).entries)._getLruList().stats().getEvictions();
                TestDelta result = (TestDelta)region.get((Object)new Integer(0));
                TestCase.assertEquals((String)"initial_plus_some_more_data", (String)result.info);
            }
        });
    }

    private long checkObjects(VM vm, final int serializations, final int deserializations, final int deltas, final int clones) {
        SerializableCallable getSize = new SerializableCallable("check objects"){

            public Object call() {
                GemFireCacheImpl cache = (GemFireCacheImpl)DeltaFaultInDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                long size = region.getDataStore().getBucketSize(0);
                TestDelta value = (TestDelta)region.get((Object)0);
                value.checkFields(serializations, deserializations, deltas, clones);
                return size;
            }
        };
        Object size = vm.invoke(getSize);
        return (Long)size;
    }
}

