/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.VMLRURegionMap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;

public class DeltaPropagationDUnitTest
extends DistributedTestCase {
    private static final Compressor compressor = SnappyCompressor.getDefaultInstance();
    protected static Cache cache = null;
    protected static Pool pool = null;
    protected static VM VM0 = null;
    protected static VM VM1 = null;
    protected static VM VM2 = null;
    protected static VM VM3 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String regionName = "DeltaPropagationDUnitTest";
    private static LogWriter logger;
    public static final int EVENTS_SIZE = 6;
    private static boolean lastKeyReceived;
    private static boolean markerReceived;
    private static int numOfCreates;
    private static int numOfUpdates;
    private static int numOfInvalidates;
    private static int numOfDestroys;
    private static int numOfEvents;
    private static DeltaTestImpl[] deltaPut;
    private static boolean areListenerResultsValid;
    private static boolean closeCache;
    private static StringBuffer listenerError;
    public static String DELTA_KEY;
    public static String LAST_KEY;
    public static final int NO_LISTENER = 0;
    public static final int CLIENT_LISTENER = 1;
    public static final int SERVER_LISTENER = 2;
    public static final int C2S2S_SERVER_LISTENER = 3;
    public static final int LAST_KEY_LISTENER = 4;
    public static final int DURABLE_CLIENT_LISTENER = 5;
    public static final int CLIENT_LISTENER_2 = 6;
    public static final String CREATE = "CREATE";
    public static final String UPDATE = "UPDATE";
    public static final String INVALIDATE = "INVALIDATE";
    public static final String DESTROY = "DESTROY";

    public DeltaPropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        VM0 = host.getVM(0);
        VM1 = host.getVM(1);
        VM2 = host.getVM(2);
        VM3 = host.getVM(3);
        VM0.invoke(DeltaPropagationDUnitTest.class, "resetAll");
        VM1.invoke(DeltaPropagationDUnitTest.class, "resetAll");
        VM2.invoke(DeltaPropagationDUnitTest.class, "resetAll");
        VM3.invoke(DeltaPropagationDUnitTest.class, "resetAll");
        DeltaPropagationDUnitTest.resetAll();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DeltaPropagationDUnitTest.closeCache();
        VM2.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        VM3.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        VM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        VM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        VM0.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        VM1.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        DeltaPropagationDUnitTest.disconnectAllFromDS();
    }

    public void testS2CSuccessfulDeltaPropagationWithCompression() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"none", new Integer(1), new Integer(0), Boolean.FALSE, compressor});
        VM0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertTrue((cache.getRegion(DeltaPropagationDUnitTest.regionName).getAttributes().getCompressor() != null ? 1 : 0) != 0);
            }
        });
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(1));
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltas), (fromDeltas == toDeltas ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(2, 5);
        DeltaPropagationDUnitTest.assertTrue((String)listenerError.toString(), (boolean)areListenerResultsValid);
    }

    public void testS2CSuccessfulDeltaPropagation() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(1));
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltas), (fromDeltas == toDeltas ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(2, 5);
        DeltaPropagationDUnitTest.assertTrue((String)listenerError.toString(), (boolean)areListenerResultsValid);
    }

    public void testS2CFailureInToDeltaMethod() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(6));
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareErroneousDeltasForToDelta");
        DeltaPropagationDUnitTest.prepareErroneousDeltasForToDelta();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        long toDeltafailures = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaFailures");
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("4 deltas were to be received but were " + fromDeltas), (fromDeltas == 4L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("1 deltas were to be failed while extracting but were " + toDeltafailures), (toDeltafailures == 1L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(2, 4);
        DeltaPropagationDUnitTest.assertTrue((String)listenerError.toString(), (boolean)areListenerResultsValid);
    }

    public void testS2CFailureInFromDeltaMethod() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(1));
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareErroneousDeltasForFromDelta");
        DeltaPropagationDUnitTest.prepareErroneousDeltasForFromDelta();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        long fromDeltafailures = DeltaTestImpl.getFromDeltaFailures();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltas), (fromDeltas == toDeltas ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("1 deltas were to be failed while applying but were " + fromDeltafailures), (fromDeltafailures == 1L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(2, 5);
        DeltaPropagationDUnitTest.assertTrue((String)listenerError.toString(), (boolean)areListenerResultsValid);
    }

    public void testS2CWithOldValueAtClientOverflownToDisk() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        EvictionAttributes evAttr = EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", Boolean.TRUE, evAttr);
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createDelta");
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAnEntry");
        Thread.sleep(5000L);
        DeltaPropagationDUnitTest.verifyOverflowOccured(1L, 2);
        VM0.invoke(DeltaPropagationDUnitTest.class, "updateDelta");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltas), (fromDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(3, 5);
        DeltaPropagationDUnitTest.assertTrue((String)listenerError.toString(), (boolean)areListenerResultsValid);
    }

    public void testS2CWithLocallyDestroyedOldValueAtClient() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        EvictionAttributes evAttr = EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", Boolean.TRUE, evAttr);
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createDelta");
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAnEntry");
        Thread.sleep(5000L);
        DeltaPropagationDUnitTest.verifyOverflowOccured(1L, 1);
        VM0.invoke(DeltaPropagationDUnitTest.class, "updateDelta");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("4 deltas were to be received but were " + fromDeltas), (fromDeltas == 4L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(4, 4);
    }

    public void testS2CWithInvalidatedOldValueAtClient() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(1));
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createDelta");
        VM0.invoke(DeltaPropagationDUnitTest.class, "invalidateDelta");
        VM0.invoke(DeltaPropagationDUnitTest.class, "updateDelta");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltas = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltas = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltas), (toDeltas == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("4 deltas were to be received but were " + fromDeltas), (fromDeltas == 4L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.verifyData(2, 5);
        DeltaPropagationDUnitTest.assertTrue((String)listenerError.toString(), (boolean)areListenerResultsValid);
    }

    public void testS2CDeltaPropagationWithClientConflationON() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", "true", new Integer(4), null, null);
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature used.", (DeltaTestImpl.getFromDeltaInvokations() == 0L ? 1 : 0) != 0);
    }

    public void testS2CDeltaPropagationWithServerConflationON() throws Exception {
        VM0.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem", 1, 0, Boolean.TRUE, null});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", "server", new Integer(4), null, null);
        VM3.invoke(DeltaPropagationDUnitTest.class, "createClientCache", new Object[]{new Integer(PORT1), new Integer(-1), "0", "false", new Integer(4), null, null});
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM3.invoke(DeltaPropagationDUnitTest.class, "registerInterestListAll");
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        VM3.invoke(DeltaPropagationDUnitTest.class, "waitForLastKey");
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature used.", (DeltaTestImpl.getFromDeltaInvokations() == 0L ? 1 : 0) != 0);
        long fromDeltaInvocations = (Long)VM3.invoke(DeltaTestImpl.class, "getFromDeltaInvokations");
        DeltaPropagationDUnitTest.assertTrue((String)"Expected 5 fromDelta() invocations but found ", (fromDeltaInvocations == 5L ? 1 : 0) != 0);
    }

    public void testS2CDeltaPropagationWithOnlyCreateEvents() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(4));
        DeltaPropagationDUnitTest.registerInterestListAll();
        VM0.invoke(DeltaPropagationDUnitTest.class, "createDeltas");
        DeltaPropagationDUnitTest.waitForLastKey();
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature used.", ((Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations") == 0L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature used.", (DeltaTestImpl.getFromDeltaInvokations() == 0L ? 1 : 0) != 0);
    }

    public void testC2S2SDeltaPropagation() throws Exception {
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM1.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        DeltaTestImpl val = deltaPut[1];
        VM0.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem", new Integer(1), new Integer(3)});
        PORT2 = (Integer)VM1.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem", new Integer(1), new Integer(3)});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT1), new Integer(-1), "0", new Integer(0));
        Region r = cache.getRegion("/DeltaPropagationDUnitTest");
        DeltaPropagationDUnitTest.assertNotNull((Object)r);
        r.create((Object)DELTA_KEY, (Object)deltaPut[0]);
        VM0.invoke(DeltaPropagationDUnitTest.class, "doLocalOp", new Object[]{INVALIDATE, regionName, DELTA_KEY});
        VM1.invoke(DeltaPropagationDUnitTest.class, "doLocalOp", new Object[]{INVALIDATE, regionName, DELTA_KEY});
        VM0.invoke(DeltaPropagationDUnitTest.class, "assertOp", new Object[]{INVALIDATE, new Integer(1)});
        VM1.invoke(DeltaPropagationDUnitTest.class, "assertOp", new Object[]{INVALIDATE, new Integer(1)});
        r.put((Object)DELTA_KEY, (Object)val);
        Thread.sleep(5000L);
        VM1.invoke(DeltaPropagationDUnitTest.class, "assertValue", new Object[]{regionName, DELTA_KEY, val});
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature used.", ((Boolean)VM0.invoke(DeltaTestImpl.class, "deltaFeatureUsed") == false ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature used.", ((Boolean)VM1.invoke(DeltaTestImpl.class, "deltaFeatureUsed") == false ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation feature NOT used.", (boolean)DeltaTestImpl.deltaFeatureUsed());
    }

    public void testS2S2CDeltaPropagationWithHAOverflow() throws Exception {
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM1.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM0.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"none", new Integer(1)});
        PORT2 = (Integer)VM1.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"entry", new Integer(1)});
        VM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        VM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        DeltaPropagationDUnitTest.createClientCache(new Integer(PORT2), new Integer(-1), "0", new Integer(1));
        Region r = cache.getRegion("/DeltaPropagationDUnitTest");
        DeltaPropagationDUnitTest.assertNotNull((Object)r);
        r.registerInterest((Object)"ALL_KEYS");
        VM0.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
        VM1.invoke(DeltaPropagationDUnitTest.class, "confirmEviction", new Object[]{new Integer(PORT2)});
        VM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        DeltaPropagationDUnitTest.waitForLastKey();
        long toDeltasOnServer1 = (Long)VM0.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltasOnServer2 = (Long)VM1.invoke(DeltaTestImpl.class, "getFromDeltaInvokations");
        long toDeltasOnServer2 = (Long)VM1.invoke(DeltaTestImpl.class, "getToDeltaInvokations");
        long fromDeltasOnClient = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be sent but were " + toDeltasOnServer1), (toDeltasOnServer1 == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltasOnServer2), (fromDeltasOnServer2 == 5L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("0 toDelta() were to be invoked but were " + toDeltasOnServer2), (toDeltasOnServer2 == 0L ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltasOnClient), (fromDeltasOnClient == 5L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testS2CDeltaPropagationWithGIIAndFailover() throws Exception {
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM1.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM2.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM0.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"none", new Integer(1), new Integer(0)});
        PORT2 = (Integer)VM1.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"none", new Integer(1), new Integer(0)});
        int port3 = (Integer)VM2.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"none", new Integer(1), new Integer(0)});
        try {
            VM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
            VM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
            VM2.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
            DeltaPropagationDUnitTest.createClientCache(new int[]{PORT1, PORT2, port3}, "1", "server", new Integer(1), null, null);
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"ALL_KEYS");
            VM primary = ((PoolImpl)pool).getPrimaryPort() == PORT1 ? VM0 : (((PoolImpl)pool).getPrimaryPort() == PORT2 ? VM1 : VM2);
            primary.invoke(DeltaPropagationDUnitTest.class, "createAndUpdateDeltas");
            Thread.sleep(5000L);
            primary.invoke(DeltaPropagationDUnitTest.class, "closeCache");
            Thread.sleep(5000L);
            primary = ((PoolImpl)pool).getPrimaryPort() == PORT1 ? VM0 : (((PoolImpl)pool).getPrimaryPort() == PORT2 ? VM1 : VM2);
            VM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            VM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            VM2.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            primary.invoke(DeltaPropagationDUnitTest.class, "closeCache");
            Thread.sleep(5000L);
            primary = ((PoolImpl)pool).getPrimaryPort() == PORT1 ? VM0 : (((PoolImpl)pool).getPrimaryPort() == PORT2 ? VM1 : VM2);
            DeltaPropagationDUnitTest.getLogWriter().info("waiting for client to receive last_key");
            DeltaPropagationDUnitTest.waitForLastKey();
            long fromDeltasOnClient = DeltaTestImpl.getFromDeltaInvokations();
            DeltaPropagationDUnitTest.assertTrue((String)("5 deltas were to be received but were " + fromDeltasOnClient), (fromDeltasOnClient == 5L ? 1 : 0) != 0);
        }
        finally {
            VM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            VM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            VM2.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40165ClientReconnects() throws Exception {
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        try {
            VM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
            String durableClientId = this.getName() + "_client";
            PoolFactory pf = PoolManager.createFactory();
            pf.addServer("localhost", PORT1).setSubscriptionEnabled(true).setSubscriptionAckInterval(1);
            ((PoolFactoryImpl)pf).getPoolAttributes();
            Properties properties = new Properties();
            properties.setProperty("mcast-port", "0");
            properties.setProperty("locators", "");
            properties.setProperty("durable-client-id", durableClientId);
            properties.setProperty("durable-client-timeout", String.valueOf(60));
            DeltaPropagationDUnitTest.createDurableCacheClient((Pool)((PoolFactoryImpl)pf).getPoolAttributes(), regionName, properties, new Integer(5), Boolean.TRUE);
            VM0.invoke(DeltaPropagationDUnitTest.class, "doPuts");
            VM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            Thread.sleep(5000L);
            DeltaPropagationDUnitTest.createDurableCacheClient((Pool)((PoolFactoryImpl)pf).getPoolAttributes(), regionName, properties, new Integer(5), Boolean.FALSE);
            DeltaPropagationDUnitTest.waitForLastKey();
            long fromDeltasOnClient = DeltaTestImpl.getFromDeltaInvokations();
            DeltaPropagationDUnitTest.assertTrue((String)("No deltas were to be received but received: " + fromDeltasOnClient), (fromDeltasOnClient < 1L ? 1 : 0) != 0);
        }
        finally {
            VM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40165ClientFailsOver() throws Exception {
        VM pVM;
        PORT1 = (Integer)VM0.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
        DeltaPropagationDUnitTest.prepareDeltas();
        VM0.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        VM1.invoke(DeltaPropagationDUnitTest.class, "prepareDeltas");
        try {
            VM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
            PORT2 = (Integer)VM1.invoke(DeltaPropagationDUnitTest.class, "createServerCache", new Object[]{"mem"});
            VM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
            String durableClientId = this.getName() + "_client";
            PoolFactory pf = PoolManager.createFactory();
            pf.addServer("localhost", PORT1).addServer("localhost", PORT2).setSubscriptionEnabled(true).setSubscriptionAckInterval(1).setSubscriptionRedundancy(2);
            ((PoolFactoryImpl)pf).getPoolAttributes();
            Properties properties = new Properties();
            properties.setProperty("mcast-port", "0");
            properties.setProperty("locators", "");
            properties.setProperty("durable-client-id", durableClientId);
            properties.setProperty("durable-client-timeout", String.valueOf(60));
            DeltaPropagationDUnitTest.createDurableCacheClient((Pool)((PoolFactoryImpl)pf).getPoolAttributes(), regionName, properties, new Integer(5), Boolean.FALSE);
            VM0.invoke(DeltaPropagationDUnitTest.class, "doPuts");
        }
        finally {
            VM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
            VM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        }
        VM vM = pVM = ((PoolImpl)pool).getPrimaryPort() == PORT1 ? VM0 : VM1;
        while (!markerReceived) {
            Thread.sleep(50L);
        }
        pVM.invoke(DeltaPropagationDUnitTest.class, "closeCache");
        Thread.sleep(5000L);
        DeltaPropagationDUnitTest.waitForLastKey();
        long fromDeltasOnClient = DeltaTestImpl.getFromDeltaInvokations();
        DeltaPropagationDUnitTest.assertTrue((String)("Atleast 99 deltas were to be received but received: " + fromDeltasOnClient), (fromDeltasOnClient >= 99L ? 1 : 0) != 0);
    }

    public static void doLocalOp(String op, String rName, String key) {
        try {
            Region r = cache.getRegion("/" + rName);
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            if (INVALIDATE.equals(op)) {
                r.localInvalidate((Object)key);
            } else if (DESTROY.equals(op)) {
                r.localDestroy((Object)key);
            }
        }
        catch (Exception e) {
            DeltaPropagationDUnitTest.fail("failed in doLocalOp()", e);
        }
    }

    public static void assertOp(String op, Integer num) {
        final int expected = num;
        DistributedTestCase.WaitCriterion wc = null;
        if (INVALIDATE.equals(op)) {
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return numOfInvalidates == expected;
                }

                @Override
                public String description() {
                    return "numOfInvalidates was expected to be " + expected + " but is " + numOfInvalidates;
                }
            };
        } else if (DESTROY.equals(op)) {
            wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return numOfInvalidates == expected;
                }

                @Override
                public String description() {
                    return "numOfDestroys was expected to be " + expected + " but is " + numOfDestroys;
                }
            };
        }
        DistributedTestCase.waitForCriterion(wc, 5000L, 100L, true);
    }

    public static void assertValue(String rName, String key, Object expected) {
        try {
            Region r = cache.getRegion("/" + rName);
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            Object value = r.getEntry((Object)key).getValue();
            DeltaPropagationDUnitTest.assertTrue((String)("Value against " + key + " is " + value + ". It should be " + expected), (boolean)expected.equals(value));
        }
        catch (Exception e) {
            DeltaPropagationDUnitTest.fail("failed in assertValue()", e);
        }
    }

    public static void confirmEviction(Integer port) {
        final EnableLRU cc = ((VMLRURegionMap)((LocalRegion)DeltaPropagationDUnitTest.cache.getRegion((String)new StringBuilder().append((String)"/").append((String)BridgeServerImpl.generateNameForClientMsgsRegion((int)port.intValue())).toString())).entries)._getCCHelper();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return cc.getStats().getEvictions() > 0L;
            }

            @Override
            public String description() {
                return "HA Overflow did not occure.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
    }

    public static void waitForLastKey() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return DeltaPropagationDUnitTest.isLastKeyReceived();
            }

            @Override
            public String description() {
                return "Last key NOT received.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
    }

    public static void prepareDeltas() {
        for (int i = 0; i < 6; ++i) {
            DeltaPropagationDUnitTest.deltaPut[i] = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
        }
        deltaPut[1].setIntVar(5);
        deltaPut[2].setIntVar(5);
        deltaPut[3].setIntVar(5);
        deltaPut[4].setIntVar(5);
        deltaPut[5].setIntVar(5);
        deltaPut[2].resetDeltaStatus();
        deltaPut[2].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[3].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[4].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[5].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[3].resetDeltaStatus();
        deltaPut[3].setDoubleVar(new Double(5.0));
        deltaPut[4].setDoubleVar(new Double(5.0));
        deltaPut[5].setDoubleVar(new Double(5.0));
        deltaPut[4].resetDeltaStatus();
        deltaPut[4].setStr("str changed");
        deltaPut[5].setStr("str changed");
        deltaPut[5].resetDeltaStatus();
        deltaPut[5].setIntVar(100);
        deltaPut[5].setTestObj(new DeltaTestImpl.TestObject1("CHANGED", 100));
    }

    public static void prepareErroneousDeltasForToDelta() {
        for (int i = 0; i < 6; ++i) {
            DeltaPropagationDUnitTest.deltaPut[i] = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
        }
        deltaPut[1].setIntVar(5);
        deltaPut[2].setIntVar(5);
        deltaPut[3].setIntVar(-101);
        deltaPut[4].setIntVar(5);
        deltaPut[5].setIntVar(5);
        deltaPut[2].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[3].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[4].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[5].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[3].setDoubleVar(new Double(5.0));
        deltaPut[4].setDoubleVar(new Double(5.0));
        deltaPut[5].setDoubleVar(new Double(5.0));
        deltaPut[4].setStr("str changed");
        deltaPut[5].setStr("str changed");
        deltaPut[5].setIntVar(100);
        deltaPut[5].setTestObj(new DeltaTestImpl.TestObject1("CHANGED", 100));
    }

    public static void prepareErroneousDeltasForFromDelta() {
        for (int i = 0; i < 6; ++i) {
            DeltaPropagationDUnitTest.deltaPut[i] = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
        }
        deltaPut[1].setIntVar(5);
        deltaPut[2].setIntVar(5);
        deltaPut[3].setIntVar(5);
        deltaPut[4].setIntVar(5);
        deltaPut[5].setIntVar(5);
        deltaPut[2].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[3].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[4].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[5].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltaPut[3].setDoubleVar(new Double(5.0));
        deltaPut[4].setDoubleVar(new Double(5.0));
        deltaPut[5].setDoubleVar(new Double(5.0));
        deltaPut[4].setStr("str changed");
        deltaPut[5].setStr("ERRONEOUS_STRING");
        deltaPut[5].setIntVar(100);
        deltaPut[5].setTestObj(new DeltaTestImpl.TestObject1("CHANGED", 100));
    }

    public static void doPuts() {
        DeltaPropagationDUnitTest.doPuts(100);
    }

    public static void doPuts(Integer num) {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            for (int i = 0; i < num; ++i) {
                DeltaTestImpl val = new DeltaTestImpl();
                val.setStr("" + i);
                r.put((Object)DELTA_KEY, (Object)val);
            }
            r.put((Object)LAST_KEY, (Object)"");
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in createDelta()", ex);
        }
    }

    public static void createAndUpdateDeltas() {
        DeltaPropagationDUnitTest.createDelta();
        DeltaPropagationDUnitTest.updateDelta();
    }

    public static void createDelta() {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            r.create((Object)DELTA_KEY, (Object)deltaPut[0]);
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in createDelta()", ex);
        }
    }

    public static void updateDelta() {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            for (int i = 1; i < 6; ++i) {
                try {
                    r.put((Object)DELTA_KEY, (Object)deltaPut[i]);
                    continue;
                }
                catch (InvalidDeltaException ide) {
                    DeltaPropagationDUnitTest.assertTrue((String)("InvalidDeltaException not expected for deltaPut[" + i + "]"), (deltaPut[i].getIntVar() == -101 ? 1 : 0) != 0);
                }
            }
            r.put((Object)LAST_KEY, (Object)"");
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in updateDelta()", ex);
        }
    }

    public static void createDeltas() {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            for (int i = 0; i < 100; ++i) {
                r.create((Object)(DELTA_KEY + i), (Object)new DeltaTestImpl());
            }
            r.create((Object)LAST_KEY, (Object)"");
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in createDeltas()", ex);
        }
    }

    public static void createAnEntry() {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            r.create((Object)"KEY-A", (Object)"I push the delta out to disk :)");
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in createAnEntry()", ex);
        }
    }

    public static void invalidateDelta() {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            r.invalidate((Object)DELTA_KEY);
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in invalidateDelta()", ex);
        }
    }

    public static void verifyOverflowOccured(long evictions, int regionsize) {
        EnableLRU cc = ((VMLRURegionMap)((LocalRegion)DeltaPropagationDUnitTest.cache.getRegion((String)regionName)).entries)._getCCHelper();
        Assert.assertTrue((cc.getStats().getEvictions() == evictions ? 1 : 0) != 0, (Object)("Number of evictions expected to be " + evictions + " but was " + cc.getStats().getEvictions()));
        int rSize = ((LocalRegion)cache.getRegion(regionName)).getRegionMap().size();
        Assert.assertTrue((rSize == regionsize ? 1 : 0) != 0, (Object)("Region size expected to be " + regionsize + " but was " + rSize));
    }

    public static void verifyData(int creates, int updates) {
        DeltaPropagationDUnitTest.assertEquals((int)creates, (int)numOfCreates);
        DeltaPropagationDUnitTest.assertEquals((int)updates, (int)numOfUpdates);
    }

    public static Integer createServerCache(String ePolicy) throws Exception {
        return DeltaPropagationDUnitTest.createServerCache(ePolicy, 1);
    }

    public static Integer createServerCache(String ePolicy, Integer cap) throws Exception {
        return DeltaPropagationDUnitTest.createServerCache(ePolicy, cap, new Integer(0));
    }

    public static Integer createServerCache(String ePolicy, Integer cap, Integer listenerCode) throws Exception {
        return DeltaPropagationDUnitTest.createServerCache(ePolicy, cap, listenerCode, Boolean.FALSE, null);
    }

    public static Integer createServerCache(String ePolicy, Integer cap, Integer listenerCode, Boolean conflate, Compressor compressor) throws Exception {
        RegionAttributes attrs;
        ConnectionTable.threadWantsSharedResources();
        new DeltaPropagationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setEnableSubscriptionConflation(conflate.booleanValue());
        if (listenerCode != 0) {
            factory.addCacheListener(DeltaPropagationDUnitTest.getCacheListener(listenerCode));
        }
        if (compressor != null) {
            factory.setCompressor(compressor);
        }
        if (listenerCode == 3) {
            factory.setScope(Scope.DISTRIBUTED_NO_ACK);
            factory.setDataPolicy(DataPolicy.NORMAL);
            factory.setConcurrencyChecksEnabled(false);
            attrs = factory.create();
            Region r = cache.createRegion(regionName, attrs);
            logger = cache.getLogger();
            r.create((Object)DELTA_KEY, (Object)deltaPut[0]);
        } else {
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.setConcurrencyChecksEnabled(false);
            attrs = factory.create();
            cache.createRegion(regionName, attrs);
            logger = cache.getLogger();
        }
        int port = AvailablePort.getRandomAvailablePort((int)0);
        CacheServer server1 = cache.addCacheServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        if (ePolicy != null) {
            File overflowDirectory = new File("bsi_overflow_" + port);
            overflowDirectory.mkdir();
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            File[] dirs1 = new File[]{overflowDirectory};
            server1.getClientSubscriptionConfig().setEvictionPolicy(ePolicy);
            server1.getClientSubscriptionConfig().setCapacity(cap.intValue());
            server1.getClientSubscriptionConfig().setDiskStoreName(dsf.setDiskDirs(dirs1).create("bsi").getName());
        }
        server1.start();
        return new Integer(server1.getPort());
    }

    public static CacheListener getCacheListener(Integer code) {
        CacheListenerAdapter listener = null;
        switch (code) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                listener = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent event) {
                        numOfCreates++;
                        logger.fine("Create Event: <" + event.getKey() + ", " + event.getNewValue() + ">");
                        if (DELTA_KEY.equals(event.getKey()) && !deltaPut[0].equals(event.getNewValue())) {
                            areListenerResultsValid = false;
                            listenerError.append("Create event:\n |-> sent: " + deltaPut[0] + "\n |-> rcvd: " + event.getNewValue() + "\n");
                        } else if (LAST_KEY.equals(event.getKey())) {
                            lastKeyReceived = true;
                        }
                    }

                    public void afterUpdate(EntryEvent event) {
                        numOfUpdates++;
                        logger.fine("Update Event: <" + event.getKey() + ", " + event.getNewValue() + ">" + ", numOfUpdates: " + numOfUpdates);
                        if (!deltaPut[numOfUpdates].equals(event.getNewValue())) {
                            areListenerResultsValid = false;
                            listenerError.append("\nUpdate event(" + numOfUpdates + "):\n |-> sent: " + deltaPut[numOfUpdates] + "\n |-> recd: " + event.getNewValue());
                        }
                    }
                };
                break;
            }
            case 6: {
                listener = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent event) {
                        numOfCreates++;
                        logger.fine("Create Event: <" + event.getKey() + ", " + event.getNewValue() + ">");
                        if (DELTA_KEY.equals(event.getKey()) && !deltaPut[0].equals(event.getNewValue())) {
                            areListenerResultsValid = false;
                            listenerError.append("Create event:\n |-> sent: " + deltaPut[0] + "\n |-> rcvd: " + event.getNewValue() + "\n");
                        } else if (LAST_KEY.equals(event.getKey())) {
                            lastKeyReceived = true;
                        }
                    }

                    public void afterUpdate(EntryEvent event) {
                        int tmp = ++numOfUpdates;
                        logger.fine("Update Event: <" + event.getKey() + ", " + event.getNewValue() + ">" + ", numOfUpdates: " + numOfUpdates);
                        int n = tmp = tmp >= 3 ? ++tmp : tmp;
                        if (!deltaPut[tmp].equals(event.getNewValue())) {
                            areListenerResultsValid = false;
                            listenerError.append("\nUpdate event(" + numOfUpdates + "):\n |-> sent: " + deltaPut[tmp] + "\n |-> recd: " + event.getNewValue());
                        }
                    }
                };
                break;
            }
            case 3: {
                listener = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent event) {
                        numOfCreates++;
                        logger.fine("Create Event: <" + event.getKey() + ", " + event.getNewValue() + ">");
                        if (LAST_KEY.equals(event.getKey())) {
                            lastKeyReceived = true;
                        }
                    }

                    public void afterUpdate(EntryEvent event) {
                        numOfUpdates++;
                        logger.fine("Update Event: <" + event.getKey() + ", " + event.getNewValue() + ">" + ", numOfUpdates: " + numOfUpdates);
                    }

                    public void afterInvalidate(EntryEvent event) {
                        numOfInvalidates++;
                        logger.fine("Invalidate Event: <" + event.getKey() + ", " + event.getOldValue() + ">" + ", numOfInvalidates: " + numOfInvalidates);
                    }

                    public void afterDestroy(EntryEvent event) {
                        numOfDestroys++;
                        logger.fine("Destroy Event: <" + event.getKey() + ", " + event.getOldValue() + ">" + ", numOfDestroys: " + numOfDestroys);
                    }
                };
                break;
            }
            case 4: {
                listener = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent event) {
                        if (LAST_KEY.equals(event.getKey())) {
                            lastKeyReceived = true;
                        }
                    }
                };
                break;
            }
            case 5: {
                listener = new CacheListenerAdapter(){

                    public void afterRegionLive(RegionEvent event) {
                        logger.fine("Marker received");
                        if (Operation.MARKER == event.getOperation()) {
                            markerReceived = true;
                            if (closeCache) {
                                logger.fine("Closing the durable client cache...");
                                DeltaPropagationDUnitTest.closeCache(true);
                            }
                        }
                    }

                    public void afterCreate(EntryEvent event) {
                        logger.fine("CREATE received");
                        if (LAST_KEY.equals(event.getKey())) {
                            logger.fine("LAST KEY received");
                            lastKeyReceived = true;
                        }
                    }

                    public void afterUpdate(EntryEvent event) {
                        TestCase.assertNotNull((Object)event.getNewValue());
                    }
                };
                break;
            }
            default: {
                DeltaPropagationDUnitTest.fail((String)"Invalid listener code");
            }
        }
        return listener;
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel) throws Exception {
        DeltaPropagationDUnitTest.createClientCache(port1, port2, rLevel, "server", new Integer(1), null, null);
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel, Boolean addListener, EvictionAttributes evictAttrs) throws Exception {
        DeltaPropagationDUnitTest.createClientCache(port1, port2, rLevel, "server", new Integer(1), evictAttrs, null);
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel, Boolean addListener, ExpirationAttributes expAttrs) throws Exception {
        DeltaPropagationDUnitTest.createClientCache(port1, port2, rLevel, "server", new Integer(1), null, expAttrs);
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel, Integer listener) throws Exception {
        DeltaPropagationDUnitTest.createClientCache(port1, port2, rLevel, "server", listener, null, null);
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel, String conflate, Integer listener, EvictionAttributes evictAttrs, ExpirationAttributes expAttrs) throws Exception {
        int[] ports = null;
        ports = port2 != -1 ? new int[]{port1, port2} : new int[]{port1};
        DeltaPropagationDUnitTest.assertTrue((String)"No server ports provided", (ports != null ? 1 : 0) != 0);
        DeltaPropagationDUnitTest.createClientCache(ports, rLevel, conflate, listener, evictAttrs, expAttrs);
    }

    public static void createClientCache(int[] ports, String rLevel, String conflate, Integer listener, EvictionAttributes evictAttrs, ExpirationAttributes expAttrs) throws Exception {
        CacheServerTestUtil.disableShufflingOfEndpoints();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        props.setProperty("conflate-events", conflate);
        new DeltaPropagationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        pool = BridgeTestCase.configureConnectionPool(factory, "localhost", ports, true, Integer.parseInt(rLevel), 2, null, 1000, 250, false, -2);
        factory.setScope(Scope.LOCAL);
        if (listener != 0) {
            factory.addCacheListener(DeltaPropagationDUnitTest.getCacheListener((int)listener));
        }
        if (evictAttrs != null) {
            factory.setEvictionAttributes(evictAttrs);
        }
        if (expAttrs != null) {
            factory.setEntryTimeToLive(expAttrs);
        }
        if (evictAttrs != null && evictAttrs.getAction().isOverflowToDisk()) {
            int port = AvailablePort.getRandomAvailablePort((int)0);
            File dir = new File("overflow_" + port);
            if (!dir.exists()) {
                dir.mkdir();
            }
            File[] dir1 = new File[]{dir};
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            factory.setDiskStoreName(dsf.setDiskDirs(dir1).create("client_overflow_ds").getName());
        }
        factory.setConcurrencyChecksEnabled(false);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(regionName, attrs);
        logger = cache.getLogger();
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        DeltaPropagationDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        DeltaPropagationDUnitTest.assertNotNull((Object)cache);
    }

    public static void verifyRegionSize(Integer regionSize, Integer msgsRegionsize, Integer port) {
        try {
            Region region = cache.getRegion("/DeltaPropagationDUnitTest");
            Region msgsRegion = cache.getRegion(BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
            logger.fine("size<serverRegion, clientMsgsRegion>: " + region.size() + ", " + msgsRegion.size());
            DeltaPropagationDUnitTest.assertEquals((int)regionSize, (int)region.size());
            DeltaPropagationDUnitTest.assertEquals((int)msgsRegionsize, (int)msgsRegion.size());
        }
        catch (Exception e) {
            DeltaPropagationDUnitTest.fail((String)("failed in verifyRegionSize()" + e));
        }
    }

    public static void createDurableCacheClient(Pool poolAttr, String regionName, Properties dsProperties, Integer listenerCode, Boolean close) throws Exception {
        new DeltaPropagationDUnitTest("temp").createCache(dsProperties);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        PoolImpl p = (PoolImpl)pf.create(regionName);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(false);
        factory.setPoolName(p.getName());
        if (listenerCode != 0) {
            factory.addCacheListener(DeltaPropagationDUnitTest.getCacheListener(listenerCode));
        }
        RegionAttributes attrs = factory.create();
        Region r = cache.createRegion(regionName, attrs);
        r.registerInterest((Object)"ALL_KEYS");
        pool = p;
        cache.readyForEvents();
        logger = cache.getLogger();
        closeCache = close;
    }

    public static void registerInterestListAll() {
        try {
            Region r = cache.getRegion("/DeltaPropagationDUnitTest");
            DeltaPropagationDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"ALL_KEYS");
        }
        catch (Exception ex) {
            DeltaPropagationDUnitTest.fail("failed in registerInterestListAll", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void closeCache(boolean keepalive) {
        if (cache != null && !cache.isClosed()) {
            cache.close(keepalive);
            cache.getDistributedSystem().disconnect();
        }
    }

    public static boolean isLastKeyReceived() {
        return lastKeyReceived;
    }

    public static void setLastKeyReceived(boolean val) {
        lastKeyReceived = val;
    }

    public static void resetAll() {
        DeltaTestImpl.resetDeltaInvokationCounters();
        numOfEvents = 0;
        numOfDestroys = 0;
        numOfInvalidates = 0;
        numOfUpdates = 0;
        numOfCreates = 0;
        lastKeyReceived = false;
        markerReceived = false;
        areListenerResultsValid = true;
        listenerError = new StringBuffer("");
    }

    static {
        logger = null;
        lastKeyReceived = false;
        markerReceived = false;
        deltaPut = new DeltaTestImpl[6];
        areListenerResultsValid = true;
        closeCache = false;
        listenerError = new StringBuffer("");
        DELTA_KEY = "DELTA_KEY";
        LAST_KEY = "LAST_KEY";
    }
}

