/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class DeltaPropagationStatsDUnitTest
extends DistributedTestCase {
    protected static VM vm0 = null;
    protected static VM vm1 = null;
    protected static VM vm2 = null;
    protected static VM vm3 = null;
    protected static Cache cache = null;
    protected static Pool pool = null;
    public static String REGION_NAME = "DeltaPropagationStatsDUnitTest";
    private static String DELTA_KEY = "DELTA_KEY_";
    private static String LAST_KEY = "LAST_KEY";
    private static boolean lastKeyReceived = false;
    private static final int PEER_TO_PEER = 1;
    private static final int SERVER_TO_CLIENT = 2;
    private static final int CLIENT_TO_SERVER = 3;

    public DeltaPropagationStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        vm2 = host.getVM(2);
        vm3 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        lastKeyReceived = false;
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "resetLastKeyReceived");
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "resetLastKeyReceived");
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "resetLastKeyReceived");
        vm3.invoke(DeltaPropagationStatsDUnitTest.class, "resetLastKeyReceived");
        DeltaPropagationStatsDUnitTest.closeCache();
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "closeCache");
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "closeCache");
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "closeCache");
        vm3.invoke(DeltaPropagationStatsDUnitTest.class, "closeCache");
    }

    public static void resetLastKeyReceived() {
        lastKeyReceived = false;
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testS2CDeltaPropagationCleanStats() throws Exception {
        int numOfKeys = 50;
        long updates = 50L;
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        int port = (Integer)vm0.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        DeltaPropagationStatsDUnitTest.createClientCache(DeltaPropagationStatsDUnitTest.getServerHostName(vm0.getHost()), port);
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putCleanDelta", new Object[]{numOfKeys, updates});
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putLastKey");
        DeltaPropagationStatsDUnitTest.waitForLastKey();
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaSenderStats", new Object[]{2, (long)numOfKeys * updates});
        DeltaPropagationStatsDUnitTest.verifyDeltaReceiverStats(2, (long)numOfKeys * updates, 0L);
    }

    public void testS2CDeltaPropagationFailedStats1() throws Exception {
        int numOfKeys = 25;
        long updates = 50L;
        long errors = 100L;
        long errors2 = 34L;
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        int port = (Integer)vm0.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        DeltaPropagationStatsDUnitTest.createClientCache(DeltaPropagationStatsDUnitTest.getServerHostName(vm0.getHost()), port);
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putErrorDeltaForReceiver", new Object[]{numOfKeys, updates, errors});
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putErrorDeltaForSender", new Object[]{numOfKeys, updates, errors2, Boolean.FALSE});
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putLastKey");
        DeltaPropagationStatsDUnitTest.waitForLastKey();
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaSenderStats", new Object[]{2, (long)(2 * numOfKeys) * updates - errors2});
        DeltaPropagationStatsDUnitTest.verifyDeltaReceiverStats(2, (long)(2 * numOfKeys) * updates - errors - errors2, errors);
    }

    public void _testS2CDeltaPropagationFailedStats2() throws Exception {
    }

    public void testP2PDeltaPropagationCleanStats() throws Exception {
        int numOfKeys = 50;
        long updates = 50L;
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putCleanDelta", new Object[]{numOfKeys, updates});
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putLastKey");
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "waitForLastKey");
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "waitForLastKey");
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaSenderStats", new Object[]{1, (long)numOfKeys * updates});
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaReceiverStats", new Object[]{1, (long)numOfKeys * updates, 0L});
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaReceiverStats", new Object[]{1, (long)numOfKeys * updates, 0L});
    }

    public void testP2PDeltaPropagationFailedStats1() throws Exception {
        int numOfKeys = 50;
        int numOfkeys2 = 10;
        long updates = 50L;
        long updates2 = 50L;
        long errors = 100L;
        long errors2 = 0L;
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putErrorDeltaForReceiver", new Object[]{numOfKeys, updates, errors});
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putErrorDeltaForSender", new Object[]{numOfkeys2, updates2, errors2, Boolean.FALSE});
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "putLastKey");
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "waitForLastKey");
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "waitForLastKey");
        long deltasSent = (long)numOfKeys * updates + (long)numOfkeys2 * updates2 - errors2;
        long deltasProcessed = deltasSent - errors;
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaSenderStats", new Object[]{1, deltasSent});
        vm1.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaReceiverStats", new Object[]{1, deltasProcessed, errors});
        vm2.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaReceiverStats", new Object[]{1, deltasProcessed, errors});
    }

    public void _testP2PDeltaPropagationFailedStats2() throws Exception {
    }

    public void testC2SDeltaPropagationCleanStats() throws Exception {
        int numOfKeys = 50;
        long updates = 50L;
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        Integer port = (Integer)vm0.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        DeltaPropagationStatsDUnitTest.createClientCache(DeltaPropagationStatsDUnitTest.getServerHostName(vm0.getHost()), port);
        DeltaPropagationStatsDUnitTest.putCleanDelta(numOfKeys, updates);
        DeltaPropagationStatsDUnitTest.putLastKey();
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "waitForLastKey");
        DeltaPropagationStatsDUnitTest.verifyDeltaSenderStats(3, (long)numOfKeys * updates);
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaReceiverStats", new Object[]{3, (long)numOfKeys * updates, 0L});
    }

    public void testC2SDeltaPropagationFailedStats1() throws Exception {
        int numOfKeys = 50;
        long updates = 50L;
        long errors = 100L;
        long errors2 = 13L;
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        Integer port = (Integer)vm0.invoke(DeltaPropagationStatsDUnitTest.class, "createServerCache", args);
        DeltaPropagationStatsDUnitTest.createClientCache(DeltaPropagationStatsDUnitTest.getServerHostName(vm0.getHost()), port);
        DeltaPropagationStatsDUnitTest.putErrorDeltaForReceiver(numOfKeys, updates, errors);
        DeltaPropagationStatsDUnitTest.putErrorDeltaForSender(numOfKeys, updates, errors2, Boolean.FALSE);
        DeltaPropagationStatsDUnitTest.putLastKey();
        long deltasSent = 2L * ((long)numOfKeys * updates) - errors2;
        long deltasProcessed = deltasSent - errors;
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "waitForLastKey");
        DeltaPropagationStatsDUnitTest.verifyDeltaSenderStats(3, deltasSent);
        vm0.invoke(DeltaPropagationStatsDUnitTest.class, "verifyDeltaReceiverStats", new Object[]{3, deltasProcessed, errors});
    }

    public void _testC2SDeltaPropagationFailedStats2() throws Exception {
    }

    public static void waitForLastKey() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return lastKeyReceived;
            }

            @Override
            public String description() {
                return "Last key NOT received.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 15000L, 100L, true);
    }

    public static void putCleanDelta(Integer keys, Long updates) {
        int i;
        Region r = cache.getRegion(REGION_NAME);
        for (i = 0; i < keys; ++i) {
            r.create((Object)(DELTA_KEY + i), (Object)new DeltaTestImpl());
        }
        for (i = 0; i < keys; ++i) {
            for (long j = 0L; j < updates; ++j) {
                DeltaTestImpl delta = new DeltaTestImpl();
                if (j % 3L == 1L) {
                    delta.setIntVar(10);
                } else if (j % 3L == 2L) {
                    delta.setStr("two");
                } else {
                    delta.setByteArr(new byte[]{11, 22, 33, 44});
                    delta.setDoubleVar(Double.valueOf(5.7));
                }
                r.put((Object)(DELTA_KEY + i), (Object)delta);
            }
        }
    }

    public static void putErrorDeltaForReceiver(Integer keys, Long updates, Long errors) {
        int i;
        Region r = cache.getRegion(REGION_NAME);
        DeltaPropagationStatsDUnitTest.assertTrue((String)"Errors cannot be more than 1/3rd of total udpates", (updates * (long)keys.intValue() / 3L > errors ? 1 : 0) != 0);
        for (i = 0; i < keys; ++i) {
            r.create((Object)(DELTA_KEY + i), (Object)new DeltaTestImpl());
        }
        for (i = 0; i < keys; ++i) {
            for (long j = 0L; j < updates; ++j) {
                DeltaTestImpl delta = new DeltaTestImpl();
                if (j % 3L == 1L) {
                    delta.setIntVar(10);
                } else if (j % 3L == 2L) {
                    delta.setStr("two");
                    if (errors != 0L) {
                        delta.setStr("ERRONEOUS_STRING");
                        Long l = errors;
                        Long l2 = errors = Long.valueOf(errors - 1L);
                    }
                } else {
                    delta.setByteArr(new byte[]{11, 22, 33, 44});
                    delta.setDoubleVar(Double.valueOf(5.7));
                }
                r.put((Object)(DELTA_KEY + i), (Object)delta);
            }
        }
        DeltaPropagationStatsDUnitTest.assertTrue((String)"Error puts not exhausted", (errors == 0L ? 1 : 0) != 0);
    }

    public static void putErrorDeltaForSender(Integer keys, Long updates, Long errors, Boolean doCreate) {
        int i;
        Region r = cache.getRegion(REGION_NAME);
        DeltaPropagationStatsDUnitTest.assertTrue((String)"Errors cannot be more than 1/3rd of total updates", ((long)keys.intValue() * updates / 3L > errors ? 1 : 0) != 0);
        if (doCreate.booleanValue()) {
            for (i = 0; i < keys; ++i) {
                r.create((Object)(DELTA_KEY + i), (Object)new DeltaTestImpl());
            }
        }
        for (i = 0; i < keys; ++i) {
            for (long j = 0L; j < updates; ++j) {
                DeltaTestImpl delta = new DeltaTestImpl();
                if (j % 3L == 1L) {
                    delta.setStr("one");
                } else if (j % 3L == 2L) {
                    delta.setIntVar(111);
                    if (errors != 0L) {
                        delta.setIntVar(-101);
                        Long l = errors;
                        Long l2 = errors = Long.valueOf(errors - 1L);
                    }
                } else {
                    delta.setByteArr(new byte[]{11, 22, 33, 44});
                    delta.setDoubleVar(Double.valueOf(5.7));
                }
                try {
                    r.put((Object)(DELTA_KEY + i), (Object)delta);
                    DeltaPropagationStatsDUnitTest.assertTrue((String)"Expected an InvalidDeltaException to be thrown, but it wasn't!", (delta.getIntVar() != -101 ? 1 : 0) != 0);
                    continue;
                }
                catch (InvalidDeltaException ide) {
                    DeltaPropagationStatsDUnitTest.assertTrue((String)"InvalidDeltaException not expected.", (delta.getIntVar() == -101 ? 1 : 0) != 0);
                    cache.getLoggerI18n().fine("Recieved InvalidDeltaException as expected.");
                }
            }
        }
        DeltaPropagationStatsDUnitTest.assertTrue((String)"Error puts not exhausted", (errors == 0L ? 1 : 0) != 0);
    }

    public static void putLastKey() {
        Region r = cache.getRegion(REGION_NAME);
        r.create((Object)LAST_KEY, (Object)"LAST_VALUE");
    }

    public static void verifyDeltaSenderStats(Integer path, Long expectedDeltasSent) {
        long numOfDeltasSent = 0L;
        long deltaTime = 0L;
        LocalRegion region = (LocalRegion)cache.getRegion(REGION_NAME);
        if (path == 1) {
            numOfDeltasSent = region.getCachePerfStats().getDeltasSent();
            deltaTime = region.getCachePerfStats().getDeltasPreparedTime();
        } else if (path == 2) {
            CacheClientNotifier ccn = ((BridgeServerImpl)cache.getCacheServers().toArray()[0]).getAcceptor().getCacheClientNotifier();
            numOfDeltasSent = ((CacheClientProxy)ccn.getClientProxies().toArray()[0]).getStatistics().getDeltaMessagesSent();
            deltaTime = 1L;
        } else if (path == 3) {
            numOfDeltasSent = region.getCachePerfStats().getDeltasSent();
            deltaTime = DistributionStats.enableClockStats ? region.getCachePerfStats().getDeltasPreparedTime() : 1L;
        } else {
            DeltaPropagationStatsDUnitTest.fail((String)("Invalid path code for delta propagation: " + path));
        }
        DeltaPropagationStatsDUnitTest.assertTrue((String)("Number of deltas sent was expected to be " + expectedDeltasSent + " but is " + numOfDeltasSent), (numOfDeltasSent == expectedDeltasSent || numOfDeltasSent + 1L == expectedDeltasSent ? 1 : 0) != 0);
    }

    public static void verifyDeltaReceiverStats(Integer path, Long expectedDeltasProcessed, Long expectedDeltaFailures) {
        long numOfDeltasProcessed = 0L;
        long deltaTime = 0L;
        long deltaFailures = 0L;
        if (path == 1 || path == 3 || path == 2) {
            CachePerfStats stats = ((DistributedRegion)cache.getRegion(REGION_NAME)).getCachePerfStats();
            numOfDeltasProcessed = stats.getDeltaUpdates();
            deltaTime = stats.getDeltaUpdatesTime();
            deltaFailures = stats.getDeltaFailedUpdates();
        } else {
            DeltaPropagationStatsDUnitTest.fail((String)("Invalid path code for delta propagation: " + path));
        }
        DeltaPropagationStatsDUnitTest.assertTrue((String)("Number of deltas received was expected to be " + expectedDeltasProcessed + " but is " + numOfDeltasProcessed), (numOfDeltasProcessed == expectedDeltasProcessed ? 1 : 0) != 0);
        DeltaPropagationStatsDUnitTest.assertTrue((String)("Delta calculation is expected to be >= zero but was " + deltaTime), (deltaTime >= 0L ? 1 : 0) != 0);
        DeltaPropagationStatsDUnitTest.assertTrue((String)("Number of delta failures was expected to be " + expectedDeltaFailures + " but is " + deltaFailures), (deltaFailures == expectedDeltaFailures ? 1 : 0) != 0);
    }

    public static void createClientCache(String host, Integer port) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        cache = new DeltaPropagationStatsDUnitTest("temp").createCache(props);
        pool = PoolManager.createFactory().addServer(host, port.intValue()).setThreadLocalConnections(true).setMinConnections(1).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setReadTimeout(10000).setSocketBufferSize(32768).create("DeltaPropagationStatsDunitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.NORMAL);
        factory.setPoolName(pool.getName());
        factory.setCloningEnabled(false);
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if (LAST_KEY.equals(event.getKey())) {
                    lastKeyReceived = true;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs).registerInterest((Object)"ALL_KEYS");
    }

    public static Integer createServerCache(Boolean flag) throws Exception {
        ConnectionTable.threadWantsSharedResources();
        return DeltaPropagationStatsDUnitTest.createServerCache(flag, DataPolicy.DEFAULT, Scope.DISTRIBUTED_ACK, false);
    }

    public static Integer createServerCache(Boolean flag, DataPolicy policy, Scope scope, Boolean listener) throws Exception {
        ConnectionTable.threadWantsSharedResources();
        DeltaPropagationStatsDUnitTest test = new DeltaPropagationStatsDUnitTest("temp");
        Properties props = new Properties();
        if (!flag.booleanValue()) {
            props.setProperty("delta-propagation", "false");
        }
        cache = test.createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        factory.setDataPolicy(policy);
        if (listener.booleanValue()) {
            factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterCreate(EntryEvent event) {
                    if (event.getKey().equals(LAST_KEY)) {
                        lastKeyReceived = true;
                    }
                }
            });
        }
        Region region = cache.createRegion(REGION_NAME, factory.create());
        if (!policy.isReplicate()) {
            region.create((Object)"KEY", (Object)"KEY");
        }
        region.getAttributesMutator().setCloningEnabled(false);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return server.getPort();
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        Cache result = null;
        result = CacheFactory.create((DistributedSystem)ds);
        if (result == null) {
            throw new Exception("CacheFactory.create() returned null");
        }
        return result;
    }
}

