/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class DiskRegByteArrayDUnitTest
extends CacheTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static CacheTransactionManager cacheTxnMgr;
    protected static File[] dirs;
    static final byte[] value;

    public DiskRegByteArrayDUnitTest(String name) {
        super(name);
        File file1 = new File(name + "1");
        file1.mkdir();
        file1.deleteOnExit();
        File file2 = new File(name + "2");
        file2.mkdir();
        file2.deleteOnExit();
        File file3 = new File(name + "3");
        file3.mkdir();
        file3.deleteOnExit();
        File file4 = new File(name + "4");
        file4.mkdir();
        file4.deleteOnExit();
        dirs = new File[4];
        DiskRegByteArrayDUnitTest.dirs[0] = file1;
        DiskRegByteArrayDUnitTest.dirs[1] = file2;
        DiskRegByteArrayDUnitTest.dirs[2] = file3;
        DiskRegByteArrayDUnitTest.dirs[3] = file4;
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(DiskRegByteArrayDUnitTest.class, "createCacheForVM0");
        vm1.invoke(DiskRegByteArrayDUnitTest.class, "createCacheForVM1");
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        cache = null;
        DiskRegByteArrayDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void createCacheForVM0() {
        try {
            ds = new DiskRegByteArrayDUnitTest("vm0_diskReg").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            factory.setDiskSynchronous(false);
            factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(dirs).create("DiskRegByteArrayDUnitTest").getName());
            RegionAttributes attr = factory.create();
            region = cache.createVMRegion("region", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiskRegByteArrayDUnitTest.fail((String)ex.toString());
        }
    }

    public static void createCacheForVM1() {
        try {
            ds = new DiskRegByteArrayDUnitTest("vm1_diskReg").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            factory.setDiskSynchronous(false);
            factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(dirs).create("DiskRegByteArrayDUnitTest").getName());
            RegionAttributes attr = factory.create();
            region = cache.createVMRegion("region", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiskRegByteArrayDUnitTest.fail((String)ex.toString());
        }
    }

    public void testPutGetByteArray() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Object[] objArr = new Object[]{"key"};
        vm0.invoke(DiskRegByteArrayDUnitTest.class, "putMethod", objArr);
        vm1.invoke(DiskRegByteArrayDUnitTest.class, "flushMethod");
        vm1.invoke(DiskRegByteArrayDUnitTest.class, "verifyByteArray", objArr);
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                Arrays.fill(value, (byte)77);
                obj = region.put(ob, (Object)value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiskRegByteArrayDUnitTest.fail((String)"Failed while region.put");
        }
        return obj;
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            DiskRegByteArrayDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static Object getValueFromDiskMethod(Object ob) {
        Object val = null;
        try {
            DiskId diskId = ((DiskEntry)((LocalRegion)region).basicGetEntry(ob)).getDiskId();
            val = ((LocalRegion)region).getDiskRegion().get(diskId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiskRegByteArrayDUnitTest.fail((String)"Failed to get the value on disk");
        }
        return val;
    }

    public static boolean verifyByteArray(Object ob) {
        boolean result = false;
        Object val = null;
        Arrays.fill(value, (byte)77);
        try {
            DiskId diskId = ((DiskEntry)((LocalRegion)region).basicGetEntry(ob)).getDiskId();
            val = ((LocalRegion)region).getDiskRegion().get(diskId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiskRegByteArrayDUnitTest.fail((String)"Failed to get the value on disk");
        }
        DiskRegByteArrayDUnitTest.assertTrue((String)"The value retrieved from disk is not a byte[] or the length of byte[] is not equla to the length set while put", (((byte[])val).length == value.length ? 1 : 0) != 0);
        byte[] x = null;
        x = (byte[])val;
        for (int i = 0; i < x.length; ++i) {
            result = x[i] == value[i];
        }
        return result;
    }

    public static void flushMethod() {
        try {
            ((LocalRegion)region).getDiskRegion().forceFlush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        dirs = null;
        value = new byte[1024];
    }
}

