/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import java.util.Properties;
import junit.framework.TestCase;

public class DistrbutedRegionProfileOffHeapDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;

    public DistrbutedRegionProfileOffHeapDUnitTest(String name) {
        super(name);
    }

    public void testPartitionedRegionProfileWithConflict() throws Exception {
        final String regionName = DistrbutedRegionProfileOffHeapDUnitTest.getTestName() + "Region";
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("createRegionNoException"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Properties properties = new Properties();
                properties.put("off-heap-memory-size", "2m");
                DistrbutedRegionProfileOffHeapDUnitTest.this.getSystem(properties);
                GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                regionFactory.setEnableOffHeapMemory(true);
                Region region = regionFactory.create(regionName);
                TestCase.assertNotNull((String)"Region is null", (Object)region);
                TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(regionName));
            }
        });
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("createRegionException"){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                Region region = null;
                try {
                    DistributedTestCase.addExpectedException("IllegalStateException");
                    region = regionFactory.create(regionName);
                    TestCase.fail((String)"Expected exception upon creation with invalid off-heap state");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    DistrbutedRegionProfileOffHeapDUnitTest.this.removeExceptionTag1("IllegalStateException");
                }
                TestCase.assertNull((String)"Region is not null", (Object)region);
                TestCase.assertNull((String)"Cache contains region", (Object)cache.getRegion(regionName));
            }
        });
    }

    public void testPartitionedRegionProfileWithoutConflict() throws Exception {
        final String offHeapRegionName = DistrbutedRegionProfileOffHeapDUnitTest.getTestName() + "OffHeapRegion";
        final String onHeapRegionName = DistrbutedRegionProfileOffHeapDUnitTest.getTestName() + "OnHeapRegion";
        for (int vmId = 0; vmId <= 1; ++vmId) {
            Host.getHost(0).getVM(vmId).invoke(new CacheSerializableRunnable("createRegionNoException"){
                private static final long serialVersionUID = 1L;

                @Override
                public void run2() throws CacheException {
                    Properties properties = new Properties();
                    properties.put("off-heap-memory-size", "2m");
                    DistrbutedRegionProfileOffHeapDUnitTest.this.getSystem(properties);
                    GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                    RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                    regionFactory.setEnableOffHeapMemory(true);
                    Region region = regionFactory.create(offHeapRegionName);
                    TestCase.assertNotNull((String)"Region is null", (Object)region);
                    TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(offHeapRegionName));
                    regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                    regionFactory.create(onHeapRegionName);
                    TestCase.assertNotNull((String)"Region is null", (Object)region);
                    TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(onHeapRegionName));
                }
            });
        }
    }

    public void testPartitionedRegionProfileWithAccessor() throws Exception {
        final String regionName = DistrbutedRegionProfileOffHeapDUnitTest.getTestName() + "Region";
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("createRegionNoException"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Properties properties = new Properties();
                properties.put("off-heap-memory-size", "2m");
                DistrbutedRegionProfileOffHeapDUnitTest.this.getSystem(properties);
                GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                regionFactory.setEnableOffHeapMemory(true);
                Region region = regionFactory.create(regionName);
                TestCase.assertNotNull((String)"Region is null", (Object)region);
                TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(regionName));
            }
        });
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("createRegionNoException"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Properties properties = new Properties();
                properties.put("off-heap-memory-size", "2m");
                DistrbutedRegionProfileOffHeapDUnitTest.this.getSystem(properties);
                GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                PartitionAttributes partitionAttributes = new PartitionAttributesFactory().setLocalMaxMemory(0).create();
                regionFactory.setPartitionAttributes(partitionAttributes);
                Region region = regionFactory.create(regionName);
                TestCase.assertNotNull((String)"Region is null", (Object)region);
                TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(regionName));
            }
        });
    }

    public void testPartitionedRegionProfileWithProxy() throws Exception {
        final String regionName = DistrbutedRegionProfileOffHeapDUnitTest.getTestName() + "Region";
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("createRegionNoException"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Properties properties = new Properties();
                properties.put("off-heap-memory-size", "2m");
                DistrbutedRegionProfileOffHeapDUnitTest.this.getSystem(properties);
                GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
                regionFactory.setEnableOffHeapMemory(true);
                Region region = regionFactory.create(regionName);
                TestCase.assertNotNull((String)"Region is null", (Object)region);
                TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(regionName));
            }
        });
        Host.getHost(0).getVM(1).invoke(new CacheSerializableRunnable("createRegionNoException"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run2() throws CacheException {
                Properties properties = new Properties();
                properties.put("off-heap-memory-size", "2m");
                DistrbutedRegionProfileOffHeapDUnitTest.this.getSystem(properties);
                GemFireCacheImpl cache = (GemFireCacheImpl)DistrbutedRegionProfileOffHeapDUnitTest.this.getCache();
                RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.PARTITION_PROXY);
                Region region = regionFactory.create(regionName);
                TestCase.assertNotNull((String)"Region is null", (Object)region);
                TestCase.assertNotNull((String)"Cache does not contain region", (Object)cache.getRegion(regionName));
            }
        });
    }
}

