/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionManagerTest;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;

public abstract class DistributedCacheTestCase
extends DistributedTestCase {
    protected static Cache cache = null;

    public DistributedCacheTestCase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.setUp(true);
    }

    protected void setUp(boolean createLocalCache) throws Exception {
        super.setUp();
        if (createLocalCache) {
            try {
                DistributedCacheTestCase.remoteCreateCache();
                DistributedCacheTestCase.assertTrue((cache != null ? 1 : 0) != 0);
            }
            catch (Exception ex) {
                String s = "While creating cache in this VM";
                throw new InternalGemFireException(s, (Throwable)ex);
            }
        } else {
            this.getSystem();
        }
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(this.getClass(), "remoteCreateCache", new Object[0]);
            }
        }
    }

    private static void remoteCreateCache() throws Exception {
        Assert.assertTrue((cache == null ? 1 : 0) != 0, (Object)"cache should be null");
        DistributedCacheTestCase x = new DistributedCacheTestCase("Lame"){};
        cache = CacheFactory.create((DistributedSystem)x.getSystem());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        cache.createRegion("root", factory.create());
    }

    @Override
    public void tearDown2() throws Exception {
        StringBuffer problems = new StringBuffer();
        if (cache != null) {
            try {
                if (DistributedCacheTestCase.remoteCloseCache()) {
                    problems.append("An exception occurred trying to close the cache.");
                }
                DistributedCacheTestCase.assertTrue((cache == null ? 1 : 0) != 0);
            }
            catch (Exception ex) {
                String s = "While closing the cache in this VM";
                throw new InternalGemFireException(s, (Throwable)ex);
            }
        }
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                boolean exceptionInThreads = vm.invokeBoolean(this.getClass(), "remoteCloseCache");
                if (!exceptionInThreads) continue;
                String s = "An exception occurred in GemFire system: " + vm.getSystem();
                problems.append(s);
            }
        }
        DistributedCacheTestCase.assertEquals((String)"Problems while tearing down", (String)"", (String)problems.toString().trim());
        super.tearDown2();
    }

    private static boolean remoteCloseCache() throws CacheException {
        Assert.assertTrue((cache != null ? 1 : 0) != 0, (Object)"No cache on this VM?");
        Assert.assertTrue((!cache.isClosed() ? 1 : 0) != 0, (Object)"Who closed my cache?");
        InternalDistributedSystem system = ((GemFireCacheImpl)cache).getDistributedSystem();
        DistributionManager dm = (DistributionManager)system.getDistributionManager();
        boolean exceptionInThreads = dm.exceptionInThreads();
        DistributionManagerTest.clearExceptionInThreads(dm);
        cache.close();
        cache = null;
        return exceptionInThreads;
    }

    protected static Region getRootRegion() throws CacheException {
        if (cache == null) {
            String s = "Cache not created yet!";
            throw new IllegalStateException(s);
        }
        return cache.getRegion("root");
    }

    protected static DistributionManager getDistributionManager() {
        if (cache == null) {
            String s = "Cache not created yet!";
            throw new IllegalStateException(s);
        }
        InternalDistributedSystem system = ((GemFireCacheImpl)cache).getDistributedSystem();
        return (DistributionManager)system.getDistributionManager();
    }

    protected static void remoteCreateRegion(String name) throws CacheException {
        DistributedCacheTestCase.remoteCreateRegion(name, Scope.LOCAL);
    }

    protected static void remoteCreateRegion(String name, Scope scope) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        Region newRegion = root.createSubregion(name, factory.create());
        DistributedCacheTestCase.getLogWriter().info("Created Region '" + newRegion.getFullPath() + "'");
    }

    protected static void remoteDefineEntry(String regionName, String entryName, Scope scope) throws CacheException {
        DistributedCacheTestCase.remoteDefineEntry(regionName, entryName, scope, true);
    }

    protected static void remoteDefineEntry(String regionName, String entryName, Scope scope, boolean doNetSearch) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        Region region = root.getSubregion(regionName);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        if (!doNetSearch) {
            factory.setCacheLoader(new CacheLoader(){

                public Object load(LoaderHelper helper) throws CacheLoaderException {
                    String s = "Should not be loading \"" + helper.getKey() + "\" in \"" + helper.getRegion().getFullPath() + "\"";
                    throw new CacheLoaderException(s);
                }

                public void close() {
                }
            });
        }
        Region sub = region.createSubregion(entryName, factory.create());
        sub.create((Object)entryName, null);
        DistributedCacheTestCase.getLogWriter().info("Defined Entry named '" + entryName + "' in region '" + sub.getFullPath() + "'");
    }

    protected static void remotePut(String regionName, String entryName, Object value, Scope scope) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        Region region = root.getSubregion(regionName);
        Region sub = region.getSubregion(entryName);
        if (sub == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(scope);
            sub = region.createSubregion(entryName, factory.create());
        }
        sub.put((Object)entryName, value);
        DistributedCacheTestCase.getLogWriter().info("Put value " + value + " in entry " + entryName + " in region '" + region.getFullPath() + "'");
    }

    protected static void remotePutDistributed(String regionName, String entryName, Object value) throws CacheException {
        DistributedCacheTestCase.remotePut(regionName, entryName, value, Scope.DISTRIBUTED_NO_ACK);
    }

    protected static void remoteReplace(String regionName, String entryName, Object value) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        Region region = root.getSubregion(regionName);
        Region sub = region.getSubregion(entryName);
        if (sub == null) {
            String s = "Entry \"" + entryName + "\" does not exist";
            throw new EntryNotFoundException(s);
        }
        sub.put((Object)entryName, value);
        DistributedCacheTestCase.getLogWriter().info("Replaced value " + value + "in entry " + entryName + " in region '" + region.getFullPath() + "'");
    }

    protected static void remoteInvalidate(String regionName, String entryName) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        Region region = root.getSubregion(regionName);
        Region sub = region.getSubregion(entryName);
        if (sub == null) {
            String s = "Entry \"" + entryName + "\" does not exist";
            throw new EntryNotFoundException(s);
        }
        sub.invalidate((Object)entryName);
    }

    protected static void remoteDestroy(String regionName, String entryName) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        Region region = root.getSubregion(regionName);
        Region sub = region.getSubregion(entryName);
        if (sub == null) {
            String s = "Entry \"" + entryName + "\" does not exist";
            throw new EntryNotFoundException(s);
        }
        DistributedCacheTestCase.assertNotNull((Object)sub.getEntry((Object)entryName));
        sub.destroy((Object)entryName);
        DistributedCacheTestCase.assertNull((Object)sub.getEntry((Object)entryName));
    }

    protected static void remoteAssertEntryValue(String regionName, String entryName, Object expected) throws CacheException {
        Region root = DistributedCacheTestCase.getRootRegion();
        Region region = root.getSubregion(regionName);
        Region sub = region.getSubregion(entryName);
        if (sub == null) {
            String s = "Entry \"" + entryName + "\" does not exist";
            throw new EntryNotFoundException(s);
        }
        DistributedCacheTestCase.assertEquals((Object)expected, (Object)sub.get((Object)entryName));
    }

    public void forEachVMInvoke(String methodName, Object[] args) {
        Host host = Host.getHost(0);
        int vmCount = host.getVMCount();
        for (int i = 0; i < vmCount; ++i) {
            DistributedCacheTestCase.getLogWriter().info("Invoking " + methodName + "on VM#" + i);
            host.getVM(i).invoke(this.getClass(), methodName, args);
        }
    }
}

