/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EvictionTestBase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import java.util.ArrayList;
import java.util.Map;

public class EvictionDUnitTest
extends EvictionTestBase {
    private static final long serialVersionUID = 270073077723092256L;

    public EvictionDUnitTest(String name) {
        super(name);
    }

    public void testDummyInlineNCentralizedEviction() {
        this.prepareScenario1(EvictionAlgorithm.LRU_HEAP, 0);
        EvictionDUnitTest.putData("PR1", 50, 1);
        int expectedEviction1 = this.getExpectedEvictionRatioOnVm(dataStore1);
        int expectedEviction2 = this.getExpectedEvictionRatioOnVm(dataStore2);
        this.raiseFakeNotification(dataStore1, "PR1", expectedEviction1);
        this.raiseFakeNotification(dataStore2, "PR1", expectedEviction2);
        this.validateNoOfEvictions("PR1", expectedEviction1 + expectedEviction2);
        EvictionDUnitTest.putData("PR1", 4, 1);
        this.validateNoOfEvictions("PR1", 4 + expectedEviction1 + expectedEviction2);
    }

    public void testThreadPoolSize() {
        this.prepareScenario1(EvictionAlgorithm.LRU_HEAP, 0);
        EvictionDUnitTest.putData("PR1", 50, 1);
        this.raiseFakeNotification(dataStore1, "PR1", this.getExpectedEvictionRatioOnVm(dataStore1));
        this.verifyThreadPoolTaskCount(HeapEvictor.MAX_EVICTOR_THREADS);
    }

    public void testCentralizedEvictionnForDistributedRegionWithDummyEvent() {
        this.prepareScenario1(EvictionAlgorithm.LRU_HEAP, 0);
        this.createDistributedRegion();
        EvictionDUnitTest.putDataInDistributedRegion(50, 1);
        this.raiseFakeNotification(dataStore1, "DR1", this.getExpectedEvictionRatioOnVm(dataStore1));
    }

    public void testEvictionWithNodeDown() {
        this.prepareScenario2(EvictionAlgorithm.LRU_HEAP, "PR3", "PR4");
        EvictionDUnitTest.putDataInDataStore3("PR3", 100, 1);
        this.fakeNotification();
        EvictionDUnitTest.print("PR3");
        this.killVm();
        this.bringVMBackToLife();
        EvictionDUnitTest.assertEquals((int)100, (int)this.getPRSize("PR3"));
        EvictionDUnitTest.assertEquals((int)0, (int)this.getPRSize("PR4"));
    }

    public void testEntryLruEvictions() {
        int extraEntries = 1;
        this.createCache();
        maxEnteries = 3;
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_ENTRY, "PR1", 4, 1, 1000, maxEnteries);
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion("PR1");
        EvictionDUnitTest.getLogWriter().info("PR- " + pr.getEvictionAttributes().getMaximum());
        for (int counter = 1; counter <= maxEnteries + extraEntries; ++counter) {
            pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
        }
        EvictionDUnitTest.assertEquals((long)extraEntries, (long)((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions());
    }

    public void testEntryLru() {
        int i;
        this.createCache();
        maxEnteries = 12;
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_ENTRY, "PR1", 4, 1, 1000, maxEnteries);
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion("PR1");
        EvictionDUnitTest.getLogWriter().info("PR- " + pr.getEvictionAttributes().getMaximum());
        for (i = 0; i < 3; ++i) {
            pr.put((Object)new Integer(i), (Object)"value0");
            pr.put((Object)new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets()), (Object)"value1");
            pr.put((Object)new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets() * 2), (Object)"value2");
        }
        pr.put((Object)new Integer(3), (Object)"value0");
        for (i = 0; i < 2; ++i) {
            pr.put((Object)(new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets()) * 3), (Object)"value1");
        }
        EvictionDUnitTest.assertEquals((long)0L, (long)((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions());
    }

    public void testCheckEntryLruEvictionsIn1DataStore() {
        int extraEntries = 10;
        this.createCache();
        maxEnteries = 20;
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_ENTRY, "PR1", 5, 1, 1000, maxEnteries);
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion("PR1");
        EvictionDUnitTest.getLogWriter().info("PR- " + pr.getEvictionAttributes().getMaximum());
        for (int counter = 1; counter <= maxEnteries + extraEntries; ++counter) {
            pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
        }
        EvictionDUnitTest.assertEquals((long)extraEntries, (long)((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions());
        for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
            BucketRegion bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null) continue;
            EvictionDUnitTest.getLogWriter().info("FINAL bucket= " + bucketRegion.getFullPath() + "size= " + bucketRegion.size() + "  count= " + bucketRegion.entryCount());
            EvictionDUnitTest.assertEquals((int)4, (int)bucketRegion.size());
        }
    }

    public void testCheckEntryLruEvictionsIn2DataStore() {
        maxEnteries = 20;
        this.prepareScenario1(EvictionAlgorithm.LRU_ENTRY, maxEnteries);
        EvictionDUnitTest.putData("PR1", 60, 1);
        this.validateNoOfEvictions("PR1", 20);
    }

    public void testMemLruForPRAndDR() {
        int i;
        this.createCache();
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_MEMORY, "PR1", 4, 1, 1000, 40);
        EvictionDUnitTest.createDistRegionWithMemEvictionAttr();
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion("PR1");
        DistributedRegion dr = (DistributedRegion)cache.getRegion("DR1");
        EvictionDUnitTest.assertEquals((int)pr.getLocalMaxMemory(), (int)pr.getEvictionAttributes().getMaximum());
        EvictionDUnitTest.assertEquals((int)10, (int)dr.getEvictionAttributes().getMaximum());
        for (i = 0; i < 41; ++i) {
            pr.put((Object)new Integer(i), (Object)new byte[0x100000]);
        }
        EvictionDUnitTest.assertTrue((1L <= ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions() ? 1 : 0) != 0);
        EvictionDUnitTest.assertTrue((((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions() <= 2L ? 1 : 0) != 0);
        for (i = 0; i < 11; ++i) {
            dr.put((Object)new Integer(i), (Object)new byte[0x100000]);
        }
        EvictionDUnitTest.assertTrue((1L <= ((AbstractLRURegionMap)dr.entries)._getLruList().stats().getEvictions() ? 1 : 0) != 0);
        EvictionDUnitTest.assertTrue((((AbstractLRURegionMap)dr.entries)._getLruList().stats().getEvictions() <= 2L ? 1 : 0) != 0);
    }

    public void testEachTaskSize() {
        this.createCache();
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_HEAP, "PR1", 6, 1, 1000, 40);
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_HEAP, "PR2", 10, 1, 1000, 40);
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_HEAP, "PR3", 15, 1, 1000, 40);
        this.createDistRegion();
        ArrayList taskSetSizes = this.getTestTaskSetSizes();
        if (taskSetSizes != null) {
            for (Integer size : taskSetSizes) {
                EvictionDUnitTest.assertEquals((int)8, (int)size);
            }
        }
    }
}

