/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.util.ObjectSizerImpl;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEvictorTask;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class EvictionTestBase
extends CacheTestCase {
    protected static Cache cache = null;
    protected static VM dataStore1 = null;
    protected static VM dataStore2 = null;
    protected static VM dataStore3 = null;
    protected static VM dataStore4 = null;
    protected static Region region = null;
    static int maxEnteries = 20;
    static int maxSizeInMb = 20;
    static int totalNoOfBuckets = 4;

    public EvictionTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
        dataStore2 = host.getVM(1);
        dataStore3 = host.getVM(2);
        dataStore4 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void prepareScenario1(EvictionAlgorithm evictionAlgorithm, int maxEntries) {
        this.createCacheInAllVms();
        this.createPartitionedRegionInAllVMS(true, evictionAlgorithm, "PR1", totalNoOfBuckets, 1, 10000, maxEntries);
        this.createPartitionedRegionInAllVMS(true, evictionAlgorithm, "PR2", totalNoOfBuckets, 2, 10000, maxEntries);
    }

    public void raiseFakeNotification(VM vm, final String prName, final int noOfExpectedEvictions) {
        vm.invoke(new CacheSerializableRunnable("fakeNotification"){

            @Override
            public void run2() throws CacheException {
                final LocalRegion region = (LocalRegion)cache.getRegion(prName);
                EvictionTestBase.this.getEvictor().testAbortAfterLoopCount = 1;
                RegionEvictorTask.TEST_EVICTION_BURST_PAUSE_TIME_MILLIS = 0;
                InternalResourceManager irm = ((GemFireCacheImpl)cache).getResourceManager();
                HeapMemoryMonitor hmm = irm.getHeapMonitor();
                hmm.setTestMaxMemoryBytes(100L);
                hmm.updateStateAndSendEvent(90L);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        long currentEvictions = ((AbstractLRURegionMap)region.entries)._getLruList().stats().getEvictions();
                        if (Math.abs(currentEvictions - (long)noOfExpectedEvictions) <= 1L) {
                            return true;
                        }
                        if (currentEvictions > (long)noOfExpectedEvictions) {
                            TestCase.fail((String)this.description());
                        }
                        return false;
                    }

                    @Override
                    public String description() {
                        return "expected " + noOfExpectedEvictions + " evictions, but got " + ((AbstractLRURegionMap)region.entries)._getLruList().stats().getEvictions();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            }
        });
    }

    public void prepareScenario2(final EvictionAlgorithm evictionAlgorithm, final String partitionRegion1, final String partitionRegion2) {
        dataStore3.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createCache();
            }
        });
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createCache();
            }
        });
        dataStore3.invoke(EvictionTestBase.class, "setTolerance");
        dataStore4.invoke(EvictionTestBase.class, "setTolerance");
        dataStore3.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(true, evictionAlgorithm, partitionRegion1, 2, 2, 10000, 0);
            }
        });
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(true, evictionAlgorithm, partitionRegion1, 2, 2, 10000, 0);
            }
        });
        dataStore3.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(true, evictionAlgorithm, partitionRegion2, 2, 2, 10000, 0);
            }
        });
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(true, evictionAlgorithm, partitionRegion2, 2, 2, 10000, 0);
            }
        });
    }

    public void fakeNotification() {
        dataStore3.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.sendFakeNotification();
            }
        });
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.sendFakeNotification();
            }
        });
    }

    public void sendFakeNotification() {
        HeapMemoryMonitor hmm = ((InternalResourceManager)cache.getResourceManager()).getHeapMonitor();
        RegionEvictorTask.TEST_EVICTION_BURST_PAUSE_TIME_MILLIS = 0;
        MemoryEvent event = new MemoryEvent(this.getResourceType(), MemoryThresholds.MemoryState.NORMAL, MemoryThresholds.MemoryState.EVICTION, cache.getDistributedSystem().getDistributedMember(), 90L, true, hmm.getThresholds());
        this.getEvictor().onEvent(event);
    }

    public static void setTolerance() {
        System.setProperty("gemfire.memoryEventTolerance", Integer.toString(0));
    }

    public void createDistributedRegion() {
        dataStore1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createDistRegion();
            }
        });
    }

    public void createDistRegion() {
        AttributesFactory factory = new AttributesFactory();
        factory.setEnableOffHeapMemory(this.getOffHeapEnabled());
        factory.setDataPolicy(DataPolicy.NORMAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.LOCAL_DESTROY));
        DistributedRegion distRegion = (DistributedRegion)cache.createRegion("DR1", factory.create());
        EvictionTestBase.assertNotNull((Object)distRegion);
    }

    public static void createDistRegionWithMemEvictionAttr() {
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.NORMAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)new ObjectSizerImpl(), (EvictionAction)EvictionAction.LOCAL_DESTROY));
        DistributedRegion distRegion = (DistributedRegion)cache.createRegion("DR1", factory.create());
        EvictionTestBase.assertNotNull((Object)distRegion);
    }

    public void createCacheInAllVms() {
        dataStore1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createCache();
            }
        });
        dataStore2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createCache();
            }
        });
    }

    public static void createCacheInVm() {
        new EvictionTestBase("temp").createCache();
    }

    public void createCache() {
        try {
            HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
            System.setProperty("gemfire.memoryEventTolerance", "0");
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            EvictionTestBase.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            EvictionTestBase.assertNotNull((Object)cache);
            EvictionTestBase.getLogWriter().info("cache= " + cache);
            EvictionTestBase.getLogWriter().info("cache closed= " + cache.isClosed());
            cache.getResourceManager().setEvictionHeapPercentage(85.0f);
            EvictionTestBase.getLogWriter().info("eviction= " + cache.getResourceManager().getEvictionHeapPercentage());
            EvictionTestBase.getLogWriter().info("critical= " + cache.getResourceManager().getCriticalHeapPercentage());
        }
        catch (Exception e) {
            EvictionTestBase.fail("Failed while creating the cache", e);
        }
    }

    public ArrayList getTestTaskSetSizes() {
        return this.getEvictor().testOnlyGetSizeOfTasks();
    }

    protected void createPartitionedRegionInAllVMS(final boolean setEvictionOn, final EvictionAlgorithm evictionAlgorithm, final String regionName, final int totalNoOfBuckets, final int evictionAction, final int evictorInterval, final int maxEntries) {
        dataStore1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(setEvictionOn, evictionAlgorithm, regionName, totalNoOfBuckets, evictionAction, evictorInterval, maxEntries);
            }
        });
        dataStore2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(setEvictionOn, evictionAlgorithm, regionName, totalNoOfBuckets, evictionAction, evictorInterval, maxEntries);
            }
        });
    }

    public void createPartitionedRegion(boolean setEvictionOn, EvictionAlgorithm evictionAlgorithm, String regionName, int totalNoOfBuckets, int evictionAction, int evictorInterval, int maxEnteries) {
        AttributesFactory factory = new AttributesFactory();
        factory.setEnableOffHeapMemory(this.getOffHeapEnabled());
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory().setRedundantCopies(totalNoOfBuckets == 4 ? 0 : 1).setTotalNumBuckets(totalNoOfBuckets);
        if (evictionAlgorithm.isLRUMemory()) {
            partitionAttributesFactory.setLocalMaxMemory(maxEnteries);
        }
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        if (setEvictionOn) {
            if (evictionAlgorithm.isLRUHeap()) {
                factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            } else if (evictionAlgorithm.isLRUMemory()) {
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)new ObjectSizerImpl(), (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            } else {
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maxEnteries, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            }
            if (evictionAction == 2) {
                File[] diskDirs = new File[]{new File("Partitioned_Region_Eviction/LogFile_" + OSProcess.getId())};
                diskDirs[0].mkdirs();
                factory.setDiskSynchronous(true);
                factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(diskDirs).create("EvictionTestBase").getName());
            }
        }
        region = cache.createRegion(regionName, factory.create());
        EvictionTestBase.assertNotNull((Object)region);
        EvictionTestBase.getLogWriter().info("Partitioned Region created Successfully :" + region);
    }

    public static void putData(final String regionName, final int noOfElememts, final int sizeOfElement) {
        dataStore1.invoke(new CacheSerializableRunnable("putData"){

            @Override
            public void run2() throws CacheException {
                Region pr = cache.getRegion(regionName);
                for (int counter = 1; counter <= noOfElememts; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[sizeOfElement * 1024 * 1024]);
                }
            }
        });
    }

    public static void putDataInDistributedRegion(final int noOfElememts, final int sizeOfElement) {
        dataStore1.invoke(new CacheSerializableRunnable("putData"){

            @Override
            public void run2() throws CacheException {
                Region pr = cache.getRegion("DR1");
                for (int counter = 1; counter <= noOfElememts; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[sizeOfElement * 1024 * 1024]);
                    DistributedTestCase.getLogWriter().info("Amar put data element no->" + counter);
                }
            }
        });
    }

    public void validateNoOfEvictions(final String regionName, int noOfEvictions) {
        SerializableCallable validate = new SerializableCallable("Validate evictions"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                    BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                    if (bucketRegion == null) continue;
                    DistributedTestCase.getLogWriter().info("FINAL bucket= " + bucketRegion.getFullPath() + "size= " + bucketRegion.size());
                }
                Long l = new Long(((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions());
                return l;
            }
        };
        long evictionsInVM1 = (Long)dataStore1.invoke(validate);
        long evictionsInVM2 = (Long)dataStore2.invoke(validate);
        EvictionTestBase.getLogWriter().info("EEE evicitons = " + noOfEvictions + " " + (evictionsInVM1 + evictionsInVM2));
        EvictionTestBase.assertEquals((long)noOfEvictions, (long)(evictionsInVM1 + evictionsInVM2));
    }

    public void verifyThreadPoolTaskCount(int taskCountToBeVerified) {
        SerializableCallable getThreadPoolTaskCount = new SerializableCallable("Validate evictions"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                Long l = EvictionTestBase.this.getEvictor().getEvictorThreadPool() != null ? EvictionTestBase.this.getEvictor().getEvictorThreadPool().getTaskCount() : 0L;
                return l;
            }
        };
        Long taskCountOfVM = (Long)dataStore1.invoke(getThreadPoolTaskCount);
        EvictionTestBase.assertTrue((taskCountOfVM > 0L && taskCountOfVM <= (long)taskCountToBeVerified ? 1 : 0) != 0);
    }

    public static void putDataInDataStore3(final String regionName, final int noOfElememts, final int sizeOfElement) {
        dataStore3.invoke(new CacheSerializableRunnable("putData"){

            @Override
            public void run2() throws CacheException {
                Region pr = cache.getRegion(regionName);
                for (int counter = 1; counter <= noOfElememts; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[sizeOfElement * 1024 * 1024]);
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new CacheSerializableRunnable.CacheSerializableRunnableException(e.getLocalizedMessage(), e);
                    }
                }
            }
        });
    }

    public static void print(final String regionName) {
        dataStore3.invoke(new CacheSerializableRunnable("putData"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                Set bucket = pr.getDataStore().getAllLocalBucketRegions();
                for (BucketRegion br : bucket) {
                    DistributedTestCase.getLogWriter().info("Print " + br.size());
                }
            }
        });
    }

    public void validateNoOfEvictionsInDataStore3N4(final String regionName, int noOfEvictions) {
        SerializableCallable validate = new SerializableCallable("Validate evictions"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                Long l = new Long(((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions());
                return l;
            }
        };
        long evictionsInVM1 = (Long)dataStore3.invoke(validate);
        long evictionsInVM2 = (Long)dataStore4.invoke(validate);
        EvictionTestBase.assertEquals((long)noOfEvictions, (long)(evictionsInVM1 + evictionsInVM2));
    }

    public void killVm() {
        dataStore4.invoke(EvictionTestBase.class, "close");
    }

    public static void close() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void bringVMBackToLife() {
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createCache();
            }
        });
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(true, EvictionAlgorithm.LRU_HEAP, "PR3", 2, 2, 10000, 0);
            }
        });
        dataStore4.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionTestBase.this.createPartitionedRegion(true, EvictionAlgorithm.LRU_HEAP, "PR4", 2, 2, 10000, 0);
            }
        });
    }

    public int getPRSize(String string) {
        Integer prSize = (Integer)dataStore4.invoke(EvictionTestBase.class, "returnPRSize", new Object[]{string});
        return prSize;
    }

    public static int returnPRSize(String string) {
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion(string);
        return pr.size();
    }

    public boolean getOffHeapEnabled() {
        return false;
    }

    public HeapEvictor getEvictor() {
        return ((GemFireCacheImpl)cache).getHeapEvictor();
    }

    public int getExpectedEvictionRatioOnVm(VM vm) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return (int)Math.ceil((double)(EvictionTestBase.this.getEvictor().getTotalBytesToEvict() / 2L) / 1048676.0) * 2;
            }
        });
    }

    public InternalResourceManager.ResourceType getResourceType() {
        return InternalResourceManager.ResourceType.HEAP_MEMORY;
    }
}

